set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9829996';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '230',
      '04231111',
      35,
      NULL,
      '0410022',
      3,
      NULL,
      0,
      NULL,
      3.479589,
      '11-23-1994',
      178,
      NULL,
      0,
      1,
      0,
      0.463039,
      NULL,
      0,
      NULL,
      1.103890,
      2.727318,
      0,
      1,
      6,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      6.151942,
      1.193880,
      2.801861,
      NULL,
      NULL,
      4,
      2,
      2,
      1,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      2,
      3,
      NULL,
      5,
      0,
      0,
      0,
      0,
      0.749890,
      NULL,
      2,
      1,
      0,
      3.071571,
      7,
      7,
      5,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      572,
      64,
      2,
      0.961264,
      NULL,
      0,
      3.906771,
      NULL,
      NULL,
      5.760141,
      NULL,
      0,
      NULL,
      10,
      3.139624,
      1.748294,
      120.666926,
      0,
      0.876911,
      1.805633,
      209,
      41.297552,
      1.847737,
      1.658398,
      23.003421,
      67.573318,
      1.200032,
      1.796851,
      NULL,
      5,
      2.877585,
      5.606609,
      239,
      24.629110,
      0,
      1.773154,
      NULL,
      182.270448,
      6,
      0.717450,
      167.925516,
      7.104275,
      0,
      NULL,
      61.728277,
      2,
      2.809535,
      3,
      60.565676,
      0,
      1.499285,
      3.253052,
      184,
      7,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.021959,
      84,
      18,
      2.501918,
      0,
      172,
      0.637668,
      NULL,
      0.794149,
      230.416430,
      17,
      3,
      7,
      20,
      30.637771,
      3,
      2,
      227.131457,
      NULL,
      2,
      7.261347,
      228.298689,
      NULL,
      3,
      3,
      196,
      0.799946,
      0,
      4.964038,
      337,
      0,
      1,
      NULL,
      559,
      4.658026,
      3.762538,
      3.744729,
      726,
      36,
      1.325508,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.407696,
      '21034',
      '44001',
      '',
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      NULL,
      170,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      415,
      0,
      NULL,
      0.719396,
      NULL,
      NULL,
      NULL,
      ' 1-15-1995',
      0.023587,
      2.032276,
      7,
      8,
      11.926647,
      0.301322,
      5,
      1,
      5,
      11.941504,
      1.180701,
      NULL,
      0,
      13,
      10.583988,
      0.635925,
      NULL,
      NULL,
      11.359290,
      11,
      5.947461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.260420,
      15.704742,
      30.627214,
      39,
      NULL,
      3,
      2,
      38,
      1.273351,
      49.433641,
      19.034055,
      13,
      NULL,
      29,
      2,
      32.145208,
      10.970438,
      NULL,
      NULL,
      5.300676,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      159,
      140,
      7.192164,
      80.879613,
      1,
      2.878318,
      0.948401,
      NULL,
      NULL,
      3.708572,
      2,
      0,
      3,
      3,
      NULL,
      NULL,
      6,
      0,
      4,
      4.731384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2.616633,
      2,
      4,
      1.077532,
      6.203298,
      6.398258,
      NULL,
      6.451066,
      8.238320,
      8,
      NULL,
      9.896199,
      2,
      7,
      3.032023,
      NULL,
      8,
      NULL,
      2.366240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      3.693942,
      2.684007,
      NULL,
      2.378112,
      8.431078,
      3,
      6,
      NULL,
      1.083996,
      NULL,
      2,
      NULL,
      6,
      2.947671,
      6.667574,
      1.631682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1.754896,
      1.594955,
      0.909339,
      1.449818,
      4,
      0,
      0.883299,
      0,
      1.861133,
      1,
      2.278064,
      5,
      NULL,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.664967,
      NULL,
      1,
      0.514277,
      1,
      2,
      NULL,
      NULL,
      1.439733,
      1,
      4,
      NULL,
      1,
      NULL,
      0.613529,
      0.039041,
      0.098859,
      0.746022,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.547900,
      0.435520,
      3.558197,
      3.357215,
      2.569941,
      NULL,
      1,
      5.089679,
      5,
      NULL,
      3.468416,
      2.219608,
      1,
      5,
      NULL,
      1.203930,
      NULL,
      NULL,
      3.427784,
      3.331433,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      8,
      2.211086,
      2.259553,
      6.113775,
      6,
      NULL,
      2.360859,
      5.865014,
      NULL,
      7,
      NULL,
      9.249605,
      11,
      NULL,
      4,
      5.649114,
      9,
      3.940434,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9,
      6.859590,
      8,
      6,
      7.767471,
      5,
      2,
      5.283180,
      3,
      1,
      7.679859,
      NULL,
      3.326345,
      1,
      8.697656,
      2,
      2.767796,
      9,
      NULL,
      1.893569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.066468,
      5.685824,
      1,
      0.287692,
      5.059768,
      NULL,
      1,
      NULL,
      7,
      2.184514,
      2,
      2.951441,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.585412,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.441132,
      0,
      0.727922,
      1,
      0.323764,
      1,
      NULL,
      1.632995,
      0,
      0.895962,
      0,
      1,
      NULL,
      1.538342,
      NULL,
      1.348053,
      NULL,
      0,
      NULL,
      0.639698,
      0.336810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315600,
      1,
      1.847068,
      0,
      0.629375,
      1.786723,
      0.003374,
      1,
      NULL,
      NULL,
      1,
      1.434245,
      1.241016,
      NULL,
      1,
      NULL,
      0.165293,
      1.083455,
      NULL,
      0.212871,
      0.861919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574224,
      1.466565,
      0.721650,
      NULL,
      1.896552,
      1.093432,
      1,
      0,
      NULL,
      NULL,
      1,
      1.523665,
      1.625265,
      0.539581,
      1.877888,
      1.793803,
      1.645200,
      0,
      1.398396,
      1.754048,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.591234,
      3.331587,
      1,
      0,
      NULL,
      0.717459,
      NULL,
      1,
      0,
      0.112902,
      NULL,
      1.266741,
      0,
      1,
      NULL,
      0.252646,
      NULL,
      NULL,
      NULL,
      0.655568,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.558653,
      1.656941,
      1.181008,
      1,
      1.000252,
      0.653434,
      1,
      NULL,
      0.654731,
      1,
      1,
      1,
      NULL,
      3,
      1.849020,
      4,
      2,
      0.926136,
      4.821790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      1.634713,
      6.571214,
      6,
      NULL,
      6,
      NULL,
      0.597689,
      8.883934,
      6.800978,
      9.983527,
      NULL,
      4,
      0.924096,
      7.933730,
      0.884591,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.170283,
      6,
      2,
      3,
      0.741474,
      1.124044,
      6.706350,
      0.323544,
      8.480989,
      6,
      6,
      6,
      5,
      1,
      NULL,
      5,
      5,
      9,
      0,
      3.421576,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754477,
      0,
      0,
      0,
      1.095309,
      1.412631,
      NULL,
      0,
      0,
      0.186925,
      0.346867,
      1.877447,
      0.401639,
      NULL,
      0,
      1.555323,
      1,
      1,
      1,
      1,
      1.831817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      3,
      NULL,
      1.955984,
      0,
      1.635183,
      0.132101,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095452,
      1.621258,
      0.373566,
      0.062868,
      0,
      1,
      0.286952,
      0,
      1.155058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      4,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      7,
      0,
      5,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      2,
      2,
      0,
      2,
      NULL,
      1,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 9-1995',
      ' 1-15-2002',
      ' 0-11-1987',
      NULL,
      ' 8-21-1996',
      ' 8-16-1980',
      ' 8-21-2001',
      ' 2-24-1990',
      NULL,
      ' 8-13-2003',
      NULL,
      ' 8-13-1997',
      ' 9-12-1992',
      ' 7-14-1987',
      NULL,
      ' 1- 4-1990',
      ' 7-20-1995',
      NULL,
      ' 2-21-1986',
      ' 5-23-1991',
      ' 7-10-2001',
      ' 1-22-1992',
      ' 6-23-1988',
      '11-20-1986',
      ' 3-15-1977',
      ' 1-10-1981',
      ' 7-13-1993',
      '11- 7-2000',
      ' 0- 3-1975',
      ' 1-15-1999',
      ' 4-26-1994',
      ' 5-27-1993',
      '11- 6-1993',
      ' 7-10-1978',
      ' 1- 7-2003',
      '11-17-1996',
      ' 6- 0-1975',
      ' 9-19-1994',
      '10- 4-2001',
      NULL,
      ' 8- 9-2000',
      NULL,
      ' 2- 5-2002',
      NULL,
      NULL,
      NULL,
      '11- 8-1984',
      NULL,
      ' 3-12-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 1-1978',
      NULL,
      NULL,
      '11- 6-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


