set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '241',
      NULL,
      12.765810,
      63.609361,
      NULL,
      4,
      2.189933,
      1,
      '22230',
      4,
      ' 7-10-2003',
      158,
      NULL,
      NULL,
      NULL,
      1.714316,
      0.850510,
      1.107831,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      9,
      NULL,
      1.378832,
      NULL,
      NULL,
      9.339866,
      0,
      5.154701,
      0,
      NULL,
      2.463783,
      2.068494,
      0.023900,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      4,
      6,
      0,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.354694,
      2,
      NULL,
      1.506388,
      1,
      1.975910,
      0,
      1,
      4.213810,
      0.014395,
      3,
      9,
      1.034698,
      8,
      2,
      4,
      5.060425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      82,
      129.315678,
      NULL,
      1.436828,
      0,
      35,
      0.952445,
      NULL,
      1,
      561,
      3.858411,
      NULL,
      1.487300,
      NULL,
      3,
      0,
      1.424514,
      132.417633,
      1.116275,
      3.411985,
      9.457966,
      149,
      5.458929,
      1.036442,
      3.578514,
      NULL,
      4,
      2,
      3.279597,
      NULL,
      5,
      0.663542,
      6,
      15.281159,
      NULL,
      1,
      NULL,
      78.537515,
      NULL,
      0,
      9,
      5,
      0.274522,
      3.554723,
      7.932429,
      192.851290,
      1.848599,
      1,
      NULL,
      73,
      2.490008,
      1,
      6,
      4,
      3,
      0.769125,
      3,
      NULL,
      1,
      NULL,
      5,
      17.693662,
      18,
      0,
      3.625935,
      10.279741,
      12,
      2.579939,
      1,
      NULL,
      11.773980,
      1.472845,
      3.887923,
      102.996861,
      NULL,
      0,
      0.680331,
      NULL,
      4,
      0.921528,
      6.718114,
      139,
      3.917992,
      0,
      6,
      212.713078,
      9.086687,
      3.610336,
      NULL,
      30.952062,
      4,
      NULL,
      3.826599,
      136,
      4,
      1,
      3,
      97.690668,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0.237202,
      2,
      NULL,
      NULL,
      NULL,
      5,
      15,
      15.096127,
      2.840669,
      9.021588,
      60.079978,
      8.563589,
      NULL,
      NULL,
      34,
      NULL,
      2.996909,
      0,
      135,
      0,
      1,
      1,
      89,
      1,
      1.008708,
      NULL,
      76.438466,
      9,
      2,
      NULL,
      178,
      12,
      3.774865,
      2.657127,
      13.356335,
      9,
      NULL,
      2.026314,
      697.793192,
      16.739688,
      3,
      1,
      1.212971,
      18.556836,
      NULL,
      2.837687,
      1156.614086,
      19,
      0.123345,
      NULL,
      NULL,
      109,
      3,
      NULL,
      130,
      6.144557,
      3.410393,
      2,
      NULL,
      8,
      2.572699,
      5.803415,
      187,
      3.553322,
      3.027603,
      7.597049,
      39,
      NULL,
      0.092081,
      NULL,
      39.156301,
      9,
      NULL,
      2,
      202.694812,
      20.001219,
      2,
      1,
      59.834285,
      10,
      NULL,
      7.395967,
      170,
      16.816053,
      2,
      7,
      63,
      12.297993,
      1,
      5,
      93.504793,
      17,
      3.912491,
      7.639021,
      192,
      NULL,
      NULL,
      7,
      NULL,
      1,
      1,
      3,
      226,
      12,
      1.925323,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      2.179759,
      NULL,
      1,
      1,
      6.219673,
      NULL,
      4,
      1,
      NULL,
      7.517313,
      2,
      3,
      1.444594,
      327,
      5,
      3.936624,
      0.604274,
      341,
      5,
      NULL,
      1,
      204,
      1,
      NULL,
      NULL,
      283,
      1.792686,
      NULL,
      NULL,
      521.274364,
      2.658900,
      3,
      2,
      508,
      1,
      2,
      2,
      432.975124,
      0,
      1.988369,
      2.649804,
      234.783692,
      0,
      3.069777,
      1,
      NULL,
      NULL,
      NULL,
      2.668141,
      126,
      1569.867307,
      NULL,
      1,
      872.843350,
      560,
      NULL,
      0.171052,
      407.364872,
      720,
      2,
      NULL,
      713,
      298,
      3.755143,
      1,
      371,
      612.506682,
      0,
      2,
      1047,
      296.585533,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.433171,
      1020,
      5,
      1,
      1.900102,
      NULL,
      NULL,
      NULL,
      1,
      199,
      11.617032,
      2.287007,
      NULL,
      210,
      35.325637,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533927,
      '32230',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      0.421486,
      159,
      0.363476,
      NULL,
      1.965246,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      1.836392,
      NULL,
      1.849921,
      NULL,
      1,
      NULL,
      NULL,
      11,
      1,
      11.066941,
      9,
      NULL,
      0.777841,
      8,
      14,
      9.514878,
      5,
      14,
      0,
      3,
      2.882142,
      1.882274,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863371,
      5.000903,
      2,
      9,
      11.477869,
      14.201794,
      3,
      13,
      18,
      4.909741,
      7,
      14,
      0.409017,
      1.224551,
      NULL,
      NULL,
      0.565725,
      4,
      6,
      NULL,
      11.970494,
      7.958839,
      8,
      20.394221,
      0.487665,
      2.841291,
      2,
      0,
      1.632178,
      NULL,
      NULL,
      NULL,
      NULL,
      1.291586,
      0,
      NULL,
      19.210935,
      54,
      2.905891,
      NULL,
      NULL,
      NULL,
      10.951451,
      NULL,
      3.668846,
      NULL,
      47,
      4.055408,
      2,
      8,
      NULL,
      4.247656,
      37.372812,
      30,
      NULL,
      14,
      13,
      2,
      5,
      30,
      44,
      NULL,
      5.730547,
      16,
      NULL,
      3.175759,
      9,
      13,
      31,
      2,
      6.125083,
      34,
      10.350179,
      16,
      5,
      2.374050,
      10.727548,
      NULL,
      14,
      1.488193,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      158,
      150,
      75,
      157,
      54,
      139.872491,
      70.161406,
      27,
      80.223973,
      57.606642,
      7,
      NULL,
      60.609523,
      100,
      93,
      79,
      36,
      44.890596,
      108.981851,
      143,
      168,
      48.784761,
      110,
      92.126671,
      98.867407,
      142,
      84,
      179,
      73.616194,
      18.302361,
      120,
      20,
      106.829588,
      76.087740,
      124,
      101,
      0.347455,
      0,
      1.147477,
      0.645481,
      0,
      1,
      0.889075,
      NULL,
      3.667065,
      1.502624,
      1.892821,
      4.582588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4.106210,
      7,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0.387595,
      0,
      4,
      4,
      4,
      5.467173,
      NULL,
      0,
      NULL,
      3.771825,
      NULL,
      3,
      4.503990,
      7,
      9,
      6,
      3,
      4,
      1.897621,
      5,
      4,
      1.814762,
      1,
      1,
      0.569495,
      1.855250,
      5.414027,
      4.439677,
      3,
      NULL,
      4.340324,
      5.907275,
      5,
      NULL,
      3.649583,
      3.367646,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.214987,
      0,
      NULL,
      0,
      1.521298,
      0,
      1,
      NULL,
      0.812197,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      2,
      1.453043,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.434760,
      1.336650,
      NULL,
      0,
      0,
      NULL,
      0.328667,
      NULL,
      1,
      0.617019,
      1.714500,
      0.755414,
      0.481873,
      1.567060,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.585962,
      0.080135,
      1.897965,
      NULL,
      1.599777,
      NULL,
      3.286496,
      0,
      NULL,
      5,
      7,
      1,
      4,
      5.697885,
      4,
      0,
      1,
      2.522416,
      NULL,
      4,
      2.158304,
      1,
      2,
      1,
      2.685872,
      0,
      4,
      2.101686,
      0.677799,
      NULL,
      1.735180,
      2.546409,
      4.910611,
      0.015052,
      0,
      NULL,
      3.081637,
      5,
      2,
      NULL,
      4.294456,
      4,
      5,
      2.603628,
      2.444415,
      3.214509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.312170,
      0.832284,
      NULL,
      1,
      0.990693,
      NULL,
      1.687339,
      4.177806,
      NULL,
      1.505376,
      1,
      1,
      0.471217,
      1,
      NULL,
      2,
      1,
      0.035756,
      5.793016,
      4,
      NULL,
      3,
      1,
      1.556449,
      0.017226,
      NULL,
      1.855905,
      1,
      NULL,
      1,
      1.635025,
      2.672314,
      1,
      0.665107,
      NULL,
      1.025740,
      1.190207,
      2.873724,
      NULL,
      1.261134,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.632774,
      5,
      1.285344,
      1,
      NULL,
      1,
      4,
      1.183124,
      NULL,
      3.786376,
      1.183094,
      3.511483,
      1.362921,
      NULL,
      3,
      0,
      1.847464,
      1.647717,
      NULL,
      1,
      1.623014,
      1.522605,
      0,
      0.796894,
      NULL,
      0,
      1,
      1,
      0.349560,
      0,
      NULL,
      NULL,
      NULL,
      0.279421,
      0.418880,
      NULL,
      0,
      0,
      NULL,
      1,
      0.505340,
      NULL,
      NULL,
      2.987359,
      0.467465,
      5.736213,
      1,
      0.232355,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.340308,
      1,
      NULL,
      4,
      NULL,
      2.212626,
      4.298506,
      1.502586,
      4.258596,
      NULL,
      0.939136,
      3,
      NULL,
      0.859204,
      0,
      2,
      4,
      1,
      NULL,
      6.932978,
      0,
      9.503769,
      1.247278,
      4.888741,
      4.934271,
      6.603740,
      0,
      0,
      1.882739,
      1,
      0.934445,
      NULL,
      4,
      2,
      3.891697,
      2,
      0,
      5.431947,
      0,
      4.882251,
      1.274507,
      3,
      2.190600,
      NULL,
      5.192372,
      6.933321,
      2.151081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.667543,
      0.519905,
      1,
      1,
      5.286035,
      NULL,
      NULL,
      1,
      4.136878,
      2.574230,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      4.586214,
      NULL,
      0.305513,
      1,
      2,
      1,
      5.335319,
      3.069600,
      7.621113,
      6,
      0,
      3.640136,
      3.219972,
      NULL,
      3.423069,
      5,
      4.523695,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.611840,
      NULL,
      6,
      7,
      5.085152,
      5.296018,
      0.237605,
      NULL,
      NULL,
      NULL,
      NULL,
      5.283453,
      2.368874,
      2,
      NULL,
      1.906009,
      1,
      3.325934,
      NULL,
      2,
      NULL,
      0,
      0,
      2,
      3,
      1,
      3,
      1,
      NULL,
      2.051956,
      2.674095,
      NULL,
      0,
      0,
      3,
      4.590670,
      1.722623,
      4,
      0.695888,
      4.848977,
      NULL,
      0,
      2.102451,
      0,
      1,
      NULL,
      2.786336,
      0,
      4.075756,
      0,
      4,
      1.560509,
      5,
      0,
      0.685177,
      NULL,
      1,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      4,
      0,
      1.120443,
      2,
      NULL,
      2.745540,
      3.197142,
      3,
      NULL,
      0.751547,
      0.414275,
      1,
      0,
      0.695687,
      NULL,
      NULL,
      7.913346,
      0.859911,
      0.055721,
      6,
      5,
      4.775315,
      0,
      NULL,
      2,
      3.463966,
      2.920600,
      1,
      NULL,
      0,
      1.869900,
      1.792765,
      2,
      2,
      NULL,
      0.874345,
      NULL,
      0,
      0.768066,
      0.225753,
      NULL,
      0.725237,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.660760,
      0.692610,
      0,
      0.132125,
      0.060549,
      NULL,
      NULL,
      0.862917,
      1.162090,
      NULL,
      1.393342,
      0.442150,
      1.160917,
      1,
      0.719402,
      1.464631,
      0,
      1.487077,
      NULL,
      1.980789,
      1,
      1,
      NULL,
      1.531524,
      1,
      0,
      0.549862,
      0.927322,
      0.676265,
      0,
      0.035167,
      NULL,
      0.989202,
      0.401060,
      0,
      0.429486,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      0.643217,
      1,
      0,
      1,
      1.632776,
      0.234319,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.197748,
      NULL,
      1.724864,
      NULL,
      0.392487,
      0.370600,
      1,
      1.219752,
      NULL,
      0.905693,
      NULL,
      1.388375,
      0.198555,
      0.834287,
      0,
      1,
      1,
      0.042183,
      4.739864,
      3,
      NULL,
      NULL,
      3,
      1.380947,
      0.829367,
      0.628662,
      1.142951,
      0,
      0.195127,
      1.349173,
      1,
      0.520491,
      0,
      0.036663,
      1.669556,
      NULL,
      0.669322,
      0,
      1,
      NULL,
      NULL,
      1.341936,
      0.467534,
      1,
      0.606506,
      NULL,
      0.088422,
      NULL,
      NULL,
      NULL,
      NULL,
      1.629023,
      0.795845,
      0.845604,
      NULL,
      NULL,
      2.812509,
      NULL,
      0.954272,
      5,
      3,
      0,
      0,
      1.635726,
      0.770217,
      NULL,
      NULL,
      2.932334,
      0,
      3.482315,
      1.536125,
      NULL,
      NULL,
      NULL,
      0,
      4.828139,
      3,
      0,
      NULL,
      NULL,
      1.753353,
      NULL,
      7,
      0,
      1.545066,
      1.890630,
      5,
      4,
      0,
      5.952603,
      4.004552,
      NULL,
      5,
      2,
      NULL,
      1.913245,
      4.999030,
      5.629609,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      5.904658,
      2.090906,
      NULL,
      5.293312,
      4.891365,
      0.462688,
      3,
      NULL,
      1.746759,
      2.219978,
      4.899633,
      NULL,
      5.445391,
      5,
      5.858252,
      1,
      4.868613,
      6.714510,
      7.387246,
      3,
      10,
      7.762646,
      3,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.825147,
      NULL,
      3.007710,
      0,
      4,
      3,
      3.774778,
      2.932719,
      6,
      5.898369,
      0,
      NULL,
      0.155219,
      2,
      6,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7.481742,
      5,
      NULL,
      6,
      NULL,
      0.608714,
      1.111925,
      1,
      0,
      0,
      5,
      1.186780,
      7,
      5,
      NULL,
      5,
      1,
      1,
      1.900943,
      NULL,
      7,
      6.760554,
      8.246420,
      NULL,
      4.936884,
      4.250313,
      NULL,
      1.172027,
      5,
      1,
      0.549595,
      1.541805,
      3.787444,
      NULL,
      5,
      5.946707,
      8.998459,
      9,
      0.994254,
      0,
      5,
      3,
      NULL,
      1.079844,
      7,
      NULL,
      2.679563,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5.330644,
      4,
      3,
      2.156417,
      NULL,
      0.888558,
      5,
      2,
      1.637855,
      NULL,
      5.517921,
      0.706293,
      1,
      4,
      4.525309,
      0.428620,
      2,
      5,
      4.710826,
      NULL,
      4,
      7,
      NULL,
      6,
      0,
      6,
      5.569224,
      3.619286,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      4.009037,
      2.310638,
      2.302435,
      1,
      7.130681,
      7.715239,
      NULL,
      5.996784,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.878040,
      1.817133,
      NULL,
      NULL,
      1.863919,
      0,
      1.453980,
      0.948147,
      0,
      NULL,
      0.185521,
      0,
      1,
      3,
      NULL,
      0.674351,
      1.463460,
      2,
      2.456001,
      1.782205,
      3,
      2.061264,
      0.308837,
      1,
      0.966268,
      1.960348,
      1.359213,
      1.013160,
      0,
      0.849686,
      1.205377,
      1,
      NULL,
      NULL,
      0.651332,
      1.383707,
      0.732037,
      1,
      1.045052,
      1,
      0,
      0.793531,
      NULL,
      1.671082,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.786192,
      NULL,
      3,
      1.199060,
      2.143830,
      NULL,
      NULL,
      NULL,
      0.996929,
      0,
      1,
      1.314633,
      NULL,
      2,
      0.490161,
      NULL,
      1,
      5,
      5,
      1.450109,
      2.935967,
      4.099539,
      NULL,
      NULL,
      0,
      3,
      0.364035,
      1,
      3,
      1.666311,
      1,
      0.087789,
      5.923840,
      4.538449,
      1,
      4.465199,
      NULL,
      NULL,
      1,
      4,
      NULL,
      0.827692,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      3,
      2,
      3,
      4,
      2,
      1,
      4,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      4,
      1,
      1,
      2,
      0,
      5,
      NULL,
      5,
      6,
      NULL,
      1,
      1,
      3,
      0,
      2,
      5,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      1,
      2,
      NULL,
      3,
      3,
      2,
      0,
      NULL,
      4,
      1,
      3,
      3,
      4,
      NULL,
      0,
      1,
      0,
      0,
      2,
      3,
      3,
      2,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-24-1996',
      ' 8-24-2000',
      NULL,
      ' 7-10-1998',
      ' 0-14-1975',
      ' 9-27-1991',
      ' 3- 5-1989',
      ' 8-29-1975',
      NULL,
      ' 5-16-1992',
      NULL,
      ' 6- 1-1990',
      ' 2-12-1998',
      ' 7-23-1996',
      NULL,
      ' 0-10-1999',
      ' 9-22-1991',
      ' 9-10-1990',
      ' 2- 8-2003',
      ' 0-16-1988',
      ' 6-23-1980',
      NULL,
      ' 7- 5-1979',
      ' 8-19-1983',
      ' 5- 2-2001',
      NULL,
      '11-11-1993',
      ' 5- 2-1999',
      '11-15-1987',
      ' 1- 1-1995',
      ' 0-25-1983',
      ' 5-21-1981',
      NULL,
      ' 3-17-1981',
      ' 2- 8-1994',
      ' 5-22-1993',
      ' 1-24-1990',
      ' 6- 7-1992',
      ' 4- 2-1978',
      ' 2- 8-1992',
      ' 9- 7-1984',
      ' 9-17-2001',
      ' 3-12-1978',
      ' 9- 0-1998',
      ' 9- 2-1989',
      NULL,
      ' 2-12-1979',
      ' 2-28-1991',
      ' 7- 9-1987',
      NULL,
      ' 0-11-1979',
      '11- 2-1989',
      ' 8-21-1976',
      '10-24-1990',
      ' 8- 5-1974',
      NULL,
      ' 7- 1-2003',
      '10- 2-1976',
      ' 3-18-1982',
      ' 3-26-1997',
      ' 8-17-1991',
      NULL,
      ' 7- 5-1981',
      NULL,
      '11- 6-1988',
      ' 7- 2-1993',
      '11- 9-1983',
      ' 1- 5-1989',
      NULL,
      ' 4-13-1982',
      ' 3- 2-1986',
      ' 1-27-1987',
      ' 5-13-1991',
      NULL,
      ' 1- 0-1985',
      NULL,
      '10-12-1992',
      ' 5-18-1987',
      ' 6-24-1999',
      NULL,
      ' 6-28-2000',
      ' 4- 1-1986',
      ' 4-10-1989',
      ' 9-12-1993',
      ' 3-14-1984',
      ' 6-18-1974',
      ' 9-23-2001',
      '11-13-1978',
      ' 3-12-1998',
      ' 0- 0-1993',
      ' 2-15-1992',
      ' 5-15-2002',
      ' 4- 3-1996',
      ' 5-24-1980',
      ' 1- 8-1983',
      ' 2-13-2001',
      '10- 5-1986',
      ' 7-26-1975',
      ' 1-26-1994',
      ' 0- 9-1979',
      NULL,
      '10-14-1979',
      ' 5- 5-1981',
      ' 0-19-1983',
      '11-25-2002',
      ' 9-22-2002',
      ' 7-27-2003',
      NULL,
      ' 9-10-1990',
      NULL,
      ' 6-21-1990',
      ' 1-18-1987',
      ' 0- 9-1990',
      ' 7-11-2002',
      ' 1-18-1974',
      ' 2- 2-1987',
      ' 9-10-1997',
      NULL,
      ' 8-27-2002',
      ' 9- 5-1996',
      NULL,
      '10-22-2001',
      ' 6-18-1985',
      NULL,
      ' 1-13-1981',
      NULL,
      NULL,
      '11-24-1987',
      NULL,
      ' 7- 4-1992',
      ' 6-18-1991',
      ' 0- 5-1991',
      ' 1-10-1978',
      ' 8-29-1984',
      NULL,
      ' 9- 1-1998',
      ' 5-14-1982',
      NULL,
      NULL,
      NULL,
      ' 4- 9-1974',
      ' 4-26-1996',
      NULL,
      ' 3-15-1975',
      ' 1-16-1979',
      NULL,
      NULL,
      ' 8- 0-1981',
      ' 0-19-1985',
      NULL,
      ' 4-29-1994',
      NULL,
      ' 4- 7-1982',
      NULL,
      NULL,
      NULL,
      ' 4- 9-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


