set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '231',
      NULL,
      22.213810,
      83,
      '3010003',
      NULL,
      3,
      0,
      '42241',
      2,
      '11-11-1993',
      143.834342,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      0.369033,
      1.719119,
      3.945215,
      2.217901,
      NULL,
      0.809104,
      NULL,
      7,
      NULL,
      2,
      NULL,
      26,
      23.777138,
      4.681006,
      1.289590,
      1,
      NULL,
      6,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      6,
      7,
      1,
      0,
      0,
      1,
      0,
      NULL,
      3,
      NULL,
      0,
      2.862793,
      0,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      4,
      0,
      7.261316,
      3,
      NULL,
      NULL,
      5,
      6,
      2.395866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      5,
      53.582510,
      NULL,
      NULL,
      0.765470,
      NULL,
      21.454121,
      NULL,
      1.816696,
      3.447991,
      166.227747,
      2.758357,
      2,
      3,
      NULL,
      NULL,
      1.956092,
      6,
      128.054649,
      NULL,
      0.033956,
      0,
      196.224779,
      16.721005,
      0,
      5,
      143.028189,
      9.812320,
      1.219713,
      4,
      0,
      NULL,
      3.258978,
      4,
      115,
      1,
      2.289213,
      0,
      185.866852,
      5,
      2,
      NULL,
      199,
      8,
      2.519315,
      8,
      76.159051,
      7,
      2,
      7.769446,
      138,
      3,
      3,
      3.074552,
      NULL,
      NULL,
      2,
      0,
      174.493434,
      10,
      NULL,
      0,
      134,
      5,
      0.055600,
      8,
      18,
      1,
      2.678422,
      NULL,
      11.717060,
      NULL,
      2.597315,
      3.075252,
      202,
      NULL,
      3,
      1.484926,
      181.195146,
      5,
      1,
      NULL,
      218,
      5,
      0,
      NULL,
      89.681493,
      NULL,
      0.415292,
      0,
      79,
      15.488857,
      2.597641,
      3.508173,
      198.631994,
      3,
      0.000606,
      2,
      44.856254,
      12,
      NULL,
      0,
      NULL,
      16,
      3.902349,
      0.468898,
      175,
      7,
      NULL,
      NULL,
      194.206899,
      NULL,
      1,
      5.961625,
      31,
      8.144281,
      NULL,
      0.861439,
      149,
      2,
      2.201039,
      5.556834,
      3.952834,
      10.113368,
      NULL,
      1.369226,
      30.508132,
      2,
      NULL,
      NULL,
      62,
      6.809594,
      NULL,
      4,
      216.567834,
      20,
      NULL,
      8,
      25,
      11,
      0.695116,
      3,
      670,
      7.296809,
      2.235745,
      5.242528,
      479.718448,
      5,
      1,
      2.381271,
      241.567125,
      657,
      3.073994,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      186.477574,
      15.886113,
      NULL,
      2,
      75.772216,
      1.864296,
      NULL,
      NULL,
      204.787371,
      4.118701,
      3.750791,
      4.257010,
      168.462267,
      17.713869,
      0.748757,
      7,
      81,
      5,
      NULL,
      9.052106,
      249,
      19.743870,
      1,
      4,
      212,
      NULL,
      3,
      NULL,
      6,
      4.791052,
      0.520068,
      1,
      31,
      4.519793,
      NULL,
      1,
      71.483355,
      15.344584,
      0.551986,
      4.203219,
      166.328638,
      4.334407,
      NULL,
      NULL,
      234,
      2.534138,
      0.654276,
      NULL,
      129.180547,
      3.019207,
      3.288963,
      4,
      31.261596,
      NULL,
      NULL,
      7,
      NULL,
      5,
      2.197523,
      NULL,
      58,
      4.628085,
      0,
      1,
      NULL,
      5.568050,
      2.442678,
      6,
      NULL,
      3.182122,
      1.920582,
      0,
      352.838105,
      NULL,
      NULL,
      NULL,
      1.495558,
      NULL,
      1,
      0,
      97.685534,
      NULL,
      1,
      7.586855,
      307,
      2,
      1,
      2.097191,
      133.235009,
      3.725522,
      3,
      0.184628,
      703.866327,
      3.855738,
      2,
      5,
      275.615760,
      5,
      NULL,
      7,
      128,
      NULL,
      3.695014,
      NULL,
      40,
      2,
      1.375761,
      1.867872,
      299.758450,
      1510.799868,
      0.911529,
      9,
      423.612005,
      22,
      2,
      2.794334,
      128,
      NULL,
      2,
      4.642905,
      1417,
      524,
      3.377791,
      NULL,
      470,
      NULL,
      2.372563,
      1.248723,
      1057,
      78,
      0,
      1,
      300,
      161,
      NULL,
      0,
      174,
      NULL,
      1.172027,
      2.486540,
      386.750340,
      NULL,
      NULL,
      2.398117,
      171,
      7.040385,
      1,
      3,
      NULL,
      152.987772,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0.044866,
      2,
      3.247242,
      NULL,
      '04202',
      '21020',
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.896335,
      '',
      NULL,
      '',
      0,
      5.265491,
      2.246589,
      1.495046,
      NULL,
      NULL,
      NULL,
      1.241451,
      NULL,
      5,
      6,
      1,
      NULL,
      2,
      9.805240,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      ' 3-17-1988',
      0.515112,
      1.744864,
      NULL,
      NULL,
      3,
      7.250629,
      10.985748,
      8,
      11,
      4,
      NULL,
      6.133914,
      NULL,
      0.575489,
      2,
      13.826050,
      15,
      10.578564,
      4.453660,
      9.306048,
      4,
      5.094843,
      8.382046,
      13,
      0.208577,
      7,
      NULL,
      13,
      NULL,
      NULL,
      8,
      4.918204,
      6.793753,
      NULL,
      6,
      3.570698,
      NULL,
      NULL,
      4,
      7,
      NULL,
      4.673083,
      24.986908,
      1.175754,
      3.700249,
      5,
      2,
      2.518185,
      13,
      8.406847,
      2,
      6.469058,
      1,
      1.426936,
      1,
      49,
      1.679921,
      26.912594,
      49,
      19,
      15,
      NULL,
      1,
      3.239779,
      26.741442,
      13,
      20,
      NULL,
      NULL,
      0,
      30,
      20,
      26,
      27.473045,
      NULL,
      19,
      15,
      7.046770,
      17.930765,
      15,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      19,
      NULL,
      13.606233,
      12.953497,
      6,
      NULL,
      15.277363,
      5.283288,
      NULL,
      18,
      18,
      NULL,
      47.877126,
      NULL,
      1.241612,
      4,
      58,
      3,
      NULL,
      NULL,
      35,
      176,
      NULL,
      169.051499,
      51.076725,
      71,
      38.528128,
      114.033982,
      92.699025,
      92,
      165,
      NULL,
      7,
      24,
      NULL,
      132.231232,
      NULL,
      102,
      90.258587,
      10.517874,
      41,
      180.371870,
      150.399932,
      NULL,
      50.268532,
      121.764433,
      110.653778,
      84,
      74.255590,
      143,
      114,
      109,
      161,
      70.149117,
      0,
      0,
      0.071715,
      1.313058,
      0,
      3,
      NULL,
      4.462839,
      1.311870,
      2,
      1,
      0,
      2.720894,
      0,
      NULL,
      4,
      NULL,
      NULL,
      1,
      0,
      6.311236,
      2,
      3.410419,
      1,
      1,
      0,
      0.224192,
      4.678373,
      3.482763,
      1,
      3.167191,
      0.133373,
      0.567479,
      0.350663,
      0,
      2.080537,
      NULL,
      9.952472,
      11.572005,
      0.004115,
      NULL,
      3.586133,
      4.118710,
      0.299204,
      7.236322,
      5.827351,
      1,
      0,
      0,
      NULL,
      1,
      5,
      2,
      NULL,
      0,
      0,
      5.993219,
      3,
      3.642843,
      4,
      1,
      NULL,
      0,
      5,
      3.516025,
      1,
      NULL,
      1.667882,
      0.589805,
      NULL,
      1,
      0,
      1,
      NULL,
      1.590207,
      0.226525,
      1,
      0,
      1,
      0,
      0.930817,
      1.180212,
      0.296161,
      0,
      0.076546,
      0.892042,
      0.724365,
      0.554855,
      2,
      1.825871,
      2.664970,
      1,
      NULL,
      1,
      0.401832,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.885990,
      0,
      1,
      0.323819,
      NULL,
      0,
      NULL,
      0,
      1.141277,
      1,
      0,
      0.741625,
      1,
      NULL,
      0,
      0.906156,
      1.094978,
      0.489132,
      1.976827,
      1.965181,
      1,
      0.825636,
      1.485859,
      1.998739,
      0,
      NULL,
      0,
      1.312933,
      0.905451,
      0,
      0,
      4.974723,
      5.647333,
      3,
      1,
      4.357563,
      4,
      1,
      1.530321,
      3,
      NULL,
      1.731278,
      0,
      3.695239,
      0.067559,
      NULL,
      3.208630,
      NULL,
      0.603520,
      1.599472,
      1.257689,
      0.107347,
      0,
      NULL,
      1,
      4.526117,
      2,
      3,
      5,
      NULL,
      0.597475,
      4,
      2,
      7.372139,
      0,
      3,
      1,
      3,
      NULL,
      0.371705,
      0.020601,
      0,
      3.253228,
      NULL,
      2.812921,
      3,
      6,
      4,
      0,
      NULL,
      1,
      0.818463,
      NULL,
      1,
      2.861305,
      3.628970,
      1.943358,
      0,
      2,
      NULL,
      0,
      1.715415,
      NULL,
      NULL,
      2,
      1,
      0,
      3.687744,
      3.012217,
      NULL,
      0,
      1.682079,
      NULL,
      1,
      1.095290,
      1,
      0,
      0.450083,
      1,
      3,
      0,
      1,
      0.473211,
      0,
      3.333545,
      7.252155,
      5.393816,
      NULL,
      1.172647,
      0.215447,
      0,
      NULL,
      0.162912,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.439517,
      2,
      0.133798,
      1,
      3,
      1,
      3.232252,
      NULL,
      1.923579,
      NULL,
      0.366829,
      1.666238,
      1.940133,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1.559353,
      0.643162,
      0.927183,
      1.343164,
      1.235805,
      NULL,
      0.363086,
      0,
      0.510111,
      1,
      1.676220,
      0.317003,
      1,
      1,
      0.176670,
      0,
      5.766099,
      3,
      1,
      1,
      NULL,
      0,
      0.106253,
      0,
      0,
      0,
      1,
      2.628310,
      2.290017,
      2.534448,
      NULL,
      7.957490,
      NULL,
      6.489725,
      1.614365,
      NULL,
      0.851916,
      6.983991,
      NULL,
      NULL,
      0.192444,
      6.589910,
      NULL,
      0.977677,
      4.329279,
      1,
      7,
      8.142569,
      1,
      NULL,
      7,
      2.288618,
      5.178093,
      2.594089,
      1.091719,
      NULL,
      3,
      NULL,
      1.039332,
      3.395279,
      NULL,
      2,
      5.892976,
      3,
      3,
      1.335438,
      1.773250,
      3.100821,
      NULL,
      6.633000,
      NULL,
      2,
      7,
      2,
      2.809118,
      1.949820,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      6.934461,
      5,
      5.158019,
      1.238372,
      5.890236,
      NULL,
      NULL,
      4,
      4,
      3,
      NULL,
      3,
      NULL,
      6,
      NULL,
      3,
      5.943170,
      1,
      0.619784,
      4.214748,
      0,
      3,
      2,
      NULL,
      0.203689,
      3.014034,
      NULL,
      NULL,
      3,
      0.709610,
      0.854779,
      NULL,
      5,
      1,
      4.018925,
      5.278700,
      2,
      7,
      0.618961,
      5.514744,
      NULL,
      NULL,
      7.894997,
      0.816621,
      5,
      5.045598,
      1,
      NULL,
      NULL,
      0,
      1,
      0.614961,
      1.267176,
      NULL,
      1,
      NULL,
      0.897444,
      NULL,
      2.728780,
      1.439534,
      2,
      0.178686,
      2,
      4.812665,
      5,
      4,
      NULL,
      5.420272,
      2.525414,
      1.063332,
      4.925464,
      NULL,
      1.518229,
      0.070079,
      NULL,
      1,
      3,
      0,
      2.267674,
      3,
      0.401441,
      1.080121,
      5.036350,
      1,
      0,
      1,
      3,
      3,
      1,
      0.645395,
      1,
      NULL,
      5,
      NULL,
      1,
      1,
      1.934188,
      3.465286,
      2,
      1,
      0.112110,
      3.599276,
      2.795575,
      0.460037,
      1.014235,
      2,
      0.541607,
      3,
      0,
      0.613374,
      1.514902,
      0,
      1.925744,
      4,
      0.202813,
      3.448139,
      1,
      2,
      NULL,
      0.941696,
      2.628031,
      2,
      6.757144,
      3.692230,
      NULL,
      NULL,
      3.530969,
      0,
      0.716363,
      NULL,
      NULL,
      3,
      3.227313,
      2.102956,
      3.850826,
      NULL,
      2.087068,
      NULL,
      1,
      1.299690,
      1,
      NULL,
      0,
      NULL,
      0.710325,
      3,
      NULL,
      1.827786,
      4.169445,
      1,
      1.640258,
      0,
      1.996251,
      1,
      1.365491,
      1,
      1.594653,
      NULL,
      0.009751,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.624444,
      NULL,
      1,
      0.781297,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1.646578,
      NULL,
      1,
      1.668221,
      1,
      0,
      1.764018,
      1.955916,
      1.659089,
      1.727544,
      1,
      0.216456,
      0.871815,
      1,
      0,
      NULL,
      0.587739,
      0,
      0.453229,
      1.292767,
      NULL,
      0.510057,
      NULL,
      0.183750,
      1.009144,
      1,
      1,
      0,
      1.518433,
      2,
      0,
      0.521270,
      1.885911,
      NULL,
      1.532199,
      1,
      1.106463,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      5,
      1,
      5.506698,
      5,
      NULL,
      1.706308,
      3,
      0.905113,
      1.198091,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.377656,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.552546,
      NULL,
      1.543156,
      NULL,
      1,
      0.701438,
      0,
      0,
      0,
      1.173793,
      0.078983,
      0,
      1,
      1.791812,
      1,
      2.244867,
      1,
      2.723488,
      5,
      4.591658,
      1,
      NULL,
      1,
      1.008910,
      1,
      0.409944,
      1.665671,
      1,
      5.912623,
      4.456216,
      4.226780,
      NULL,
      1,
      1,
      5.801292,
      3,
      NULL,
      1,
      NULL,
      0.288131,
      NULL,
      0,
      0.436074,
      0.471512,
      NULL,
      4,
      4,
      3,
      2,
      3,
      2,
      NULL,
      0.713205,
      6,
      2.043805,
      NULL,
      3.525252,
      3.899162,
      0.675675,
      0,
      NULL,
      1,
      4.399059,
      1,
      4,
      3,
      0.396258,
      3.607445,
      NULL,
      4,
      1.191688,
      5.354445,
      1,
      4,
      7,
      0.307947,
      3.755253,
      4,
      3.361115,
      0,
      4.909388,
      NULL,
      NULL,
      NULL,
      1.503130,
      8,
      2,
      0.250393,
      5,
      2.014818,
      3.255347,
      0.242812,
      1,
      0,
      0,
      1,
      0,
      5,
      1.453047,
      9,
      2.328747,
      NULL,
      4,
      1.492830,
      2.196903,
      NULL,
      6.610550,
      NULL,
      3,
      0.188326,
      NULL,
      5.042441,
      4.335850,
      3.872693,
      1.516969,
      3.228637,
      5.523307,
      2,
      7,
      5,
      NULL,
      1.645087,
      2.586251,
      1.962896,
      NULL,
      1,
      5,
      NULL,
      1.538941,
      2,
      3.492834,
      NULL,
      0,
      4,
      6.149677,
      4,
      7,
      NULL,
      11,
      9,
      2,
      0,
      5,
      NULL,
      1.518578,
      0.529269,
      1.459431,
      2.804250,
      0,
      5,
      7.775474,
      8,
      3,
      2.606895,
      3,
      0,
      5.645032,
      0,
      9.332191,
      5.515971,
      4,
      NULL,
      0.353185,
      1.508650,
      0.002520,
      0.048825,
      4,
      1.253631,
      2.334896,
      1,
      5.212552,
      5,
      3,
      4.776429,
      NULL,
      3,
      3.798813,
      0.430249,
      2.631087,
      NULL,
      5,
      4.804460,
      2.834416,
      3.672400,
      3.199302,
      NULL,
      NULL,
      2,
      1.482082,
      4,
      0,
      NULL,
      1,
      0,
      0.835938,
      3.064158,
      5.062595,
      5,
      5,
      NULL,
      5.925950,
      NULL,
      2.394568,
      0,
      5.699474,
      4.721684,
      4,
      5,
      7.126701,
      1.923894,
      7.105152,
      NULL,
      2.222996,
      4,
      1,
      NULL,
      4,
      4.303376,
      1.368049,
      1,
      1.633612,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1.915038,
      0,
      0,
      1,
      0,
      0.023852,
      NULL,
      NULL,
      0.837799,
      1.114441,
      0.868815,
      3.598107,
      0,
      3,
      3,
      2,
      1.216470,
      NULL,
      NULL,
      NULL,
      0.995967,
      1,
      1,
      NULL,
      0.590832,
      0.505243,
      0.829758,
      0.397305,
      NULL,
      0,
      0.008531,
      1.859209,
      0,
      1,
      1.538787,
      0.607340,
      0,
      0.078181,
      0.511795,
      0,
      0.303410,
      1,
      NULL,
      NULL,
      0,
      1.203228,
      3,
      0.354641,
      1,
      3.967484,
      1,
      3.327204,
      1.712461,
      NULL,
      1,
      NULL,
      1.949792,
      NULL,
      4.384874,
      0,
      1,
      0.445391,
      2,
      3,
      0,
      0.715825,
      5,
      3.456689,
      3.613703,
      1,
      1,
      NULL,
      0.312101,
      NULL,
      1.139147,
      NULL,
      3,
      NULL,
      NULL,
      5.731907,
      0,
      NULL,
      NULL,
      3.479180,
      0,
      5.487529,
      3,
      4.040157,
      2,
      5.829429,
      5.368178,
      5.130272,
      1,
      NULL,
      2,
      4,
      2,
      3,
      0,
      1,
      NULL,
      0,
      1,
      4,
      2,
      NULL,
      4,
      0,
      1,
      0,
      4,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      7,
      0,
      NULL,
      5,
      5,
      NULL,
      5,
      3,
      7,
      NULL,
      1,
      NULL,
      1,
      1,
      5,
      NULL,
      5,
      NULL,
      0,
      1,
      2,
      0,
      5,
      0,
      NULL,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      3,
      0,
      NULL,
      3,
      2,
      0,
      1,
      NULL,
      3,
      1,
      0,
      4,
      2,
      NULL,
      1,
      2,
      2,
      4,
      3,
      0,
      0,
      5,
      0,
      NULL,
      3,
      2,
      3,
      NULL,
      2,
      5,
      NULL,
      1,
      4,
      2,
      0,
      5,
      NULL,
      NULL,
      4,
      1,
      5,
      0,
      0,
      3,
      4,
      2,
      3,
      5,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 2-1978',
      ' 0-15-1985',
      NULL,
      ' 2- 2-1984',
      NULL,
      ' 2-14-1986',
      '11- 0-1986',
      NULL,
      ' 1-26-1994',
      ' 2- 6-1989',
      ' 6-13-2001',
      NULL,
      ' 8- 1-2001',
      ' 3-25-1998',
      ' 3-29-1999',
      ' 1- 9-1981',
      '10-22-1998',
      NULL,
      NULL,
      ' 2-10-2003',
      ' 8- 5-1997',
      NULL,
      ' 9-24-1998',
      ' 3-12-1988',
      '11-25-1994',
      NULL,
      ' 4- 6-1987',
      ' 9- 2-1987',
      ' 5- 1-1984',
      NULL,
      ' 2- 5-1974',
      ' 0- 4-1977',
      ' 2-28-1991',
      ' 4-25-1998',
      ' 5- 4-1991',
      ' 5-26-1984',
      ' 0-29-1981',
      '11-20-1989',
      ' 0-28-1998',
      NULL,
      ' 4-19-1981',
      NULL,
      ' 5-20-1975',
      ' 8-24-1976',
      ' 9-16-1987',
      NULL,
      ' 2- 5-1975',
      ' 7-13-1981',
      ' 6-25-1999',
      ' 9- 1-1974',
      NULL,
      ' 5- 2-1975',
      NULL,
      ' 5-11-1982',
      '11-27-1983',
      ' 2- 7-1976',
      '11-19-1982',
      ' 9-18-1996',
      ' 4-13-2000',
      ' 2- 0-1977',
      ' 4-16-1999',
      ' 5-25-1989',
      ' 2-11-1992',
      NULL,
      ' 1- 6-1975',
      NULL,
      NULL,
      '10-19-1993',
      NULL,
      ' 8-20-1987',
      ' 0-29-1988',
      ' 9-16-1978',
      NULL,
      NULL,
      ' 6-15-1998',
      NULL,
      ' 3-17-1999',
      ' 9-15-1975',
      ' 1-11-1984',
      NULL,
      ' 1-28-1993',
      ' 1-26-2001',
      ' 7-27-1982',
      ' 1-10-1997',
      ' 6- 2-1990',
      NULL,
      ' 0-17-1975',
      ' 6- 6-1984',
      NULL,
      ' 3-12-1991',
      ' 8-21-1980',
      ' 9-13-1997',
      '10-28-1975',
      ' 2-11-1993',
      ' 6- 3-1981',
      ' 1-16-1988',
      NULL,
      ' 1- 2-1979',
      ' 8- 1-1988',
      '10-16-1990',
      ' 7-15-1984',
      ' 1- 9-1989',
      ' 6-22-1978',
      NULL,
      NULL,
      ' 1- 6-1997',
      ' 2-21-1982',
      ' 9-20-1993',
      '10- 2-1999',
      ' 1-28-1975',
      NULL,
      ' 9- 1-1992',
      ' 2-20-1985',
      ' 5- 0-1983',
      ' 0-19-1978',
      ' 4- 9-1974',
      NULL,
      ' 9-24-1979',
      ' 7- 9-1977',
      ' 0-23-2003',
      ' 4- 2-1992',
      ' 2-14-1978',
      NULL,
      NULL,
      ' 2-26-2003',
      NULL,
      ' 2- 3-1985',
      ' 8-27-1990',
      ' 5-16-1999',
      ' 0- 1-2003',
      ' 2-27-1998',
      ' 1-21-2002',
      ' 7- 7-1976',
      ' 4- 4-1975',
      ' 7-22-1989',
      NULL,
      ' 9-22-1992',
      NULL,
      ' 1-29-1980',
      ' 4-22-1984',
      ' 4-12-1978',
      ' 3-18-1981',
      ' 1-22-1995',
      ' 7- 9-1978',
      '10- 7-1976',
      ' 7- 7-1976',
      ' 8-12-2001',
      ' 1- 9-1999',
      '11- 2-1976',
      NULL,
      ' 9-18-2001',
      ' 2-29-1981',
      NULL,
      '11- 9-1995',
      ' 8-12-1990',
      NULL,
      ' 4-10-1988',
      NULL,
      '11-22-1983',
      NULL,
      ' 6- 2-2001',
      ' 8-21-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


