set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7719348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      NULL,
      NULL,
      '2311014',
      1,
      NULL,
      0,
      '30233',
      0,
      NULL,
      32.723825,
      NULL,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      1,
      2.337495,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.774429,
      0.581620,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9.140004,
      NULL,
      NULL,
      1.276293,
      NULL,
      NULL,
      NULL,
      9,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      5.769927,
      5,
      7.502537,
      3,
      0.356322,
      1.061797,
      0.698202,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      0,
      4,
      9,
      2,
      NULL,
      11,
      0,
      NULL,
      11.561011,
      '11-12-1989',
      11,
      0,
      NULL,
      4,
      NULL,
      NULL,
      2.527079,
      3,
      28,
      27.719257,
      1.952774,
      3,
      1,
      976.659722,
      182,
      2.923975,
      3,
      106.292514,
      10758,
      2,
      2.418162,
      114.832393,
      NULL,
      1,
      17.803031,
      200.813528,
      5623,
      2,
      14,
      723.909726,
      831.226112,
      NULL,
      NULL,
      96.586017,
      240,
      1,
      3.927355,
      138.644813,
      37,
      0,
      5.824958,
      1178.923180,
      708.085766,
      1,
      NULL,
      116.733582,
      647.037578,
      1,
      0.103567,
      1333,
      111,
      3.658823,
      NULL,
      NULL,
      30,
      NULL,
      1.001611,
      555,
      NULL,
      1,
      2,
      129,
      0.716958,
      2.668511,
      2.804251,
      254.171081,
      1.182795,
      0.754095,
      2.244480,
      141,
      5.130557,
      0.809888,
      1.231081,
      NULL,
      4.791023,
      1,
      3.306242,
      821.630426,
      2.527585,
      2.601363,
      0,
      423.314028,
      6,
      1.389606,
      NULL,
      51.908359,
      NULL,
      3.695838,
      1.562224,
      933,
      1.615503,
      0,
      6,
      NULL,
      9,
      0,
      5,
      175.379368,
      NULL,
      0,
      4.260192,
      155,
      205.299851,
      2,
      3.390843,
      NULL,
      354.145619,
      1.894725,
      0,
      977,
      2,
      0,
      3,
      95.131815,
      482,
      2,
      2,
      754.836676,
      5.611618,
      2.191068,
      3.033105,
      140.207924,
      252.107834,
      0.089184,
      3.958973,
      151,
      516,
      3.620077,
      NULL,
      176.437681,
      670.390774,
      0.394767,
      4,
      160.995323,
      167,
      3.220444,
      4.976560,
      166,
      NULL,
      1,
      NULL,
      88,
      NULL,
      0,
      1.970813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.371987,
      '11441',
      '04021',
      NULL,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      4,
      '3211',
      '4023',
      NULL,
      3,
      1.635978,
      NULL,
      NULL,
      NULL,
      1.800251,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.788867,
      69.930836,
      1,
      NULL,
      ' 8- 7-1987',
      13.236141,
      3,
      11.019014,
      NULL,
      NULL,
      14,
      11.705087,
      10,
      7.165241,
      8.377286,
      9,
      0.848264,
      11,
      12.645984,
      17,
      NULL,
      NULL,
      2,
      6.078962,
      22.407552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.324359,
      NULL,
      NULL,
      5.081214,
      NULL,
      NULL,
      31,
      1.059464,
      NULL,
      29.968750,
      20,
      14,
      19,
      NULL,
      12.692714,
      NULL,
      1,
      0.558902,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53.060849,
      92.815021,
      16,
      71.088822,
      NULL,
      NULL,
      NULL,
      NULL,
      63,
      NULL,
      5,
      27.042303,
      97,
      14,
      158,
      169.089223,
      NULL,
      39.045801,
      113,
      123,
      41,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531165,
      3,
      NULL,
      4.294936,
      4,
      0,
      8.462213,
      6,
      NULL,
      NULL,
      NULL,
      1,
      6,
      NULL,
      3,
      7,
      4,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.477621,
      NULL,
      2,
      6,
      1.615937,
      8,
      4,
      6.529707,
      NULL,
      10.308507,
      2,
      1.367902,
      9,
      2.394109,
      2,
      3.116607,
      3,
      6,
      NULL,
      3.592067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.419193,
      2.547437,
      1.238108,
      NULL,
      0.033321,
      2.683722,
      NULL,
      7,
      1.713632,
      5,
      1,
      5.866378,
      1,
      2.907729,
      5,
      4,
      6.418249,
      2.315562,
      7.676938,
      7.503005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.102683,
      0.662971,
      NULL,
      4.228616,
      NULL,
      5.205427,
      0.729973,
      1,
      2.239377,
      3.915109,
      4.988066,
      8,
      NULL,
      NULL,
      9,
      4.355674,
      7,
      0,
      6.682922,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.526875,
      2,
      7.075597,
      3.894118,
      7.609529,
      0.622096,
      4,
      2,
      NULL,
      0,
      7.267533,
      1.973278,
      NULL,
      6,
      6.036439,
      4.542164,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.862120,
      1,
      5,
      7,
      7.005335,
      NULL,
      2.541079,
      7,
      NULL,
      8,
      3.502151,
      NULL,
      6,
      3,
      8.459906,
      2,
      NULL,
      7.704699,
      11.617060,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      5.292200,
      1.652345,
      0,
      1,
      3.770525,
      1,
      7,
      4.334296,
      NULL,
      NULL,
      1.734019,
      5,
      5.542213,
      6.925167,
      0.412659,
      7,
      11,
      7.351114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064493,
      3,
      NULL,
      3,
      4,
      1,
      NULL,
      0,
      NULL,
      5.230693,
      4,
      NULL,
      2.052022,
      3.180700,
      0,
      7,
      4.415761,
      1.780365,
      4,
      2,
      1.998192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.275000,
      4.289009,
      7.530699,
      NULL,
      NULL,
      NULL,
      2.675778,
      6.018694,
      3,
      9.372732,
      5.537275,
      2,
      8,
      NULL,
      8.969114,
      3,
      3.387084,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      4,
      5.680912,
      1,
      0.738772,
      2,
      0.421032,
      NULL,
      3.135336,
      1,
      NULL,
      0,
      3,
      0.129533,
      NULL,
      1.952500,
      5,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.279992,
      1.034623,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0.054575,
      0,
      1.348949,
      0,
      1,
      0.281490,
      1.220410,
      1,
      0.811383,
      1.972324,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.838904,
      2.381782,
      3.471810,
      0.516147,
      NULL,
      3,
      NULL,
      2,
      3.887765,
      0,
      0,
      3,
      0.440001,
      2.687712,
      1.071975,
      1.398301,
      3.511322,
      0,
      1,
      3.178538,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.737315,
      1,
      0,
      1,
      0,
      0,
      1.089531,
      1.542452,
      NULL,
      1.926322,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0.585669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      7.315338,
      3.472153,
      4.456429,
      1,
      3.882077,
      8,
      NULL,
      4,
      5,
      2.376445,
      5,
      5.070759,
      8,
      7.214569,
      NULL,
      5,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      5,
      5,
      1.390503,
      7,
      4.962355,
      0.669733,
      8,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.998923,
      4.426829,
      1,
      0,
      2.612080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.428550,
      0,
      1,
      0.122260,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.723811,
      0.373491,
      0,
      0.277934,
      1,
      0.444389,
      1.420054,
      0,
      1,
      1.559855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469874,
      1.835035,
      2.895193,
      1.664595,
      2.626523,
      NULL,
      2.344262,
      NULL,
      2.142715,
      2.848023,
      3.151020,
      3,
      3.263951,
      3.081394,
      3,
      2.521511,
      3.340017,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      1,
      0,
      2,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      1,
      NULL,
      2,
      0,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      3,
      0,
      NULL,
      3,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 7-1986',
      NULL,
      ' 9- 6-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-10-1997',
      '11-25-1981',
      NULL,
      NULL,
      ' 3-16-1995',
      NULL,
      ' 7-17-1975',
      NULL,
      ' 3-18-1985',
      ' 1- 6-1986',
      NULL,
      NULL,
      NULL,
      ' 3-12-1980',
      ' 8-27-1983',
      ' 1-23-1979',
      NULL,
      ' 1- 4-1999',
      ' 1- 2-1990',
      ' 7- 8-1980',
      NULL,
      NULL,
      ' 7- 7-1985',
      ' 4-21-1989',
      '10- 4-1995',
      ' 1-26-1975',
      ' 7-20-1981',
      NULL,
      NULL,
      ' 1-28-1986',
      NULL,
      ' 3-15-2003',
      ' 7-10-1985',
      '10- 2-1988',
      ' 8- 4-2003',
      NULL,
      ' 3- 7-2003',
      '11-26-1989',
      ' 5- 2-1975',
      ' 4-23-1974',
      ' 7-17-1994',
      '10-18-1986',
      ' 4- 4-1977',
      ' 2- 2-1993',
      ' 6-17-1978',
      ' 8-28-1986',
      ' 1-19-1988',
      ' 8-27-1991',
      ' 4-22-1975',
      ' 1- 6-1987',
      ' 8- 3-2001',
      ' 0- 0-1991',
      '11- 4-1994',
      ' 7-28-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-22-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


