set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6100037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '0110411',
      NULL,
      3,
      0,
      '30034',
      2.130506,
      ' 4-14-1988',
      25,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1.458074,
      1,
      1,
      2,
      3,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2,
      NULL,
      0,
      25.686766,
      4.187040,
      1,
      2,
      NULL,
      NULL,
      4,
      0,
      3,
      NULL,
      NULL,
      6,
      7,
      6,
      5,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      4,
      NULL,
      7,
      3.087494,
      4,
      4.802141,
      2,
      0.592888,
      1.450294,
      1,
      0.154278,
      3,
      1,
      NULL,
      1.980037,
      4,
      7,
      7.617478,
      7,
      1,
      4,
      1.152118,
      0.054117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      NULL,
      0,
      0,
      31,
      NULL,
      8.443719,
      0.925077,
      1,
      161,
      1.277879,
      2,
      0,
      174,
      4.262493,
      0.381408,
      NULL,
      58.911273,
      3,
      2,
      NULL,
      NULL,
      16.142030,
      3,
      0,
      232,
      5,
      3.593705,
      NULL,
      112.427518,
      3.324837,
      NULL,
      NULL,
      NULL,
      1,
      1.513084,
      1,
      NULL,
      NULL,
      0,
      0,
      1012,
      45,
      NULL,
      NULL,
      NULL,
      NULL,
      9.760275,
      2.227682,
      89.221606,
      62.907334,
      4,
      3,
      31.571595,
      89.609770,
      5.116169,
      1,
      NULL,
      NULL,
      9.950348,
      3.284516,
      210.345141,
      33.163239,
      0,
      2.370500,
      128.385477,
      286,
      NULL,
      2.203700,
      78,
      50,
      0.833930,
      3,
      NULL,
      63,
      0.526729,
      3,
      171.027308,
      48.448742,
      0.555427,
      0.374682,
      75,
      223.699364,
      1,
      2.191441,
      110,
      382.428484,
      2.001739,
      8.939145,
      34,
      62,
      0,
      0.798791,
      221,
      1.321002,
      0.460074,
      NULL,
      53.784455,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.450146,
      '23014',
      '41042',
      NULL,
      '',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      3,
      1.306751,
      NULL,
      1,
      NULL,
      0.789445,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.598295,
      157,
      0,
      NULL,
      0.866920,
      NULL,
      1,
      NULL,
      ' 1- 8-2003',
      2.780799,
      19,
      5.146070,
      4,
      2,
      1.152771,
      NULL,
      9,
      23,
      NULL,
      NULL,
      20.045545,
      20,
      0,
      10,
      NULL,
      5,
      NULL,
      NULL,
      11.551886,
      12.548723,
      NULL,
      2.774760,
      2.866027,
      6.809782,
      13.554424,
      0.175067,
      2.354807,
      2.474200,
      1,
      6.290077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.082305,
      11.432333,
      16.703934,
      NULL,
      11.822084,
      31,
      NULL,
      NULL,
      54.168002,
      NULL,
      33.803556,
      NULL,
      11,
      NULL,
      49.952954,
      11,
      14,
      NULL,
      41,
      NULL,
      34,
      13.115062,
      NULL,
      NULL,
      NULL,
      1.749560,
      25.021908,
      3.960569,
      NULL,
      3,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42.915413,
      27.491200,
      151.754185,
      103,
      46.761511,
      NULL,
      9.475827,
      84.273882,
      4.722504,
      NULL,
      126,
      142,
      152,
      NULL,
      180,
      142.071797,
      91,
      121.170021,
      0.282231,
      175,
      105,
      165,
      22.966511,
      21,
      160.359106,
      NULL,
      86.164752,
      183.946552,
      190.294633,
      121,
      25.227748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426803,
      1.347229,
      3.420086,
      1.757714,
      2.072146,
      5.868364,
      1,
      5,
      2,
      2.364623,
      1,
      NULL,
      0,
      1,
      4,
      2.817842,
      2.005102,
      0.579296,
      NULL,
      1,
      0.588323,
      NULL,
      2.425812,
      NULL,
      7,
      2,
      4.619382,
      5.278288,
      0.072823,
      4.174137,
      0.322094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.286080,
      3.212504,
      5,
      3,
      5,
      1.956350,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0.750986,
      0,
      1.781551,
      1.330027,
      0.275306,
      3.988119,
      NULL,
      1,
      3,
      0,
      NULL,
      4.888510,
      6,
      NULL,
      1.776488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.568658,
      2.858403,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      0.774262,
      1.329150,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.826105,
      NULL,
      0.665734,
      3,
      3.740487,
      3.080788,
      NULL,
      0,
      3,
      1.863174,
      3.771734,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859083,
      0.536735,
      NULL,
      0,
      1.994169,
      0,
      0.747390,
      0.894269,
      4.519727,
      3,
      1.661022,
      0.610373,
      0,
      1.298860,
      NULL,
      NULL,
      0.177792,
      0,
      0.156264,
      1.867177,
      1.096371,
      0.914731,
      0.545183,
      NULL,
      1.363442,
      1,
      1.537743,
      NULL,
      2.520819,
      4.719564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202183,
      1.156077,
      NULL,
      0,
      0.340195,
      NULL,
      NULL,
      0,
      0.557421,
      0,
      1,
      NULL,
      1,
      1.490973,
      0.436164,
      0,
      NULL,
      1,
      1,
      0.755925,
      1.804952,
      1,
      1,
      1.960123,
      1.236320,
      1,
      1.403548,
      2.919179,
      7.957018,
      1,
      0.762134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862701,
      2,
      5.672114,
      0,
      4.820264,
      4,
      5,
      0.973358,
      2.274973,
      NULL,
      1.041507,
      1.267383,
      4.581466,
      4.852413,
      NULL,
      3.806502,
      5,
      NULL,
      NULL,
      NULL,
      0,
      1.680568,
      NULL,
      6.402378,
      0.436092,
      1,
      7,
      4.924542,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      3.098261,
      5,
      5,
      2.161519,
      1,
      4,
      1,
      6.086021,
      6,
      6.377676,
      1.546174,
      5,
      1,
      3.909687,
      7,
      4,
      4.025191,
      NULL,
      7.921676,
      NULL,
      4,
      2.837809,
      7,
      5,
      7,
      4,
      4.530202,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692159,
      NULL,
      1.280919,
      0,
      1,
      0,
      1.187129,
      1.442673,
      1,
      6.944901,
      2,
      0,
      1.092049,
      0,
      0,
      0.066482,
      0,
      2.854524,
      NULL,
      2,
      2,
      1.164658,
      1,
      3.981807,
      0.188059,
      1.936568,
      0,
      1.671631,
      2.851845,
      2.212589,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      3.526165,
      0.166721,
      NULL,
      NULL,
      NULL,
      2,
      0.458872,
      0,
      2,
      2.737462,
      0.439542,
      1,
      1.459582,
      NULL,
      0,
      0.002174,
      2.236663,
      3.229532,
      0,
      2,
      3.137849,
      3.390747,
      1.847363,
      5.227773,
      3,
      0.354988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      4.806910,
      1,
      1,
      0,
      0,
      1,
      0.804591,
      0.000843,
      1.678892,
      1.989513,
      0.426987,
      0.140203,
      0.176005,
      1.762895,
      0.552838,
      0.931867,
      0,
      1.588703,
      0.433234,
      1,
      1,
      1.199693,
      NULL,
      0.199604,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.465535,
      0.084337,
      1,
      1,
      1.185697,
      NULL,
      1.257304,
      1,
      1,
      0.993167,
      0,
      0.154095,
      0.071811,
      NULL,
      1,
      0.700327,
      0,
      NULL,
      1,
      1.727810,
      1.020032,
      1.572350,
      0.170374,
      NULL,
      0.366056,
      1,
      1.982722,
      1,
      0.319683,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252323,
      4,
      3.751142,
      1.528369,
      2,
      NULL,
      NULL,
      7,
      1.894676,
      7.351348,
      NULL,
      NULL,
      3.256259,
      2,
      NULL,
      2.724504,
      NULL,
      NULL,
      1.987295,
      NULL,
      NULL,
      3.753350,
      6.199259,
      2.376537,
      NULL,
      NULL,
      2,
      0,
      3,
      0.288565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.471085,
      NULL,
      0,
      NULL,
      0.423848,
      NULL,
      0.910156,
      0,
      6,
      1.026438,
      1.747355,
      1.756942,
      5,
      3,
      2.489855,
      NULL,
      0.698718,
      1.984747,
      0.595492,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      0,
      0,
      0.534530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970668,
      NULL,
      1.724920,
      3,
      1,
      6.208460,
      0,
      6,
      3.318131,
      6.256496,
      0,
      NULL,
      NULL,
      1,
      3.308626,
      1,
      3.472590,
      1,
      0.303283,
      0.882369,
      1.806789,
      1,
      4,
      0,
      7,
      2,
      2,
      6.054196,
      4,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3,
      0.360078,
      0.642697,
      NULL,
      3.869529,
      0.117311,
      3.772193,
      1.057583,
      NULL,
      1.870427,
      0,
      5.564310,
      6,
      0.943789,
      NULL,
      2,
      7.004073,
      7.124715,
      2,
      6.296802,
      2.612994,
      3,
      0.745494,
      NULL,
      4.083648,
      5,
      2,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.040380,
      1.470211,
      0,
      0,
      0.624937,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0.695993,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.729585,
      1,
      0.770444,
      NULL,
      1,
      0.894509,
      0,
      0.897065,
      0.202842,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.192336,
      5,
      2.785283,
      0,
      4.635915,
      3.636390,
      4,
      0.635292,
      2.635078,
      0,
      4,
      NULL,
      2.294325,
      0,
      3,
      0,
      0.896180,
      NULL,
      4,
      1.617345,
      5.874765,
      1,
      NULL,
      NULL,
      0.027118,
      0.655271,
      0,
      1,
      NULL,
      1.169452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      7,
      2,
      1,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      3,
      2,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      0,
      4,
      1,
      5,
      2,
      1,
      2,
      NULL,
      3,
      5,
      0,
      NULL,
      2,
      1,
      1,
      3,
      4,
      2,
      4,
      2,
      2,
      4,
      3,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-14-1996',
      '11-26-1980',
      ' 5-14-1976',
      NULL,
      ' 5-18-1988',
      ' 8- 3-1981',
      ' 7-14-1977',
      NULL,
      '11-25-1997',
      ' 1-23-1977',
      '10-29-1981',
      '11-23-1996',
      ' 5- 5-1988',
      ' 0-18-2003',
      '10-29-1980',
      ' 5- 4-1979',
      ' 0-12-2003',
      NULL,
      ' 5- 4-1999',
      ' 6-10-1993',
      ' 7-13-1999',
      ' 6-12-1994',
      '10-14-1988',
      ' 5-24-1992',
      ' 1- 1-1987',
      ' 2-12-1997',
      NULL,
      NULL,
      ' 0- 6-1993',
      ' 9-10-1993',
      ' 7-12-1993',
      ' 5-22-1993',
      NULL,
      ' 8-26-2000',
      '10-17-1998',
      '10- 0-1982',
      ' 8-28-1997',
      ' 9-20-1985',
      ' 3- 9-1974',
      ' 9- 3-2000',
      ' 8-19-1987',
      NULL,
      ' 4-10-1976',
      '11-12-1997',
      ' 0-22-1992',
      NULL,
      ' 9-29-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.725716);
commit;
end;
/


