set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8927024';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      '2413234',
      0,
      3.412425,
      0,
      '40412',
      0.042083,
      ' 9- 2-1993',
      50,
      NULL,
      0,
      2,
      3,
      NULL,
      1,
      0,
      0.053313,
      3.528287,
      NULL,
      1.700175,
      0.865354,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      21.023359,
      NULL,
      NULL,
      2.442426,
      NULL,
      4.391318,
      1,
      1.310490,
      3.688682,
      NULL,
      NULL,
      0,
      2,
      5,
      2,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      9,
      1,
      1,
      NULL,
      1,
      0,
      0,
      5,
      11.018935,
      NULL,
      17.122371,
      5,
      5,
      3,
      2,
      8,
      4,
      0.735760,
      NULL,
      15,
      NULL,
      10.104184,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      11.085850,
      NULL,
      18,
      2.657261,
      2.618200,
      220,
      NULL,
      0,
      0.382227,
      222,
      48,
      NULL,
      0.520721,
      226,
      NULL,
      1.993675,
      1,
      NULL,
      NULL,
      2.966948,
      2,
      106.765106,
      68.214262,
      5,
      6.254512,
      NULL,
      16.935428,
      0.441416,
      2.238782,
      8.089259,
      NULL,
      NULL,
      2.719284,
      188.893424,
      20.837478,
      NULL,
      3,
      111.473132,
      NULL,
      2.129493,
      3.960314,
      NULL,
      3.926758,
      2,
      6.414109,
      NULL,
      40,
      1,
      2.764009,
      NULL,
      14.658426,
      NULL,
      0.344721,
      460,
      9,
      1,
      0,
      91.484400,
      4,
      2.208140,
      5.996848,
      283,
      58,
      2,
      3.936828,
      509,
      2.148978,
      2.252856,
      2.580176,
      42,
      NULL,
      2,
      0.936490,
      152,
      68,
      0.170208,
      NULL,
      24.991528,
      1,
      3,
      1,
      185,
      8,
      0.914973,
      2,
      152,
      175,
      NULL,
      4.751678,
      146.474144,
      182.991383,
      3.303850,
      1,
      NULL,
      230,
      0.177166,
      3,
      3.715184,
      195.971135,
      0,
      3.459224,
      NULL,
      NULL,
      NULL,
      4,
      152.900911,
      553,
      0.447405,
      5,
      3.178355,
      156,
      3,
      2.512578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.079029,
      '34401',
      '04024',
      '',
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      1.705851,
      NULL,
      NULL,
      2,
      1.920937,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.169708,
      NULL,
      1.473678,
      NULL,
      NULL,
      291,
      0,
      NULL,
      ' 8-26-1993',
      NULL,
      1.624573,
      12.677849,
      NULL,
      6,
      9,
      NULL,
      NULL,
      0.044020,
      4,
      NULL,
      2.271944,
      4,
      9.272638,
      0,
      7.988690,
      2,
      1,
      8.497789,
      11.465615,
      19,
      16.308511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      10.753679,
      1.548933,
      NULL,
      NULL,
      17,
      18.547007,
      12,
      NULL,
      1,
      NULL,
      19,
      44,
      0.985971,
      NULL,
      14,
      16,
      31,
      5.667679,
      12.405933,
      32,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      72,
      142,
      136.451355,
      21.902168,
      42.583200,
      19.302231,
      44.637617,
      48.987001,
      106,
      90.801860,
      2,
      119.068060,
      112.602475,
      120,
      NULL,
      NULL,
      NULL,
      140.085466,
      137.055978,
      1,
      86.697619,
      147.894015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399202,
      1.693421,
      10,
      3.028404,
      1.253029,
      5,
      4.095759,
      4.115788,
      9,
      5.727487,
      6.025585,
      6,
      9,
      5,
      1.285896,
      5,
      3.466059,
      5.075287,
      2,
      6.045042,
      1,
      2.679766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900303,
      NULL,
      0,
      0.833795,
      1,
      3.171539,
      2.907055,
      5,
      11,
      1.733311,
      3,
      NULL,
      0,
      1.423168,
      2,
      1,
      NULL,
      3.828444,
      8.864846,
      NULL,
      0.241615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9.193707,
      0.426731,
      4.447298,
      0,
      7.125723,
      NULL,
      5.970669,
      0.680583,
      2.708276,
      1.674471,
      5.093302,
      0,
      1,
      0.251844,
      NULL,
      1,
      NULL,
      0.448616,
      NULL,
      0.448316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423579,
      1,
      1.408531,
      1,
      0.534386,
      NULL,
      0,
      1.661123,
      NULL,
      1,
      1.421279,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.446640,
      1.104380,
      NULL,
      1.384040,
      0.477316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.123245,
      NULL,
      0.234454,
      4,
      5.486763,
      1,
      0,
      NULL,
      5,
      NULL,
      5,
      5,
      1.518076,
      NULL,
      7.149171,
      2,
      2.622033,
      0.682316,
      7.372880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184910,
      1,
      4.435517,
      5.434133,
      NULL,
      3.887299,
      4.515512,
      0,
      4.805762,
      NULL,
      4,
      1.284299,
      6,
      4,
      3,
      5.161383,
      1,
      0.342701,
      6,
      1.584741,
      5,
      0.128735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.577202,
      1.468841,
      2.254270,
      NULL,
      NULL,
      5.082046,
      6,
      NULL,
      6,
      NULL,
      3.028056,
      4,
      2.286477,
      NULL,
      0,
      3,
      1,
      6.545006,
      5.872059,
      1,
      7.451829,
      3.660563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.606824,
      0.746260,
      NULL,
      5,
      0,
      NULL,
      0.561611,
      NULL,
      0.728628,
      3.714798,
      NULL,
      0.967904,
      4.381875,
      NULL,
      2,
      NULL,
      7,
      6,
      7,
      3,
      1,
      1.930992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730588,
      1.970546,
      1,
      0,
      0.905601,
      1,
      3.710906,
      NULL,
      2,
      0.295825,
      2.362776,
      0,
      0.458819,
      NULL,
      1,
      1,
      1.630086,
      1.564037,
      NULL,
      1,
      3,
      1.937487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.407667,
      1,
      1,
      0,
      NULL,
      1,
      1.136863,
      0.364151,
      4,
      1,
      NULL,
      0.733613,
      1.988404,
      NULL,
      1.300909,
      1,
      1,
      NULL,
      1.825399,
      0.649422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.194370,
      1,
      0,
      1.704014,
      0.038120,
      1,
      0,
      1,
      0.048409,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.881279,
      1,
      NULL,
      0.891408,
      NULL,
      0,
      0.066394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.139733,
      1,
      5,
      3.642077,
      0.071656,
      0.996617,
      5,
      5.732944,
      0.233555,
      NULL,
      NULL,
      3.765795,
      NULL,
      1.232591,
      5.366215,
      3.640146,
      3.582762,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.789508,
      0.640563,
      0.276907,
      NULL,
      1,
      1,
      0.930500,
      0.224110,
      1,
      0,
      1,
      1.770916,
      1,
      NULL,
      0,
      0.109177,
      1,
      0,
      NULL,
      NULL,
      0.186845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      4,
      2.750553,
      9.085248,
      5,
      11,
      4,
      NULL,
      4.693015,
      NULL,
      0.257435,
      5.558793,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944288,
      NULL,
      NULL,
      NULL,
      7.535625,
      4,
      8.872361,
      2.186202,
      4.785115,
      0,
      2,
      3,
      NULL,
      1,
      2.624902,
      1.573775,
      3.821733,
      6,
      2,
      1,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.527705,
      0,
      1,
      0.921885,
      0.643805,
      NULL,
      0.406150,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.426687,
      1.602728,
      1,
      0.054393,
      1,
      0.531304,
      0.744174,
      0.586478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.918271,
      1,
      0,
      2.473548,
      0,
      1.757384,
      0,
      2.282862,
      3.178064,
      0.991520,
      NULL,
      0.145815,
      3.948213,
      NULL,
      1.115341,
      0,
      0.282092,
      2,
      0.431321,
      NULL,
      0,
      1.826683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0,
      5,
      0,
      3,
      1,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      3,
      0,
      4,
      0,
      3,
      0,
      1,
      2,
      1,
      0,
      NULL,
      2,
      0,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.033634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 5-1979',
      ' 5-22-1988',
      NULL,
      ' 6- 8-1983',
      ' 5- 1-1976',
      '10-24-1994',
      ' 4-12-1996',
      NULL,
      NULL,
      ' 2-14-1976',
      ' 3- 1-1982',
      ' 3-23-1977',
      NULL,
      NULL,
      NULL,
      ' 9-10-1995',
      NULL,
      ' 8-13-1986',
      ' 3-24-1979',
      ' 8-18-1987',
      ' 1- 3-1978',
      ' 4- 4-1982',
      '10- 1-1976',
      '10-24-1984',
      '11- 1-1992',
      ' 6-26-1979',
      ' 1-27-1977',
      NULL,
      ' 1- 8-1981',
      ' 5- 1-1997',
      NULL,
      ' 8- 7-1983',
      NULL,
      ' 1- 2-1995',
      ' 5- 6-2002',
      '11-27-2002',
      ' 8-21-1985',
      '10- 9-1997',
      ' 9- 4-1997',
      ' 2-11-2002',
      ' 5- 5-1989',
      ' 8- 9-1991',
      ' 2-12-1983',
      ' 0-19-1988',
      ' 4-13-1992',
      ' 3-19-1988',
      ' 4- 9-1974',
      ' 7- 4-1977',
      ' 2-24-1979',
      ' 7-24-1998',
      ' 1- 0-1987',
      '10- 4-1983',
      ' 2-12-1987',
      ' 4-21-1998',
      ' 4- 7-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 1-1985',
      NULL,
      ' 7-24-2001',
      ' 4- 1-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878320);
commit;
end;
/


