set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530250';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04401003',
      31,
      NULL,
      '3224221',
      0,
      2.255821,
      NULL,
      NULL,
      1,
      ' 3- 6-1990',
      33.383634,
      NULL,
      2,
      0,
      2,
      2.765790,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1.400722,
      7,
      NULL,
      NULL,
      1.153561,
      NULL,
      0,
      27,
      0.120642,
      7.220413,
      NULL,
      NULL,
      9.855560,
      0,
      2.434071,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      0,
      1,
      2,
      1,
      0,
      0,
      1,
      1,
      4,
      6,
      NULL,
      NULL,
      1.634308,
      0.724492,
      1.761685,
      0.872589,
      2,
      1,
      NULL,
      0,
      0,
      NULL,
      6,
      8,
      6.258269,
      7,
      NULL,
      0.905252,
      NULL,
      NULL,
      NULL,
      NULL,
      1.409036,
      1.929661,
      0,
      1,
      NULL,
      NULL,
      2,
      90,
      79,
      0,
      0.443554,
      2,
      175.729853,
      2.577472,
      3.890460,
      1.101471,
      NULL,
      26,
      2,
      7,
      80,
      NULL,
      3,
      7.750814,
      13,
      6.753412,
      0.074822,
      1.562061,
      NULL,
      NULL,
      1,
      NULL,
      103,
      1.178887,
      2,
      7.626014,
      114.333495,
      69.399510,
      4,
      5,
      85.945207,
      NULL,
      0.665365,
      6.610900,
      191,
      73.223975,
      6.771393,
      2,
      104,
      NULL,
      3.446912,
      6,
      119.365644,
      0.198639,
      NULL,
      1,
      104,
      NULL,
      1,
      5.245592,
      164.565033,
      9,
      3.035490,
      0.627003,
      199.935962,
      NULL,
      3,
      0.025009,
      156.373075,
      NULL,
      3,
      1.415648,
      55.392594,
      4,
      0.647098,
      3.824682,
      55.405126,
      13.254032,
      2,
      2.740256,
      157,
      151.554462,
      2,
      6.025780,
      184.501267,
      NULL,
      7,
      2,
      136,
      49.770014,
      0,
      1.970404,
      160,
      86,
      5,
      NULL,
      NULL,
      3,
      1,
      NULL,
      41.574081,
      0.557050,
      1,
      NULL,
      6,
      0,
      2.991814,
      1,
      60.612627,
      NULL,
      NULL,
      3,
      161.548488,
      6,
      0.094601,
      1,
      564,
      28,
      2.158553,
      3.766509,
      99,
      NULL,
      3,
      5,
      NULL,
      1187.612716,
      0,
      5,
      173.678124,
      1023,
      0,
      7,
      326,
      2.852782,
      3,
      3.548836,
      156.100289,
      NULL,
      3,
      1,
      48.543337,
      355,
      0,
      3.485747,
      137.447899,
      6,
      2.282491,
      NULL,
      50.238866,
      10.512930,
      2,
      NULL,
      177,
      33,
      NULL,
      7.302769,
      205,
      154.190209,
      2,
      5.013691,
      131.917417,
      NULL,
      1.581417,
      1.239133,
      983.973197,
      2,
      3,
      2,
      5,
      NULL,
      0,
      3,
      NULL,
      30,
      NULL,
      1,
      805,
      NULL,
      NULL,
      4.188314,
      784,
      2,
      0.410384,
      NULL,
      50.411035,
      41.989842,
      1.143323,
      3.874339,
      88,
      73.377421,
      2,
      3,
      468.793037,
      19,
      NULL,
      0,
      444,
      75.110495,
      0.133418,
      3,
      600,
      279,
      NULL,
      5.239180,
      76.180862,
      248.388594,
      3.567552,
      2.232285,
      87,
      75,
      3,
      4,
      86,
      15,
      0,
      3,
      174.038632,
      56.116928,
      0,
      3,
      114,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '21220',
      '',
      '',
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1.791643,
      '',
      '',
      '',
      NULL,
      1.719889,
      NULL,
      0,
      123.806671,
      1.520866,
      NULL,
      0.287009,
      NULL,
      1.108687,
      NULL,
      1.568844,
      NULL,
      0.465086,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.033319,
      NULL,
      ' 3-29-2002',
      2,
      4.975850,
      0,
      NULL,
      3,
      20,
      0,
      4.139228,
      8,
      0.498265,
      NULL,
      6,
      4,
      1.242457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101883,
      3,
      3.117333,
      14.448576,
      30.291799,
      35,
      4,
      20.732306,
      16.615681,
      NULL,
      50.657595,
      NULL,
      9,
      20.628884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      157,
      10.513938,
      86,
      NULL,
      127.577561,
      91.030278,
      74,
      137.081079,
      2,
      NULL,
      3.020031,
      5.582786,
      6,
      2.565051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.764384,
      3.099238,
      NULL,
      4,
      4.462899,
      7.901337,
      6,
      NULL,
      9,
      NULL,
      2,
      5,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.556059,
      5,
      NULL,
      9,
      10,
      0,
      NULL,
      8,
      1.603071,
      2.278647,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.251298,
      NULL,
      1,
      1,
      1.755688,
      1,
      1.505801,
      NULL,
      1,
      0.548252,
      1.220476,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.668217,
      NULL,
      0,
      2.427874,
      0.926734,
      NULL,
      4,
      4.727040,
      1.093219,
      0,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.048550,
      1,
      1.985499,
      1,
      NULL,
      4,
      7.390920,
      5,
      NULL,
      4,
      0,
      6.688778,
      1.090456,
      6.809624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.876900,
      NULL,
      3.380699,
      5,
      1,
      5,
      9,
      9,
      1.311362,
      NULL,
      6,
      5.910104,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.575866,
      2,
      4,
      NULL,
      2,
      7,
      3,
      NULL,
      0,
      4.216137,
      1,
      1,
      5,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      3.123060,
      6.701279,
      NULL,
      1,
      9.167182,
      3,
      NULL,
      8,
      5.197953,
      9.503827,
      NULL,
      6.516266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.164171,
      1,
      0,
      0,
      0.973792,
      1,
      0,
      1.925568,
      1,
      0,
      1,
      0.474115,
      0,
      1.982014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274127,
      0,
      1,
      1.638297,
      0,
      0,
      0.691033,
      0,
      0,
      0,
      1,
      0.221336,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.868126,
      1,
      0.674896,
      1.621647,
      NULL,
      1.984204,
      NULL,
      1.818586,
      1.776586,
      NULL,
      1,
      1.827097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842802,
      1,
      0.189740,
      0.150143,
      0.113714,
      0,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0.350802,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.158776,
      NULL,
      0.391905,
      0.652236,
      NULL,
      1,
      0,
      0.798828,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.336268,
      2,
      4,
      5,
      6.795125,
      2,
      0,
      5.059826,
      4,
      7.603184,
      8,
      3.385718,
      0.752355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445002,
      3,
      NULL,
      5,
      NULL,
      2.762467,
      2,
      4.516327,
      4,
      6.216026,
      3,
      7,
      8.149449,
      2.881615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.991820,
      0,
      1.194386,
      0,
      1.941509,
      0.887863,
      1,
      NULL,
      0.195291,
      NULL,
      1,
      0.115566,
      1.880866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.958611,
      1.493327,
      1,
      1,
      1,
      1,
      0.637391,
      1.785990,
      0.419920,
      NULL,
      0.256396,
      1,
      1.077135,
      0.078104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      1,
      1,
      0,
      4,
      1,
      4,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-17-1997',
      ' 6- 7-1975',
      NULL,
      ' 5-16-1995',
      NULL,
      ' 7- 0-1996',
      NULL,
      ' 1-15-1990',
      ' 3-10-1987',
      ' 1-19-1994',
      ' 3-27-1985',
      NULL,
      NULL,
      ' 0-29-1983',
      ' 5-24-1976',
      ' 3-25-2002',
      NULL,
      ' 2- 1-1996',
      NULL,
      ' 9-25-2002',
      ' 7-14-1984',
      ' 5-18-1997',
      ' 0-25-2003',
      ' 5-11-1999',
      ' 8- 7-2002',
      ' 2-17-1988',
      ' 3-24-1978',
      ' 5- 7-1977',
      ' 6-24-1994',
      ' 5-12-1999',
      ' 3-28-1974',
      ' 9- 2-1998',
      '10-19-1978',
      ' 4- 1-1986',
      ' 1- 9-1975',
      ' 8- 5-1979',
      NULL,
      ' 8-23-1995',
      ' 7- 5-1987',
      ' 5-15-1987',
      ' 3- 7-1987',
      ' 1- 8-1983',
      ' 6-25-1997',
      ' 2- 2-1992',
      NULL,
      NULL,
      ' 7-19-1979',
      ' 3-11-1996',
      ' 6-23-1986',
      ' 9-21-1996',
      NULL,
      ' 5- 1-1997',
      ' 9-18-1990',
      ' 4-14-1991',
      ' 0-22-1974',
      ' 2-28-1975',
      ' 3-15-1993',
      ' 9- 7-2000',
      NULL,
      ' 2-27-1997',
      ' 9-28-1978',
      ' 8- 7-1983',
      ' 9-27-2003',
      '10-13-1992',
      '10- 7-1994',
      ' 4-24-1988',
      ' 8-26-2000',
      ' 3-13-1992',
      ' 2-13-1984',
      ' 5- 4-2000',
      NULL,
      ' 4-17-1977',
      ' 2-26-1987',
      ' 7- 2-1998',
      ' 0- 2-1987',
      NULL,
      ' 4-24-1989',
      NULL,
      ' 3-22-1993',
      ' 2-10-1991',
      ' 1-22-1987',
      NULL,
      ' 7- 8-1995',
      ' 3- 7-1977',
      NULL,
      ' 4-19-1983',
      ' 7- 7-1997',
      ' 9-24-1995',
      '11-24-1993',
      NULL,
      ' 2-19-2002',
      NULL,
      NULL,
      NULL,
      ' 1-22-1976',
      NULL,
      ' 3-11-1977',
      ' 5-18-1993',
      ' 2-18-1989',
      NULL,
      ' 6-12-1986',
      NULL,
      NULL,
      NULL,
      ' 2-21-1982',
      NULL,
      ' 5- 1-1981',
      ' 1-16-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-18-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


