set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      '10',
      NULL,
      NULL,
      '0200120',
      NULL,
      2,
      3,
      '11021',
      0.706528,
      ' 1- 4-1974',
      106.424971,
      NULL,
      1,
      NULL,
      3.521732,
      0,
      0.250553,
      0,
      0,
      2,
      1,
      1,
      1.156232,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      41,
      2.633446,
      1.731241,
      NULL,
      NULL,
      1,
      1.400705,
      2.489255,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      4,
      0,
      1,
      NULL,
      NULL,
      5,
      6,
      1,
      1,
      2,
      7.517836,
      NULL,
      3,
      7,
      1.811466,
      1,
      0,
      0.035934,
      NULL,
      2,
      2.597727,
      7,
      6.911913,
      1,
      NULL,
      4,
      1.517330,
      NULL,
      2.015056,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      NULL,
      2,
      34.806038,
      NULL,
      0.093212,
      2,
      0,
      38.055363,
      NULL,
      1,
      6,
      802.630259,
      19,
      3.701315,
      5.768197,
      NULL,
      119,
      0.506156,
      2.166126,
      60,
      NULL,
      3,
      5,
      234,
      36.658561,
      1.284377,
      9,
      305,
      6.282285,
      NULL,
      0.898797,
      NULL,
      NULL,
      3,
      7.028603,
      112.344986,
      7,
      2,
      7.771158,
      176.241360,
      71,
      2,
      7.326187,
      NULL,
      71,
      2,
      8,
      238,
      NULL,
      3.021837,
      1,
      165.660275,
      3,
      NULL,
      8,
      NULL,
      0.319876,
      NULL,
      3.249520,
      93.954292,
      760.408878,
      3.501913,
      NULL,
      NULL,
      1014,
      2.934371,
      4,
      NULL,
      1,
      0.423181,
      1,
      176,
      NULL,
      1,
      1,
      559,
      NULL,
      3,
      6.545042,
      127.262496,
      1,
      1.080982,
      0,
      100.745143,
      375,
      3.095235,
      3,
      449,
      102.498181,
      0,
      2,
      623.233386,
      15.529432,
      1,
      NULL,
      511,
      84.367456,
      NULL,
      0,
      147.062422,
      4.644954,
      0.516191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '10314',
      '33341',
      '01320',
      NULL,
      NULL,
      0.093604,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      NULL,
      14.528459,
      2,
      8.449405,
      1,
      NULL,
      1,
      NULL,
      0.889530,
      21,
      0.165427,
      NULL,
      1.486970,
      752,
      1.296470,
      NULL,
      2,
      NULL,
      0,
      16.549880,
      ' 6-13-1986',
      0,
      4,
      2.753669,
      5.154278,
      1,
      7.409428,
      NULL,
      8.297904,
      9,
      10.768634,
      NULL,
      0,
      NULL,
      6.553301,
      NULL,
      NULL,
      0,
      16.361041,
      2,
      3.979016,
      6,
      12.526588,
      1.969864,
      3.163432,
      17,
      4,
      9.021466,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      0,
      0.147979,
      0.269975,
      NULL,
      0,
      1.788480,
      10,
      21.190997,
      4,
      2,
      1,
      5.726879,
      27,
      3,
      NULL,
      0.833211,
      17,
      11,
      51.905592,
      5.275647,
      21,
      19.820641,
      1.475559,
      3.541042,
      16.164801,
      NULL,
      9,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      146.098573,
      111.052148,
      130.751792,
      49.119401,
      181,
      62.887337,
      140.335835,
      NULL,
      80,
      53,
      97,
      83,
      106.028828,
      NULL,
      19.083976,
      118,
      NULL,
      160.002906,
      190,
      77.025544,
      69,
      190.944391,
      79.315559,
      172,
      NULL,
      82,
      144.207023,
      NULL,
      166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.275979,
      6.652279,
      5,
      3,
      6,
      NULL,
      NULL,
      2,
      1.172882,
      1,
      0.358684,
      1.713015,
      0.750317,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0.481906,
      1.047943,
      2,
      1.444824,
      2.077986,
      NULL,
      3,
      0,
      7.155844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.330912,
      4,
      7,
      NULL,
      0,
      5,
      1.338357,
      1.352667,
      1,
      0.768250,
      0.862934,
      0.764552,
      1.572895,
      1.740816,
      1,
      1.441708,
      1,
      0.654390,
      NULL,
      3.214665,
      0.064688,
      5,
      0,
      1.670967,
      5,
      5,
      1,
      0,
      0.683946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.537059,
      0,
      NULL,
      1,
      0.603908,
      0.452517,
      1,
      NULL,
      0,
      NULL,
      0.122264,
      NULL,
      0,
      1,
      1.807854,
      2.061637,
      1.287150,
      1.713255,
      1.570594,
      5.024954,
      5.112467,
      5,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595577,
      NULL,
      0.902723,
      1.646460,
      3,
      3,
      0,
      1.292930,
      NULL,
      1.995486,
      1,
      0,
      1.819767,
      NULL,
      0.125304,
      1,
      0.262828,
      1,
      2.826944,
      NULL,
      1.488279,
      0,
      NULL,
      NULL,
      1,
      0.754749,
      NULL,
      NULL,
      1.256741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.250524,
      4.136789,
      NULL,
      NULL,
      0.084873,
      NULL,
      NULL,
      3.530770,
      1,
      4,
      4,
      0.483254,
      NULL,
      0,
      0.043116,
      2.395988,
      2.678858,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.472542,
      0.924967,
      0.199545,
      0,
      0.816133,
      1.055664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.076635,
      3,
      0,
      0,
      5,
      7,
      4,
      3.475338,
      6.544524,
      1,
      1,
      3,
      0.802989,
      4.513148,
      5.738631,
      4,
      NULL,
      1,
      NULL,
      7,
      2.364677,
      3.131501,
      0,
      2.964513,
      NULL,
      1,
      NULL,
      7.482737,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.865486,
      6.154637,
      5,
      5.829244,
      8.877233,
      NULL,
      9.362857,
      2.933045,
      NULL,
      1.448804,
      1.127799,
      5.490167,
      3,
      0,
      0.323562,
      3,
      1,
      1.617751,
      2.930171,
      4.602962,
      3.963081,
      7.852196,
      5,
      NULL,
      2.402593,
      NULL,
      6.854317,
      NULL,
      4.608977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.482693,
      4.270600,
      0.610791,
      0.564819,
      2.252428,
      3,
      NULL,
      3.031233,
      5,
      7,
      1.461641,
      0.529403,
      NULL,
      4.496076,
      NULL,
      NULL,
      5,
      4,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024800,
      4,
      2,
      5,
      NULL,
      0.306902,
      1.884003,
      0,
      5,
      4,
      NULL,
      3.106957,
      NULL,
      NULL,
      0,
      NULL,
      3.380773,
      5,
      0.313758,
      2.102147,
      2,
      3,
      2.758810,
      0,
      NULL,
      4,
      3,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456849,
      1,
      NULL,
      0,
      1.171318,
      1.650379,
      1,
      1,
      NULL,
      1.582119,
      1,
      NULL,
      1.886475,
      0.798584,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0.684682,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208991,
      0.033300,
      0.681629,
      1,
      0,
      0,
      0.439147,
      NULL,
      0.102001,
      1,
      NULL,
      NULL,
      1.425478,
      NULL,
      1.031349,
      1,
      0,
      1,
      0,
      1.322126,
      0,
      1,
      1,
      NULL,
      1.945391,
      1,
      1.051354,
      NULL,
      1.128685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999562,
      NULL,
      0,
      3.509252,
      0,
      0,
      3,
      1,
      NULL,
      3.367035,
      NULL,
      0,
      NULL,
      1.245002,
      1,
      1,
      0,
      NULL,
      3,
      0.455187,
      1.209910,
      3.939046,
      3.128209,
      5,
      0,
      0.361945,
      0,
      1.967378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.438759,
      4.858561,
      5,
      2.193978,
      5.247928,
      2.595571,
      2.024417,
      1.707105,
      NULL,
      1.449896,
      3,
      NULL,
      0,
      2.492594,
      0,
      3,
      0.145957,
      5.966063,
      3.032502,
      NULL,
      0,
      4,
      2,
      2.589518,
      NULL,
      4,
      1.976805,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.999876,
      NULL,
      3.331776,
      3,
      NULL,
      NULL,
      0,
      1.365912,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.249493,
      2.515036,
      4,
      3,
      5.787471,
      5.901121,
      5.282941,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702328,
      2.278109,
      7.459047,
      1.547715,
      1,
      1.089965,
      1.416097,
      0.852237,
      7.911700,
      NULL,
      4,
      0.769503,
      1.938658,
      NULL,
      1,
      0.788215,
      NULL,
      6,
      0,
      7.619352,
      0.121027,
      6.767800,
      3.719716,
      5.077514,
      2.969115,
      1.974339,
      1.379604,
      5,
      0.122455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319643,
      1,
      1.410426,
      0,
      NULL,
      1,
      1.101231,
      0.472030,
      0,
      1.441450,
      1,
      0.528303,
      0,
      1,
      NULL,
      1.807091,
      0,
      0,
      1.790874,
      0.425596,
      0,
      NULL,
      1.682434,
      NULL,
      1.188270,
      0,
      1.033959,
      1.704172,
      1.517418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.373997,
      3,
      3,
      3.299287,
      1,
      3,
      3,
      3,
      0,
      1.741944,
      1.208079,
      0.193485,
      NULL,
      0.050629,
      0.874171,
      2,
      1.009905,
      4,
      NULL,
      1,
      0,
      1,
      2,
      1.486824,
      2,
      0,
      1.709901,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      0,
      NULL,
      2,
      2,
      2,
      NULL,
      0,
      1,
      3,
      NULL,
      3,
      2,
      3,
      NULL,
      4,
      0,
      5,
      4,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0,
      3,
      0,
      1,
      5,
      3,
      3,
      2,
      5,
      5,
      2,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      1,
      2,
      1,
      0,
      3,
      0,
      3,
      1,
      0,
      NULL,
      2,
      0,
      0,
      4,
      NULL,
      2,
      2,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-21-1993',
      '11-21-1979',
      ' 1- 7-1981',
      ' 9-24-2001',
      ' 8- 7-1980',
      ' 3-15-1989',
      ' 7-25-1983',
      ' 9-18-1976',
      ' 5-19-1988',
      ' 0-29-1993',
      ' 0- 1-1991',
      ' 1-23-2001',
      ' 8-22-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-1990',
      ' 5-25-1984',
      ' 3-10-1976',
      ' 8-12-1978',
      ' 6-28-1974',
      NULL,
      ' 2-22-1996',
      NULL,
      NULL,
      ' 4-27-1992',
      ' 8-16-1976',
      '10- 5-1987',
      ' 8-18-1989',
      ' 4-17-1978',
      NULL,
      ' 1-14-1978',
      ' 4-14-1985',
      ' 5- 2-2003',
      ' 9-25-1990',
      ' 3- 4-1978',
      ' 7- 2-1982',
      ' 2-22-1979',
      ' 1-20-1980',
      NULL,
      '11- 6-1999',
      ' 4- 3-1992',
      ' 3-23-1977',
      ' 9-22-1995',
      ' 0- 0-1974',
      ' 7-20-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 7-1976',
      ' 3-20-1977',
      '10- 9-2000',
      NULL,
      ' 8-20-1997',
      NULL,
      ' 4-15-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


