set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9708246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21333113',
      55,
      30,
      '1312133',
      1,
      NULL,
      2,
      '12200',
      NULL,
      ' 7-21-2003',
      58,
      NULL,
      2.567089,
      3,
      0.342794,
      1,
      1.973171,
      0,
      0.264222,
      0,
      0.012198,
      1.700209,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.012990,
      28.490343,
      7.821825,
      2,
      NULL,
      NULL,
      4,
      4.567356,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      6,
      2,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      3,
      0,
      0,
      4.225236,
      2,
      0,
      1,
      NULL,
      1.887348,
      NULL,
      1,
      1.307587,
      0,
      0,
      1,
      1,
      2,
      2,
      2,
      NULL,
      NULL,
      1.881961,
      12.589926,
      ' 2- 4-1976',
      4.536033,
      3,
      2.248528,
      NULL,
      1,
      1,
      NULL,
      1,
      5,
      NULL,
      60,
      0.431251,
      2.549094,
      305.359005,
      1.569029,
      0,
      NULL,
      592,
      392.097455,
      0.772382,
      NULL,
      531.518735,
      353,
      3.363723,
      2,
      NULL,
      1.946164,
      0,
      3.299838,
      39,
      3.246496,
      1,
      NULL,
      367.561125,
      128.957633,
      NULL,
      1.901689,
      NULL,
      42,
      2.969377,
      1.845204,
      247.994977,
      24,
      NULL,
      NULL,
      562,
      NULL,
      NULL,
      3,
      457.665858,
      8,
      3,
      1.790977,
      519,
      50,
      NULL,
      NULL,
      73,
      5,
      1.072986,
      1,
      286.067946,
      32,
      1,
      1,
      1038.909478,
      NULL,
      3,
      5,
      1046,
      2200,
      0,
      7.355685,
      513.276098,
      0.288546,
      0,
      NULL,
      225,
      99,
      1.181240,
      1.319769,
      276,
      NULL,
      NULL,
      3.512278,
      121.325345,
      24.428826,
      NULL,
      2.244487,
      155.521364,
      16,
      3.078071,
      3.288087,
      53,
      8,
      2.013228,
      0,
      1181,
      1043.030469,
      NULL,
      NULL,
      NULL,
      328,
      3.055708,
      0,
      86.482534,
      75,
      1,
      0.309172,
      91.663038,
      69.170659,
      0.058435,
      4.242413,
      143.773841,
      3,
      NULL,
      1,
      NULL,
      4,
      3,
      3.270211,
      198.594252,
      NULL,
      1.241301,
      3.559745,
      232,
      31.321524,
      2.364050,
      NULL,
      NULL,
      99,
      3.826265,
      3,
      27,
      16.888896,
      1.234084,
      NULL,
      203,
      76,
      NULL,
      5.442503,
      161.875989,
      9.053319,
      0.645202,
      1.237508,
      80.957872,
      10.276902,
      2,
      3.956331,
      15,
      34,
      NULL,
      2,
      157.185908,
      NULL,
      NULL,
      1.920699,
      36,
      2.920920,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.683501,
      '44410',
      '20433',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      2,
      '10020',
      '',
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      1.941949,
      NULL,
      0.787758,
      NULL,
      1,
      1.765645,
      1.358290,
      NULL,
      1,
      686.088713,
      NULL,
      NULL,
      1,
      494,
      NULL,
      NULL,
      NULL,
      4,
      5,
      12,
      15.227520,
      0.900613,
      NULL,
      5.594177,
      5,
      NULL,
      NULL,
      14,
      4.966765,
      17,
      21,
      13.812130,
      NULL,
      13,
      NULL,
      0.405256,
      4.021522,
      1.175501,
      2,
      7.478969,
      1,
      5,
      8,
      6.016164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      7,
      11,
      16,
      41,
      18.296569,
      15.373746,
      12.842626,
      51,
      NULL,
      9,
      28.338480,
      0,
      23,
      NULL,
      NULL,
      25,
      22,
      NULL,
      2,
      18.930217,
      40,
      1,
      6,
      6,
      NULL,
      NULL,
      15,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      13.134601,
      27.015810,
      26.472217,
      117.409459,
      131.522690,
      155.983644,
      34,
      56.517750,
      158.539005,
      146.854893,
      7,
      79.433222,
      69.603173,
      78,
      1,
      1.252231,
      3.223508,
      5.121823,
      1.002993,
      NULL,
      4.206670,
      5,
      3,
      0.820729,
      2.636153,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      4.985010,
      NULL,
      0,
      5,
      2,
      NULL,
      3.103065,
      NULL,
      5.486011,
      2,
      NULL,
      8,
      0,
      7,
      4.829616,
      NULL,
      1.445982,
      1,
      NULL,
      4.221948,
      4,
      5.427697,
      4.716562,
      5,
      6,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1.633900,
      0,
      0,
      0.287417,
      2.655669,
      6,
      1,
      3,
      NULL,
      7.433810,
      3,
      0,
      8.345620,
      NULL,
      8.538579,
      7.797742,
      NULL,
      2.678604,
      8,
      5.599243,
      8.389245,
      1.308361,
      8,
      0.234029,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.127378,
      2,
      2,
      2.058476,
      0.081094,
      NULL,
      0,
      NULL,
      1.175774,
      1,
      1,
      NULL,
      1,
      1.845273,
      1,
      NULL,
      0.091882,
      0.446574,
      NULL,
      NULL,
      5,
      1.029647,
      NULL,
      1,
      0,
      0,
      0.372096,
      2.933952,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.180487,
      NULL,
      NULL,
      1.429251,
      NULL,
      0,
      NULL,
      1.142823,
      NULL,
      1.821638,
      1.128138,
      1.861922,
      1.185918,
      1.927521,
      1,
      1.592007,
      NULL,
      NULL,
      5.842328,
      0.133643,
      4,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.863673,
      1.891764,
      0,
      0.819214,
      0,
      0,
      1.504709,
      NULL,
      0.559131,
      0.893842,
      0,
      0,
      0.419138,
      1.447474,
      NULL,
      1.949828,
      1,
      1,
      1,
      1,
      0.639061,
      2,
      5,
      1.955045,
      1.012167,
      2.429411,
      3.738794,
      2.932887,
      2.826820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.621606,
      2,
      0,
      NULL,
      5,
      1,
      5.242688,
      0.893741,
      6.349709,
      4.309528,
      0.091941,
      2.546929,
      5,
      3,
      2,
      5,
      0,
      7,
      3,
      0.475001,
      1.388288,
      5,
      0,
      3.738902,
      8.890042,
      NULL,
      4,
      6.230588,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.488426,
      1,
      4,
      3.603996,
      5,
      3.662343,
      6,
      7.342909,
      1.711086,
      6.461539,
      5.028626,
      0,
      6,
      NULL,
      9.532342,
      9,
      0,
      1.999227,
      2,
      NULL,
      5.796880,
      9,
      NULL,
      5.379918,
      NULL,
      4,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.965263,
      NULL,
      3,
      0.303119,
      1.228570,
      2.817058,
      NULL,
      NULL,
      2.073895,
      3,
      0.946314,
      0.526115,
      1,
      4.972068,
      3.458086,
      4.776304,
      3.783995,
      NULL,
      4,
      NULL,
      2.788897,
      0.806812,
      NULL,
      3.174908,
      NULL,
      3.827712,
      4.326838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.193610,
      NULL,
      1.605010,
      1,
      0.958489,
      NULL,
      1,
      0.412232,
      0,
      NULL,
      NULL,
      1.532969,
      1,
      0.511517,
      1,
      1.979918,
      0,
      0,
      0.712366,
      0,
      NULL,
      0.131459,
      0.210813,
      1,
      NULL,
      0.487430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.493929,
      0,
      NULL,
      0,
      0.547938,
      NULL,
      1,
      NULL,
      1,
      1.581876,
      1,
      NULL,
      0.447651,
      0.065186,
      1,
      1.126800,
      1.231717,
      0.151949,
      NULL,
      1.966698,
      0.328518,
      NULL,
      1.489554,
      1.884387,
      0.482355,
      0,
      NULL,
      0.772319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1.544811,
      0,
      0,
      1.688347,
      0.783264,
      0,
      1,
      0,
      0,
      1,
      0,
      0.998231,
      1,
      1,
      1,
      0,
      1.729527,
      0.177323,
      1,
      NULL,
      1,
      1,
      1.470783,
      1.695456,
      1.177325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.432373,
      0.402831,
      1,
      0.374493,
      4,
      1.789370,
      3,
      NULL,
      3,
      1,
      5,
      1,
      2.042121,
      0.102099,
      3.750664,
      0.118423,
      7,
      3,
      1.386317,
      NULL,
      4,
      1.623887,
      NULL,
      3,
      3.658860,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.789370,
      2,
      0.855932,
      3,
      NULL,
      0,
      1.847320,
      1.928722,
      1.191022,
      NULL,
      1.575905,
      1,
      2.239362,
      0,
      3,
      0,
      4,
      3,
      NULL,
      2,
      NULL,
      3.254331,
      3,
      3,
      7,
      3.002122,
      NULL,
      4,
      3.404166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      6.139625,
      0,
      6,
      7.634447,
      7,
      NULL,
      4,
      5,
      4,
      3.600610,
      6.815332,
      2.756431,
      NULL,
      NULL,
      2,
      4.047532,
      7,
      3,
      1,
      3,
      1.150430,
      6,
      7,
      3,
      NULL,
      3,
      1.026945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      7,
      2,
      7.939130,
      2.832718,
      NULL,
      2.778393,
      7.434127,
      NULL,
      4.352329,
      5.701917,
      6,
      3,
      7,
      5.400765,
      3,
      0,
      4.543199,
      9.354117,
      7.529203,
      6.299279,
      6,
      6,
      4.363941,
      6,
      3.400758,
      6.243595,
      5.469876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228973,
      0.457168,
      1.529758,
      NULL,
      0.944542,
      0.245349,
      NULL,
      NULL,
      NULL,
      1,
      1.121609,
      1.235832,
      0.706113,
      NULL,
      0,
      1.807543,
      0.416247,
      NULL,
      0,
      0,
      1.995086,
      0,
      1,
      1,
      NULL,
      1.790197,
      NULL,
      0.053374,
      1.060306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.630733,
      5,
      NULL,
      4.412373,
      0,
      1,
      5.292793,
      1,
      5.264493,
      1.630899,
      3,
      1,
      1,
      1.537720,
      NULL,
      NULL,
      NULL,
      1.204977,
      NULL,
      3.702545,
      5.873571,
      NULL,
      5,
      1.998367,
      4,
      3,
      2,
      1.315806,
      1.371667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      1,
      7,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      7,
      1,
      7,
      0,
      4,
      0,
      0,
      1,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      5,
      1,
      4,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      4,
      3,
      3,
      3,
      3,
      3,
      0,
      NULL,
      4,
      0,
      NULL,
      NULL,
      3,
      NULL,
      4,
      NULL,
      4,
      3,
      4,
      0,
      4,
      3,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      3,
      1,
      1,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-20-1983',
      ' 6-27-2000',
      ' 5-22-1980',
      ' 8-25-1974',
      ' 2-22-1995',
      NULL,
      ' 5-11-1990',
      ' 7-20-1987',
      ' 6-27-1983',
      ' 5-15-2003',
      ' 6- 4-1988',
      '10-10-2000',
      ' 7-17-1989',
      '11-13-1980',
      ' 4-23-1995',
      ' 7- 3-1991',
      ' 4-13-1994',
      NULL,
      ' 5-22-1989',
      ' 7-24-1986',
      ' 1- 1-1977',
      ' 2- 1-1974',
      ' 4- 3-1999',
      ' 5-15-2000',
      '10- 7-1979',
      ' 1-22-1981',
      NULL,
      NULL,
      ' 9- 3-2001',
      NULL,
      NULL,
      ' 4-11-1994',
      ' 8- 5-1995',
      ' 7-10-1994',
      NULL,
      NULL,
      '10- 9-1976',
      ' 1-14-1977',
      ' 7-16-1983',
      ' 5-16-1975',
      ' 3- 0-1985',
      NULL,
      ' 8- 3-1976',
      ' 2-18-1985',
      NULL,
      '11- 7-1975',
      ' 1-15-1974',
      NULL,
      ' 4- 2-2001',
      ' 3- 8-1982',
      ' 9- 5-1980',
      NULL,
      ' 9- 2-1975',
      ' 3-28-2000',
      ' 1-16-1998',
      NULL,
      ' 8- 5-1988',
      ' 2-11-1980',
      '11-16-1978',
      ' 8- 2-1997',
      ' 9-21-1982',
      NULL,
      ' 0-17-1986',
      NULL,
      ' 3-19-1985',
      ' 4-18-2003',
      ' 2-20-1977',
      ' 7- 5-1987',
      ' 0-15-1975',
      ' 4- 0-1996',
      ' 1-22-1986',
      ' 8-28-1979',
      NULL,
      NULL,
      ' 0-21-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-13-1983',
      NULL,
      ' 7- 4-1975',
      ' 4-29-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


