set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7501963';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      '3434122',
      2,
      0.630423,
      2,
      '14123',
      1.952927,
      ' 1-23-1984',
      8.481813,
      NULL,
      NULL,
      2,
      0.518509,
      2.132917,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      0.661804,
      NULL,
      1,
      NULL,
      6.694801,
      2,
      1,
      NULL,
      7.736737,
      3,
      1,
      2.240215,
      NULL,
      NULL,
      4,
      9,
      1,
      9,
      0,
      0,
      1,
      0,
      5,
      1,
      4,
      7,
      9,
      6.098593,
      1,
      7,
      0,
      NULL,
      0,
      1,
      1,
      1,
      6,
      3.424687,
      1.988009,
      4,
      4,
      3.112957,
      1,
      3,
      2,
      2.572747,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981087,
      NULL,
      3,
      0,
      2,
      NULL,
      1,
      75.224037,
      452.623696,
      25,
      1.336482,
      NULL,
      533.886279,
      81,
      3,
      1.363687,
      370.523514,
      54,
      3.430711,
      3,
      398,
      89.310307,
      2.219739,
      NULL,
      NULL,
      1692.149172,
      2.683114,
      3.759730,
      366,
      1095.191948,
      3,
      1,
      NULL,
      NULL,
      NULL,
      8.276517,
      748.116902,
      NULL,
      3.195971,
      2,
      28.217471,
      393.192371,
      2.095390,
      0.566463,
      NULL,
      511.118437,
      1.044913,
      0.338790,
      147.855176,
      19.530302,
      3.108590,
      1,
      296,
      1.228752,
      2,
      2,
      119.121054,
      5.171675,
      1.178355,
      7,
      1062.940124,
      6,
      2,
      1.893168,
      67,
      4.228188,
      2.895309,
      1,
      83.919522,
      11.208359,
      NULL,
      2.981946,
      119,
      16,
      NULL,
      1,
      NULL,
      4.272424,
      3,
      2,
      NULL,
      144.043447,
      1.102339,
      NULL,
      256.606106,
      NULL,
      1.074016,
      3,
      295.112669,
      127,
      0,
      1,
      91.086498,
      92.146060,
      0,
      1,
      225.647702,
      3467.781626,
      NULL,
      2.903556,
      721,
      14.371607,
      1.178565,
      1,
      NULL,
      13,
      0,
      1.860895,
      NULL,
      342,
      1,
      NULL,
      129.975335,
      7,
      1,
      2.039328,
      1124,
      18,
      0.543819,
      3,
      190.906227,
      33,
      3,
      5.610287,
      436,
      38,
      NULL,
      6.418024,
      213,
      40,
      2.068409,
      4.368864,
      NULL,
      18.564310,
      NULL,
      6,
      175,
      23,
      NULL,
      NULL,
      121,
      98,
      0,
      NULL,
      395.723740,
      81.937162,
      0.996699,
      0,
      236.277686,
      1.812882,
      NULL,
      NULL,
      11.296897,
      2,
      1.851239,
      0.815310,
      NULL,
      NULL,
      3,
      NULL,
      164.138130,
      418.076374,
      3.773744,
      6.902358,
      39.551451,
      275,
      0.346054,
      5,
      159.925197,
      NULL,
      2.418656,
      NULL,
      NULL,
      2538.407339,
      0.481032,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '41232',
      '34313',
      '12443',
      '',
      '',
      NULL,
      0.358025,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      82,
      3,
      6,
      NULL,
      NULL,
      6.945003,
      270,
      1.594474,
      NULL,
      1,
      130.026811,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      '10-16-2002',
      1,
      3.720907,
      2,
      3,
      NULL,
      NULL,
      2.121819,
      2.526919,
      NULL,
      NULL,
      NULL,
      2.101186,
      3,
      9,
      NULL,
      2.124519,
      1.672326,
      7.015859,
      17,
      1,
      10,
      4.001650,
      2.506358,
      2.881832,
      15.493587,
      4.449942,
      10.121175,
      15.620049,
      2.448801,
      1,
      NULL,
      13.141070,
      15.409062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.660530,
      NULL,
      2.126452,
      2.649289,
      2,
      0.033181,
      3,
      2,
      NULL,
      NULL,
      1,
      3,
      0.460357,
      2.878566,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.820701,
      1,
      17.223144,
      55.325764,
      9,
      NULL,
      16.787410,
      27,
      12,
      57,
      NULL,
      23.221675,
      29,
      45.068080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      93,
      36.077225,
      38,
      37,
      41,
      2,
      65,
      157,
      59,
      107,
      80,
      NULL,
      94,
      104,
      NULL,
      110.957356,
      109.443931,
      21,
      95.873553,
      NULL,
      125.942105,
      79,
      188.833787,
      104.947717,
      156.260624,
      165,
      84.993773,
      NULL,
      NULL,
      26.563717,
      NULL,
      160.835452,
      2,
      192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.958677,
      0.525339,
      0.518323,
      2.780771,
      NULL,
      2.794474,
      0,
      2.213012,
      3,
      NULL,
      1.012979,
      3,
      3.073633,
      3.441179,
      NULL,
      3.397574,
      4,
      4.242860,
      0,
      2.642018,
      2,
      4,
      NULL,
      5.784499,
      1,
      3.524886,
      1.440836,
      7,
      2,
      1,
      3.805729,
      5.883006,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.783330,
      NULL,
      4,
      2,
      2.635070,
      3.992389,
      3,
      NULL,
      5,
      NULL,
      2,
      5.428310,
      NULL,
      NULL,
      6.717544,
      NULL,
      2.637226,
      4,
      2.719539,
      2.397121,
      1,
      NULL,
      0.187839,
      1.703352,
      NULL,
      NULL,
      4.022262,
      7.094301,
      0,
      0.597420,
      NULL,
      7,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.490802,
      1,
      NULL,
      0.834653,
      1.577908,
      0.967265,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.556657,
      0,
      0.034777,
      0,
      1,
      0,
      1.286243,
      1.288270,
      NULL,
      0.151093,
      0.569783,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1.350289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.575641,
      1.999279,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.069339,
      NULL,
      0.749124,
      1.022973,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0.150669,
      0.326363,
      0,
      NULL,
      0,
      0.049320,
      1,
      1.236138,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.063559,
      NULL,
      1,
      0.177723,
      1.395383,
      1,
      1,
      NULL,
      0,
      0,
      1.752926,
      0.970325,
      0,
      0.324545,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0.801233,
      1,
      0.076899,
      1.997071,
      0.594397,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0.436870,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.132688,
      2,
      0.259404,
      NULL,
      6.016681,
      5.011770,
      1,
      3,
      NULL,
      NULL,
      0.460080,
      0,
      9.179786,
      NULL,
      NULL,
      5.255792,
      4.585125,
      NULL,
      NULL,
      1.266018,
      0.473749,
      3,
      6.999050,
      3,
      1.088672,
      7,
      2,
      0,
      NULL,
      7,
      0.395679,
      7,
      NULL,
      9.699200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.386002,
      2.638043,
      NULL,
      1.466817,
      5,
      NULL,
      3,
      2,
      2,
      7,
      5,
      5,
      3.377397,
      NULL,
      NULL,
      6.544222,
      0,
      6.573678,
      5.492388,
      7.421185,
      3.865897,
      4.440227,
      5.496769,
      7,
      3,
      5,
      1,
      NULL,
      5.752288,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.378591,
      2.593743,
      4.373707,
      1.402277,
      1.258262,
      0.644564,
      2.934571,
      NULL,
      4.981064,
      5,
      2,
      NULL,
      5.836107,
      0,
      1.039907,
      NULL,
      5,
      0,
      2,
      5.172961,
      0.096737,
      0.197620,
      6,
      2,
      7.926631,
      3.526810,
      NULL,
      1,
      9.307002,
      1,
      NULL,
      4.211866,
      1.306603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.524184,
      1.998455,
      1,
      1.775431,
      1.537386,
      1.690570,
      0,
      0.691475,
      0.568519,
      0.082480,
      1.610712,
      NULL,
      NULL,
      NULL,
      0.955662,
      1.749770,
      NULL,
      1.537971,
      0,
      0.781954,
      0,
      1,
      NULL,
      0.242345,
      0,
      1.829319,
      NULL,
      NULL,
      1.475325,
      1.071975,
      1,
      0.979737,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.061052,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0.555722,
      1,
      0.910933,
      1,
      1,
      1.246699,
      1,
      1,
      0,
      0.146392,
      0,
      NULL,
      0,
      1.148424,
      NULL,
      NULL,
      NULL,
      1.864767,
      0.067450,
      1.174795,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      3,
      4,
      4.920385,
      2,
      0.466830,
      NULL,
      1.366841,
      0,
      NULL,
      3.712985,
      5.680874,
      4.497047,
      2,
      NULL,
      0.562630,
      3.570242,
      3.023172,
      0,
      3.226800,
      1,
      1.774219,
      3,
      1,
      1.502930,
      NULL,
      0.008512,
      NULL,
      0,
      0.930371,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542491,
      5,
      6,
      NULL,
      3,
      3.348571,
      NULL,
      NULL,
      1,
      1,
      5,
      NULL,
      NULL,
      2,
      1.486878,
      NULL,
      2,
      0,
      4.872782,
      2.201192,
      2,
      NULL,
      5.227347,
      NULL,
      9,
      2.170073,
      NULL,
      1,
      5.286084,
      2.244468,
      5,
      7.850641,
      2,
      2.993880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0.153817,
      1.454381,
      0,
      1.193489,
      1,
      0,
      2.702732,
      3.043836,
      3.871692,
      1.203827,
      1,
      1.484620,
      1,
      3,
      5,
      3,
      2.194128,
      2,
      6,
      NULL,
      3,
      2.685069,
      2,
      0.930606,
      NULL,
      0,
      1.053173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.368942,
      0,
      3,
      NULL,
      0,
      0.649219,
      1,
      3,
      0,
      0,
      NULL,
      1,
      1.810664,
      0.538110,
      7.972448,
      NULL,
      0,
      0,
      2,
      NULL,
      4.049564,
      4,
      NULL,
      6,
      6,
      2.880856,
      5,
      1.206329,
      2,
      4,
      NULL,
      5.854060,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.185353,
      NULL,
      NULL,
      5,
      NULL,
      2,
      5,
      6,
      3,
      2,
      7.407193,
      1,
      1,
      7,
      6.313964,
      0.171776,
      2.983872,
      5.533656,
      2.668744,
      3,
      0.289780,
      3.323823,
      5,
      NULL,
      9.427577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012530,
      0,
      1.633278,
      0.047168,
      1,
      2,
      1.283661,
      1,
      4.474325,
      2,
      0.963159,
      1,
      NULL,
      1,
      2.898217,
      3,
      0,
      NULL,
      0.260279,
      0,
      1.702787,
      0.406039,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.413359,
      0,
      1.753694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.024758,
      3,
      4,
      7.532054,
      2,
      1.360929,
      3,
      2,
      2,
      5.682745,
      0,
      4,
      5,
      1.506823,
      NULL,
      1,
      0.886404,
      6,
      2.785265,
      5.131772,
      NULL,
      1.047620,
      2.827299,
      0.844434,
      NULL,
      6.606650,
      0.931559,
      1,
      2.668753,
      NULL,
      7.944385,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0,
      7,
      2,
      3,
      5,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      5,
      2,
      5,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2,
      0,
      NULL,
      5,
      4,
      NULL,
      4,
      2,
      1,
      2,
      3,
      0,
      4,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      NULL,
      2,
      2,
      0,
      2,
      0,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-28-1989',
      ' 9-17-1998',
      ' 4-18-1992',
      ' 5-16-1981',
      ' 7-20-1984',
      '11-19-1988',
      ' 2-17-1983',
      ' 0-19-1982',
      NULL,
      ' 8-21-1998',
      ' 5-16-1982',
      NULL,
      ' 0-13-1995',
      ' 1-14-1995',
      ' 7- 0-1997',
      '11-29-2000',
      NULL,
      ' 7-23-1995',
      ' 5- 4-1996',
      ' 3- 4-1981',
      ' 5- 2-1975',
      ' 4-18-1977',
      ' 1-20-1996',
      ' 6-18-1982',
      ' 8-14-1994',
      NULL,
      ' 4- 7-2001',
      ' 1-22-1998',
      NULL,
      NULL,
      NULL,
      ' 2-25-1975',
      ' 1-22-1979',
      ' 3- 2-1974',
      ' 4-22-1992',
      ' 0-10-1989',
      ' 4- 6-1998',
      ' 3-17-1975',
      ' 9-26-1995',
      '11-15-1980',
      NULL,
      ' 1- 5-1974',
      ' 3-28-1979',
      ' 0-23-1989',
      ' 8-19-2002',
      NULL,
      '10-28-1980',
      ' 6-12-1988',
      '11- 9-1997',
      '11-16-1981',
      NULL,
      '11-14-2003',
      ' 0- 2-1984',
      ' 5-22-1991',
      ' 0-18-1992',
      NULL,
      ' 8-11-1984',
      ' 2- 9-1994',
      ' 2-11-1985',
      NULL,
      ' 1-16-1991',
      NULL,
      NULL,
      NULL,
      ' 4- 4-1981',
      ' 4-24-1992',
      NULL,
      ' 3- 4-1978',
      ' 1- 1-1979',
      ' 1-14-1974',
      NULL,
      ' 4- 1-1986',
      '10-10-1982',
      NULL,
      '11-21-1987',
      NULL,
      ' 2-16-1986',
      ' 3-19-1980',
      '10-12-1987',
      ' 7-14-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 9-2000',
      NULL,
      '11-29-1977',
      NULL,
      ' 4-13-1995',
      ' 5-17-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018035);
commit;
end;
/


