set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8312986';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      '2443312',
      2,
      3,
      1,
      '34332',
      0,
      ' 9- 3-1988',
      NULL,
      NULL,
      1.964980,
      3,
      3,
      0,
      0.069794,
      0.432109,
      0,
      NULL,
      NULL,
      0,
      0.891537,
      NULL,
      NULL,
      NULL,
      1.818061,
      2.926691,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.953852,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      4,
      0,
      1.656034,
      5,
      7,
      NULL,
      0,
      0.721457,
      NULL,
      NULL,
      2,
      1,
      2.635401,
      1.115613,
      1,
      1,
      1.383304,
      4,
      3.418241,
      7,
      9,
      2.531591,
      6.010574,
      NULL,
      ' 5-12-1996',
      13,
      0,
      NULL,
      0,
      4,
      0,
      5,
      NULL,
      91,
      52.357716,
      8,
      0,
      3.760444,
      476.958514,
      15,
      0.272360,
      3,
      NULL,
      520.116841,
      2,
      6.314998,
      173,
      3,
      NULL,
      NULL,
      1212.974028,
      270.399640,
      2,
      6,
      136,
      142.246415,
      0.576790,
      4,
      11,
      125,
      1.777981,
      2,
      215.961469,
      54.840891,
      2,
      3,
      NULL,
      18,
      3.179918,
      1,
      116.164614,
      35,
      3.110047,
      3,
      NULL,
      3.808348,
      2,
      2,
      574,
      27,
      2.143681,
      2,
      133.979675,
      13,
      1,
      0.866345,
      NULL,
      NULL,
      3.335578,
      2,
      726.397152,
      16,
      NULL,
      NULL,
      207,
      NULL,
      1.928476,
      NULL,
      16,
      NULL,
      2,
      4.856693,
      6,
      123.511622,
      NULL,
      NULL,
      NULL,
      192,
      3,
      2.964688,
      NULL,
      NULL,
      2,
      2.879267,
      NULL,
      76,
      1.806052,
      NULL,
      34,
      13,
      0.749400,
      2.712461,
      959,
      4,
      2.028270,
      0,
      227,
      756.460503,
      7,
      0.189875,
      18,
      12.624349,
      3.178606,
      0,
      158.341503,
      NULL,
      1.186267,
      0.504493,
      29,
      1408.466159,
      2.056182,
      2,
      46.302856,
      15628.830729,
      1,
      1,
      NULL,
      10014,
      0.121042,
      3.339985,
      243.671935,
      4029,
      NULL,
      3.193011,
      584.157249,
      2078.350380,
      1,
      2.462508,
      112,
      9615.669215,
      0,
      3,
      75,
      10423,
      2,
      NULL,
      12.200717,
      14482,
      16,
      0.915490,
      54,
      NULL,
      3.041185,
      NULL,
      NULL,
      2,
      2,
      3,
      99,
      NULL,
      0.161627,
      0.536177,
      194.571348,
      16290,
      1.625714,
      3,
      385.040180,
      NULL,
      1.934143,
      2.014272,
      349,
      19370.380228,
      0,
      3,
      NULL,
      5062.333642,
      3.297402,
      0,
      611,
      16569,
      1,
      3,
      116.357722,
      19912,
      NULL,
      3,
      851,
      15590.661464,
      2,
      0,
      NULL,
      NULL,
      2,
      1.959008,
      NULL,
      6501.841279,
      0,
      3.697243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.479034,
      '43110',
      '',
      '',
      NULL,
      '',
      '',
      3.792230,
      '44243',
      NULL,
      NULL,
      0.683400,
      '3034',
      '',
      '',
      NULL,
      2.069314,
      1027,
      0.261253,
      388,
      3.325665,
      NULL,
      0.568920,
      NULL,
      NULL,
      174,
      0,
      1.411764,
      1,
      NULL,
      NULL,
      NULL,
      0.350798,
      NULL,
      0.531962,
      NULL,
      NULL,
      4.406795,
      1,
      10.481499,
      NULL,
      NULL,
      0.625581,
      2,
      17.679820,
      22,
      NULL,
      5.176785,
      10.427801,
      4.399622,
      1,
      1.306327,
      4.538579,
      8,
      17.776856,
      NULL,
      11.697443,
      NULL,
      NULL,
      23,
      2.631837,
      1.304737,
      NULL,
      NULL,
      10.680891,
      20,
      2.423815,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.568123,
      18.380196,
      11,
      NULL,
      NULL,
      0,
      3.521513,
      3.400334,
      0.530037,
      1,
      0.515633,
      6,
      NULL,
      1,
      2,
      11.882521,
      10.882460,
      2,
      1,
      1.358888,
      NULL,
      2.963111,
      3.968288,
      NULL,
      2,
      5,
      2,
      2.521754,
      0.766671,
      12.292601,
      32.793533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64.619048,
      13.446747,
      12.932349,
      51,
      112.826260,
      90.401353,
      22.282581,
      43.564964,
      144.228023,
      113.146486,
      95,
      143.214475,
      NULL,
      67.471065,
      29,
      124.716468,
      NULL,
      111.692082,
      116.560849,
      120,
      42.292616,
      NULL,
      NULL,
      NULL,
      39,
      99.902342,
      18,
      91,
      33.742267,
      153.015207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8,
      4,
      6.739053,
      NULL,
      6,
      1.634675,
      8.729668,
      2,
      0,
      0.832724,
      1.857008,
      2,
      6,
      6,
      1.692423,
      1,
      3.295270,
      1.954660,
      4.279655,
      6.719328,
      4,
      7.075234,
      2,
      NULL,
      NULL,
      7,
      6,
      4.949290,
      4.770469,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      10.008027,
      0,
      NULL,
      NULL,
      1.123662,
      NULL,
      0.180942,
      4,
      5.983532,
      5.933470,
      4.170884,
      2,
      1.340426,
      2,
      5.030130,
      2,
      6,
      3,
      0,
      5,
      5.726098,
      4,
      0,
      5.493246,
      1,
      4.842922,
      NULL,
      5.264405,
      6.860213,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.700859,
      5,
      1,
      NULL,
      0.270810,
      5.144685,
      0.685087,
      1.148600,
      NULL,
      NULL,
      0.686051,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.476229,
      1.166815,
      NULL,
      3,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.647148,
      NULL,
      0.950639,
      5.479358,
      0,
      4,
      NULL,
      1.407289,
      1.791620,
      4.272473,
      0,
      3.024516,
      0,
      0.597718,
      NULL,
      3,
      0,
      NULL,
      1,
      5.129229,
      0,
      0.826910,
      0,
      NULL,
      0,
      3,
      1,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.490487,
      0,
      0.330413,
      0.769335,
      4.317634,
      1.037779,
      5,
      0.988928,
      4,
      NULL,
      1.373205,
      NULL,
      3.602569,
      0.250977,
      2.830257,
      NULL,
      0.560920,
      NULL,
      1.407677,
      NULL,
      3,
      2.244253,
      3.076971,
      NULL,
      3.448113,
      2,
      3,
      NULL,
      5.639909,
      1.740797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.379354,
      6,
      NULL,
      2,
      3.136442,
      2,
      NULL,
      0,
      7,
      NULL,
      9,
      5,
      NULL,
      3,
      8,
      7,
      0,
      3.047013,
      0,
      0.660660,
      NULL,
      0.625796,
      6.105058,
      2.489267,
      NULL,
      NULL,
      3,
      NULL,
      8.700479,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      2.894789,
      2.390160,
      NULL,
      1,
      7.572785,
      NULL,
      NULL,
      NULL,
      0.350429,
      7.014401,
      4.483392,
      0,
      5.050185,
      4,
      7,
      4.324616,
      4,
      2.846159,
      0.066736,
      0,
      6.041504,
      2,
      5.884441,
      NULL,
      4.855511,
      2.465953,
      5.295723,
      7,
      9.551270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      3,
      3,
      2.963809,
      0,
      5,
      NULL,
      3.619887,
      1.118232,
      5.096517,
      0,
      NULL,
      2.004643,
      NULL,
      2,
      NULL,
      3.492669,
      0,
      2.716289,
      0,
      3,
      6.152917,
      2.368146,
      1.791455,
      2.347342,
      3,
      0.444673,
      7,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305886,
      NULL,
      2,
      1.061055,
      1,
      6.667620,
      3.754479,
      NULL,
      2.862607,
      NULL,
      1,
      5.873504,
      0.290110,
      4,
      2.325804,
      NULL,
      0,
      6,
      NULL,
      0,
      2,
      0.959580,
      0,
      6,
      NULL,
      NULL,
      0.061280,
      3,
      3,
      5.819752,
      0.855312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252269,
      NULL,
      NULL,
      1.458642,
      1,
      1,
      0.175655,
      1.440329,
      0,
      NULL,
      NULL,
      0.510480,
      1,
      0.006478,
      0,
      0,
      NULL,
      0.657266,
      1.749775,
      1.274853,
      0.328544,
      0.901428,
      0,
      NULL,
      1.425785,
      1,
      0.691419,
      1.905662,
      0.499736,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.319878,
      0.414529,
      NULL,
      1,
      1,
      1.223909,
      NULL,
      0.256571,
      0,
      0.258290,
      0,
      0,
      0,
      0.688541,
      0,
      0,
      0,
      NULL,
      5,
      NULL,
      NULL,
      0.775557,
      1.456636,
      7.268330,
      1.052701,
      0.269474,
      NULL,
      1.397982,
      1.299334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.270227,
      2.094790,
      3,
      NULL,
      2.161083,
      1,
      3,
      7,
      2.424513,
      1.486837,
      3,
      NULL,
      2,
      1.687035,
      0.751080,
      NULL,
      NULL,
      NULL,
      1,
      1.593983,
      1,
      0.736940,
      0.485243,
      3.988679,
      NULL,
      1.683905,
      0.300657,
      5,
      3.804875,
      2.869731,
      4.189757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459078,
      NULL,
      NULL,
      3,
      0,
      5.178304,
      2.581969,
      6.271106,
      3,
      6,
      2,
      3,
      NULL,
      NULL,
      2,
      3.540470,
      NULL,
      4,
      0,
      1.048026,
      0.948261,
      0,
      1,
      7,
      3,
      0,
      1.401910,
      3,
      3.456719,
      11.629319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754301,
      2.028679,
      3,
      2.224110,
      0,
      6,
      2,
      8,
      5,
      1,
      1.683727,
      7,
      4.448314,
      1,
      2.808255,
      7,
      NULL,
      1,
      NULL,
      5,
      NULL,
      1.341006,
      7,
      1.415544,
      5,
      4.995987,
      5.998352,
      5,
      6,
      5.329914,
      6.335753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      6,
      3.904326,
      NULL,
      1.471136,
      1,
      9.628931,
      0,
      8,
      6.694002,
      0,
      3,
      NULL,
      0,
      0,
      NULL,
      2,
      0.218360,
      0,
      NULL,
      0,
      3,
      7.954181,
      0,
      3.212235,
      7,
      6,
      3,
      9.289988,
      1.464310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.776953,
      1.893823,
      0,
      0.001628,
      0,
      1.699967,
      0,
      0.599419,
      0.072734,
      0.148683,
      NULL,
      NULL,
      1,
      1.703600,
      NULL,
      0,
      1,
      1,
      4,
      1.458861,
      0.629376,
      NULL,
      0,
      1,
      NULL,
      0.070453,
      NULL,
      1.846232,
      0.899410,
      0.128475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.080095,
      3,
      NULL,
      1.942465,
      0.917671,
      0.865163,
      0,
      3,
      6,
      NULL,
      4,
      1.711061,
      4,
      NULL,
      3.852959,
      2.192394,
      5,
      0.197570,
      1.179622,
      1.258119,
      NULL,
      1.269137,
      5,
      NULL,
      1.972371,
      1,
      4.244559,
      2,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      4,
      2,
      0,
      NULL,
      5,
      3,
      5,
      2,
      0,
      3,
      0,
      0,
      4,
      3,
      5,
      3,
      3,
      3,
      3,
      2,
      0,
      3,
      NULL,
      0,
      2,
      1,
      2,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-22-1995',
      NULL,
      ' 3-12-1993',
      NULL,
      NULL,
      NULL,
      ' 9- 5-1977',
      ' 2-23-1995',
      ' 6- 3-1990',
      ' 6-21-2003',
      ' 6-26-1983',
      ' 8-17-1987',
      ' 2-15-1976',
      ' 6-19-1994',
      ' 3-23-1985',
      ' 2-25-1991',
      ' 6-14-1984',
      NULL,
      ' 8-25-1975',
      ' 9-21-1995',
      ' 5- 0-1994',
      NULL,
      ' 5- 0-1999',
      ' 4-23-2002',
      NULL,
      ' 6- 7-1992',
      ' 1-16-1984',
      ' 0-28-2002',
      ' 1-20-1978',
      '10-28-1980',
      NULL,
      ' 8-14-1979',
      ' 8-12-1996',
      '10-27-1983',
      ' 8-20-1995',
      ' 6- 1-1987',
      NULL,
      ' 4- 6-1987',
      ' 3- 8-1995',
      '10- 8-1997',
      NULL,
      ' 4- 2-2002',
      NULL,
      ' 9-22-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-23-2003',
      NULL,
      '10- 5-1981',
      NULL,
      ' 9-22-1985',
      NULL,
      ' 7-10-1983',
      NULL,
      ' 1- 7-1986',
      NULL,
      NULL,
      NULL,
      ' 1-25-1999',
      NULL,
      NULL,
      NULL,
      ' 4- 4-2003',
      NULL,
      NULL,
      NULL,
      ' 6-10-2000',
      NULL,
      ' 7- 5-2002',
      ' 3-21-1985',
      ' 5-27-1978',
      NULL,
      '10- 3-1982',
      NULL,
      NULL,
      NULL,
      '10- 4-2003',
      NULL,
      '11-22-1975',
      ' 9-19-1998',
      '10-29-1982',
      NULL,
      ' 4-11-1991',
      NULL,
      ' 1-27-1979',
      NULL,
      ' 7-26-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-20-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


