set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9664148';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '1312311',
      1,
      1.288103,
      2,
      NULL,
      1.853457,
      ' 1- 0-1981',
      132.078169,
      NULL,
      1.626412,
      0,
      2,
      0.095250,
      NULL,
      0,
      0.426097,
      NULL,
      2,
      3.994727,
      0.277894,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.459987,
      NULL,
      NULL,
      2.284347,
      0,
      0.298502,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      6,
      1.175653,
      3,
      9,
      NULL,
      NULL,
      1.387638,
      0,
      1.805173,
      3,
      2,
      NULL,
      0,
      0.294345,
      9,
      NULL,
      5,
      0,
      1,
      8.951443,
      2,
      3,
      43.902718,
      ' 6-10-1977',
      18.230054,
      0.393498,
      NULL,
      3,
      1,
      1,
      2.349754,
      5,
      22,
      100.142729,
      75,
      2.244670,
      NULL,
      NULL,
      43.395887,
      NULL,
      2,
      97,
      121,
      NULL,
      3,
      2,
      5,
      0.858547,
      1.362346,
      619,
      364,
      0.363113,
      NULL,
      137.179904,
      NULL,
      2.705819,
      0,
      232.754824,
      0,
      0,
      2.858116,
      157,
      NULL,
      2.980529,
      0.833701,
      54,
      13,
      3.515667,
      1.457611,
      84.302347,
      40.360086,
      NULL,
      3.933301,
      157,
      NULL,
      3.870133,
      3.258884,
      0.233486,
      3.754074,
      NULL,
      1,
      NULL,
      374.787228,
      2,
      NULL,
      180.541661,
      10.952406,
      1,
      3,
      245.185873,
      7.810022,
      1,
      0.937541,
      134,
      15,
      NULL,
      2,
      NULL,
      88.430908,
      NULL,
      1.380710,
      726.061844,
      1.710151,
      0.775511,
      3.563236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      '22113',
      '01112',
      '',
      '',
      '',
      '',
      0.070827,
      '',
      '',
      NULL,
      5,
      '42202',
      '30302',
      '',
      5,
      1,
      NULL,
      3,
      4804.445402,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      536.540860,
      1,
      NULL,
      0,
      NULL,
      0.974153,
      NULL,
      ' 6- 9-1986',
      16,
      2,
      NULL,
      1,
      1.129086,
      1.473057,
      13.615448,
      13.758206,
      1,
      10.007758,
      NULL,
      21,
      7.522834,
      5,
      NULL,
      NULL,
      1.097584,
      7,
      9,
      4,
      6.373819,
      4.624111,
      8.278941,
      5,
      14.575522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      41,
      NULL,
      NULL,
      40.441370,
      NULL,
      3.371156,
      15,
      3,
      NULL,
      37.439985,
      12.444514,
      34.828289,
      3,
      NULL,
      NULL,
      NULL,
      4.554268,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      13.624723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      84,
      46,
      61.119929,
      96,
      48,
      89.139677,
      49,
      102,
      NULL,
      38.029626,
      NULL,
      NULL,
      9,
      74.700349,
      124,
      NULL,
      15,
      106,
      47.011536,
      117,
      0.401909,
      140.162320,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.824639,
      NULL,
      NULL,
      6,
      2,
      8.971467,
      1,
      4.004336,
      5.272980,
      9.879829,
      NULL,
      11,
      NULL,
      0.857248,
      3,
      0,
      4,
      9,
      NULL,
      3,
      NULL,
      6,
      NULL,
      8.321428,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959609,
      3,
      NULL,
      NULL,
      0,
      6,
      2,
      1.125772,
      NULL,
      4.991492,
      2,
      4,
      2.039424,
      3.530401,
      0.662123,
      1,
      3.724254,
      1,
      0.331790,
      0.485127,
      3,
      4.326851,
      1,
      2.177444,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.844455,
      3.374982,
      1.870524,
      0,
      NULL,
      2,
      0,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      1.992095,
      0.110362,
      NULL,
      3.915150,
      0.843248,
      2.257958,
      1.038390,
      NULL,
      5,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      0.398413,
      1,
      0,
      NULL,
      NULL,
      0,
      5,
      NULL,
      7,
      5.543340,
      1.105050,
      6,
      3.019398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684583,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1.282166,
      0,
      1,
      1,
      NULL,
      1,
      1.202343,
      0,
      1,
      NULL,
      1.901718,
      1.651363,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3,
      6,
      0,
      5.882352,
      1,
      5.094659,
      5,
      4,
      0.768130,
      5,
      7.211603,
      3.877983,
      0,
      0,
      5,
      NULL,
      NULL,
      2,
      0,
      4,
      6,
      4.656983,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1.081083,
      4.133459,
      2.023644,
      7,
      7,
      5,
      4,
      NULL,
      7,
      3,
      2,
      7,
      3.189281,
      4,
      0,
      0.114082,
      0,
      2,
      NULL,
      7,
      5.093208,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.046721,
      0,
      7,
      4.790788,
      0,
      NULL,
      1.874597,
      0,
      4,
      NULL,
      5.761063,
      3.052002,
      0,
      1,
      2,
      0.139476,
      6,
      NULL,
      2.365074,
      NULL,
      5,
      NULL,
      7,
      4.971722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.800039,
      1.016721,
      0,
      1.466957,
      NULL,
      0.676699,
      1,
      0.663322,
      NULL,
      0.683637,
      0.759270,
      1.060408,
      1,
      1.167430,
      1.102325,
      1,
      1,
      NULL,
      0.910103,
      0,
      0.358525,
      0.141317,
      2.991907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.192443,
      1,
      0.459978,
      1,
      0,
      NULL,
      NULL,
      0.979036,
      1,
      1.738764,
      0,
      NULL,
      1,
      1,
      1,
      0.334104,
      1.790150,
      NULL,
      0,
      0.898421,
      0.867218,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.599668,
      1,
      1,
      1.459957,
      0,
      0.712219,
      0.007845,
      1.299937,
      0.055532,
      0,
      0,
      1.138215,
      3.494178,
      0,
      NULL,
      1.536386,
      1,
      0,
      1,
      0.881183,
      1.848805,
      1,
      0.109894,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.497158,
      1,
      1.445124,
      1,
      1,
      1.251406,
      0,
      NULL,
      NULL,
      0.366289,
      NULL,
      1,
      1,
      0.391401,
      1.475871,
      1.722716,
      NULL,
      NULL,
      0.423891,
      0.442953,
      NULL,
      0,
      1,
      0.578662,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.702977,
      1.497644,
      1.536181,
      NULL,
      0.560408,
      0.060616,
      NULL,
      0,
      0,
      1.319002,
      NULL,
      1,
      1,
      0,
      NULL,
      0.254536,
      1,
      NULL,
      0.975206,
      NULL,
      0,
      NULL,
      0.347077,
      0,
      0.554015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.563970,
      NULL,
      NULL,
      1.871004,
      7.169192,
      2,
      5.723301,
      0.173542,
      NULL,
      NULL,
      NULL,
      2,
      3.715975,
      3.721496,
      NULL,
      6,
      3.848112,
      1.600920,
      NULL,
      0,
      7,
      2.345641,
      9,
      7.191092,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.305260,
      2.132952,
      7,
      6.099989,
      0,
      1.171457,
      3.764754,
      9.967441,
      NULL,
      1,
      3.401019,
      6.785389,
      NULL,
      6,
      2.647364,
      4,
      3.836166,
      4,
      8.816917,
      3,
      5.335227,
      4.738895,
      NULL,
      0.827519,
      7.226470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063588,
      NULL,
      0.837638,
      0.851258,
      0,
      1.402947,
      1,
      1,
      0.785916,
      0,
      0.627805,
      1.295339,
      1,
      1,
      0.480102,
      0,
      1.233467,
      0,
      1,
      0,
      1.901382,
      0.335658,
      1,
      1.674809,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.140251,
      NULL,
      1.197845,
      1.298778,
      1.506710,
      0,
      1.258998,
      1,
      0.939326,
      NULL,
      NULL,
      1.093226,
      1.219195,
      1,
      NULL,
      0,
      1.327380,
      0.309559,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      4,
      1,
      0,
      0,
      2,
      0,
      5,
      2,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      NULL,
      1,
      NULL,
      2,
      4,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      0,
      2,
      NULL,
      1,
      2,
      4,
      3,
      3,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 8-1995',
      ' 8-26-1979',
      ' 5-15-2002',
      ' 3-26-2001',
      ' 4-28-1993',
      ' 2- 1-1977',
      ' 3- 4-1990',
      ' 7-18-1997',
      ' 4-18-1998',
      NULL,
      '10- 8-1985',
      ' 6-12-1985',
      '11-21-1987',
      ' 7- 2-1979',
      ' 4-22-1981',
      '11- 9-2000',
      ' 2- 0-2003',
      ' 2- 7-2001',
      ' 1- 0-2001',
      ' 9- 3-1998',
      ' 8-23-2002',
      '10-20-1988',
      ' 5- 2-1985',
      '11- 0-1991',
      ' 4-12-1999',
      ' 9- 8-1993',
      ' 4-12-1984',
      '11- 9-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 4-1990',
      NULL,
      ' 2-10-1997',
      ' 3-16-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


