set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6850715';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      '30324021',
      36,
      26.393249,
      NULL,
      NULL,
      1,
      1,
      '01312',
      NULL,
      ' 6-18-1982',
      109.242924,
      NULL,
      NULL,
      1,
      1,
      1.437878,
      NULL,
      0,
      1.942003,
      NULL,
      NULL,
      0.530561,
      1,
      8,
      NULL,
      NULL,
      0.837587,
      0.442152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.642856,
      1,
      1,
      0.635647,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1,
      0,
      7,
      NULL,
      6,
      0.879308,
      0,
      0,
      0.895021,
      NULL,
      1.817745,
      0,
      3,
      0.866712,
      0.117336,
      1,
      6,
      0.431572,
      NULL,
      0.367279,
      6,
      4.118745,
      0.132654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      29.765181,
      517,
      3,
      NULL,
      3.977750,
      NULL,
      NULL,
      2.286278,
      1.141723,
      153,
      11,
      1,
      1.813307,
      103.121722,
      25,
      3,
      0,
      208,
      30.461858,
      0,
      2.161530,
      228.185377,
      0.101939,
      3,
      NULL,
      10.544325,
      8.132853,
      0,
      NULL,
      569,
      993.160274,
      1.706978,
      3,
      464,
      21.021463,
      NULL,
      2.066385,
      498,
      NULL,
      3,
      0.106241,
      NULL,
      5.457793,
      NULL,
      2.401502,
      NULL,
      3,
      0.041288,
      NULL,
      266.001845,
      95,
      0,
      NULL,
      22,
      NULL,
      1.803191,
      NULL,
      2.454143,
      100.119122,
      1,
      NULL,
      74,
      84,
      NULL,
      2,
      NULL,
      10.178372,
      3,
      NULL,
      615.978017,
      NULL,
      2.760560,
      NULL,
      104.258245,
      5,
      0,
      1,
      790,
      NULL,
      NULL,
      2,
      688.334611,
      243,
      2,
      NULL,
      654,
      2034.554612,
      NULL,
      0,
      196.833339,
      10.867012,
      3.772928,
      3.435317,
      611.996808,
      70,
      1,
      2.038489,
      360,
      24,
      1,
      NULL,
      195,
      8,
      3.782425,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.654429,
      '31034',
      '00124',
      '',
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '1442',
      '',
      '',
      1,
      1,
      NULL,
      3,
      478,
      1.439008,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      71,
      1,
      NULL,
      NULL,
      NULL,
      1.243104,
      NULL,
      1.132918,
      NULL,
      ' 1- 5-1982',
      8.890700,
      NULL,
      NULL,
      6,
      16,
      1.549097,
      2,
      NULL,
      NULL,
      6.222459,
      0,
      8.318058,
      0.025631,
      6.683301,
      NULL,
      4,
      NULL,
      NULL,
      2,
      1.010419,
      5,
      NULL,
      3,
      NULL,
      5.226339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.112881,
      3.821494,
      7,
      56.192418,
      NULL,
      NULL,
      33.278133,
      NULL,
      NULL,
      6,
      24,
      7,
      17.747528,
      28.842027,
      2.854655,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      37,
      NULL,
      NULL,
      9.755309,
      3.080948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.114547,
      NULL,
      NULL,
      132,
      151.443370,
      NULL,
      150.561930,
      74.884723,
      98.408523,
      120,
      NULL,
      149.754171,
      NULL,
      161,
      9,
      158,
      143.787972,
      NULL,
      NULL,
      192.124142,
      17.964343,
      51,
      NULL,
      167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711310,
      5.063431,
      2.125422,
      6,
      6,
      5,
      3,
      NULL,
      4.054887,
      6,
      4,
      6.984932,
      4,
      NULL,
      1,
      9,
      4,
      6.217879,
      8.705094,
      0.654695,
      8,
      5.164101,
      9.920231,
      1.609691,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909478,
      1.956567,
      NULL,
      1,
      0.481898,
      1.989941,
      0.730851,
      0.886875,
      1,
      1,
      NULL,
      1.717050,
      1.050234,
      0,
      1.355636,
      1.643846,
      1,
      8.155015,
      0,
      NULL,
      NULL,
      3.230130,
      2.969750,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.637508,
      NULL,
      0.070324,
      0.623059,
      1.808460,
      1,
      1.435425,
      1,
      0.572335,
      1.177306,
      0,
      NULL,
      1.845915,
      NULL,
      0,
      0,
      0.567930,
      NULL,
      1,
      1.164621,
      1,
      1.041950,
      0.448186,
      0.561784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693330,
      1,
      3,
      9.862807,
      3.816078,
      6.364869,
      4,
      NULL,
      2.667962,
      3,
      4,
      6,
      4,
      NULL,
      7.051707,
      NULL,
      2.500791,
      NULL,
      6.668798,
      1.376462,
      3,
      6.209732,
      4.861611,
      1.833029,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.802610,
      1,
      NULL,
      5,
      0.143406,
      3.145706,
      6.858971,
      3.439338,
      NULL,
      2.117241,
      3,
      1.966381,
      NULL,
      4.302251,
      NULL,
      1,
      3,
      5,
      1.701827,
      3,
      NULL,
      1,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      11.172952,
      5,
      1,
      NULL,
      6.736136,
      2,
      7,
      7.433823,
      6,
      4.068432,
      4,
      2.561107,
      0,
      1,
      7.261096,
      1,
      4,
      2.918230,
      NULL,
      4.054646,
      NULL,
      8.746010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.327038,
      3.572772,
      8,
      1.818937,
      3,
      4.428875,
      6.178314,
      3,
      1,
      3,
      0,
      6.808748,
      0.451694,
      1.225782,
      3,
      7.007747,
      4,
      4.218044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822466,
      NULL,
      0,
      4.803313,
      2,
      0.072274,
      NULL,
      7.930900,
      4.955106,
      2,
      0,
      3,
      2,
      2,
      NULL,
      4.103111,
      NULL,
      1,
      2.748574,
      6,
      1,
      6,
      4.632046,
      9.297830,
      2.583865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565522,
      5,
      2.806771,
      4,
      NULL,
      NULL,
      NULL,
      7.286171,
      4.924023,
      NULL,
      4,
      NULL,
      NULL,
      2,
      0,
      6,
      NULL,
      3.341821,
      3.919538,
      NULL,
      1,
      NULL,
      3,
      NULL,
      4.357393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.097934,
      0,
      0.957210,
      1,
      0,
      1.761943,
      0.899567,
      0.547758,
      0.538451,
      NULL,
      2.625095,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1.313571,
      1,
      0.379297,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.072518,
      0,
      NULL,
      0.612600,
      1.893432,
      1,
      0.122849,
      0,
      0,
      1.966273,
      1.530808,
      1,
      1,
      1,
      1.577734,
      NULL,
      1,
      1,
      NULL,
      1.190289,
      NULL,
      NULL,
      1.249942,
      NULL,
      1.442224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549976,
      3,
      7.479623,
      5,
      3.521889,
      NULL,
      5,
      9.107657,
      0,
      5.211551,
      3.423984,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      4.201359,
      5.937270,
      2,
      0,
      1.645331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.243690,
      9.723426,
      6,
      8,
      2,
      5.398856,
      3.976836,
      5,
      0,
      6.393228,
      NULL,
      0,
      0,
      2.748524,
      7.343038,
      NULL,
      7,
      5.010518,
      0,
      3,
      NULL,
      1,
      NULL,
      6.436664,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.885029,
      10.585427,
      1.493488,
      NULL,
      NULL,
      NULL,
      1.532518,
      5,
      NULL,
      5.381949,
      5,
      8,
      9.473964,
      NULL,
      8.914322,
      2.027195,
      9.214736,
      1.542313,
      5,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517422,
      3.504609,
      6,
      NULL,
      2,
      NULL,
      0,
      6,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.895776,
      5.072482,
      1.148832,
      NULL,
      5,
      9,
      6.230565,
      3.854705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.917307,
      NULL,
      NULL,
      0,
      1.369430,
      0,
      NULL,
      NULL,
      1,
      0.238979,
      1,
      0.402988,
      NULL,
      NULL,
      0.611287,
      0,
      1,
      0.238312,
      0,
      0.189028,
      0.177837,
      NULL,
      1.600466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.663956,
      8,
      NULL,
      8.561964,
      1,
      0,
      1.574117,
      2,
      7.604866,
      8.545374,
      1,
      NULL,
      2,
      NULL,
      3.218517,
      0.797463,
      7.444278,
      0.697913,
      4,
      0.911251,
      6.438773,
      9.591745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      3,
      0,
      3,
      3,
      1,
      0,
      3,
      NULL,
      3,
      1,
      NULL,
      3,
      0,
      3,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      4,
      2,
      NULL,
      3,
      NULL,
      1,
      1,
      0,
      2,
      2,
      5,
      3,
      5,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-20-1994',
      '10-25-2000',
      '11-18-2001',
      ' 4- 6-1990',
      ' 4- 3-1991',
      ' 9- 9-1995',
      NULL,
      ' 2- 3-1997',
      ' 3-20-1997',
      ' 0-22-1988',
      ' 0-17-1987',
      ' 2- 8-1975',
      ' 4- 1-1995',
      ' 9- 1-1987',
      ' 0-12-1983',
      NULL,
      NULL,
      NULL,
      ' 6-13-1981',
      ' 0- 9-1994',
      NULL,
      '10- 4-1991',
      ' 5- 0-1977',
      ' 9-15-1982',
      ' 9-28-1987',
      ' 2-21-1975',
      ' 3-25-1990',
      ' 2- 7-1982',
      ' 0- 4-1977',
      ' 2- 8-1993',
      ' 2-24-1997',
      ' 8-13-1986',
      ' 1- 9-1977',
      ' 1- 3-1999',
      NULL,
      ' 0- 3-1987',
      ' 6-12-1993',
      '10-29-1977',
      ' 4-16-1985',
      ' 4-25-1999',
      NULL,
      ' 7-17-1976',
      NULL,
      '11-24-1982',
      ' 9-12-1974',
      ' 9-16-1997',
      NULL,
      '10-15-1983',
      ' 6- 5-1976',
      ' 3-13-1979',
      ' 0- 8-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-23-1982',
      ' 1-21-2000',
      ' 5-23-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


