set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '304',
      '10401333',
      23,
      80.150419,
      '4432431',
      3,
      5.670960,
      0,
      '04111',
      2,
      ' 5-27-1986',
      47,
      NULL,
      1.670988,
      0,
      3,
      0.760969,
      1.404971,
      1.815434,
      0,
      NULL,
      NULL,
      0.033353,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      78.141663,
      23,
      3.484400,
      0,
      NULL,
      NULL,
      4,
      2.809727,
      1,
      5.419650,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      9,
      4.089952,
      NULL,
      0.637674,
      3,
      NULL,
      0,
      1.119811,
      1,
      3,
      0,
      NULL,
      1,
      0,
      NULL,
      1.112194,
      4,
      4,
      NULL,
      3.663020,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.257563,
      2,
      1,
      1,
      NULL,
      3,
      NULL,
      238.416074,
      6.893102,
      2.278401,
      0.109741,
      168.123119,
      2,
      0.116912,
      NULL,
      NULL,
      3,
      NULL,
      3,
      153,
      149,
      NULL,
      1,
      366.585382,
      NULL,
      NULL,
      6,
      130,
      42,
      NULL,
      0,
      36,
      5,
      NULL,
      3,
      NULL,
      2,
      1,
      3,
      888,
      6,
      3,
      2,
      NULL,
      NULL,
      2,
      3,
      338,
      6,
      0,
      4,
      592.411441,
      0,
      3.368887,
      NULL,
      15,
      NULL,
      NULL,
      3,
      131.220522,
      6.626199,
      0.442624,
      0.278676,
      29.221367,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      455.010968,
      57.754582,
      1,
      3.770560,
      157.415151,
      2,
      1.818792,
      7,
      NULL,
      7.693790,
      1,
      0.539013,
      248,
      NULL,
      1,
      0,
      130,
      5,
      2,
      2,
      NULL,
      3.831127,
      1.985601,
      1,
      263,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.208914,
      NULL,
      NULL,
      15.097681,
      2.929049,
      0,
      153,
      0.435420,
      0.873355,
      2,
      NULL,
      75,
      NULL,
      2.388750,
      236,
      3.450412,
      2,
      1.304811,
      131.447854,
      2,
      2.089655,
      5,
      143,
      43.408153,
      0,
      1,
      573.611107,
      11.913370,
      2,
      2,
      78,
      10.437115,
      3.579149,
      1.646123,
      294.388142,
      271,
      0.534798,
      6.347001,
      125.038398,
      3,
      0,
      7.818560,
      358.539215,
      303.568891,
      3,
      2,
      106.088905,
      13,
      2.780534,
      0,
      82,
      NULL,
      3,
      NULL,
      141.385316,
      3.021094,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.857807,
      '00040',
      '22420',
      '',
      '',
      '',
      NULL,
      NULL,
      '24311',
      NULL,
      '',
      0.831195,
      '30024',
      '',
      NULL,
      3,
      7,
      123,
      1,
      NULL,
      1.829369,
      NULL,
      1,
      NULL,
      0.212546,
      6.119731,
      NULL,
      NULL,
      1.973659,
      NULL,
      NULL,
      NULL,
      0.495492,
      NULL,
      1,
      NULL,
      NULL,
      0.888996,
      19.036617,
      1,
      3,
      7.540286,
      6.551040,
      3.736405,
      2.454264,
      3.326184,
      NULL,
      NULL,
      NULL,
      13.123795,
      13.216594,
      4,
      16.455597,
      3.825504,
      16.932789,
      NULL,
      NULL,
      6,
      NULL,
      7.345105,
      0.655403,
      8,
      13,
      NULL,
      8.670616,
      7.631535,
      2.110634,
      2,
      10.720387,
      13,
      NULL,
      0.624653,
      7,
      4,
      15,
      7,
      7.541299,
      5,
      10,
      4.162819,
      16.678851,
      0,
      5,
      NULL,
      12.607188,
      13,
      3.879191,
      4,
      10,
      28.175607,
      NULL,
      22.441907,
      NULL,
      8.501347,
      20.540706,
      29,
      11,
      7,
      1,
      6.592700,
      8.320008,
      20.381706,
      17,
      37,
      3,
      10,
      10.874833,
      NULL,
      1,
      1.633504,
      19,
      3,
      23.127838,
      6,
      32,
      NULL,
      17.665571,
      2.824603,
      10,
      12.204801,
      9.619785,
      49,
      NULL,
      NULL,
      18.048109,
      8,
      11,
      4,
      3.089248,
      NULL,
      2,
      31,
      NULL,
      22.507185,
      0,
      NULL,
      37,
      10,
      2.554322,
      20.163326,
      30,
      NULL,
      137,
      NULL,
      77,
      64.330882,
      185,
      62,
      30,
      NULL,
      155.244367,
      82,
      NULL,
      177,
      117,
      NULL,
      119.785886,
      73,
      79,
      52,
      122.436813,
      NULL,
      97,
      165,
      44,
      190,
      153,
      151.778028,
      10.664986,
      164,
      121,
      NULL,
      96.728872,
      14.563828,
      NULL,
      107,
      NULL,
      NULL,
      0.025212,
      1.334458,
      0.186755,
      0,
      1.613193,
      3,
      1,
      1.836869,
      5,
      2.287624,
      NULL,
      1,
      4.759857,
      NULL,
      6,
      0.543613,
      5.464807,
      NULL,
      0.934011,
      NULL,
      0.638700,
      NULL,
      0.207107,
      1.823301,
      0,
      1,
      NULL,
      1.307286,
      NULL,
      1.739814,
      3,
      1.248969,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.396195,
      0,
      NULL,
      0.897920,
      9.120869,
      3.381358,
      2.016014,
      4,
      3,
      NULL,
      0,
      1.519028,
      1,
      1,
      0.969081,
      0.676310,
      1,
      1,
      0,
      1,
      1.576387,
      0,
      NULL,
      0,
      1,
      0,
      7.521916,
      1.340966,
      2.461728,
      0,
      NULL,
      1.094508,
      1.726776,
      4.007905,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1.858393,
      0.053257,
      1.916729,
      0,
      1,
      0,
      0.632935,
      1.136454,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.552788,
      0.909186,
      8,
      3.059522,
      1.545475,
      0.132650,
      0.999772,
      1,
      NULL,
      1,
      1.038720,
      1.142131,
      1.306357,
      1,
      1,
      NULL,
      NULL,
      5,
      3,
      0.862063,
      NULL,
      1.767521,
      4.302579,
      1,
      NULL,
      0.207411,
      0.638367,
      0.858970,
      1.366173,
      1.052711,
      1.060175,
      NULL,
      1.197854,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      3.406048,
      1,
      1,
      0,
      0.260233,
      1,
      1.262169,
      0,
      0.109538,
      1,
      1,
      1.557373,
      1.649721,
      5.929182,
      0.821817,
      1.018248,
      1.692129,
      1,
      0.521630,
      0,
      1.855422,
      1.525978,
      0,
      1,
      1,
      1.958146,
      0,
      0.356997,
      0.193263,
      1,
      1,
      2.597330,
      2.637630,
      7,
      1,
      NULL,
      5,
      4,
      NULL,
      NULL,
      5.344091,
      0.653084,
      1,
      6,
      0,
      NULL,
      4.579909,
      2.334116,
      0,
      2,
      NULL,
      NULL,
      3.145837,
      1,
      NULL,
      0.351980,
      0,
      0.234452,
      1.876313,
      NULL,
      0.211363,
      0,
      3.831103,
      NULL,
      7,
      0,
      6.643429,
      2,
      NULL,
      5,
      1.184261,
      NULL,
      1,
      0.858042,
      NULL,
      0,
      NULL,
      NULL,
      0.649960,
      1.972507,
      1.521737,
      1,
      NULL,
      1.995909,
      0.721130,
      3,
      3.398843,
      1.839127,
      1.767641,
      0.487106,
      4.705642,
      1.433677,
      5,
      2,
      0.808428,
      NULL,
      3.419928,
      1.987424,
      1.537733,
      2,
      NULL,
      0,
      1.827675,
      2,
      0.803665,
      NULL,
      4.961982,
      0,
      2.395047,
      0.619111,
      NULL,
      5.796304,
      4,
      5.727933,
      0.127690,
      3,
      0.234985,
      1,
      3.820751,
      0,
      3.382687,
      1,
      NULL,
      4,
      NULL,
      0,
      1.878356,
      NULL,
      3.252801,
      NULL,
      NULL,
      2.302246,
      7.471087,
      6,
      7.813975,
      7.364711,
      NULL,
      NULL,
      1.740764,
      1.180263,
      3,
      6,
      5.981837,
      NULL,
      0.665392,
      4.570914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.910285,
      4.155711,
      1,
      6,
      2,
      1.769312,
      1,
      3,
      6,
      7.990220,
      1.176974,
      0,
      4.125757,
      1.726295,
      2.029702,
      2,
      5,
      5.359065,
      NULL,
      4.844810,
      5.993199,
      NULL,
      NULL,
      NULL,
      5.636993,
      1,
      7.220170,
      NULL,
      7.419768,
      NULL,
      5.987742,
      7.373237,
      NULL,
      1,
      NULL,
      7,
      1.083192,
      NULL,
      6,
      NULL,
      1.000292,
      1,
      NULL,
      1,
      3,
      NULL,
      0.236700,
      0,
      6,
      5.412799,
      NULL,
      NULL,
      4.490357,
      5,
      NULL,
      2,
      5.992442,
      0,
      5,
      2.431673,
      1.277149,
      NULL,
      0,
      1,
      2.253685,
      0.260456,
      0,
      3,
      3,
      4,
      5,
      2.909330,
      4.036403,
      NULL,
      2,
      0,
      NULL,
      3,
      4.528209,
      0,
      0.596211,
      5,
      5.514654,
      5.745305,
      NULL,
      1,
      0.098306,
      5,
      NULL,
      4,
      3,
      3,
      3.355046,
      7,
      NULL,
      NULL,
      1,
      1.166792,
      3,
      1,
      1.519296,
      3,
      0.917373,
      1,
      NULL,
      NULL,
      NULL,
      1.311470,
      1,
      NULL,
      4.398864,
      0,
      1.480528,
      1.444312,
      3,
      1,
      2,
      3.685935,
      1.278973,
      0,
      3.085031,
      NULL,
      NULL,
      NULL,
      NULL,
      1.977388,
      3,
      1.714377,
      3.773226,
      0,
      1,
      0,
      2.697825,
      3,
      NULL,
      5,
      3,
      4,
      1.657282,
      0,
      5.417842,
      NULL,
      2.668227,
      NULL,
      0.146045,
      3,
      4,
      0,
      0.647289,
      7,
      4,
      NULL,
      2,
      5,
      0,
      2.850533,
      4.942444,
      1,
      5.280330,
      3,
      4.660896,
      4,
      2.598797,
      NULL,
      5,
      NULL,
      2.332274,
      1.306744,
      1.120767,
      4.879222,
      4.744235,
      3.254867,
      NULL,
      2,
      4,
      6.017409,
      2.294328,
      4,
      6,
      4,
      0.033799,
      0,
      4.835279,
      4,
      NULL,
      4,
      4.426750,
      3,
      5.222987,
      0.171435,
      5.651083,
      NULL,
      4,
      0.059619,
      NULL,
      4.763322,
      5,
      5,
      0,
      1.727397,
      NULL,
      10.913469,
      0,
      3.197620,
      1,
      5,
      2,
      2.590022,
      5.176920,
      2,
      6,
      NULL,
      0,
      3,
      NULL,
      NULL,
      6,
      6.624996,
      3.658413,
      0.521410,
      2.124078,
      NULL,
      5,
      4.019570,
      1.408553,
      5,
      NULL,
      7.262345,
      3,
      NULL,
      1,
      4.922879,
      4,
      1,
      1,
      0.458423,
      1,
      1.323321,
      1.022977,
      3.253916,
      2.154714,
      0,
      4,
      7.659349,
      NULL,
      3,
      5.607420,
      1.902816,
      NULL,
      1.475940,
      1.803056,
      NULL,
      0.020654,
      0,
      NULL,
      1.673048,
      0,
      1,
      0,
      0.630879,
      1.552685,
      1,
      1.075696,
      1,
      0.566545,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      0.651277,
      0.243492,
      1,
      0,
      NULL,
      1.498357,
      1.276898,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448579,
      1.061171,
      0,
      1,
      NULL,
      1.753114,
      NULL,
      1.304601,
      0.464167,
      1.180040,
      1.314040,
      0,
      1,
      1.992586,
      6.226540,
      3,
      5.787614,
      NULL,
      1,
      4,
      0.973429,
      NULL,
      0.878780,
      3,
      3,
      NULL,
      3.656747,
      1.689910,
      1.832365,
      1.618669,
      5,
      3,
      NULL,
      0.456596,
      1.030763,
      4.992790,
      1.031652,
      0,
      1.989001,
      3.675339,
      5.074621,
      NULL,
      1.151619,
      NULL,
      2.075135,
      5.504662,
      0.042053,
      0.713187,
      0,
      NULL,
      3,
      1,
      3,
      0.933269,
      1,
      4,
      5,
      1.574880,
      0.544166,
      7.028965,
      1.542481,
      5.192019,
      2,
      NULL,
      2.354599,
      0.269925,
      2,
      NULL,
      5,
      5.760828,
      3.959005,
      1,
      NULL,
      2.211720,
      2,
      1.193143,
      NULL,
      4,
      4.008838,
      NULL,
      NULL,
      1.823638,
      3,
      2,
      2,
      NULL,
      0.471122,
      0.075736,
      1,
      NULL,
      5,
      4,
      NULL,
      1,
      3.506756,
      NULL,
      1,
      1.316421,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1.608897,
      1.271456,
      NULL,
      1.838229,
      1.925228,
      0,
      1,
      0.483573,
      NULL,
      1,
      0.609556,
      0.854812,
      4.739813,
      3.712193,
      NULL,
      7,
      2,
      0,
      1,
      NULL,
      1.706339,
      7,
      0,
      0,
      2,
      3.388195,
      1.722622,
      4,
      2.923032,
      NULL,
      NULL,
      3,
      1,
      1.145719,
      0,
      3,
      0,
      2.150604,
      2,
      NULL,
      4.973086,
      NULL,
      6.146372,
      0,
      NULL,
      4.091959,
      3.721511,
      NULL,
      0,
      1.173301,
      1,
      NULL,
      1,
      1.246440,
      0.599446,
      1.580465,
      NULL,
      6,
      0,
      3.925351,
      5,
      3,
      6.835322,
      4.082209,
      1,
      2,
      4,
      0,
      NULL,
      7,
      NULL,
      7,
      2.178994,
      0,
      2.975087,
      0.451019,
      5,
      4.364816,
      0.320668,
      0,
      1,
      5.597862,
      1.996038,
      3.049002,
      2.778319,
      4,
      3.182549,
      NULL,
      5,
      0,
      0.701442,
      7,
      NULL,
      2,
      5,
      0,
      5.541223,
      0.933888,
      NULL,
      3.217146,
      NULL,
      5,
      NULL,
      3.749373,
      3,
      2,
      0,
      5,
      5,
      6,
      0.501231,
      NULL,
      NULL,
      7,
      4.941625,
      4,
      2.987846,
      0,
      1,
      1.131779,
      NULL,
      0.624090,
      1.466002,
      1.514547,
      0.543243,
      0.343524,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1.869273,
      1,
      1.211850,
      1.625855,
      1,
      NULL,
      1.006848,
      NULL,
      NULL,
      1.162524,
      0.856799,
      0,
      1.181642,
      NULL,
      0.047427,
      NULL,
      0,
      1,
      0.698730,
      NULL,
      NULL,
      0,
      0,
      0.896249,
      1,
      0.673813,
      0,
      NULL,
      0.609336,
      0.415692,
      1.334947,
      0,
      3.035831,
      2.759007,
      2.387126,
      3,
      NULL,
      2,
      4.720569,
      1,
      3.489917,
      2.817664,
      1,
      3.524388,
      4.540603,
      2.818912,
      NULL,
      3.261151,
      0.554207,
      2.284685,
      0.733651,
      0.223558,
      NULL,
      0,
      2.668707,
      0,
      0,
      3.404711,
      1,
      NULL,
      0.884447,
      2,
      0,
      1.206715,
      2,
      NULL,
      0.291754,
      NULL,
      3.337379,
      5.353765,
      2,
      1,
      1,
      NULL,
      5.078859,
      NULL,
      1,
      NULL,
      1.549265,
      4.546900,
      1.908780,
      4,
      NULL,
      4,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      3,
      0,
      3,
      0,
      0,
      NULL,
      1,
      1,
      1,
      3,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      3,
      0,
      1,
      2,
      1,
      NULL,
      3,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      3,
      4,
      5,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      2,
      NULL,
      5,
      NULL,
      NULL,
      3,
      4,
      4,
      NULL,
      2,
      2,
      2,
      4,
      0,
      1,
      1,
      NULL,
      2,
      NULL,
      0,
      1,
      4,
      4,
      3,
      NULL,
      2,
      NULL,
      4,
      0,
      NULL,
      2,
      0,
      3,
      NULL,
      4,
      0,
      2,
      0,
      NULL,
      0,
      1.605154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 8-1998',
      NULL,
      ' 5-27-1975',
      ' 6- 0-1992',
      ' 8-22-1975',
      NULL,
      ' 0-28-1993',
      ' 8-12-1993',
      ' 4-13-1974',
      ' 7-29-1983',
      ' 3-16-1983',
      NULL,
      NULL,
      '11- 0-1993',
      NULL,
      ' 4-24-1980',
      NULL,
      ' 1- 8-1988',
      NULL,
      ' 7-20-1985',
      NULL,
      ' 2-19-1995',
      ' 9-15-2003',
      ' 0- 2-1983',
      ' 4-29-1977',
      ' 2- 4-1999',
      ' 9-10-1979',
      '11-25-1994',
      ' 3-24-1980',
      ' 3- 6-1978',
      ' 2-10-1981',
      '10-18-1993',
      ' 4-16-1994',
      ' 6- 3-1990',
      NULL,
      ' 9- 0-2001',
      ' 6-23-1974',
      NULL,
      ' 3-16-1997',
      NULL,
      NULL,
      ' 5-19-1995',
      NULL,
      NULL,
      '10-14-1980',
      ' 4-12-1977',
      ' 8- 1-1984',
      ' 2- 2-1974',
      ' 0- 7-1982',
      NULL,
      ' 1- 2-1978',
      ' 7-18-1997',
      NULL,
      ' 2-26-1991',
      ' 5- 7-1981',
      ' 8-24-1984',
      NULL,
      ' 5-25-2000',
      NULL,
      ' 0-29-2001',
      ' 0-29-1999',
      ' 7-13-2001',
      NULL,
      NULL,
      ' 5- 1-1980',
      '11-12-1983',
      NULL,
      '11- 0-1983',
      ' 3-29-1998',
      NULL,
      ' 1-25-1999',
      NULL,
      ' 0-19-1989',
      ' 8-28-1995',
      ' 0-29-2003',
      '10- 1-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-19-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-17-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


