set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8335020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '2403241',
      2,
      3,
      3,
      '30211',
      2,
      '11- 0-1983',
      40,
      NULL,
      0.814235,
      NULL,
      3.088910,
      1,
      0,
      3,
      0,
      1.126630,
      2,
      3.373181,
      0,
      0,
      NULL,
      NULL,
      1.642595,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.069226,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      8,
      5,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      4,
      0.364156,
      NULL,
      6,
      0,
      0.026369,
      0,
      0,
      1.581074,
      2,
      5,
      NULL,
      1.326929,
      0,
      NULL,
      7.908445,
      NULL,
      6,
      1,
      7,
      2,
      3.809352,
      10,
      ' 4- 0-1986',
      NULL,
      0.283661,
      4,
      2,
      5,
      NULL,
      5.808306,
      1,
      12.146364,
      NULL,
      2,
      NULL,
      1.193631,
      238.165064,
      15,
      NULL,
      3.815145,
      233.500980,
      122.344139,
      2.358216,
      3.657115,
      187.820804,
      100,
      2,
      2,
      570.936761,
      1189,
      2.191766,
      1,
      33,
      4.888211,
      3.788356,
      0.525983,
      580,
      431,
      NULL,
      1.229779,
      69,
      171,
      3.780023,
      7.270504,
      231,
      10,
      3,
      6.765200,
      68,
      254,
      1.152697,
      5,
      429.678632,
      16.996625,
      NULL,
      0.333161,
      511.243490,
      1713.561946,
      NULL,
      1.636722,
      96,
      737.437961,
      3.698895,
      5,
      383.093668,
      NULL,
      3.332281,
      0,
      115.371305,
      NULL,
      1.057945,
      3.800150,
      223,
      17.701264,
      2,
      1,
      444,
      107.339294,
      0.669701,
      2.444978,
      386.174116,
      18540,
      0.765075,
      5.108404,
      60.217459,
      6153,
      2.881988,
      3,
      NULL,
      101,
      NULL,
      4.923320,
      773.481538,
      1.748161,
      2.920960,
      3,
      714,
      0,
      3,
      1,
      161.518616,
      NULL,
      3.639696,
      2,
      NULL,
      155,
      1,
      5,
      112,
      377.570612,
      3,
      2.412218,
      NULL,
      126.612534,
      0.737456,
      0.065344,
      162.556413,
      178.757052,
      3,
      2,
      107.774816,
      134.594609,
      3,
      2,
      NULL,
      NULL,
      NULL,
      7.152206,
      211.659770,
      515,
      0,
      0,
      74.481966,
      NULL,
      2,
      2.185629,
      131.960325,
      NULL,
      3.500220,
      5,
      117.852012,
      91.917292,
      NULL,
      3,
      67,
      506,
      2.160468,
      3,
      120,
      828,
      0.581748,
      NULL,
      130,
      NULL,
      1,
      0.989360,
      NULL,
      7,
      3.916903,
      3.379398,
      NULL,
      NULL,
      3,
      2.351550,
      105,
      0,
      3.358691,
      1.809009,
      548,
      NULL,
      0.234972,
      1,
      691.661952,
      6,
      0.870046,
      1,
      NULL,
      49.502063,
      3.061587,
      2.733805,
      798,
      NULL,
      2.209122,
      2,
      1024,
      112.603969,
      3.949874,
      2,
      NULL,
      81.721448,
      1.484389,
      3.313333,
      1354,
      46.986904,
      3,
      2,
      428.428304,
      25,
      0,
      5.216425,
      112.420301,
      NULL,
      NULL,
      1,
      961.272785,
      463.505058,
      NULL,
      7.924331,
      38.620671,
      213.555946,
      0,
      NULL,
      NULL,
      148.287811,
      0,
      2,
      800.071415,
      501,
      1,
      2.136521,
      NULL,
      31.038297,
      2,
      1,
      559.102066,
      9.169293,
      0.988305,
      0.956417,
      1292,
      39.377089,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.332529,
      '14230',
      '',
      '',
      NULL,
      NULL,
      '',
      0.869855,
      '',
      NULL,
      '',
      1.282421,
      NULL,
      '',
      '',
      5,
      0.190563,
      NULL,
      0,
      208.592675,
      1.117922,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      539.334682,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.635517,
      NULL,
      ' 8- 3-1976',
      7.540178,
      23.915554,
      10,
      0.872984,
      3,
      0,
      NULL,
      0,
      1,
      3,
      NULL,
      9.220291,
      11,
      17,
      19,
      NULL,
      2,
      NULL,
      12,
      11,
      10,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.904353,
      15,
      29,
      43.879593,
      16,
      37,
      3,
      NULL,
      2.045933,
      NULL,
      NULL,
      20.433699,
      30.463392,
      37,
      32.413256,
      37.049544,
      NULL,
      1.524044,
      18.946889,
      41,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      158.780550,
      138,
      NULL,
      NULL,
      NULL,
      101,
      74,
      63,
      NULL,
      NULL,
      161,
      124.330922,
      13.778675,
      173,
      39,
      150,
      75,
      130.868479,
      NULL,
      58,
      123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.481662,
      6,
      2,
      NULL,
      NULL,
      4,
      6,
      0.807895,
      4,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      2.211444,
      NULL,
      9,
      10.227127,
      8.267509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.972119,
      2,
      0,
      0,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      2.395744,
      3.643021,
      0.687343,
      5,
      4.575200,
      4.992324,
      NULL,
      2.497212,
      9.546919,
      4,
      1.032664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.543303,
      0,
      NULL,
      1,
      0,
      0.974556,
      1,
      1.129215,
      0.856299,
      1,
      NULL,
      NULL,
      0.993686,
      0.108908,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1.772654,
      0,
      0,
      0.776316,
      1.074204,
      1,
      1.717123,
      NULL,
      1,
      0,
      1,
      0,
      0.062117,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.299975,
      2,
      4.892599,
      0,
      0.381778,
      3,
      NULL,
      0,
      3.315204,
      NULL,
      1,
      NULL,
      NULL,
      2.486257,
      4.111439,
      6.996153,
      0.800679,
      4.234239,
      NULL,
      3.484232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      5.229218,
      0.018501,
      0.119383,
      3.960720,
      5,
      NULL,
      6.327527,
      NULL,
      3.546225,
      2,
      NULL,
      NULL,
      0.222332,
      1,
      2.060443,
      6,
      7,
      10.181433,
      8.684488,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      6.418376,
      NULL,
      0,
      1.774963,
      4,
      4,
      7,
      8.004548,
      5,
      NULL,
      4,
      0.799140,
      NULL,
      3.663653,
      9,
      6.649419,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.729803,
      4.818512,
      2.284044,
      NULL,
      4,
      3,
      4,
      3.701030,
      3,
      3,
      7.171269,
      2.810101,
      0,
      0,
      NULL,
      0,
      3.454688,
      3.819776,
      2,
      NULL,
      5.116066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.591389,
      3,
      2,
      NULL,
      0.338634,
      2,
      NULL,
      3,
      2.311421,
      9,
      2,
      9.622030,
      9,
      8,
      NULL,
      7.940001,
      1,
      6,
      3.330365,
      0.495110,
      9.420483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738034,
      0.988901,
      0.380795,
      NULL,
      NULL,
      1.983829,
      1,
      0,
      1,
      1.048300,
      0.446874,
      1,
      0.779905,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.159664,
      NULL,
      1.884874,
      0.650864,
      NULL,
      0.410035,
      0.236532,
      1,
      1,
      0,
      0.528056,
      1.521987,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377846,
      5,
      2,
      1,
      7.652554,
      7.373516,
      8.304311,
      3,
      2.809844,
      5.090703,
      2.566614,
      0.482645,
      4,
      NULL,
      NULL,
      2,
      8.424417,
      1.220084,
      NULL,
      0.581309,
      7.458680,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.251642,
      2,
      5,
      7,
      7,
      0,
      NULL,
      1.647212,
      3.631153,
      3,
      5.610655,
      5,
      4.044310,
      4,
      NULL,
      1.279847,
      0.955687,
      2,
      3.376051,
      NULL,
      5.230870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      5.365803,
      3.299143,
      2.058622,
      3,
      3.633911,
      1.518802,
      6.978055,
      6.986751,
      NULL,
      NULL,
      5,
      0,
      3,
      3,
      NULL,
      3.923723,
      NULL,
      2,
      4.757866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      7,
      1,
      1.332203,
      4,
      9,
      2.346853,
      9.895274,
      7.931140,
      1,
      1,
      7.054350,
      NULL,
      1,
      5.294780,
      3,
      2,
      NULL,
      5.140318,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.849796,
      NULL,
      1,
      1,
      0,
      0.492626,
      NULL,
      0,
      0.785526,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.972024,
      1.277950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885789,
      3,
      0.791447,
      NULL,
      NULL,
      5.280672,
      NULL,
      1.487440,
      4.256559,
      5,
      NULL,
      4,
      2.728600,
      0,
      4,
      NULL,
      NULL,
      8.630912,
      7.717284,
      3.205780,
      8,
      9.101298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      5,
      0,
      0,
      0,
      5,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-28-1988',
      ' 1- 6-1985',
      ' 8-24-1977',
      ' 3-16-1977',
      ' 6- 4-1999',
      NULL,
      ' 2- 2-1993',
      ' 1- 1-1978',
      ' 9-17-1975',
      ' 8- 3-1977',
      '11-24-1988',
      ' 1- 5-1993',
      NULL,
      ' 9-27-2001',
      ' 0-29-1984',
      ' 9- 3-2000',
      ' 9-11-1975',
      ' 3-27-1993',
      ' 1-28-1979',
      ' 1- 9-2000',
      ' 8- 7-1992',
      ' 4-13-1978',
      ' 4-15-1984',
      ' 2-11-1989',
      ' 4- 4-1997',
      '11- 4-1996',
      ' 0-29-1982',
      NULL,
      ' 0-23-1990',
      NULL,
      ' 6-20-1989',
      NULL,
      ' 2-15-1976',
      ' 4-16-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 7-1997',
      '11-27-1985',
      ' 8- 1-1979',
      ' 5-15-1981',
      ' 0-21-2000',
      '10- 2-1999',
      ' 9-13-1999',
      ' 2-23-1993',
      ' 0- 1-1984',
      ' 6-22-2003',
      ' 0- 5-1986',
      NULL,
      NULL,
      ' 1- 6-1977',
      ' 9- 8-1996',
      NULL,
      ' 7- 2-1982',
      NULL,
      ' 0- 9-1986',
      NULL,
      ' 9- 8-1999',
      ' 0- 9-1990',
      ' 0- 4-2000',
      ' 7- 4-1980',
      ' 1-20-1991',
      ' 7-21-2002',
      NULL,
      ' 0-14-1993',
      ' 3-21-1978',
      '10- 9-2002',
      NULL,
      ' 7-12-1990',
      NULL,
      '11-13-1987',
      ' 9-27-1998',
      ' 9-23-2002',
      NULL,
      NULL,
      NULL,
      '11-22-1998',
      ' 6-13-1981',
      '10- 7-1984',
      ' 8- 7-1998',
      ' 1- 3-1988',
      ' 5-21-1990',
      ' 5- 1-1997',
      NULL,
      ' 5- 8-1996',
      NULL,
      ' 5- 1-2000',
      ' 8-19-1976',
      ' 1-19-1994',
      NULL,
      NULL,
      ' 4- 6-1977',
      ' 6-23-1999',
      ' 1-29-2002',
      ' 1- 1-1988',
      ' 2- 2-1978',
      ' 8-23-1983',
      '10-23-1982',
      ' 7-29-1978',
      ' 9-17-1978',
      '11- 0-1997',
      NULL,
      ' 2- 4-1988',
      NULL,
      '11-15-1982',
      NULL,
      NULL,
      ' 0-29-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


