set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9528893';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '0021031',
      0,
      1.116088,
      0,
      '24202',
      1,
      ' 4-23-1975',
      139,
      NULL,
      1,
      2,
      0,
      0,
      1.680676,
      1.255186,
      NULL,
      NULL,
      1.105240,
      0.128025,
      1,
      5,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.135468,
      7,
      NULL,
      4.408124,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      3,
      5.084940,
      NULL,
      NULL,
      1,
      1,
      0.724327,
      0,
      0.561217,
      1,
      2,
      1.837142,
      0.296038,
      NULL,
      9,
      NULL,
      5,
      3,
      2,
      5,
      0.360997,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1,
      NULL,
      4.692163,
      2,
      8,
      121.667355,
      11,
      NULL,
      0.779664,
      NULL,
      20.323746,
      2.463055,
      NULL,
      177,
      NULL,
      0,
      2,
      94,
      1,
      0,
      0.033643,
      56.124944,
      3,
      0,
      1.968074,
      NULL,
      30,
      3,
      3.662443,
      106.038154,
      747.699034,
      NULL,
      2.277390,
      88.477548,
      3.092711,
      2,
      NULL,
      32,
      NULL,
      0.074111,
      2.181603,
      79.391988,
      5.762879,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      856,
      NULL,
      1,
      0.373700,
      1354.369884,
      2,
      2.694180,
      3,
      427.642496,
      7.323969,
      0.368248,
      0,
      210.945137,
      5.930041,
      3.282640,
      NULL,
      551,
      29.151307,
      0,
      2,
      39,
      NULL,
      1.322085,
      1,
      517,
      NULL,
      3.515813,
      6.288889,
      534,
      641,
      NULL,
      6.397472,
      572,
      242.129535,
      0.169117,
      7,
      6,
      NULL,
      0,
      3,
      467,
      6.402479,
      1,
      3.248418,
      560.778141,
      11,
      1.206543,
      0,
      181,
      41.043138,
      1,
      1,
      230,
      59,
      NULL,
      2.537338,
      1203.297447,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '32012',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      4,
      1,
      NULL,
      0.608423,
      841,
      0.362317,
      NULL,
      0,
      NULL,
      5.515904,
      NULL,
      1.936881,
      NULL,
      0.551911,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.037982,
      NULL,
      NULL,
      NULL,
      4.686272,
      9,
      8.244735,
      NULL,
      4,
      6.719298,
      7.931250,
      NULL,
      15,
      0,
      7,
      10.137847,
      7,
      7.175370,
      NULL,
      5,
      4,
      4,
      NULL,
      1,
      8,
      14.362920,
      2.023204,
      NULL,
      NULL,
      17,
      2.007139,
      8.720079,
      14,
      0.833366,
      2.023675,
      NULL,
      0,
      NULL,
      4.793332,
      5.401384,
      0.844505,
      NULL,
      1.901141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.654376,
      11,
      5,
      NULL,
      2,
      3,
      24,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.016973,
      NULL,
      0,
      0,
      1.295297,
      1,
      NULL,
      7.451256,
      1,
      12,
      NULL,
      NULL,
      21,
      10.959790,
      29.174605,
      10.447072,
      18,
      19,
      1,
      3,
      NULL,
      NULL,
      NULL,
      63,
      6,
      35,
      55.496717,
      12.740248,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65.844614,
      31.764761,
      157.666206,
      153,
      143.823798,
      70.726894,
      6.820447,
      115.232963,
      94.182698,
      48.788842,
      NULL,
      NULL,
      16,
      20,
      154,
      44,
      NULL,
      139.655942,
      35.803395,
      43,
      57.064385,
      131,
      NULL,
      40,
      NULL,
      30.003115,
      NULL,
      0,
      31,
      69,
      NULL,
      26,
      89.987089,
      75.098040,
      179,
      122.005192,
      110,
      NULL,
      162.932530,
      NULL,
      NULL,
      107.283731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      8,
      NULL,
      NULL,
      0.142655,
      9.288140,
      8,
      0.993483,
      3.918873,
      7.344448,
      10.424433,
      2.403651,
      4.610353,
      2,
      10,
      NULL,
      6,
      2.300769,
      NULL,
      5,
      6,
      NULL,
      2.578794,
      3.853689,
      NULL,
      6,
      NULL,
      NULL,
      4,
      8.827260,
      2,
      1.750328,
      5,
      8.759028,
      NULL,
      9,
      NULL,
      4,
      5,
      1.545389,
      1,
      1.295560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.100410,
      4,
      6,
      NULL,
      6.440464,
      0.736260,
      0.983801,
      NULL,
      NULL,
      8.213065,
      8.933397,
      3,
      5,
      3.531558,
      5,
      3,
      3.983034,
      NULL,
      NULL,
      0.631484,
      1,
      2.626117,
      NULL,
      1.694727,
      NULL,
      1,
      NULL,
      4.577183,
      5,
      3.874070,
      1,
      0,
      0,
      0,
      2.582667,
      0.408835,
      1.607239,
      1.757805,
      5,
      3,
      5.454963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6.871745,
      6.676589,
      NULL,
      NULL,
      7,
      6,
      NULL,
      4,
      NULL,
      7,
      4.578409,
      7.727772,
      4,
      4.194861,
      2.026067,
      4.525779,
      4.713469,
      NULL,
      2.636003,
      0,
      7.044082,
      NULL,
      6.231542,
      6.308682,
      3.927012,
      5,
      8,
      5.868154,
      NULL,
      1.766188,
      4,
      3.580224,
      1,
      2.605055,
      NULL,
      4.582749,
      0,
      4,
      3.861398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6.062515,
      1,
      NULL,
      0,
      3.379935,
      3.086917,
      0,
      4,
      0.003018,
      5.077120,
      NULL,
      0.320444,
      3,
      4.503970,
      3.822550,
      NULL,
      NULL,
      4,
      NULL,
      2.379896,
      NULL,
      2,
      3.326043,
      3.258440,
      2.975226,
      NULL,
      5,
      NULL,
      NULL,
      4,
      4.714945,
      3,
      0.812167,
      3,
      3.852640,
      NULL,
      NULL,
      7.569853,
      0.634781,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.581647,
      4,
      4.636363,
      1.637697,
      4,
      3,
      1,
      5,
      2.133518,
      5,
      3,
      NULL,
      2.703346,
      1.275137,
      0,
      1.379541,
      NULL,
      3,
      2,
      NULL,
      5.979966,
      4,
      2,
      0.332030,
      0,
      2.084200,
      7.190699,
      2,
      4,
      1.903017,
      6.873824,
      6,
      5,
      0.694666,
      0,
      3,
      1,
      0,
      1,
      0.401415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.494669,
      6.211322,
      9,
      3,
      6.961517,
      NULL,
      7.979258,
      NULL,
      NULL,
      NULL,
      1.202788,
      NULL,
      4.844449,
      1,
      8.155184,
      2.031885,
      6,
      3,
      7,
      0,
      5.785525,
      7.474067,
      1,
      4.475101,
      2,
      NULL,
      6.652276,
      2,
      2.035942,
      6,
      5,
      3,
      3.542522,
      5,
      0.570679,
      1.187856,
      7,
      NULL,
      7.727415,
      NULL,
      5.667768,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8.979630,
      6,
      0,
      NULL,
      5.275372,
      6,
      NULL,
      5.896633,
      1.468377,
      8.321634,
      2.378759,
      5.554950,
      4,
      1,
      4,
      1.087692,
      5.451575,
      NULL,
      1.933917,
      0.746290,
      2,
      4.568565,
      3.931811,
      NULL,
      7,
      0,
      2,
      6.681263,
      6.069575,
      9.752673,
      3.172856,
      1.447940,
      8,
      0.714033,
      4.246262,
      7.884458,
      4,
      2.726437,
      6.994274,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.001292,
      5,
      5.883744,
      4,
      1,
      4.956839,
      NULL,
      4.878665,
      NULL,
      3,
      2.628268,
      2.509919,
      NULL,
      1.431096,
      3.246575,
      1,
      3.284874,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.279717,
      2.275324,
      3,
      2.660082,
      5.256127,
      0,
      5.760647,
      4,
      NULL,
      5.634424,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      4.973791,
      3,
      NULL,
      0.346309,
      2,
      2.935186,
      5,
      3,
      NULL,
      1.133572,
      3.953174,
      0,
      0,
      0,
      3.015014,
      5,
      NULL,
      1.082284,
      NULL,
      2.735464,
      3.881293,
      NULL,
      4,
      NULL,
      2.609419,
      3.405850,
      1.487666,
      4.139931,
      7.197611,
      1,
      5,
      5,
      NULL,
      2,
      NULL,
      4.259194,
      0.852923,
      0.138880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.301391,
      NULL,
      NULL,
      1.402444,
      0,
      3,
      3,
      0,
      NULL,
      NULL,
      2,
      1.949528,
      1,
      0,
      0,
      2.177095,
      0.181861,
      3.946542,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2.304090,
      2.896529,
      1,
      1.270713,
      0,
      1,
      0,
      1,
      2,
      3.657242,
      0,
      0,
      3,
      0,
      1,
      0,
      3.981906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.398646,
      1.883357,
      0.699223,
      0,
      0,
      0.069076,
      1.406957,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1.131388,
      1,
      1.088894,
      NULL,
      1,
      NULL,
      1,
      5,
      1,
      1.621437,
      1.453180,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.457577,
      NULL,
      0.584118,
      NULL,
      NULL,
      1,
      0.164260,
      0,
      0.626246,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.618958,
      NULL,
      0.492856,
      0,
      NULL,
      1.840621,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      4,
      0,
      2.801560,
      NULL,
      4.780103,
      NULL,
      NULL,
      1.397973,
      5.863397,
      1.358704,
      1.546865,
      4,
      1,
      4,
      NULL,
      6,
      5.517914,
      3.141620,
      7.696829,
      2,
      NULL,
      2.689000,
      NULL,
      3,
      4.815816,
      NULL,
      NULL,
      2.354890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.070541,
      0,
      5,
      2.076799,
      0.809566,
      1.640943,
      4.371722,
      NULL,
      1,
      NULL,
      0,
      2.125856,
      NULL,
      0,
      1,
      1,
      NULL,
      0.977888,
      0,
      NULL,
      1,
      0,
      0,
      0.328910,
      0,
      1.948857,
      1.080375,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.901061,
      NULL,
      0,
      3.482458,
      2.211863,
      1.074831,
      1,
      0,
      1.035221,
      3.705396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.244293,
      5.582945,
      1.376165,
      8,
      4,
      9,
      8.036631,
      0.873265,
      2,
      0.448835,
      8.075003,
      NULL,
      3.843742,
      1.570812,
      11,
      5.096359,
      3.901661,
      1,
      6,
      NULL,
      NULL,
      1.743000,
      1,
      6,
      2,
      NULL,
      3,
      5,
      8,
      5,
      1.498811,
      NULL,
      9,
      1.715337,
      0.472793,
      4.015708,
      8,
      NULL,
      3,
      5.732501,
      1.047870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988990,
      2,
      0.826051,
      9,
      5.801256,
      1.509532,
      5.945231,
      1,
      7.817449,
      7,
      3.424832,
      0.426345,
      1,
      0.297212,
      3,
      7,
      2,
      4.215448,
      2,
      1,
      3.824406,
      NULL,
      0.345918,
      0,
      0,
      8.450695,
      6,
      7,
      0,
      4.036037,
      3.717207,
      7,
      8,
      0.714226,
      3.332703,
      5.283470,
      2,
      3,
      NULL,
      NULL,
      0,
      3.323818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.403907,
      NULL,
      1,
      1.654160,
      0.650301,
      0.666210,
      NULL,
      1.576192,
      0,
      NULL,
      1,
      1.989896,
      1.437543,
      1,
      NULL,
      1,
      NULL,
      0.757991,
      1,
      0,
      0,
      0.251582,
      0,
      0.346542,
      1.675489,
      1,
      NULL,
      1.999998,
      1.516903,
      1.224672,
      1,
      1.340377,
      1.402831,
      NULL,
      NULL,
      1,
      NULL,
      1.011825,
      1.394726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.069077,
      1,
      1,
      1,
      0,
      0,
      0,
      0.188645,
      0,
      NULL,
      1.225513,
      NULL,
      1.989589,
      3.000478,
      0.203309,
      4.280539,
      1.841908,
      0,
      4,
      NULL,
      0,
      1,
      2,
      1.326730,
      2.083961,
      3.817139,
      1.146788,
      NULL,
      6,
      6,
      4.711689,
      1.925478,
      NULL,
      0.776814,
      NULL,
      5.751374,
      0,
      5.759161,
      1.963507,
      0,
      0,
      4.541665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1,
      0,
      5,
      1,
      NULL,
      4,
      3,
      NULL,
      3,
      2,
      0,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      4,
      4,
      1,
      2,
      NULL,
      NULL,
      2,
      2,
      1,
      0,
      4,
      4,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      0,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-18-1995',
      ' 3-19-2000',
      '10- 5-1986',
      ' 1- 0-1982',
      '10-29-1983',
      ' 3- 6-1982',
      NULL,
      '11-26-1978',
      ' 4-17-1981',
      ' 8-26-1978',
      ' 8-19-1996',
      '11-27-1980',
      ' 8-18-1979',
      ' 7-22-1993',
      NULL,
      '11- 0-1974',
      NULL,
      ' 4- 5-1986',
      ' 8- 0-1986',
      NULL,
      ' 3-23-1996',
      ' 1-26-1984',
      ' 5-26-1995',
      ' 7- 1-1976',
      ' 4-18-1985',
      NULL,
      ' 8-16-2002',
      ' 7- 1-1999',
      ' 6-25-1989',
      NULL,
      '10-13-2001',
      ' 8-23-1994',
      ' 5-21-1992',
      NULL,
      ' 6- 2-1998',
      NULL,
      ' 0-20-1986',
      '11-23-1989',
      '11- 2-1977',
      ' 6-14-1991',
      NULL,
      ' 5-23-1998',
      NULL,
      ' 3-18-1998',
      ' 9- 7-1988',
      ' 5-20-1974',
      '11-24-1990',
      ' 5- 1-1993',
      '11-16-1991',
      ' 5-14-1979',
      ' 0-29-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 0-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


