set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314770';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '211',
      '43400030',
      NULL,
      47.014782,
      '3334134',
      6,
      3,
      NULL,
      '00102',
      6.059675,
      ' 3- 2-1990',
      14.269612,
      NULL,
      NULL,
      NULL,
      0,
      2.433205,
      0,
      1.322844,
      2,
      0,
      1,
      1.346298,
      NULL,
      2,
      NULL,
      NULL,
      1.849790,
      NULL,
      23,
      42,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.790589,
      0.512520,
      0.505190,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      7,
      7,
      3,
      0,
      0,
      1.723403,
      1,
      0.072609,
      1,
      0,
      6.059052,
      1.405899,
      NULL,
      3,
      3,
      3,
      NULL,
      6,
      NULL,
      0.688715,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      5,
      1,
      0,
      NULL,
      NULL,
      4.897195,
      NULL,
      3,
      2,
      4.692734,
      NULL,
      6,
      2.451751,
      0,
      114.513593,
      2.628151,
      1.854124,
      NULL,
      144.046782,
      0,
      0,
      5,
      234.057789,
      0,
      0.701849,
      NULL,
      9,
      3.081589,
      3,
      0,
      154.996399,
      18.526161,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '23344',
      '42321',
      NULL,
      NULL,
      '',
      '',
      0.298487,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      3.835136,
      36.954514,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.276105,
      NULL,
      0,
      NULL,
      9.572736,
      518.238311,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '11-25-2000',
      3.479575,
      8,
      NULL,
      3.650982,
      6.817895,
      9.783870,
      12,
      NULL,
      NULL,
      NULL,
      10,
      6,
      13,
      22,
      9,
      19,
      0,
      3.796879,
      4,
      4,
      6.693869,
      3.511886,
      14.469060,
      11,
      NULL,
      NULL,
      14,
      0.226487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.514180,
      2,
      15,
      8.310894,
      31,
      43,
      2,
      1.467405,
      41,
      33.523487,
      27,
      3,
      1,
      2,
      32.815856,
      NULL,
      29,
      15,
      24,
      18,
      1.731540,
      0,
      37,
      2.932276,
      15,
      31.947349,
      5,
      3,
      5.892836,
      32,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      114,
      NULL,
      33.093462,
      38.632476,
      138,
      86,
      NULL,
      196,
      140,
      3.204015,
      3,
      2.918351,
      3,
      2.581272,
      3,
      2.666647,
      NULL,
      0,
      3.554585,
      3.453500,
      3.894948,
      5.424046,
      4,
      1,
      0.663470,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081156,
      0.369548,
      0.101949,
      0,
      1.553356,
      NULL,
      NULL,
      3.551755,
      NULL,
      0.971342,
      3,
      2.121506,
      3,
      NULL,
      0.856899,
      7,
      1,
      2.112531,
      4.089612,
      NULL,
      NULL,
      3,
      4,
      NULL,
      2,
      3,
      NULL,
      0.549298,
      2,
      3,
      3.155791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.765542,
      1.491214,
      NULL,
      2,
      3,
      1,
      0,
      2.359348,
      0.985106,
      0,
      3,
      3,
      3.724573,
      NULL,
      4.387994,
      1.666124,
      3,
      0,
      NULL,
      0.418194,
      0,
      0.542886,
      0,
      0.052427,
      1.211488,
      4.503868,
      NULL,
      NULL,
      0,
      1.098200,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      NULL,
      3,
      1,
      NULL,
      0,
      0,
      3.057635,
      0,
      3,
      0,
      2.878403,
      NULL,
      1.634913,
      NULL,
      3.713960,
      2.829306,
      1.507624,
      0,
      NULL,
      NULL,
      4.551545,
      2,
      0,
      NULL,
      3.321751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1.653712,
      1.450209,
      0.140002,
      1,
      NULL,
      1.271401,
      1.384200,
      1,
      3.914659,
      5.494103,
      3.331023,
      3.924551,
      1,
      NULL,
      1.039292,
      1,
      NULL,
      0.615776,
      1.367670,
      1.577127,
      1,
      1,
      0.920082,
      0,
      1,
      1.145008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.808958,
      0.902155,
      0.859994,
      NULL,
      1,
      0.992164,
      0.289000,
      0.871814,
      1,
      1,
      0.040645,
      NULL,
      NULL,
      NULL,
      NULL,
      1.147635,
      1.438493,
      0.190955,
      0,
      NULL,
      2.700052,
      2.580888,
      NULL,
      5.615408,
      4.772606,
      NULL,
      2,
      0.637321,
      NULL,
      0,
      1.096136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673759,
      NULL,
      3.611294,
      0.425878,
      2,
      5,
      5.947240,
      6,
      1,
      1,
      4.926556,
      0.159561,
      2,
      1.927346,
      4.572746,
      1.980766,
      6,
      NULL,
      NULL,
      1.592990,
      5,
      7.740555,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.533191,
      3,
      NULL,
      1,
      0,
      3.148581,
      1.158364,
      5,
      NULL,
      2,
      1,
      3.599531,
      2.633347,
      3,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      1.890333,
      NULL,
      2,
      NULL,
      2.176837,
      2.510681,
      5,
      0.680206,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.554335,
      1.837743,
      NULL,
      0,
      1.935688,
      NULL,
      1,
      1.561698,
      0,
      1,
      NULL,
      NULL,
      1.932599,
      0.357564,
      1.330213,
      1,
      0,
      0.140634,
      3,
      NULL,
      0.320166,
      0.363522,
      1.840364,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.224783,
      0,
      4.913984,
      NULL,
      1.653108,
      1.917187,
      NULL,
      NULL,
      1.576854,
      1,
      0,
      1.260107,
      0,
      0.353484,
      0.368656,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.198736,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.278001,
      NULL,
      0,
      1.753026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946370,
      0.008765,
      0,
      0.874120,
      0,
      0,
      0.261141,
      1.663801,
      1,
      1,
      NULL,
      1.652076,
      3,
      3.102786,
      2,
      0.803025,
      0.579527,
      0.316009,
      0.602208,
      1.050449,
      1.685006,
      1.561049,
      1.049195,
      2,
      0,
      1,
      1.215476,
      NULL,
      1.869897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.878771,
      NULL,
      1,
      NULL,
      1,
      1,
      0.366324,
      1,
      1,
      1,
      NULL,
      1.946991,
      NULL,
      0.894518,
      1,
      NULL,
      1.852625,
      1.267542,
      0.981201,
      0.540280,
      0.912373,
      0.477718,
      1.386469,
      0,
      0.635452,
      1,
      1,
      1,
      1.669972,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.475803,
      NULL,
      0,
      NULL,
      0,
      3.076812,
      NULL,
      2,
      NULL,
      2,
      1.968444,
      2,
      2.484085,
      3.928757,
      2.878405,
      1,
      0,
      0,
      1,
      0.341157,
      0.367629,
      NULL,
      2,
      3,
      NULL,
      5,
      1.654479,
      1.223902,
      1,
      1.820315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      5,
      2,
      3,
      1,
      NULL,
      5,
      2.862428,
      2,
      NULL,
      3,
      2.194452,
      2,
      1,
      NULL,
      0.055167,
      1.365912,
      3.663835,
      NULL,
      3.708918,
      NULL,
      4.900320,
      7,
      NULL,
      2.137595,
      3.799970,
      0,
      1.830765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619263,
      3,
      2,
      3.951613,
      1,
      0.303181,
      3.450178,
      3.346495,
      0.065103,
      NULL,
      0.346639,
      9,
      2.119330,
      5.298083,
      3.045906,
      NULL,
      2.046601,
      5.057147,
      NULL,
      1.852524,
      0.644693,
      0.773164,
      2,
      NULL,
      9.883435,
      6,
      2,
      0,
      5.428418,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714467,
      0,
      1,
      0,
      1.057132,
      NULL,
      5,
      5,
      5,
      5,
      5,
      3.460946,
      3,
      NULL,
      4,
      NULL,
      0.604965,
      3,
      4,
      2.052082,
      4,
      4,
      1.017589,
      5.926236,
      1.090473,
      5.982726,
      3,
      2,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063078,
      0.867608,
      NULL,
      NULL,
      0.567442,
      1.026033,
      1,
      0,
      1.950996,
      NULL,
      0.258578,
      1,
      1,
      NULL,
      1,
      1.524782,
      1.371430,
      0.352282,
      1.512278,
      1,
      NULL,
      1.868745,
      0,
      0.518528,
      1.608282,
      0.584902,
      0.628840,
      NULL,
      0.690795,
      1,
      1.688755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.327480,
      2,
      NULL,
      NULL,
      1.366442,
      3.786144,
      1.029810,
      0,
      0,
      2,
      3,
      3.147574,
      NULL,
      1.006163,
      2.806247,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1.338582,
      2,
      1,
      4,
      0.571378,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      4,
      6,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      5,
      4,
      0,
      1,
      5,
      NULL,
      NULL,
      3,
      5,
      2,
      5,
      2,
      3,
      3,
      NULL,
      7,
      7,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      6,
      4,
      0,
      3,
      0,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      2,
      NULL,
      4,
      3,
      7,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0,
      2,
      NULL,
      3,
      0,
      4,
      0,
      NULL,
      1,
      0,
      5,
      NULL,
      NULL,
      2,
      4,
      7,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-25-2000',
      NULL,
      ' 8-20-1984',
      ' 8- 5-1980',
      ' 8-28-1976',
      ' 7- 3-1979',
      ' 8-15-1989',
      '11-20-1977',
      ' 2- 7-1978',
      NULL,
      ' 7-10-1989',
      ' 2- 6-1980',
      ' 2- 3-1988',
      ' 7-19-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-14-1982',
      NULL,
      ' 1-17-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900834);
commit;
end;
/


