set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501739';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      '2400310',
      0,
      3,
      3,
      '44003',
      NULL,
      ' 9- 0-1974',
      13,
      NULL,
      1,
      1,
      3,
      NULL,
      1.639552,
      1,
      1.354500,
      1.820624,
      3,
      2.807239,
      1,
      4,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.696465,
      5,
      3,
      0.673381,
      NULL,
      7.441410,
      2.578571,
      1.217301,
      2.768050,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      5,
      NULL,
      5,
      4.250295,
      6,
      NULL,
      4,
      1.867059,
      0,
      NULL,
      0,
      1,
      1,
      2.983188,
      NULL,
      NULL,
      6,
      4,
      4,
      4,
      7,
      6.095475,
      NULL,
      3.789765,
      NULL,
      '11- 0-1992',
      20,
      0,
      NULL,
      3,
      0,
      0,
      5.218322,
      1,
      16,
      188,
      243,
      2.328200,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      58.159202,
      1,
      3,
      217,
      10,
      1,
      2.440627,
      41.237947,
      46,
      2,
      0.223641,
      219,
      NULL,
      1,
      3.807424,
      56,
      NULL,
      3,
      6,
      158,
      28,
      2.586415,
      9.024113,
      61,
      27,
      NULL,
      1.943275,
      318,
      12,
      3,
      2.323600,
      NULL,
      97.897678,
      2.969962,
      9,
      NULL,
      45,
      3,
      2.478223,
      1204.266230,
      17.482268,
      1,
      6,
      117,
      NULL,
      3.260810,
      7.137081,
      450.096895,
      21,
      2.637947,
      2.653555,
      34.869977,
      2.275009,
      2,
      2.129755,
      30.633001,
      NULL,
      0,
      3.502647,
      305,
      NULL,
      1,
      NULL,
      593,
      1221,
      2,
      2.202367,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02430',
      '',
      '',
      NULL,
      '',
      NULL,
      1.007103,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      3.142693,
      2155,
      1.477638,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.883418,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.744310,
      NULL,
      0.296562,
      NULL,
      '11- 4-1997',
      11,
      9.392708,
      7.035849,
      13,
      NULL,
      6,
      8.363454,
      11.000965,
      2,
      12,
      5.604633,
      4,
      2,
      10,
      6,
      NULL,
      15.611349,
      13.743646,
      NULL,
      NULL,
      NULL,
      4,
      11,
      1,
      18.382572,
      11,
      7.047970,
      15.903166,
      NULL,
      2.173312,
      3.328765,
      NULL,
      3.473183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      13.681852,
      13.175189,
      2.325390,
      5,
      NULL,
      3.879099,
      2,
      21.032119,
      0.771088,
      8,
      NULL,
      0,
      20,
      19,
      0,
      6,
      4.540828,
      2.801670,
      1,
      NULL,
      1.996104,
      3.927556,
      8.138075,
      1.175200,
      29,
      55.757302,
      2,
      1.606896,
      21.123893,
      25.731325,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28.751303,
      NULL,
      NULL,
      116.051919,
      38,
      122.994661,
      90,
      51.276470,
      100.943240,
      95,
      NULL,
      18,
      NULL,
      53.888662,
      37.068343,
      60.880612,
      36,
      NULL,
      118.041223,
      104,
      56,
      109.449707,
      140.610090,
      146,
      NULL,
      184.607491,
      123.989326,
      184.111134,
      62,
      NULL,
      26,
      59.337498,
      170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.998105,
      0,
      NULL,
      2,
      0,
      1,
      NULL,
      8,
      5,
      4.029537,
      6,
      1,
      7.860721,
      9,
      5,
      0.362808,
      6.035555,
      3,
      1,
      3.396507,
      1,
      4.525399,
      9,
      NULL,
      4.747926,
      3.176729,
      4,
      NULL,
      1.456423,
      3.006334,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549842,
      7,
      0,
      NULL,
      0.338919,
      NULL,
      0.557511,
      4.934952,
      2.818629,
      1,
      NULL,
      1,
      0,
      4.255958,
      NULL,
      0,
      7,
      5.671753,
      1,
      NULL,
      NULL,
      3.316151,
      7.900486,
      4.064220,
      NULL,
      6,
      2.129840,
      5.567911,
      NULL,
      1.247846,
      7,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.998752,
      0.706552,
      NULL,
      1.171175,
      2.278701,
      1.992471,
      0,
      5.499815,
      NULL,
      1,
      0,
      5.698653,
      NULL,
      3,
      NULL,
      0.461654,
      NULL,
      3,
      0.510782,
      7,
      3.161736,
      NULL,
      1,
      4,
      0.005295,
      5.066975,
      0.321180,
      0,
      5.865673,
      2.661136,
      1.099004,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.824877,
      0.143896,
      0.613995,
      NULL,
      NULL,
      NULL,
      5,
      3,
      0,
      0.306956,
      NULL,
      2,
      1,
      7.134799,
      1,
      3,
      3,
      3.101289,
      3,
      NULL,
      NULL,
      4.574393,
      3,
      1.783263,
      1.102585,
      4,
      NULL,
      1.594328,
      NULL,
      NULL,
      2,
      1.481008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427994,
      NULL,
      1.089130,
      1,
      0,
      NULL,
      0,
      0.016595,
      2,
      2.455650,
      NULL,
      3.812257,
      2,
      3,
      4,
      1.152863,
      NULL,
      2.020663,
      2.719208,
      2,
      0,
      0,
      0,
      5,
      1,
      NULL,
      NULL,
      4.224320,
      4,
      NULL,
      4,
      2.658943,
      0.638743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.917134,
      0,
      1.165723,
      1,
      0,
      0.520168,
      0.970558,
      NULL,
      0.270507,
      NULL,
      3,
      4,
      3.309184,
      1.345676,
      NULL,
      3.867445,
      1,
      2.737773,
      0.032441,
      NULL,
      4.318324,
      3.802356,
      3,
      NULL,
      0,
      5,
      1.289109,
      NULL,
      NULL,
      2.064048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754436,
      1.580950,
      1.782960,
      0.516350,
      0.026524,
      1,
      0,
      NULL,
      0.457151,
      NULL,
      1.520773,
      0.575530,
      1.778843,
      1.281685,
      0,
      1.881612,
      NULL,
      2.389345,
      NULL,
      2,
      NULL,
      1.702961,
      1,
      0.871803,
      2,
      2.006313,
      0.498300,
      0.092408,
      0.853715,
      1.930926,
      5,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464999,
      0,
      NULL,
      3.619716,
      1.076989,
      3,
      NULL,
      2,
      0.107135,
      4.940744,
      4,
      2.401921,
      NULL,
      2,
      3,
      1,
      4.635363,
      4,
      3.776778,
      2,
      0,
      0,
      2,
      0,
      3,
      2.878512,
      NULL,
      5,
      0,
      0,
      1.492219,
      1.650676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140076,
      0.907658,
      0,
      1,
      0.037169,
      0,
      0.121803,
      0.576441,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.387569,
      1.930962,
      0.671229,
      1.018024,
      9.454273,
      3,
      4.399467,
      4.267387,
      3,
      2,
      4,
      3.591790,
      5.299595,
      3,
      NULL,
      NULL,
      4.701529,
      NULL,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682976,
      4.140881,
      NULL,
      0.557064,
      NULL,
      6,
      3,
      3.668131,
      6,
      NULL,
      5.559059,
      1,
      2,
      0,
      0.390389,
      0,
      NULL,
      2.766296,
      3.663570,
      4,
      NULL,
      3,
      3,
      6.518532,
      1.677758,
      2,
      NULL,
      2,
      NULL,
      3,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494261,
      0,
      0.210300,
      1,
      0,
      1.419650,
      NULL,
      NULL,
      0.395575,
      NULL,
      1.908084,
      1,
      1.884128,
      NULL,
      1.212268,
      0,
      0.418257,
      0.322876,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      1.446219,
      0,
      NULL,
      NULL,
      0.679871,
      1.276729,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.552716,
      0,
      1.746756,
      1,
      0,
      NULL,
      0,
      1.237939,
      1.294064,
      1,
      0,
      0,
      NULL,
      NULL,
      1.087151,
      1.790031,
      0.709014,
      1,
      1,
      1,
      1.979436,
      NULL,
      1,
      1.633186,
      0.796996,
      0.599740,
      0.561047,
      1,
      1.347447,
      0.627613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.435433,
      1,
      NULL,
      0,
      1.394827,
      0,
      1.007769,
      1,
      1.788097,
      0.335046,
      1.488575,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.821101,
      NULL,
      0,
      0.844365,
      NULL,
      1.048230,
      NULL,
      0.371975,
      0,
      0,
      NULL,
      0.576111,
      1,
      0.335266,
      1.407142,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.370785,
      4,
      6.868120,
      NULL,
      4.472501,
      3,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      3,
      7,
      6,
      0,
      NULL,
      NULL,
      NULL,
      4,
      5.822797,
      NULL,
      2,
      8.630088,
      1,
      3.800680,
      3,
      4,
      NULL,
      NULL,
      3,
      6.767350,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      3.717734,
      0.082201,
      3.738968,
      1,
      4.732303,
      2,
      NULL,
      NULL,
      1,
      0,
      5.300193,
      7,
      1,
      1.643425,
      7,
      NULL,
      0,
      1.783204,
      1,
      2,
      3.974894,
      5.561693,
      3.753277,
      NULL,
      5,
      4.762624,
      4,
      2,
      2.466481,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.445964,
      1,
      1.010231,
      NULL,
      0.774346,
      0,
      0,
      1.686257,
      NULL,
      1,
      1.094146,
      NULL,
      1,
      1,
      0,
      1,
      0.626133,
      0,
      1.857041,
      1.034333,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.421538,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.871220,
      0.388441,
      0.625730,
      0.062869,
      0,
      0.445077,
      1,
      NULL,
      0,
      1.645952,
      1.001091,
      0,
      1,
      1.687848,
      1.096459,
      1.514478,
      1,
      0,
      0,
      0,
      0.570086,
      1,
      1,
      1.628377,
      NULL,
      1.331396,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      1,
      0,
      2,
      NULL,
      NULL,
      3,
      3,
      4,
      1,
      1,
      NULL,
      5,
      0,
      4,
      2,
      3,
      1,
      0,
      1,
      0,
      2,
      0,
      0,
      3,
      NULL,
      3,
      5,
      2,
      3,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.755253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-20-1985',
      NULL,
      ' 5- 9-1975',
      ' 6-24-1981',
      ' 2-15-1998',
      NULL,
      ' 8-22-2001',
      ' 9-13-1975',
      ' 0-18-1991',
      ' 5-27-1980',
      ' 3- 2-1984',
      ' 7-14-2003',
      ' 5-22-1988',
      ' 4- 4-2002',
      ' 4-11-1997',
      NULL,
      ' 9-20-2001',
      ' 6-19-1991',
      NULL,
      ' 7-13-1996',
      ' 1- 2-1997',
      ' 0- 8-1994',
      ' 7-25-1979',
      ' 7-14-1989',
      NULL,
      ' 1- 3-1989',
      ' 1-29-2000',
      ' 8-24-1999',
      ' 7- 5-1998',
      NULL,
      ' 5-19-1991',
      ' 2- 1-1986',
      NULL,
      ' 5-25-1991',
      ' 8-27-1987',
      ' 1- 1-1996',
      ' 6-27-1983',
      ' 4-23-2000',
      ' 7- 3-1988',
      ' 8-29-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309433);
commit;
end;
/


