set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007923';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '4112403',
      2,
      1.816480,
      3,
      NULL,
      3.208657,
      '11-26-1982',
      54,
      NULL,
      1.152899,
      3,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      2,
      2,
      0.399276,
      2,
      NULL,
      NULL,
      0.341262,
      2.799749,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      6.420017,
      1,
      1,
      NULL,
      NULL,
      7,
      1,
      7,
      5,
      1,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1,
      4,
      3,
      0,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3.717029,
      5,
      11.773251,
      2,
      7,
      9,
      9.302738,
      1,
      11.720255,
      102,
      ' 3-22-1998',
      109.676032,
      NULL,
      NULL,
      3,
      6,
      1,
      NULL,
      6,
      NULL,
      754,
      13525.055691,
      NULL,
      0,
      NULL,
      48,
      3,
      NULL,
      4.257138,
      NULL,
      1,
      3,
      112.657450,
      0.360972,
      3,
      1.590348,
      216.149118,
      5.307439,
      3.382640,
      0.717797,
      128,
      196.445415,
      NULL,
      0.640290,
      179.045532,
      1,
      NULL,
      2,
      189.245685,
      158,
      3.955294,
      NULL,
      75,
      0,
      1.399363,
      2,
      205.110731,
      66.820668,
      NULL,
      NULL,
      NULL,
      250.636854,
      1,
      1,
      86.007805,
      3.235626,
      3,
      2.736453,
      82,
      9.990069,
      1.436384,
      NULL,
      96,
      46,
      2.032913,
      1,
      14,
      31,
      0,
      5,
      505.977299,
      NULL,
      1,
      3,
      NULL,
      72.633127,
      NULL,
      9.055701,
      130.866637,
      1,
      NULL,
      7.445246,
      111,
      21.988588,
      3.448435,
      4.944498,
      71,
      NULL,
      NULL,
      1,
      35,
      1,
      1.977460,
      1.061470,
      89.886966,
      6,
      3,
      NULL,
      87.707213,
      12,
      0,
      NULL,
      124.936478,
      NULL,
      2.537758,
      2,
      123.304122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.637051,
      '32030',
      '',
      '',
      NULL,
      '',
      '',
      0,
      '32212',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      0,
      NULL,
      0.101863,
      1769,
      NULL,
      NULL,
      0.534077,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.960297,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 1-15-1985',
      NULL,
      0,
      3.490742,
      0,
      7,
      17,
      NULL,
      4,
      NULL,
      NULL,
      7.888618,
      NULL,
      8.529005,
      11.009621,
      NULL,
      NULL,
      4.495914,
      2.673169,
      9,
      16.207943,
      15.031518,
      13,
      11.953680,
      9.824526,
      0.050829,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593365,
      41,
      15,
      9,
      5.664732,
      54.144839,
      43,
      43,
      7,
      48,
      24,
      28,
      NULL,
      NULL,
      30,
      32,
      7.093659,
      NULL,
      13,
      9.958437,
      1,
      0,
      5.889867,
      NULL,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.906879,
      20,
      NULL,
      109.725799,
      112.942115,
      7.920515,
      101.253259,
      NULL,
      NULL,
      55,
      115.202509,
      26.666156,
      123.189115,
      27,
      92,
      NULL,
      11.895438,
      42,
      160,
      109.899425,
      28,
      170,
      34.770110,
      132,
      138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      7.873227,
      NULL,
      3,
      NULL,
      6.182345,
      7,
      6,
      NULL,
      9.183664,
      5,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.687341,
      NULL,
      NULL,
      6,
      0.470609,
      2,
      9.492047,
      7,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.708086,
      1.773220,
      0,
      NULL,
      1,
      0.684783,
      NULL,
      1.030402,
      0,
      1.731352,
      0.955308,
      0.455683,
      1.161990,
      5,
      0.483388,
      0.055266,
      1,
      1.433234,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.128330,
      NULL,
      1,
      0.028894,
      2.378772,
      5.177408,
      3.289552,
      2.427424,
      4.560922,
      2.862419,
      3,
      3.016845,
      0,
      0.341831,
      1.213065,
      6,
      NULL,
      NULL,
      3.998058,
      NULL,
      0.146269,
      0,
      5.656694,
      6,
      NULL,
      2.962624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.927203,
      2,
      0.018838,
      1,
      NULL,
      1,
      3,
      6.218230,
      2.280193,
      5,
      NULL,
      2.856257,
      1,
      3,
      5,
      NULL,
      1.894678,
      7.879818,
      7,
      7.624813,
      6,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.601979,
      4.612146,
      5,
      6.523032,
      4.717731,
      7,
      3,
      1.247777,
      3.493013,
      7,
      7,
      NULL,
      3.117232,
      7,
      NULL,
      1,
      3,
      NULL,
      2.929914,
      2.397969,
      2.780918,
      2.798274,
      NULL,
      5,
      3,
      2.216843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.010655,
      7.061603,
      7.634417,
      7.676869,
      NULL,
      1,
      3,
      3,
      1,
      NULL,
      8.968379,
      NULL,
      5,
      2.698476,
      0,
      6.267648,
      2.123365,
      2,
      9,
      NULL,
      6,
      8.236517,
      3,
      NULL,
      0.620359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.513996,
      1,
      4,
      0,
      1.212497,
      0.117718,
      NULL,
      4.700833,
      5.737852,
      2,
      2,
      6.037232,
      5,
      5,
      2,
      6,
      5,
      7,
      4.377198,
      1.075706,
      2,
      9,
      7,
      7,
      7.264398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      3.778596,
      6,
      0.082486,
      4.172751,
      1,
      7.974795,
      2,
      NULL,
      3.790786,
      NULL,
      0.302000,
      5.898252,
      2.784385,
      NULL,
      5.283575,
      5.157649,
      4.221359,
      7.827268,
      3,
      7,
      2,
      2,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.360140,
      NULL,
      NULL,
      0,
      0,
      2,
      1.468982,
      0,
      0.766319,
      1,
      NULL,
      0.514630,
      1.258958,
      3,
      1.316937,
      0.319674,
      0.869144,
      1,
      NULL,
      4,
      1.160050,
      7.551363,
      1.642597,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1.895918,
      1,
      1.418597,
      1.827285,
      0.658077,
      NULL,
      1.676994,
      0,
      0.842432,
      0,
      0,
      NULL,
      0.987403,
      0.461951,
      NULL,
      0.658353,
      0,
      0.211269,
      1.496973,
      2.093916,
      0.252094,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.698843,
      0,
      0,
      1,
      3,
      2,
      0.728055,
      1,
      NULL,
      0.661836,
      0,
      NULL,
      NULL,
      0,
      0.220291,
      2,
      1,
      1,
      1.748290,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.933432,
      0.458267,
      0,
      1.591073,
      1.634475,
      1,
      0.388744,
      NULL,
      5,
      0.561604,
      0,
      1.193203,
      0.330521,
      1,
      1.394233,
      0,
      1,
      0.570470,
      1.245419,
      NULL,
      0,
      1,
      1,
      1.932860,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.129943,
      NULL,
      3,
      NULL,
      2.870044,
      3.719823,
      NULL,
      1,
      3.494863,
      3.284964,
      1.650541,
      2.318631,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      3.655814,
      0.507719,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.588767,
      2,
      0,
      4,
      1,
      7.498226,
      2,
      8,
      7.415183,
      NULL,
      8,
      4,
      6.030782,
      3,
      3,
      2.519622,
      1.287565,
      1.585883,
      6,
      7,
      7,
      6.504312,
      1.461059,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.148218,
      1,
      NULL,
      2,
      7,
      1.657767,
      1,
      8.726011,
      9,
      7.978690,
      0,
      4.585493,
      0,
      1,
      0.377211,
      0,
      4,
      2.399887,
      4.156778,
      0.361634,
      7.778033,
      5,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.084451,
      0.047229,
      0,
      0.958692,
      0,
      2.994208,
      3,
      1.084488,
      2,
      2.981449,
      NULL,
      0,
      1.764244,
      1,
      2,
      1.711972,
      2,
      1,
      2,
      3,
      2.872387,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616045,
      0,
      NULL,
      0,
      0.632170,
      NULL,
      0.551329,
      NULL,
      0.520920,
      5,
      1.577568,
      1.590142,
      NULL,
      0.867061,
      0,
      0,
      1.142993,
      2.040804,
      0,
      3,
      1.993583,
      0,
      NULL,
      0.094857,
      0.826763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4,
      1,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      1,
      2,
      5,
      1,
      2,
      2,
      1,
      1,
      NULL,
      1,
      0,
      3,
      0,
      3,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-28-1983',
      ' 6- 3-1993',
      '11-24-1993',
      ' 8-22-1990',
      ' 5- 0-2001',
      ' 6- 5-1982',
      ' 7-24-1987',
      ' 5- 2-1980',
      '11-12-1975',
      ' 7-23-1983',
      NULL,
      ' 6-18-1992',
      ' 7-24-1983',
      ' 0- 2-1987',
      '11-23-1982',
      NULL,
      '10-18-1989',
      NULL,
      ' 2- 4-1988',
      ' 0-12-1985',
      '11- 0-1992',
      ' 9-18-1995',
      ' 0-18-1985',
      ' 7-11-1988',
      ' 9- 6-1992',
      ' 3-15-1990',
      NULL,
      '10-28-1995',
      '11- 7-1995',
      NULL,
      ' 0- 8-1975',
      ' 5-13-1987',
      ' 7- 8-2002',
      '11- 5-1985',
      ' 2- 2-1982',
      NULL,
      NULL,
      ' 4- 6-1979',
      ' 2- 0-1990',
      NULL,
      ' 8- 1-1999',
      NULL,
      NULL,
      '11-17-1980',
      ' 7-13-1985',
      ' 2- 5-1983',
      ' 4-20-1976',
      NULL,
      ' 9- 5-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-27-2002',
      ' 8- 5-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


