set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9970404';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '022',
      '32143422',
      29,
      46,
      '0123001',
      2,
      0.394590,
      2,
      NULL,
      0,
      ' 5-17-2001',
      NULL,
      NULL,
      1.867523,
      0,
      NULL,
      NULL,
      1,
      0.759784,
      1,
      2.212443,
      3,
      1,
      0.614781,
      3,
      NULL,
      NULL,
      0.599437,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.928103,
      0.468607,
      2.008742,
      NULL,
      NULL,
      0,
      1,
      4,
      6,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.946814,
      1,
      6,
      0,
      1,
      0.103331,
      1,
      NULL,
      3,
      3,
      NULL,
      1.582122,
      5,
      0,
      3,
      5,
      4.285068,
      2,
      5.190358,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      10.866794,
      5,
      1.680212,
      3,
      15.746462,
      53,
      3,
      7,
      169,
      108,
      3,
      NULL,
      208.869690,
      163.564158,
      1,
      NULL,
      NULL,
      123,
      1,
      4.346414,
      38,
      NULL,
      NULL,
      5.182907,
      21,
      NULL,
      3,
      0.210482,
      NULL,
      18.143378,
      3.434360,
      1.049163,
      NULL,
      NULL,
      2,
      2,
      29,
      2.989353,
      3,
      2,
      118.731155,
      1.617847,
      2,
      2.620584,
      NULL,
      456,
      1,
      0.921832,
      34.408062,
      38,
      NULL,
      1,
      445,
      46.463240,
      NULL,
      3,
      63.323796,
      274,
      0,
      0,
      252.439311,
      5.857271,
      0,
      2.023942,
      86,
      564.829480,
      1.173369,
      NULL,
      146.048558,
      NULL,
      2.355701,
      NULL,
      NULL,
      227,
      NULL,
      1,
      1022.020589,
      7,
      1,
      1,
      209.685689,
      40.560355,
      1,
      3.814914,
      87,
      1,
      0,
      2.201072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '40310',
      '',
      '',
      '',
      NULL,
      NULL,
      0,
      '',
      '',
      NULL,
      3,
      NULL,
      NULL,
      '',
      4,
      1.768282,
      NULL,
      1,
      NULL,
      1.045552,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.449365,
      NULL,
      0,
      NULL,
      1.537166,
      NULL,
      NULL,
      NULL,
      ' 7-16-1996',
      1,
      7,
      8.340885,
      17,
      0,
      2.061807,
      1.492263,
      3,
      5.338070,
      1.049523,
      9,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.193106,
      3,
      NULL,
      NULL,
      7,
      NULL,
      15.656900,
      3,
      10.603987,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      11,
      57.404802,
      1.333286,
      16,
      3.965452,
      10.455259,
      6,
      22,
      NULL,
      3,
      0,
      9,
      35,
      31.391429,
      4,
      10.427951,
      4.723186,
      NULL,
      NULL,
      4.036153,
      16,
      32,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      140.359998,
      133,
      95.861896,
      NULL,
      14,
      113,
      149,
      73,
      NULL,
      48,
      48.814702,
      32,
      47.230695,
      67,
      18,
      44,
      133.519056,
      30.869186,
      87.196437,
      NULL,
      58,
      148,
      141.269211,
      7.775518,
      4.575444,
      3.044536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.090636,
      1.235207,
      5,
      0.877564,
      9.052488,
      NULL,
      6,
      NULL,
      NULL,
      6,
      7,
      NULL,
      2,
      7,
      3.561119,
      0,
      1.572237,
      3.478855,
      1,
      6.375600,
      1,
      7,
      0,
      NULL,
      5.123524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.678403,
      6,
      3.122166,
      5,
      4.388249,
      5,
      6,
      0,
      NULL,
      4.300020,
      NULL,
      9,
      5,
      NULL,
      5,
      NULL,
      6,
      5.024463,
      4,
      NULL,
      NULL,
      6.657285,
      NULL,
      1.883751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843984,
      1.941424,
      NULL,
      1,
      0.090347,
      3.857774,
      2.095275,
      3.341687,
      0.736301,
      2,
      NULL,
      2,
      1.943525,
      NULL,
      3.494004,
      2.347853,
      0,
      5.465665,
      4.078288,
      5.308296,
      4,
      3.072965,
      3.112251,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952422,
      1,
      1,
      0,
      0.159334,
      2.571229,
      NULL,
      1,
      0.036431,
      1.586104,
      NULL,
      1,
      3.505492,
      NULL,
      NULL,
      1.944739,
      2,
      2,
      0.675959,
      0,
      2.327192,
      3.701053,
      2.302152,
      3.801875,
      2.325925,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.948484,
      0,
      1,
      0,
      NULL,
      1,
      1.369380,
      1.641030,
      2.301974,
      2,
      2.638337,
      0.916535,
      3.378893,
      4,
      NULL,
      5.239673,
      4.736410,
      1,
      4.774034,
      4,
      NULL,
      3.816186,
      1.901744,
      2.481595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.927806,
      0.634567,
      NULL,
      1.512693,
      1.557640,
      1.157882,
      1,
      3,
      5.241916,
      1.866290,
      5.248717,
      4.978380,
      NULL,
      NULL,
      NULL,
      2,
      2.293072,
      NULL,
      2.524077,
      0,
      7,
      7,
      6.267251,
      3.813895,
      6.759845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823701,
      1.414213,
      1.785652,
      1.994202,
      1,
      1.044577,
      4,
      5,
      4,
      0,
      2.757855,
      4,
      2.570981,
      5,
      3.974223,
      7,
      0.750405,
      1,
      1.793372,
      4,
      5,
      NULL,
      6.679641,
      2.909413,
      2.913846,
      5.861015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.761982,
      NULL,
      1.680540,
      0.778990,
      2,
      2,
      0.234930,
      5,
      1.713569,
      0.289595,
      5,
      4.273413,
      2.911138,
      7.534562,
      3,
      3,
      NULL,
      5,
      6.561040,
      4,
      7.278213,
      6.302330,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.919554,
      0.315870,
      1,
      0.389903,
      1.888403,
      1,
      1,
      0.520501,
      NULL,
      1.968327,
      0,
      1,
      1.238265,
      NULL,
      1.558031,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302139,
      NULL,
      NULL,
      0,
      0,
      1.588276,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.111213,
      1,
      1.898606,
      NULL,
      NULL,
      1,
      0.372447,
      1,
      0,
      1.148680,
      NULL,
      0.761673,
      1.712550,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866699,
      0.207004,
      0,
      1,
      0,
      0,
      0,
      1,
      0.370713,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      0.578476,
      NULL,
      1.627829,
      NULL,
      0.106780,
      0,
      NULL,
      1.789323,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.444453,
      0,
      0.891557,
      NULL,
      0.179900,
      0,
      1.938488,
      0.003867,
      NULL,
      0.559432,
      1.730504,
      NULL,
      1,
      0,
      0,
      0.652264,
      NULL,
      1.829317,
      1.467292,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.410931,
      NULL,
      NULL,
      NULL,
      3.812290,
      1.381605,
      5.408930,
      2,
      2.556159,
      NULL,
      3,
      NULL,
      3.586622,
      3,
      4,
      5.987158,
      1,
      4,
      1,
      5,
      1,
      5.927679,
      NULL,
      NULL,
      1.087792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125830,
      1.345976,
      0,
      NULL,
      7,
      1.553562,
      9.099019,
      1.033372,
      0.368297,
      0,
      NULL,
      6,
      NULL,
      1.981689,
      0.545356,
      3.960094,
      2.119102,
      NULL,
      6,
      5.015482,
      0.534024,
      4,
      3,
      10.004845,
      5.734026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.970352,
      1.721507,
      NULL,
      0,
      2,
      2,
      1.341608,
      5,
      0.566120,
      2,
      NULL,
      0,
      NULL,
      5,
      0.460407,
      3.382393,
      6,
      4,
      3,
      1.255079,
      NULL,
      0,
      6,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.177098,
      0.473586,
      1.719808,
      NULL,
      1,
      1,
      0.930563,
      0.801747,
      0.975345,
      NULL,
      0,
      1,
      0,
      NULL,
      1.990676,
      1,
      1.126847,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0.705454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.892434,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.529278,
      NULL,
      0.939675,
      0.257785,
      1.760762,
      NULL,
      0.781566,
      0,
      NULL,
      0,
      0,
      1.568546,
      0,
      1.663800,
      1,
      1.269424,
      NULL,
      1.792473,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      3,
      3,
      NULL,
      3,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      2,
      1,
      0,
      1,
      3,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      0,
      0,
      1,
      1,
      2,
      3,
      5,
      1,
      NULL,
      2,
      3,
      0,
      1,
      1,
      4,
      0,
      5,
      0,
      NULL,
      2,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-17-1991',
      NULL,
      ' 5- 6-1990',
      ' 9- 8-1993',
      ' 1-15-1980',
      NULL,
      ' 5-17-1992',
      ' 7-28-1992',
      ' 0- 6-2002',
      '10-20-1996',
      '10-21-1994',
      ' 7-15-2003',
      ' 0- 3-1983',
      ' 3-24-1976',
      ' 2-14-1992',
      ' 7-21-1993',
      ' 2- 7-1990',
      '11- 2-2003',
      ' 9- 2-1993',
      ' 2-28-1989',
      ' 1-26-1996',
      ' 4- 7-1978',
      ' 8-16-1992',
      ' 2-23-2000',
      ' 2-24-1985',
      ' 5- 3-1984',
      ' 0-16-1981',
      ' 6-24-1976',
      '11- 8-1976',
      '11- 7-2000',
      NULL,
      NULL,
      ' 9- 3-1985',
      ' 1-24-1979',
      ' 3- 7-1974',
      ' 0-18-1980',
      ' 7- 5-1979',
      ' 6-19-1992',
      ' 0- 5-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 7-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.558251);
commit;
end;
/


