set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8102496';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      NULL,
      NULL,
      '0313330',
      2,
      2.304051,
      3,
      '03000',
      3.578103,
      '10- 2-1991',
      186,
      NULL,
      NULL,
      2,
      NULL,
      1.497813,
      0.897499,
      NULL,
      0.595884,
      0.349046,
      1,
      NULL,
      1.062086,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      7.651410,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      13,
      4,
      2,
      1,
      NULL,
      NULL,
      1.057840,
      1,
      3,
      1,
      3,
      NULL,
      1.691340,
      4,
      2.368864,
      1,
      1,
      2,
      6.824270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.253854,
      2.000781,
      3,
      0,
      4,
      1,
      NULL,
      58.305913,
      118,
      49.543319,
      0,
      NULL,
      182,
      NULL,
      1.403738,
      0.184737,
      41.138997,
      59.887009,
      1.105176,
      2,
      NULL,
      17,
      0.180599,
      NULL,
      44,
      14551.298584,
      4.182400,
      1.867702,
      NULL,
      15998.418272,
      3,
      NULL,
      109.773446,
      5048.981922,
      3.964317,
      1,
      219.726284,
      NULL,
      NULL,
      0.633500,
      107,
      84,
      1,
      1,
      196.785915,
      3911.016339,
      0,
      NULL,
      124.610639,
      37,
      1,
      1.874294,
      134.372559,
      NULL,
      NULL,
      3,
      145.990176,
      9217,
      2.829382,
      1.192170,
      55.833597,
      21,
      1.954372,
      NULL,
      NULL,
      1548.984133,
      NULL,
      0.981046,
      NULL,
      4,
      NULL,
      3.322968,
      NULL,
      NULL,
      0.459499,
      0.732252,
      71.936689,
      15.642370,
      3,
      0,
      212,
      156.022697,
      0.933157,
      NULL,
      198.076815,
      NULL,
      1,
      0,
      109.072874,
      64,
      3,
      7,
      56,
      92,
      NULL,
      7,
      8,
      241,
      NULL,
      7,
      165.986459,
      684,
      1,
      1.717343,
      93.450113,
      2,
      2,
      NULL,
      356.901602,
      40,
      0,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      32,
      3.298534,
      3,
      1161.808423,
      19.588903,
      0,
      0,
      1237,
      NULL,
      0.762027,
      3,
      1275,
      336.357642,
      1,
      1.232989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '23130',
      '',
      '',
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      1701,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.755253,
      NULL,
      0,
      NULL,
      1.099079,
      NULL,
      NULL,
      NULL,
      ' 7-15-1994',
      18,
      5.082254,
      NULL,
      NULL,
      4.649481,
      5.490303,
      6,
      23,
      25.342959,
      0,
      6,
      13,
      5.647359,
      7,
      3,
      0.480642,
      6.637205,
      0,
      0,
      1,
      0.159783,
      3.456031,
      5.881062,
      12.174198,
      3,
      7.248319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31.913492,
      3,
      4.767842,
      16.431727,
      5,
      6.771373,
      NULL,
      1.002881,
      5.943755,
      17,
      2.343930,
      0.108856,
      3,
      NULL,
      1.622247,
      25.390497,
      NULL,
      NULL,
      NULL,
      13.004996,
      18,
      10,
      7.653383,
      23.438575,
      4.787906,
      27,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      68,
      121,
      82,
      32,
      NULL,
      81,
      42.286414,
      1.835349,
      30,
      132,
      36.002630,
      119,
      93.330535,
      NULL,
      73,
      NULL,
      NULL,
      NULL,
      79,
      96,
      103.532211,
      NULL,
      185.269891,
      133,
      NULL,
      197.915673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.099837,
      10.815872,
      2,
      6,
      7.613726,
      4.939783,
      0,
      1,
      5.012219,
      8,
      0.090559,
      NULL,
      0,
      8.773350,
      1.713201,
      1.256182,
      5.010223,
      9,
      3.417036,
      NULL,
      1,
      4.571910,
      7.031906,
      5.626987,
      5.788690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.063343,
      3.849170,
      NULL,
      NULL,
      7,
      0,
      5,
      0.850834,
      7.864182,
      2.358036,
      5,
      6.230758,
      8,
      11,
      0.932623,
      2,
      NULL,
      4,
      1.397023,
      2,
      4,
      7.555028,
      5,
      9.288908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.352835,
      6.050601,
      3.868896,
      3.584021,
      1.398885,
      2.884889,
      1.260128,
      0.373787,
      0,
      NULL,
      5.301079,
      3,
      NULL,
      0,
      1.469201,
      3,
      NULL,
      5.520551,
      5.777272,
      2,
      5,
      5,
      4.191812,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.241800,
      0,
      6,
      2,
      7.265449,
      0,
      6,
      2.687946,
      2.992314,
      3,
      2.944961,
      0,
      7,
      0.027037,
      7,
      3.362186,
      1,
      1,
      4,
      3.319299,
      1,
      2,
      2.226169,
      0.868143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.840083,
      NULL,
      1,
      NULL,
      4.459656,
      4.483305,
      7,
      2,
      2.564157,
      NULL,
      5,
      7,
      7,
      3,
      4.965390,
      2,
      0.327849,
      6.748280,
      3.552286,
      4,
      1,
      0.414499,
      NULL,
      7.905872,
      4.702562,
      3.528202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.031234,
      3,
      1,
      7.777558,
      5,
      7.830052,
      6,
      6,
      5,
      11.891031,
      4,
      9.762434,
      NULL,
      NULL,
      9.790388,
      4,
      8.507337,
      NULL,
      9,
      7.976737,
      7.210231,
      5.438379,
      7.161994,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345453,
      7.308620,
      7.747140,
      1.211979,
      2.749514,
      10.160094,
      9.403857,
      10,
      2.100450,
      0,
      7,
      2.250281,
      3.932749,
      0.013285,
      0,
      NULL,
      0.311093,
      10,
      0,
      5,
      NULL,
      NULL,
      NULL,
      4,
      8.513520,
      3.108380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.823271,
      7,
      NULL,
      1.046195,
      1.307234,
      4.079184,
      4,
      7.687479,
      3.765323,
      8,
      3,
      3,
      6.457267,
      3,
      5,
      NULL,
      3.226205,
      10.394490,
      NULL,
      4,
      NULL,
      6.780886,
      1,
      NULL,
      4.105221,
      6.958624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.383447,
      2.591328,
      8.397928,
      1,
      10,
      3,
      6,
      3.726889,
      0.144824,
      5.789316,
      1,
      2,
      3.752055,
      0.278535,
      NULL,
      3,
      NULL,
      1.455537,
      6,
      3.524527,
      0.301421,
      1.487011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325343,
      3.220579,
      NULL,
      2.760100,
      1.133857,
      2.516762,
      3,
      0.414485,
      3.297597,
      2,
      1.348057,
      0.885467,
      2,
      0.172430,
      1.672540,
      3,
      1,
      NULL,
      2,
      2.297808,
      1.320689,
      2.749581,
      3,
      1.977106,
      NULL,
      3.078421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.965234,
      NULL,
      1.518493,
      0,
      1.680692,
      1,
      1,
      0,
      NULL,
      1.147041,
      1,
      1,
      1,
      0.689200,
      NULL,
      0.717651,
      NULL,
      1,
      0,
      1.485683,
      1.266832,
      0.582891,
      NULL,
      0.835579,
      0.301521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.135662,
      1.580841,
      NULL,
      0,
      1,
      1,
      1,
      2.425827,
      1,
      1,
      2.374452,
      3,
      2.699631,
      3,
      0.873636,
      3.988353,
      0.093900,
      2.641426,
      NULL,
      3,
      2.172121,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.008665,
      0.770366,
      NULL,
      1,
      1,
      NULL,
      1.604692,
      NULL,
      1.674566,
      1,
      1,
      1.221706,
      1,
      NULL,
      0.269768,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0.154307,
      0.893510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      5,
      9,
      5,
      5.393346,
      NULL,
      2,
      3,
      0.490590,
      4,
      4.681724,
      5,
      2,
      0,
      NULL,
      6,
      9.821602,
      0,
      7,
      4.013745,
      7,
      7.655011,
      3.532340,
      1.606775,
      6.393973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365661,
      2.511500,
      4,
      3.728719,
      2.201699,
      1,
      2.191397,
      5.631551,
      0.146834,
      1.819627,
      2,
      0,
      NULL,
      NULL,
      3,
      NULL,
      8,
      7.647432,
      NULL,
      7,
      7,
      8.175346,
      8.845914,
      8.858076,
      1.920118,
      2.573746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414996,
      1.222518,
      1,
      1,
      0.567855,
      1,
      0,
      NULL,
      0,
      0.813539,
      1.456828,
      1.660219,
      0.462220,
      0,
      0,
      0,
      0.293400,
      0,
      1.497060,
      0.556783,
      1,
      1.428732,
      1,
      0.194243,
      0.164689,
      0.497807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.918144,
      0.212895,
      0,
      1,
      1,
      NULL,
      0,
      0.748846,
      0.247499,
      1,
      0,
      0.545237,
      NULL,
      NULL,
      1.214077,
      0.867470,
      0,
      1,
      1,
      0,
      1,
      0.961738,
      1,
      1,
      0,
      1.126297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      2,
      0,
      5,
      0,
      2,
      1,
      2,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      5,
      NULL,
      5,
      1,
      2,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      3,
      1,
      4,
      3,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      4,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.153699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-10-1994',
      ' 8-14-2001',
      NULL,
      ' 3- 4-1983',
      ' 8- 5-1989',
      ' 8- 5-2003',
      ' 2- 2-1992',
      ' 6-15-1982',
      ' 8-21-1986',
      ' 5-14-1993',
      ' 2- 7-1999',
      ' 4- 1-1991',
      NULL,
      ' 1- 2-1998',
      NULL,
      ' 1-23-1984',
      ' 7- 9-1988',
      ' 2- 5-1994',
      NULL,
      ' 0- 5-2002',
      ' 4-18-1996',
      ' 2-20-1997',
      '11-26-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-1981',
      ' 0- 9-1996',
      ' 9-27-1993',
      NULL,
      ' 1-20-1994',
      NULL,
      ' 2-27-1997',
      '11-15-1997',
      ' 9-25-1984',
      NULL,
      ' 7-10-1993',
      '11- 5-1995',
      ' 6-24-1977',
      ' 3-25-1997',
      NULL,
      '10-11-1996',
      NULL,
      '10-10-1976',
      NULL,
      ' 5- 0-1987',
      NULL,
      '11- 1-1991',
      ' 7-26-1985',
      ' 3-29-1986',
      ' 9-15-2003',
      ' 8-10-1999',
      ' 7- 6-1977',
      ' 9-26-1995',
      NULL,
      '10-28-1978',
      NULL,
      ' 3- 5-1982',
      NULL,
      ' 6-13-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-28-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131705);
commit;
end;
/


