set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4810533';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '13131',
      NULL,
      ' 1- 4-1982',
      NULL,
      NULL,
      NULL,
      0,
      2.962844,
      NULL,
      1.727055,
      1.070818,
      0.113181,
      2,
      3,
      1,
      0,
      9,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.718808,
      3.689571,
      1.705168,
      NULL,
      NULL,
      NULL,
      4,
      5,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      2,
      4,
      6,
      5,
      7,
      7,
      NULL,
      7,
      0.431877,
      0,
      1.808634,
      1,
      2,
      0,
      0,
      0,
      NULL,
      9,
      7,
      5,
      4,
      5,
      8.011747,
      0.612707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      7.302201,
      NULL,
      15.509687,
      30.514477,
      8.743694,
      1.185489,
      3,
      18,
      15,
      NULL,
      1.067515,
      60.140287,
      7.695975,
      NULL,
      0.883542,
      149.001974,
      20.403584,
      3.812333,
      1.914812,
      NULL,
      NULL,
      5.280581,
      NULL,
      108.922904,
      24.386514,
      1,
      3,
      NULL,
      139,
      1,
      3,
      122.539276,
      105.551138,
      1.776065,
      NULL,
      NULL,
      NULL,
      1.303187,
      2,
      NULL,
      NULL,
      0.172926,
      3.986435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095639,
      '3040',
      '',
      '',
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      3.989173,
      246.740404,
      2,
      281,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      ' 7-28-1974',
      9,
      5.629493,
      7.516941,
      NULL,
      9,
      11.694467,
      3.893466,
      NULL,
      9,
      9.888619,
      0,
      7.329981,
      2,
      21.967073,
      2,
      8.273140,
      NULL,
      7,
      2.256459,
      20,
      NULL,
      10.625791,
      9,
      5.961714,
      13,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      22.605647,
      2.800564,
      9.694026,
      46,
      0,
      5.589832,
      9.214726,
      4.460499,
      6,
      3,
      NULL,
      11.722510,
      NULL,
      0,
      3.589148,
      13.151091,
      12,
      NULL,
      1.336129,
      10.527703,
      14,
      7.502219,
      7.716182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64.151914,
      NULL,
      74,
      21.621600,
      39,
      NULL,
      144,
      86.731535,
      2.128500,
      NULL,
      41,
      151,
      75.146358,
      110.063289,
      23.924436,
      53,
      NULL,
      52,
      67.247970,
      177.814844,
      101.790046,
      153,
      83.637784,
      76,
      1.521974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.914063,
      1,
      5,
      NULL,
      NULL,
      3.326978,
      5,
      6.107038,
      9,
      2.835651,
      NULL,
      NULL,
      NULL,
      3.789506,
      NULL,
      4.706746,
      0,
      NULL,
      2,
      NULL,
      6,
      5,
      1.456804,
      7.147861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.838401,
      1,
      5,
      6,
      NULL,
      3,
      9,
      5,
      3.683005,
      NULL,
      4.185754,
      6.795463,
      1,
      3.257971,
      4,
      1,
      8,
      5,
      0,
      4.896863,
      6.908557,
      5.462567,
      4.728586,
      NULL,
      8.039541,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.091997,
      7,
      2.364052,
      9.770638,
      NULL,
      0.151836,
      2,
      7,
      3,
      NULL,
      NULL,
      7,
      3.056161,
      3,
      4,
      6.563646,
      5.869230,
      5,
      NULL,
      9.586317,
      5.071373,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      9,
      NULL,
      6,
      4,
      NULL,
      4,
      3.197924,
      0.717518,
      7,
      5.644933,
      NULL,
      5,
      4,
      4,
      0,
      4,
      3.183765,
      4,
      2,
      5,
      1.025217,
      NULL,
      2.438735,
      2.422121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7,
      0.188526,
      NULL,
      0.669778,
      7,
      2.414934,
      7,
      2,
      NULL,
      NULL,
      4.389792,
      2,
      0.156540,
      2.294840,
      6,
      NULL,
      6.247565,
      3,
      5.868632,
      3.091251,
      4.814555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.730740,
      0.467147,
      9.050114,
      NULL,
      NULL,
      2,
      5.821296,
      4,
      NULL,
      3.086634,
      3,
      6,
      6,
      3,
      NULL,
      NULL,
      4.654707,
      4.571856,
      1,
      5.165270,
      4,
      6,
      3,
      6.353098,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      8,
      5,
      1.064843,
      6.208784,
      NULL,
      6.066740,
      4.949915,
      1.735348,
      5.684682,
      9,
      0,
      1.976237,
      4.445503,
      1.631410,
      6,
      3,
      5,
      5.389885,
      7.989154,
      7.853454,
      8.235376,
      8,
      2.953976,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      4.610974,
      5.982781,
      NULL,
      NULL,
      NULL,
      1,
      4.278616,
      4,
      NULL,
      4.342457,
      3.201416,
      3,
      2.308731,
      4,
      1.499040,
      0.987696,
      NULL,
      2.613765,
      NULL,
      2,
      3.590010,
      1.733355,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106818,
      5.133209,
      0,
      2.397150,
      6.097126,
      4.017983,
      NULL,
      NULL,
      2,
      2,
      NULL,
      4,
      6.632814,
      NULL,
      3.224934,
      1.951681,
      6,
      1,
      3.371321,
      NULL,
      2,
      3,
      0.838239,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.395982,
      2.542074,
      3.146210,
      5.252666,
      3,
      5.457806,
      2.299247,
      2.980102,
      NULL,
      4.522402,
      2,
      4.628048,
      NULL,
      5.396529,
      0,
      3.233212,
      3,
      1.986685,
      0,
      4.800552,
      2,
      4.281007,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.641255,
      1,
      3,
      NULL,
      1.384624,
      NULL,
      1.805509,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.754283,
      0.709920,
      NULL,
      1,
      0,
      0,
      NULL,
      1.552275,
      0,
      1.920517,
      0.563092,
      1.281456,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.801152,
      0,
      0.109926,
      0,
      0,
      0.388119,
      1,
      1,
      NULL,
      0.539908,
      1.838431,
      1.832967,
      0,
      1,
      1,
      0.856748,
      1.447323,
      1,
      1.287064,
      0,
      0.190112,
      1,
      0.974051,
      NULL,
      0.465177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.860868,
      1.346516,
      0.723761,
      1.831651,
      NULL,
      0,
      1,
      NULL,
      1.401002,
      0,
      0.887924,
      0,
      NULL,
      0.751874,
      1.003974,
      1.420579,
      NULL,
      NULL,
      1.120967,
      NULL,
      1,
      0.682898,
      NULL,
      1.913246,
      1,
      0.694136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.524533,
      1,
      NULL,
      2,
      6,
      3.538057,
      1,
      0,
      2.454850,
      3.820528,
      1.016661,
      NULL,
      9.992715,
      6,
      9.254406,
      NULL,
      8,
      7,
      4.871237,
      2.834351,
      NULL,
      0,
      1.795961,
      4,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      7.402346,
      3,
      5.857198,
      6,
      4,
      8,
      0,
      NULL,
      3,
      5.286334,
      1.177474,
      6,
      2.297960,
      1,
      7,
      8,
      1,
      NULL,
      0,
      1,
      4,
      3.209349,
      2,
      7.814934,
      8.524345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.966986,
      1,
      0.666094,
      1,
      0.338100,
      1.412270,
      0,
      1.257032,
      0.833272,
      1.352686,
      1.363113,
      0.803062,
      0.965720,
      NULL,
      0,
      NULL,
      1,
      1,
      1.306814,
      NULL,
      NULL,
      NULL,
      NULL,
      0.901381,
      0.184174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.317730,
      1,
      NULL,
      0.544972,
      0,
      0.552864,
      1,
      1,
      NULL,
      1.194775,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      0.562774,
      0.884287,
      0,
      0.635101,
      0.120510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      4,
      1,
      4,
      3,
      5,
      3,
      1,
      3,
      0,
      2,
      2,
      NULL,
      0,
      0,
      1,
      2,
      NULL,
      0,
      2,
      NULL,
      5,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.684809,
      2,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-13-1989',
      ' 1- 6-1978',
      '10-12-1985',
      ' 4- 8-2001',
      ' 3-25-1979',
      NULL,
      ' 9- 8-1983',
      '11-12-1979',
      ' 4-22-2002',
      ' 3-26-1974',
      ' 3-17-2001',
      ' 3- 8-1995',
      ' 1-20-1978',
      ' 2-15-1997',
      ' 3-27-2001',
      NULL,
      NULL,
      ' 5-27-1997',
      ' 5-20-1980',
      ' 5-22-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-25-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731718);
commit;
end;
/


