set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602311';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '122',
      '21302231',
      40,
      49,
      '4043000',
      3,
      NULL,
      2,
      '01442',
      1.638007,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.157821,
      NULL,
      0,
      3,
      2,
      1.515295,
      1,
      7,
      NULL,
      NULL,
      2.154367,
      NULL,
      1,
      1.229440,
      1.990166,
      0,
      0,
      NULL,
      6.159987,
      NULL,
      0.734325,
      4.953099,
      NULL,
      NULL,
      NULL,
      3,
      5,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      5,
      NULL,
      1,
      11,
      2,
      1.952306,
      1,
      0,
      1,
      NULL,
      NULL,
      0.840521,
      0,
      0.768650,
      2,
      3,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.427537,
      4,
      1,
      2,
      NULL,
      1,
      112,
      NULL,
      1.171505,
      2,
      4.734685,
      149,
      30.275672,
      NULL,
      0.392192,
      107.004341,
      NULL,
      1.916406,
      2,
      NULL,
      191,
      1.889993,
      NULL,
      302.903898,
      NULL,
      0.827468,
      3.182384,
      214,
      17,
      3,
      NULL,
      488.208823,
      238.230243,
      3,
      NULL,
      1608,
      594,
      3,
      0.791051,
      90.980689,
      1,
      NULL,
      NULL,
      1309,
      60,
      3.723937,
      NULL,
      475,
      34.780755,
      2.005256,
      0,
      NULL,
      5.896122,
      NULL,
      3,
      176,
      3.767597,
      2,
      2.409366,
      463,
      81.058400,
      1.136203,
      0.562845,
      282,
      14,
      2.462058,
      1.942900,
      NULL,
      22.949551,
      1.759857,
      5.175681,
      397.469107,
      230,
      0,
      NULL,
      NULL,
      24.367255,
      0,
      0,
      176,
      2.823811,
      0.400719,
      2,
      454.175627,
      1,
      2,
      NULL,
      548.051088,
      2,
      1.562061,
      0.387995,
      NULL,
      2.955631,
      1,
      0.344540,
      126.963126,
      89.655614,
      3.503769,
      3,
      111.801004,
      1.851983,
      0.340587,
      3.438999,
      299.446608,
      18,
      3,
      0.195958,
      240.801822,
      29,
      2,
      0,
      NULL,
      4.267006,
      NULL,
      6,
      71.077816,
      51.352814,
      2,
      2,
      189,
      60,
      3.433542,
      1,
      NULL,
      64,
      NULL,
      2,
      NULL,
      102,
      4,
      2,
      141,
      63,
      7.078739,
      NULL,
      51,
      287.084887,
      0.166695,
      NULL,
      564,
      323,
      3,
      1.179428,
      504,
      NULL,
      0.042362,
      3,
      169.929143,
      NULL,
      0.256568,
      NULL,
      216,
      5,
      3,
      NULL,
      1098.215942,
      NULL,
      1.867334,
      3,
      340,
      3,
      1,
      1,
      74,
      436.062295,
      3.023596,
      4.395962,
      NULL,
      608,
      0.785583,
      0.830648,
      515.783906,
      1.179449,
      2.905651,
      2.851187,
      41,
      36,
      NULL,
      2.363657,
      88,
      933,
      0.070254,
      3,
      NULL,
      190,
      3,
      3.255735,
      104,
      411.636169,
      0,
      3,
      NULL,
      380.077102,
      1,
      NULL,
      106,
      547,
      3.725623,
      0.629604,
      87,
      NULL,
      0,
      8.104723,
      5,
      355.259962,
      3.801748,
      5.997014,
      256.714127,
      27,
      3.866854,
      2.937092,
      170.451648,
      441.759203,
      2.404742,
      NULL,
      NULL,
      695,
      3,
      NULL,
      NULL,
      NULL,
      2.382354,
      5.996803,
      48,
      NULL,
      1.654961,
      NULL,
      13.805222,
      13.279749,
      2,
      7.687350,
      196,
      57.752815,
      0.640320,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      18.919380,
      39.705368,
      NULL,
      2.614945,
      NULL,
      3,
      NULL,
      3.842475,
      37.372388,
      14,
      3.107347,
      NULL,
      332,
      7,
      NULL,
      9.532518,
      292,
      28.961039,
      2,
      6,
      74.111077,
      NULL,
      2,
      3.689094,
      1333,
      11.152837,
      3,
      2,
      139.245223,
      NULL,
      2,
      5,
      44,
      234.132805,
      2.710244,
      1,
      857,
      271,
      NULL,
      3.755436,
      755,
      16.869646,
      3,
      1.753234,
      138.299873,
      5,
      1,
      5,
      233,
      29.774339,
      2,
      4.765835,
      234,
      1,
      NULL,
      0.110563,
      176,
      5,
      1.497036,
      3.301680,
      5.458607,
      101.393556,
      0.766166,
      7.202321,
      36.776175,
      109.366751,
      0.406578,
      4.204514,
      NULL,
      80.363375,
      2.138629,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '31420',
      '41031',
      NULL,
      '',
      '',
      1.490718,
      '',
      NULL,
      '',
      3,
      '2420',
      NULL,
      NULL,
      4,
      1.789408,
      NULL,
      2.832028,
      1373.279775,
      0.352746,
      NULL,
      1.026214,
      NULL,
      3,
      1,
      0,
      NULL,
      1.657274,
      88,
      0.872380,
      NULL,
      2.621502,
      NULL,
      1.459494,
      NULL,
      ' 5-11-1984',
      NULL,
      6,
      18,
      5,
      6,
      5,
      1.502380,
      4,
      8,
      9,
      10,
      14,
      1,
      15,
      5,
      2,
      2,
      0.471741,
      6.375339,
      5.621677,
      11.673906,
      2,
      3.825746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.271659,
      27,
      22,
      NULL,
      9,
      0.939083,
      25.740378,
      36,
      51,
      11,
      1,
      10.333586,
      29,
      2.562041,
      NULL,
      NULL,
      4,
      40.163534,
      9.420950,
      27.828240,
      NULL,
      43.396782,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.528174,
      36,
      77.847690,
      29.701244,
      83,
      107.114033,
      112.558963,
      115,
      121.573067,
      NULL,
      74,
      133.829736,
      143,
      114.013416,
      125.500309,
      164,
      17,
      183,
      NULL,
      NULL,
      NULL,
      41,
      2.815780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.010167,
      5,
      NULL,
      NULL,
      NULL,
      4,
      4.241244,
      6.660218,
      6.324301,
      7.599832,
      NULL,
      2.900112,
      4.817713,
      8,
      4.429768,
      2,
      7.790146,
      4,
      2.509419,
      NULL,
      NULL,
      0.851182,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.267251,
      10.395733,
      0.081745,
      9.938997,
      NULL,
      NULL,
      8.468881,
      2.990630,
      2,
      4,
      1,
      7.313041,
      1.589001,
      8,
      NULL,
      1,
      4.897086,
      11.272395,
      4.062164,
      11,
      6.907965,
      5.897154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.211847,
      NULL,
      0.153506,
      0,
      1,
      1.330858,
      1.544980,
      0.122846,
      1,
      2,
      0.433847,
      0,
      1.249522,
      0,
      NULL,
      3.364177,
      5.653283,
      NULL,
      0.177772,
      2,
      4.830138,
      4.785121,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.802178,
      0.662368,
      NULL,
      NULL,
      1.907614,
      0.281910,
      4,
      3.478435,
      0,
      3.796379,
      3,
      2,
      5.124490,
      1.450298,
      0.269022,
      2,
      NULL,
      5.671132,
      4.799995,
      5.199868,
      2.484817,
      2.816859,
      1.191840,
      4.347516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      5,
      4.211786,
      0.199220,
      NULL,
      NULL,
      5,
      2,
      NULL,
      3,
      0.355955,
      0.607291,
      0.925129,
      2.211569,
      4,
      4.521615,
      0,
      4,
      5,
      2.446520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2.290926,
      2.936928,
      NULL,
      0,
      NULL,
      9,
      9,
      7,
      5.945246,
      2,
      6.524168,
      NULL,
      5.826855,
      4.178859,
      NULL,
      3.093425,
      5.154997,
      NULL,
      NULL,
      4,
      8.922853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      3,
      3,
      9,
      2.538709,
      6.779619,
      2,
      5,
      NULL,
      1.708340,
      5,
      4,
      9,
      0,
      8.663456,
      5.819296,
      3.750025,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.538488,
      7.534100,
      5,
      NULL,
      4.731377,
      4.453296,
      NULL,
      8.284686,
      6.370290,
      NULL,
      1.800239,
      9,
      2,
      NULL,
      NULL,
      4,
      1,
      5.830582,
      5,
      0.376122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.698018,
      0.019320,
      0.608004,
      1,
      1,
      0,
      1,
      0,
      1,
      1.346353,
      0,
      0,
      0,
      0.400570,
      0.018248,
      0,
      1.291398,
      NULL,
      1,
      0.447022,
      0,
      0.228541,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.898821,
      0,
      1.344348,
      1,
      NULL,
      0,
      1,
      0.217500,
      0.150388,
      0,
      0.815846,
      1,
      0.683070,
      0.798215,
      0.216931,
      0,
      1.743817,
      1,
      0.868548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.765420,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1.459064,
      NULL,
      NULL,
      1.101921,
      0,
      0.979151,
      1,
      0.029117,
      1.401957,
      1.068336,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.843819,
      3.824637,
      0,
      4,
      0.751135,
      0.409317,
      NULL,
      5.814554,
      0,
      NULL,
      5.070424,
      NULL,
      3.207210,
      NULL,
      4,
      0,
      1,
      2.618353,
      2,
      1,
      1.847483,
      NULL,
      1.524305,
      0.519358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.541454,
      1,
      1,
      0,
      1.646611,
      1,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      9,
      4,
      0,
      3,
      4,
      1.687020,
      1,
      NULL,
      1.448597,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.132331,
      2.152450,
      3.819925,
      9.630004,
      0.687136,
      6.030213,
      5,
      NULL,
      NULL,
      NULL,
      5.675042,
      NULL,
      NULL,
      1.126033,
      NULL,
      7,
      10,
      NULL,
      NULL,
      4.006423,
      NULL,
      NULL,
      0.479050,
      2.082755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.878198,
      5.679737,
      5.516678,
      3.700514,
      0.780918,
      0.480949,
      7,
      NULL,
      8.526781,
      7.896854,
      0.513922,
      3.087322,
      NULL,
      8,
      8,
      8.790223,
      7.335705,
      9.179005,
      0,
      3.211158,
      4,
      3.547391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339048,
      NULL,
      NULL,
      0,
      1.475827,
      1,
      0.416288,
      NULL,
      0,
      0,
      1,
      1.096131,
      NULL,
      0.796378,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.649495,
      1.461948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.469240,
      4,
      0.122467,
      1,
      2.352249,
      1,
      NULL,
      1.576311,
      0,
      2,
      0.880651,
      2.007058,
      1.462444,
      NULL,
      1.836889,
      1,
      4,
      5.675513,
      2,
      1.613666,
      0,
      1.653259,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      3,
      3,
      3,
      0,
      0,
      3,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      1,
      2,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      1,
      1,
      2,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      3,
      2,
      2,
      3,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      2,
      2,
      1,
      4,
      2,
      1,
      3,
      0,
      3,
      NULL,
      3,
      1,
      2,
      1,
      2,
      2,
      2,
      5,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-27-1998',
      ' 7-13-1981',
      ' 7-18-1983',
      ' 5-11-1994',
      ' 1-29-1980',
      ' 5-15-2002',
      ' 7- 4-1995',
      ' 0- 1-1988',
      '11-13-1998',
      ' 4-20-1985',
      ' 9- 1-2003',
      ' 2-25-1984',
      ' 6- 5-1981',
      ' 7-12-1975',
      NULL,
      NULL,
      ' 0- 2-2003',
      ' 9-29-1979',
      ' 8- 5-1988',
      ' 1- 3-1983',
      ' 3-23-1976',
      ' 2-21-2003',
      ' 9- 5-1987',
      ' 2-19-1999',
      NULL,
      NULL,
      ' 3-18-1976',
      ' 8-14-1989',
      NULL,
      ' 7-20-1989',
      ' 1-11-1987',
      ' 5-26-1991',
      ' 0- 8-1996',
      ' 4-17-1993',
      '11-21-1993',
      ' 9-20-1998',
      ' 1-15-1989',
      ' 4-20-1989',
      ' 3-23-1984',
      '11-26-1974',
      '10-26-1999',
      ' 7-12-1984',
      ' 3- 6-1989',
      ' 9-16-1985',
      ' 8-14-2003',
      ' 0- 2-1998',
      ' 5-27-1998',
      ' 1- 4-1993',
      ' 3- 6-2003',
      ' 4-22-1997',
      ' 7- 4-1980',
      ' 8-13-1989',
      ' 5-18-1994',
      ' 1-11-2000',
      ' 1- 2-2002',
      ' 7-22-1988',
      ' 2- 9-1988',
      ' 7- 8-1981',
      ' 5- 5-1983',
      '10-10-1987',
      ' 5- 1-1978',
      NULL,
      ' 4- 1-1990',
      ' 4- 8-1987',
      ' 2-14-1994',
      ' 3- 0-2002',
      ' 0-22-2003',
      '11-17-1981',
      '11-20-1989',
      '10-19-1975',
      '10- 5-1988',
      ' 2-28-1991',
      '11-14-1989',
      ' 1- 4-1991',
      '11-13-1985',
      ' 0- 4-1981',
      ' 9-21-1980',
      '11- 4-1979',
      NULL,
      NULL,
      ' 7-12-1996',
      '11-22-1983',
      NULL,
      ' 9-28-1984',
      ' 8-14-1977',
      ' 5-20-1981',
      ' 5-27-1982',
      '11-14-1983',
      ' 3-19-1992',
      NULL,
      '10-28-2002',
      NULL,
      ' 5-17-2001',
      '11- 3-2002',
      ' 0- 0-1997',
      NULL,
      '11-19-1984',
      ' 6-12-1998',
      NULL,
      ' 7-17-1977',
      NULL,
      NULL,
      ' 3-23-2003',
      '11- 3-1988',
      ' 2-16-1982',
      ' 3-25-2003',
      ' 3- 5-2000',
      ' 7-25-1986',
      ' 1-22-1981',
      ' 6- 1-1981',
      ' 6- 7-1976',
      ' 2-29-1979',
      ' 5-20-1994',
      ' 8-21-1997',
      ' 2- 2-1982',
      ' 8-26-1974',
      NULL,
      NULL,
      '11-21-1989',
      ' 1-15-1994',
      '10-15-1987',
      ' 7- 4-1985',
      ' 2-25-1993',
      '11-22-1975',
      ' 3-14-1988',
      NULL,
      NULL,
      '11-23-1974',
      ' 0-19-1976',
      ' 2-28-1990',
      '10-14-1978',
      NULL,
      ' 9- 7-1985',
      ' 0- 5-1975',
      NULL,
      ' 5-28-2001',
      NULL,
      ' 3-21-2002',
      ' 9-11-1986',
      '11- 4-2002',
      ' 3- 1-1988',
      ' 0- 2-1989',
      ' 6-19-1974',
      ' 5- 5-1982',
      NULL,
      '11-24-1974',
      ' 3-14-1986',
      '11- 5-2000',
      NULL,
      ' 7-28-1979',
      ' 0-21-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-21-1998',
      NULL,
      NULL,
      ' 3- 8-2002',
      ' 6-28-1991',
      '11- 6-1974',
      ' 5- 0-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.007517);
commit;
end;
/


