set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402430';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      '00414',
      0.548253,
      NULL,
      103.080742,
      NULL,
      0,
      0,
      1,
      0,
      0.789956,
      0,
      1,
      3.734715,
      0.118845,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6.710266,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      3,
      6,
      2,
      NULL,
      3,
      0,
      4,
      1.591838,
      NULL,
      0,
      NULL,
      0,
      1,
      0.284758,
      0,
      0,
      0,
      1,
      1,
      2,
      2,
      0,
      5,
      1,
      NULL,
      8.669363,
      2,
      NULL,
      11.266612,
      ' 4-26-2000',
      3,
      0.382426,
      NULL,
      NULL,
      3,
      1,
      2,
      6,
      17,
      203.020455,
      19031.782619,
      3.697363,
      NULL,
      30,
      13076,
      2,
      19.846324,
      134.208995,
      4919.917668,
      2.607436,
      13,
      27,
      430,
      0,
      1.536185,
      51,
      6431.308026,
      1.391596,
      17.554244,
      177.970722,
      12620.345589,
      6.417525,
      5,
      225.956660,
      5893,
      1.805648,
      8,
      66,
      74,
      6,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      292.679927,
      1,
      0.264520,
      15,
      16.452831,
      NULL,
      2,
      9.347436,
      600,
      NULL,
      3.818847,
      3.667906,
      10.870991,
      5,
      0,
      2,
      236,
      2,
      2,
      1,
      58,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1.631001,
      423.729975,
      NULL,
      3,
      NULL,
      1167,
      NULL,
      NULL,
      9.269444,
      142.657914,
      17,
      0,
      5.470106,
      313.642894,
      NULL,
      1,
      7,
      NULL,
      6,
      0.292348,
      13,
      NULL,
      9,
      0,
      15.227908,
      446.429681,
      NULL,
      1,
      2.621527,
      215.286568,
      7,
      2,
      13.117648,
      NULL,
      3.796080,
      0.230540,
      NULL,
      1082,
      172.318740,
      1.447811,
      16.120517,
      201,
      NULL,
      3.727376,
      17,
      23,
      14,
      1,
      3.711204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '33440',
      '',
      '',
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      3,
      NULL,
      NULL,
      '',
      0,
      0,
      NULL,
      NULL,
      983.935243,
      1.519775,
      NULL,
      1,
      NULL,
      1.594929,
      NULL,
      1.886018,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.321012,
      NULL,
      1.175118,
      NULL,
      NULL,
      0,
      2.507369,
      9,
      14,
      1.908629,
      0.117612,
      4,
      17.572932,
      18.010231,
      NULL,
      14.147672,
      23,
      NULL,
      13.220121,
      1.013789,
      16.780907,
      6,
      16.653335,
      0,
      20.081793,
      1,
      6.684547,
      5,
      2.268935,
      15.550971,
      4.144726,
      9.431339,
      NULL,
      7,
      4.606595,
      5,
      0.172861,
      6.345896,
      13.196379,
      NULL,
      9,
      0,
      4,
      3,
      18.347058,
      1.786328,
      2.124910,
      12,
      12,
      NULL,
      NULL,
      0,
      NULL,
      5.861992,
      4.521991,
      0.219847,
      23,
      7,
      NULL,
      26,
      NULL,
      17.826910,
      NULL,
      NULL,
      NULL,
      27,
      27.919380,
      9,
      6,
      19.270714,
      29,
      1,
      28.392768,
      1,
      16,
      11,
      NULL,
      1.371102,
      2,
      1,
      NULL,
      17.282581,
      26.958941,
      NULL,
      NULL,
      NULL,
      12,
      27,
      24.913602,
      0,
      NULL,
      31.876681,
      NULL,
      15,
      21,
      22.351079,
      4,
      15,
      11,
      10.794129,
      25.877768,
      27,
      29,
      NULL,
      13.201712,
      27,
      25,
      NULL,
      30.590899,
      92,
      20,
      45,
      69.315359,
      77,
      115,
      100,
      66,
      92,
      57.276055,
      42.954571,
      78.650336,
      57.904645,
      24,
      NULL,
      76.330541,
      100,
      NULL,
      NULL,
      91,
      NULL,
      NULL,
      82.291747,
      104.352319,
      65,
      67.399058,
      73,
      53.579537,
      17,
      133.275549,
      92,
      69.868433,
      NULL,
      124.808108,
      59,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      159,
      27.000881,
      NULL,
      164.341087,
      NULL,
      39.996123,
      129,
      78.956731,
      107.788847,
      NULL,
      168.655105,
      175.644992,
      3,
      6,
      0.440693,
      1,
      3.325364,
      NULL,
      1.081719,
      1,
      0,
      1.419708,
      1,
      6.128682,
      1,
      4,
      NULL,
      NULL,
      7.447325,
      6.776370,
      6.309844,
      6.885046,
      1,
      5.768563,
      3,
      NULL,
      1.600209,
      2.401671,
      1,
      NULL,
      7.630336,
      9.554859,
      6,
      NULL,
      NULL,
      NULL,
      7,
      7.687371,
      4.084743,
      2,
      NULL,
      5.110813,
      NULL,
      8,
      0,
      1.978125,
      2.181862,
      7,
      7.584568,
      NULL,
      0.149756,
      6.780640,
      NULL,
      2.464659,
      NULL,
      5.838407,
      1,
      NULL,
      2.039941,
      2,
      0,
      NULL,
      4,
      5,
      3,
      6.933452,
      1,
      NULL,
      3,
      3.470734,
      5,
      5.930969,
      NULL,
      NULL,
      2.004971,
      6,
      3.160767,
      5.958029,
      4,
      NULL,
      1,
      NULL,
      NULL,
      7,
      5,
      6.190944,
      3.413023,
      0.150290,
      5.381008,
      5.343532,
      3,
      6.707599,
      4.149028,
      5,
      3,
      7,
      3.642858,
      NULL,
      2,
      0.101674,
      0.395927,
      5,
      5.911184,
      8.833383,
      1.414583,
      4,
      2.855653,
      9.580164,
      6,
      5.190262,
      0.801662,
      NULL,
      4,
      3.327859,
      0.235836,
      3.321328,
      NULL,
      4,
      1.478654,
      NULL,
      1,
      1.690079,
      1.315505,
      2.053491,
      3.875317,
      1.175805,
      4,
      5.059954,
      NULL,
      4,
      2,
      3.760883,
      5.988254,
      4,
      5,
      5.858395,
      1.037154,
      1.416604,
      2,
      1.936202,
      4.794166,
      4.129080,
      4,
      3,
      2,
      NULL,
      0.722707,
      NULL,
      5,
      5.801635,
      2,
      1.228134,
      3.281926,
      0,
      NULL,
      NULL,
      4,
      3,
      2,
      0.003670,
      NULL,
      5,
      1.830589,
      1,
      2,
      0.829682,
      NULL,
      0.541772,
      1,
      5,
      NULL,
      5,
      2.097596,
      4,
      5,
      3,
      3,
      NULL,
      2,
      NULL,
      3,
      2.707645,
      1,
      2,
      4,
      1.417052,
      3.971169,
      1,
      3,
      5.519819,
      NULL,
      6,
      4.672892,
      3.327094,
      2.067111,
      NULL,
      0.184419,
      5,
      3,
      NULL,
      1,
      5,
      1,
      7,
      2.467860,
      5.295125,
      5.089789,
      7.735212,
      3.598121,
      2.375305,
      2.313596,
      0,
      0.411373,
      4,
      5.955711,
      4.820857,
      5,
      0.929506,
      2.328670,
      1.007218,
      5,
      7.648759,
      0.213017,
      5,
      5,
      2,
      0,
      NULL,
      3,
      3,
      5.082297,
      NULL,
      NULL,
      4,
      5,
      6,
      NULL,
      2,
      NULL,
      5.891630,
      3.486205,
      1.454886,
      4.538271,
      0,
      2.466389,
      7.120264,
      3.341281,
      0,
      5,
      7.866610,
      1.284974,
      4,
      0.059433,
      2.360479,
      NULL,
      0.504071,
      NULL,
      5.447292,
      NULL,
      0,
      NULL,
      6.356268,
      NULL,
      NULL,
      NULL,
      6,
      5.211531,
      4.678742,
      7.571454,
      2,
      8.392332,
      4.316428,
      6,
      0.998308,
      5.908908,
      1.808796,
      2.646783,
      NULL,
      2.709078,
      7,
      3,
      7,
      7,
      6.421637,
      0.992362,
      3,
      NULL,
      2,
      NULL,
      NULL,
      6.101770,
      2,
      NULL,
      NULL,
      7,
      1.219897,
      5.575098,
      NULL,
      NULL,
      6.746526,
      3,
      NULL,
      7.177386,
      7,
      NULL,
      9,
      2,
      2.539365,
      2.909010,
      6.368899,
      6,
      5.911596,
      0.759170,
      7,
      3,
      NULL,
      0.158626,
      NULL,
      0,
      NULL,
      NULL,
      6,
      3.287999,
      6.356750,
      NULL,
      5.989722,
      4,
      0.399671,
      1.177309,
      3.466955,
      0.071491,
      4,
      0.133249,
      7.029244,
      2.521095,
      5.816509,
      4,
      5,
      2,
      1.557315,
      1.284343,
      1.951047,
      2.067577,
      0,
      NULL,
      4,
      NULL,
      2,
      4,
      5.324594,
      NULL,
      2.331512,
      NULL,
      4,
      5,
      0.014371,
      NULL,
      2,
      NULL,
      2.879616,
      5.135859,
      7,
      1.337000,
      7.809120,
      6,
      3,
      2,
      3.749570,
      NULL,
      7.342030,
      3.132691,
      5,
      2.742053,
      2.255179,
      4,
      1,
      1,
      0,
      0,
      4,
      2.955640,
      0.112660,
      3.280788,
      NULL,
      NULL,
      4,
      3,
      0,
      1.294741,
      1,
      5.222964,
      1.641715,
      3,
      5.620547,
      2.625776,
      4,
      NULL,
      3.199163,
      NULL,
      1,
      1.009531,
      3.393027,
      2,
      2,
      5.749382,
      3,
      1,
      5,
      1.556357,
      NULL,
      5.159795,
      2.201168,
      4.233633,
      1.430548,
      1,
      5,
      0,
      NULL,
      0.444631,
      1.784808,
      1.459056,
      2.258044,
      3.409924,
      NULL,
      1,
      NULL,
      2.251080,
      3,
      2.850905,
      0,
      0,
      3.021159,
      3.873045,
      5.368471,
      0,
      NULL,
      1,
      1.765706,
      3.411021,
      2,
      1.986211,
      2.640804,
      2.984018,
      NULL,
      1.870692,
      3.923746,
      2.983626,
      NULL,
      1.625370,
      5.057983,
      2.806322,
      0.214357,
      0.944249,
      3.235653,
      NULL,
      3.605647,
      3.730498,
      4,
      1,
      0.557659,
      0,
      2,
      3,
      1,
      3.382198,
      5,
      0.026192,
      1.015953,
      2.474934,
      5.093197,
      0,
      NULL,
      1,
      2,
      1,
      2,
      2,
      5,
      1.679735,
      3,
      1,
      6,
      0,
      6,
      0,
      NULL,
      2.579169,
      1,
      0,
      3,
      1.329795,
      3.046932,
      NULL,
      0.602849,
      2.055388,
      NULL,
      1,
      7,
      0.917410,
      4,
      1,
      1,
      2.542082,
      1.226561,
      NULL,
      7,
      NULL,
      1.950760,
      2.861497,
      1,
      NULL,
      1,
      NULL,
      0.959096,
      3.560220,
      6,
      0,
      5.635819,
      NULL,
      NULL,
      4,
      1,
      1,
      1.513563,
      0.155638,
      1.283324,
      1,
      1.535015,
      1.725645,
      1,
      NULL,
      NULL,
      0.005537,
      0.533579,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0.955183,
      0,
      0,
      0,
      0.568898,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.054662,
      1,
      1,
      1,
      0.300276,
      NULL,
      0,
      0.804680,
      1.166355,
      NULL,
      1,
      1.766346,
      1.750280,
      0.065671,
      1,
      NULL,
      1,
      0.477709,
      1,
      NULL,
      0.627976,
      NULL,
      1.134419,
      1.854935,
      1.944112,
      1,
      1.159084,
      0.429719,
      0.500111,
      0,
      1.827728,
      1.462942,
      0.361375,
      0.946362,
      NULL,
      0,
      0,
      1,
      1.399523,
      0,
      1.639110,
      1.273936,
      1.100928,
      1.345994,
      1,
      1.775395,
      1,
      1.094725,
      0,
      0.353242,
      0,
      1.921343,
      0,
      NULL,
      1,
      1.835158,
      0.902473,
      0.605295,
      NULL,
      0,
      0,
      NULL,
      0.352762,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.593497,
      NULL,
      1.801475,
      0,
      1,
      0.162030,
      1,
      0.086156,
      NULL,
      1.893592,
      0,
      NULL,
      0.904776,
      0.727418,
      NULL,
      1,
      1.604444,
      NULL,
      1.927625,
      0,
      1,
      1.963920,
      0.288680,
      1.868463,
      0,
      1,
      1,
      1.715116,
      1.603792,
      1,
      1.818068,
      1.612743,
      NULL,
      NULL,
      0.930023,
      0,
      1.785097,
      NULL,
      0.127607,
      0,
      1,
      NULL,
      0,
      1.840491,
      0.826728,
      0,
      1.433901,
      0.433491,
      2,
      NULL,
      1,
      4.422678,
      3,
      9.534927,
      6.675866,
      6.124576,
      5.940328,
      2.193592,
      7.756529,
      6.382030,
      0.918956,
      0.125182,
      6,
      NULL,
      4.688997,
      0.838316,
      6.398868,
      NULL,
      5.187203,
      3.579999,
      6,
      1.733948,
      NULL,
      6.993343,
      3.623987,
      0,
      NULL,
      7.932254,
      NULL,
      6,
      1.758233,
      NULL,
      NULL,
      0,
      3,
      3,
      NULL,
      0.984212,
      1,
      1,
      0.306384,
      7.690374,
      1,
      1.601034,
      2,
      6.717692,
      NULL,
      2.193280,
      7,
      4.492782,
      0.082613,
      7.527660,
      0.750856,
      9.131285,
      4.327033,
      NULL,
      3,
      2.225404,
      4.666560,
      7,
      2.339600,
      1,
      1.689285,
      NULL,
      5,
      4,
      NULL,
      1,
      4.261957,
      0.529418,
      3,
      1,
      4.446638,
      7,
      2.021472,
      7,
      4,
      NULL,
      3,
      5.670744,
      4.208959,
      NULL,
      1,
      NULL,
      5,
      7,
      5,
      NULL,
      6,
      4.486047,
      4.770307,
      3,
      7.699325,
      3,
      7,
      3.185063,
      NULL,
      0.099125,
      7,
      5,
      5.260469,
      1,
      2,
      3.954552,
      1.573790,
      1.104867,
      0.392964,
      NULL,
      NULL,
      0,
      0.396928,
      1.443239,
      1,
      1,
      NULL,
      0,
      1.108988,
      1,
      0.784917,
      1,
      0,
      1,
      1.536802,
      1,
      1,
      1.500842,
      1,
      0.766409,
      NULL,
      0,
      1.971505,
      0.214752,
      NULL,
      0,
      NULL,
      1.123595,
      0.397015,
      1,
      0,
      0,
      1,
      1.702044,
      0,
      NULL,
      1,
      1.662871,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.702506,
      1.346599,
      0,
      1,
      1.184279,
      0,
      0.812739,
      0.580370,
      1,
      NULL,
      0.304557,
      1,
      0,
      0.261765,
      0,
      1.160216,
      1.923762,
      0,
      1.521642,
      1,
      0.749062,
      NULL,
      1.901219,
      0,
      0,
      1.103600,
      1,
      NULL,
      0.426471,
      1,
      1.245934,
      NULL,
      1.292452,
      1.903181,
      1.238576,
      0.183391,
      1,
      0,
      NULL,
      0.853580,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0.504321,
      0.432915,
      1,
      NULL,
      0,
      1.288422,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      3,
      5,
      2,
      4,
      0,
      5,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      3,
      5,
      0,
      5,
      3,
      3,
      NULL,
      4,
      3,
      2,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      0,
      3,
      3,
      0,
      3,
      2,
      1,
      0,
      3,
      3,
      5,
      1,
      0.259665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-21-2002',
      NULL,
      NULL,
      NULL,
      '11-23-1983',
      NULL,
      ' 8-19-2003',
      NULL,
      ' 0-14-1997',
      NULL,
      ' 9-15-1993',
      NULL,
      ' 1-10-1988',
      ' 2- 4-1997',
      ' 8- 8-1995',
      NULL,
      '11-10-2001',
      ' 0- 7-1996',
      '11-11-1996',
      NULL,
      ' 0- 6-1990',
      ' 6-13-1988',
      ' 7- 7-1976',
      NULL,
      '10-18-1994',
      '11-20-1988',
      ' 3- 3-1978',
      ' 9-19-1979',
      ' 0-22-1991',
      '10- 2-1984',
      ' 8-22-2003',
      ' 8-21-1990',
      ' 0- 2-1988',
      NULL,
      NULL,
      NULL,
      ' 2-15-1991',
      ' 5-16-1992',
      ' 8- 7-1982',
      ' 6-10-1976',
      ' 2-25-1993',
      ' 1-20-2000',
      '11-13-1989',
      ' 5-22-1976',
      ' 4- 5-1984',
      '11-14-1998',
      ' 2- 0-1980',
      ' 8-18-1982',
      NULL,
      ' 2-26-1989',
      ' 2-18-1995',
      '11-13-1974',
      ' 4-12-1975',
      NULL,
      NULL,
      '11-28-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 1-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


