set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9680781';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      NULL,
      NULL,
      '10- 7-1985',
      68,
      NULL,
      0.212133,
      NULL,
      1.629682,
      1.188206,
      0.485473,
      1.402004,
      0.234274,
      NULL,
      0.082648,
      1.390246,
      1,
      8,
      NULL,
      NULL,
      3.387853,
      NULL,
      NULL,
      28,
      9.652936,
      7.012910,
      0,
      NULL,
      9.094743,
      2.903922,
      3.923336,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      5,
      6.769808,
      2,
      NULL,
      1,
      0.838664,
      1,
      0.117713,
      NULL,
      NULL,
      3,
      1,
      1,
      1.295394,
      7,
      NULL,
      3,
      2.366574,
      4,
      6.516105,
      0.330574,
      NULL,
      NULL,
      NULL,
      NULL,
      3.719391,
      NULL,
      1,
      1,
      3,
      3.832937,
      0,
      25.506770,
      61.816289,
      NULL,
      0.959972,
      3.752765,
      153,
      1,
      2,
      2.801488,
      78.369639,
      4,
      3.569608,
      3,
      71,
      10,
      0,
      3,
      34,
      10.765641,
      0.657265,
      1.333409,
      NULL,
      92,
      0,
      3,
      127.904151,
      3,
      0.881222,
      3.784165,
      215,
      4,
      1,
      2,
      23.993295,
      16,
      2,
      4,
      17,
      1.472154,
      1.102699,
      1,
      NULL,
      34.459209,
      NULL,
      2.517145,
      198.800777,
      NULL,
      3,
      1,
      87,
      NULL,
      2.615212,
      5.116391,
      125.854063,
      2.822780,
      1.632247,
      2.294011,
      159.425897,
      94,
      0.115050,
      2.294636,
      5,
      NULL,
      1.444335,
      NULL,
      126.622123,
      152,
      2.088934,
      3.770599,
      NULL,
      NULL,
      NULL,
      9,
      129.417176,
      4,
      3,
      3,
      180,
      2,
      1.085261,
      5.003770,
      NULL,
      20,
      2.747865,
      3.132392,
      23,
      NULL,
      NULL,
      9,
      161,
      6.601200,
      3,
      3.829892,
      73,
      0.353407,
      0,
      0,
      117,
      27,
      1,
      1.984481,
      210.250833,
      NULL,
      1,
      NULL,
      216.679113,
      2.207603,
      3.696434,
      NULL,
      134.781718,
      6,
      3,
      7,
      163,
      3.994876,
      0.516860,
      3.705509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.843002,
      '14020',
      '',
      '',
      '',
      '',
      '',
      0.244513,
      NULL,
      NULL,
      '',
      1.572334,
      NULL,
      '',
      '',
      4,
      1.470805,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.918561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665530,
      NULL,
      NULL,
      NULL,
      0.276129,
      NULL,
      ' 4- 9-1984',
      12,
      5.379790,
      1,
      3,
      11,
      1.264313,
      13.916395,
      24.538859,
      11,
      NULL,
      7,
      NULL,
      9.270634,
      NULL,
      5.785937,
      10.293081,
      5,
      14,
      NULL,
      NULL,
      15,
      14.924314,
      0,
      7,
      6.053927,
      0.535495,
      12,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      NULL,
      14,
      NULL,
      19.928304,
      1,
      16,
      NULL,
      46.562260,
      5.800304,
      24.072689,
      3,
      9.509359,
      NULL,
      2,
      NULL,
      37,
      24,
      5.772523,
      6,
      18,
      NULL,
      48.334726,
      NULL,
      9.305084,
      12.832021,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94.675800,
      2,
      136,
      161.124691,
      158.672156,
      NULL,
      41,
      23,
      2,
      148,
      165,
      75.135871,
      97.347345,
      48.692629,
      189,
      28,
      29,
      44.072396,
      71,
      181.798534,
      6,
      NULL,
      183.358073,
      69.801277,
      81.248785,
      2.964525,
      112.592547,
      62,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.587820,
      1,
      5,
      7,
      4,
      7,
      NULL,
      1,
      0.575312,
      4,
      6,
      1.709768,
      5,
      2,
      0,
      7,
      NULL,
      7,
      6.648295,
      4.919879,
      2,
      1,
      0,
      NULL,
      NULL,
      4,
      0.711564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280358,
      5.423709,
      5,
      4,
      NULL,
      5.203581,
      1.468905,
      NULL,
      0.398966,
      NULL,
      4.838546,
      0,
      NULL,
      7,
      1.815967,
      5,
      0,
      4,
      0,
      0,
      2.752159,
      6.060603,
      6,
      0.115786,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      8,
      0,
      0,
      4,
      4.733870,
      3,
      NULL,
      0,
      0,
      8,
      2.458101,
      4,
      NULL,
      NULL,
      5.758909,
      7.632658,
      5,
      2,
      1,
      3.916966,
      5.708140,
      4.656987,
      3,
      NULL,
      NULL,
      5.297848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728880,
      0,
      1.562234,
      0,
      7.670665,
      0.955335,
      NULL,
      1,
      0,
      1,
      0.290685,
      5,
      0,
      NULL,
      1,
      2.639259,
      3.697228,
      3.249927,
      1,
      1,
      NULL,
      0,
      1,
      1.117274,
      0,
      1,
      1.037743,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.537015,
      3.026521,
      3,
      3.892118,
      2,
      2,
      3,
      1,
      7.245997,
      0,
      0.816938,
      5.230786,
      0.827979,
      4.098581,
      NULL,
      0.700757,
      NULL,
      0.527024,
      NULL,
      3.750418,
      4,
      4,
      1.605035,
      0.711295,
      NULL,
      1.153414,
      NULL,
      1.828827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.179120,
      NULL,
      2,
      6.589357,
      0,
      3.150400,
      NULL,
      8,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      5.909955,
      3.747846,
      6.912873,
      9.888219,
      5,
      5,
      1,
      0,
      3,
      1.967029,
      2,
      2.536214,
      7.270170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.948597,
      NULL,
      4,
      3.446336,
      2,
      4.549699,
      6,
      5,
      11.626242,
      1.979492,
      4,
      1,
      7,
      5.023262,
      5,
      4,
      2,
      0.541413,
      6.992791,
      NULL,
      3.809859,
      6.913516,
      3,
      7,
      NULL,
      3,
      NULL,
      6.106594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.325250,
      NULL,
      4,
      4.273504,
      0,
      6.304413,
      1.072832,
      2.374344,
      5.951730,
      2.109084,
      0.269932,
      2.963422,
      NULL,
      0.277100,
      7.152934,
      2.786463,
      NULL,
      1.702340,
      NULL,
      0,
      0,
      5.749879,
      4,
      4,
      1.451205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.156252,
      7,
      NULL,
      4.299011,
      NULL,
      4.775527,
      1,
      0,
      2,
      NULL,
      3,
      0.896974,
      4.150673,
      NULL,
      2,
      3,
      5.425982,
      2.078314,
      2,
      4,
      1,
      4,
      5.567297,
      NULL,
      6.670521,
      0.783617,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.516825,
      NULL,
      1.569263,
      0.457231,
      0,
      1,
      1.837118,
      NULL,
      NULL,
      1.417938,
      0,
      1.595899,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.779259,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.537688,
      1,
      1.432334,
      0,
      0.926955,
      1.624605,
      1.214883,
      1,
      1.956280,
      1.545135,
      0,
      1,
      NULL,
      1.530228,
      0.104615,
      0.710393,
      1,
      1,
      1,
      1,
      0,
      1.919676,
      0,
      1,
      1.800180,
      0.266538,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158141,
      NULL,
      0.918533,
      0,
      NULL,
      0,
      3.908894,
      NULL,
      3,
      NULL,
      4.837297,
      NULL,
      0,
      NULL,
      0.916536,
      2,
      5.092742,
      2.093366,
      1.923521,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      1.294855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351908,
      NULL,
      4.824581,
      1,
      NULL,
      0.505782,
      0,
      1.512377,
      1,
      1.454651,
      5,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0.462167,
      6.301684,
      NULL,
      4,
      NULL,
      0,
      1,
      1.029595,
      0.646839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.651220,
      0,
      5,
      7.416580,
      5,
      5.919643,
      7,
      2,
      8.102789,
      0,
      6.842678,
      8,
      0.230538,
      NULL,
      7,
      5.210996,
      NULL,
      2,
      NULL,
      7.643713,
      4,
      0,
      1.524735,
      3.074087,
      7,
      4,
      6.525614,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4,
      5.895977,
      NULL,
      1.837584,
      8,
      1.022507,
      1,
      6,
      7.566875,
      7.802832,
      2,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      3.269813,
      NULL,
      2.657975,
      4.785851,
      9,
      NULL,
      1,
      0.708925,
      5.559661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.442718,
      0.072472,
      NULL,
      NULL,
      1.437275,
      0.156872,
      1,
      0.284154,
      NULL,
      NULL,
      1.830264,
      1,
      0.865276,
      NULL,
      1,
      1.693581,
      1,
      1.244138,
      1,
      0.700535,
      NULL,
      1,
      NULL,
      0.065318,
      0,
      0.815042,
      NULL,
      1.074800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308435,
      1.955662,
      0,
      0,
      1.498276,
      NULL,
      0,
      NULL,
      0.395223,
      1,
      0,
      1.465797,
      4,
      0.704460,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0.542782,
      NULL,
      0,
      1.357410,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      5,
      3,
      4,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      3,
      3,
      NULL,
      0,
      2,
      NULL,
      3,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-13-1993',
      ' 3-20-1987',
      NULL,
      ' 5-10-1980',
      ' 2-20-1991',
      ' 8- 8-1985',
      ' 6-28-1981',
      NULL,
      NULL,
      ' 9- 0-1991',
      NULL,
      ' 7-13-2001',
      '11-27-1989',
      ' 6- 1-1985',
      NULL,
      ' 9- 1-1989',
      ' 7- 5-1980',
      NULL,
      ' 5-11-1983',
      ' 2- 6-1996',
      ' 3-27-1981',
      ' 3-20-1993',
      ' 3-17-1993',
      ' 4-22-1976',
      '10-13-2003',
      ' 0- 9-1997',
      '11-21-1978',
      ' 1-29-1978',
      ' 3-25-2000',
      ' 0-14-1974',
      ' 8-12-1988',
      ' 1-19-1992',
      '11-29-1979',
      '10-19-1986',
      NULL,
      NULL,
      NULL,
      ' 0- 7-1997',
      ' 0-10-1994',
      '11- 2-2001',
      NULL,
      ' 8- 6-1997',
      ' 3-24-1994',
      ' 6-10-2001',
      ' 1- 5-1998',
      NULL,
      ' 0-27-1983',
      '11- 8-1997',
      ' 5-11-1996',
      ' 9- 1-1978',
      NULL,
      ' 9- 2-1975',
      ' 1- 0-1995',
      ' 8-16-1995',
      '11- 2-1986',
      ' 3-10-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-25-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968708);
commit;
end;
/


