set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8931056';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      NULL,
      '2110400',
      1,
      7,
      3,
      '32303',
      0,
      ' 2- 0-1990',
      110,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      2,
      NULL,
      0,
      3,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173852,
      NULL,
      7,
      NULL,
      0.739893,
      4,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      5,
      2.142858,
      3,
      3,
      1,
      1,
      NULL,
      NULL,
      1.345176,
      0,
      4,
      2.565085,
      0.568132,
      0,
      2,
      1.471881,
      7,
      NULL,
      NULL,
      0,
      1,
      1.411769,
      18.126997,
      ' 6-16-1979',
      5,
      0,
      NULL,
      1,
      4,
      0,
      NULL,
      1,
      2.484090,
      177,
      1710,
      2.252359,
      5.990145,
      NULL,
      1567,
      1,
      0.141168,
      107,
      2281,
      0.065849,
      2,
      196,
      295,
      3,
      7,
      13,
      327.528872,
      1,
      NULL,
      132.850700,
      95,
      2.238065,
      1,
      NULL,
      15.695139,
      1.256469,
      NULL,
      147,
      NULL,
      3.408604,
      NULL,
      164.995182,
      NULL,
      3,
      1.785007,
      49.719650,
      NULL,
      3.762744,
      1.998012,
      NULL,
      1853.873535,
      1.073034,
      0.873809,
      43,
      81.899418,
      2,
      0.885532,
      141.931064,
      12,
      0,
      NULL,
      NULL,
      11,
      NULL,
      1.539873,
      141,
      754.227511,
      2,
      NULL,
      406.734090,
      1224,
      0.510955,
      1.784807,
      301,
      966,
      3.787198,
      0.834603,
      129,
      86,
      0.443772,
      6,
      238,
      796,
      2,
      NULL,
      159,
      187,
      0,
      2.549688,
      85.190377,
      NULL,
      3.933607,
      NULL,
      153,
      262,
      3,
      0.421129,
      NULL,
      13.961669,
      0,
      1,
      10.812028,
      712,
      0.724302,
      5,
      19.556117,
      NULL,
      NULL,
      2,
      686.476976,
      1688,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      0.944287,
      '',
      NULL,
      NULL,
      0.814110,
      NULL,
      '',
      '',
      NULL,
      29.896592,
      331,
      0,
      NULL,
      NULL,
      NULL,
      1.622471,
      NULL,
      1,
      NULL,
      0.165247,
      NULL,
      0.609534,
      NULL,
      0.238678,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      ' 3- 6-2003',
      NULL,
      5.870016,
      NULL,
      NULL,
      NULL,
      3,
      1,
      6.576780,
      0.573809,
      0.701131,
      3.104514,
      23,
      9,
      17.975943,
      NULL,
      22.343758,
      6,
      2,
      12,
      15.331321,
      13,
      16.566018,
      3.575429,
      10.844452,
      NULL,
      NULL,
      2.538631,
      2.800434,
      14.534122,
      9.921226,
      3.194167,
      NULL,
      2.665177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816685,
      2,
      0.211317,
      3.593987,
      2,
      3.249027,
      NULL,
      3,
      2.512949,
      3,
      1,
      1.504190,
      2.138002,
      1,
      4,
      2,
      5.125797,
      NULL,
      0.829307,
      NULL,
      0,
      3.338463,
      NULL,
      1.342624,
      NULL,
      3,
      3.776633,
      4.160768,
      2.583069,
      20,
      45.947082,
      2.378266,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.012335,
      18.805585,
      77,
      61.750760,
      NULL,
      NULL,
      140.905305,
      NULL,
      18,
      NULL,
      104.838829,
      88.336522,
      25,
      93.698608,
      10.061205,
      NULL,
      41,
      114.226909,
      95.258311,
      154.872755,
      14.106863,
      104,
      95.820888,
      55,
      166.683057,
      65,
      153,
      180,
      18.051404,
      68,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.990697,
      2.270240,
      2,
      NULL,
      0,
      0.322552,
      3.039607,
      4,
      5.857378,
      5,
      NULL,
      1.570416,
      5.424287,
      0,
      NULL,
      5,
      NULL,
      4.093305,
      6.460077,
      NULL,
      7,
      5,
      NULL,
      0.689307,
      2.047372,
      3,
      0.388517,
      0,
      NULL,
      NULL,
      2.491624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.297963,
      0,
      0,
      NULL,
      5.828919,
      NULL,
      0,
      1,
      4,
      1,
      3.899361,
      1.778552,
      3,
      0.006064,
      0.026667,
      NULL,
      NULL,
      NULL,
      3.513948,
      0,
      1.291518,
      1.711899,
      1.564933,
      0,
      7.580316,
      3,
      NULL,
      0,
      NULL,
      5,
      NULL,
      4.585646,
      0.686101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.253140,
      2.697951,
      NULL,
      1.137037,
      1.562258,
      7,
      NULL,
      1,
      1,
      NULL,
      2.241028,
      NULL,
      0,
      0.451106,
      NULL,
      2,
      1.528509,
      6,
      3,
      6.139585,
      1,
      NULL,
      2,
      1,
      5,
      4.856842,
      1,
      NULL,
      3,
      4.363816,
      5.189544,
      0.277636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.491646,
      1,
      NULL,
      NULL,
      NULL,
      3.699375,
      2,
      0.586174,
      NULL,
      3,
      0.826709,
      NULL,
      1,
      NULL,
      2,
      5,
      1.076834,
      0.022375,
      6,
      1.172672,
      7.684791,
      2,
      NULL,
      NULL,
      6,
      2,
      0,
      1,
      2.314959,
      4.854626,
      2,
      NULL,
      5.735142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      0.525942,
      1,
      0,
      1,
      NULL,
      3,
      0.430135,
      2,
      3,
      4.519058,
      1,
      2,
      1.896126,
      NULL,
      3.214863,
      0,
      0.657868,
      3.954517,
      NULL,
      1,
      NULL,
      1.535999,
      0,
      3,
      1.642749,
      5,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.364763,
      1,
      1.223032,
      NULL,
      8.800313,
      NULL,
      0,
      1,
      5.573163,
      3,
      NULL,
      1.459349,
      0.814104,
      3,
      4,
      1.228624,
      NULL,
      0.848036,
      NULL,
      1,
      1.772573,
      1.537140,
      1,
      5.653933,
      6.450473,
      1.762583,
      4,
      2.068359,
      3.532585,
      NULL,
      6,
      5.305629,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607481,
      0,
      4.954887,
      0.331648,
      2.162124,
      1,
      0,
      0,
      2,
      NULL,
      4,
      2.205375,
      4.990343,
      NULL,
      0,
      0.827880,
      1,
      3,
      NULL,
      1.998616,
      5.491879,
      3,
      5,
      4,
      NULL,
      2.941245,
      0.407055,
      1,
      1.601640,
      1,
      9,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.963796,
      0.357431,
      0,
      8,
      1.370924,
      2.096322,
      NULL,
      4,
      4,
      2.237086,
      5.427534,
      0.625507,
      1,
      7,
      2,
      0,
      NULL,
      0,
      1.617432,
      4.807582,
      3.344038,
      0.250905,
      1,
      6,
      0,
      5,
      2,
      0,
      5.044681,
      1.953164,
      4.638884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.723224,
      NULL,
      7.202558,
      0.038310,
      0,
      NULL,
      3.589871,
      NULL,
      5,
      NULL,
      9.490631,
      0,
      6,
      1,
      0.536156,
      1,
      3,
      1,
      7.935005,
      1,
      4,
      1.796481,
      1,
      2.477706,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.280808,
      1,
      2.841013,
      NULL,
      2,
      2.273703,
      6,
      1,
      1.899526,
      2.138694,
      3,
      NULL,
      2,
      NULL,
      1,
      2.321599,
      2.569403,
      0.367121,
      1.565547,
      3,
      NULL,
      2,
      5.467754,
      0.613795,
      3.172124,
      1.664207,
      1,
      0.515976,
      1.896452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.162259,
      1,
      0.308471,
      NULL,
      3.833648,
      1.124392,
      0.394454,
      1.894153,
      0,
      NULL,
      NULL,
      1.645416,
      5,
      NULL,
      3.193567,
      3.646652,
      1.307272,
      1.519478,
      1,
      0.432535,
      2,
      1,
      1,
      3,
      4,
      NULL,
      1,
      0.150008,
      5,
      NULL,
      3,
      1.501113,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.273221,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.798036,
      3,
      1.419606,
      3,
      1,
      2,
      1,
      0,
      1.906870,
      0.521605,
      1.569665,
      3.252853,
      1,
      1,
      NULL,
      0.151382,
      1,
      0.745908,
      0,
      0,
      1,
      0.241210,
      1,
      NULL,
      2.972594,
      1.899829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.663679,
      NULL,
      0.850107,
      5,
      1.470410,
      NULL,
      0.698620,
      1,
      0.713475,
      2,
      1.521580,
      1.063065,
      0.414062,
      1,
      0.176389,
      1,
      1.552600,
      1,
      1.240500,
      NULL,
      0.763272,
      1.910565,
      1,
      5.107859,
      1,
      1.399399,
      NULL,
      0.337047,
      0,
      0.005119,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4,
      0,
      1.773802,
      0,
      4,
      4,
      4.263820,
      0.072541,
      0.752795,
      2,
      NULL,
      0,
      2.653611,
      0,
      5.528103,
      1,
      7,
      1,
      2.340612,
      5,
      5.803025,
      3.583119,
      2.983058,
      3,
      5,
      0.713958,
      0,
      2.748575,
      0,
      0.780790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742301,
      2.845465,
      2.668753,
      3,
      11.693901,
      1,
      NULL,
      3,
      2.546499,
      0,
      0.626258,
      NULL,
      3,
      2,
      NULL,
      0,
      6.281752,
      0,
      8,
      NULL,
      0,
      0.588654,
      NULL,
      5,
      5,
      NULL,
      NULL,
      0.781604,
      NULL,
      NULL,
      6.210160,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      4,
      0,
      5,
      0.049036,
      4,
      0.507949,
      4.681855,
      0,
      5,
      0.907099,
      5,
      0.191360,
      0,
      0.169521,
      NULL,
      0,
      NULL,
      1.204082,
      2,
      1,
      1.015324,
      0.964786,
      NULL,
      0.486058,
      0.651139,
      NULL,
      0.231191,
      NULL,
      4,
      3.980446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.082296,
      1.418207,
      0.114587,
      NULL,
      1,
      0,
      NULL,
      0.592616,
      1,
      NULL,
      1.123315,
      0,
      0,
      NULL,
      1,
      3,
      1,
      NULL,
      1.144871,
      0.156999,
      1.849101,
      3,
      1,
      1.667000,
      0.071882,
      0.284268,
      1.974424,
      0.126761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2,
      3,
      NULL,
      3,
      1,
      0,
      3,
      5,
      3,
      4,
      2,
      5,
      3,
      5,
      1,
      2,
      1,
      0,
      NULL,
      0,
      0,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-14-1981',
      ' 8- 6-1984',
      '10-23-1991',
      NULL,
      ' 5- 2-1990',
      NULL,
      ' 3-11-2002',
      ' 0-10-1998',
      '10- 5-1994',
      '10- 8-1991',
      ' 1-18-2003',
      ' 0- 5-2000',
      ' 2- 7-1975',
      ' 0- 3-1994',
      NULL,
      NULL,
      NULL,
      ' 2- 4-1996',
      ' 7-15-1981',
      ' 1- 4-2000',
      NULL,
      ' 1-10-2003',
      ' 6-24-1983',
      '10- 1-1978',
      ' 2- 4-1996',
      ' 2-12-1982',
      ' 1-17-1999',
      ' 8-21-1986',
      ' 9- 9-1986',
      ' 9-29-1978',
      ' 3-11-1989',
      ' 9-16-1991',
      ' 5-11-1980',
      NULL,
      ' 6-15-1979',
      NULL,
      NULL,
      '11- 5-1999',
      NULL,
      NULL,
      ' 7-15-1978',
      NULL,
      NULL,
      ' 2-20-1997',
      ' 7- 3-1983',
      ' 2- 1-1978',
      '11-12-1974',
      ' 3- 8-1975',
      '10- 8-1979',
      '10-13-1979',
      ' 3- 4-1987',
      ' 4-15-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-21-1981',
      ' 0-24-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


