set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8931056';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      '0300413',
      1,
      9,
      NULL,
      NULL,
      NULL,
      ' 4-25-1989',
      35.103066,
      NULL,
      1.514325,
      3,
      1,
      1.178138,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      5,
      NULL,
      NULL,
      0.519769,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3.435216,
      1.255041,
      0.669855,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1.330450,
      NULL,
      0,
      1.789639,
      1,
      0,
      NULL,
      2,
      2.786364,
      0.637907,
      0.081503,
      NULL,
      0.964047,
      NULL,
      NULL,
      6,
      2.264341,
      3.523687,
      0,
      20,
      ' 8-16-1989',
      15.659385,
      0,
      NULL,
      3,
      5,
      1,
      2,
      0,
      NULL,
      184,
      NULL,
      2.190160,
      7,
      129,
      2285,
      1.575531,
      3.988898,
      192.743943,
      368.049250,
      1,
      3.570520,
      34.185409,
      676,
      1.340875,
      2,
      NULL,
      850.672712,
      2.023575,
      2,
      18,
      NULL,
      NULL,
      0,
      NULL,
      36,
      NULL,
      7.860635,
      NULL,
      68.457639,
      3.453916,
      0.027152,
      231,
      277.955950,
      0,
      2.253677,
      135,
      2721,
      NULL,
      9,
      87,
      NULL,
      3.718347,
      NULL,
      48.422584,
      NULL,
      NULL,
      0,
      176,
      NULL,
      5.856958,
      NULL,
      81,
      NULL,
      0.767933,
      NULL,
      282.398765,
      440,
      2,
      NULL,
      NULL,
      1028,
      NULL,
      5.641291,
      290.787801,
      NULL,
      2,
      3,
      163.725843,
      NULL,
      3.626354,
      0,
      205.479046,
      647.139656,
      NULL,
      1,
      184.911984,
      118.691428,
      3,
      5.735453,
      49.681831,
      405.202470,
      2.226547,
      5.914285,
      142,
      NULL,
      0.515825,
      3,
      49.563834,
      25,
      2,
      NULL,
      NULL,
      566.994530,
      1.051982,
      8.793315,
      6.404612,
      391,
      0.057316,
      0.082423,
      557,
      213,
      3.328298,
      2.819546,
      118,
      10.390110,
      2.974278,
      NULL,
      24.938271,
      NULL,
      0,
      3,
      NULL,
      467.999861,
      0.715651,
      0,
      21,
      9,
      NULL,
      3,
      158.158630,
      44,
      1,
      0.702349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.225513,
      '31414',
      '',
      '',
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      0.873475,
      NULL,
      '',
      '',
      1,
      30.674479,
      92,
      0,
      NULL,
      1,
      NULL,
      0.177937,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.454410,
      NULL,
      0.996822,
      NULL,
      0,
      NULL,
      0,
      NULL,
      '10-19-1987',
      NULL,
      13,
      5.215143,
      NULL,
      1,
      3,
      9.176271,
      18.419032,
      1,
      0,
      6.597349,
      1,
      4.194155,
      16.946109,
      2,
      3,
      11.262437,
      2.971799,
      NULL,
      19.603593,
      NULL,
      14,
      NULL,
      7,
      NULL,
      2,
      9.176191,
      4,
      18.189689,
      8.504640,
      5,
      NULL,
      2.205348,
      8.183695,
      7.959560,
      2,
      1.830754,
      0,
      NULL,
      15.155641,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      NULL,
      NULL,
      2.323830,
      NULL,
      2,
      5.315041,
      2.571795,
      0.935931,
      NULL,
      1,
      0.508375,
      5.341797,
      3,
      1,
      NULL,
      0.744278,
      1,
      4,
      0.675971,
      0.633453,
      0,
      NULL,
      NULL,
      4,
      3,
      1,
      18,
      18,
      8.353181,
      11.727943,
      1,
      31,
      NULL,
      45.734841,
      20.791536,
      34,
      6.576906,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      76.985000,
      64,
      100,
      102,
      37.543007,
      20,
      12.290225,
      40.850036,
      115,
      112,
      53,
      69.144626,
      NULL,
      67,
      30,
      100,
      12.683252,
      145,
      32,
      14.146175,
      43,
      64.487250,
      NULL,
      29,
      134.483052,
      NULL,
      32.220509,
      181,
      185,
      NULL,
      70.321764,
      5.752080,
      34,
      177.494948,
      40,
      146.446947,
      180,
      74,
      115,
      134,
      94.714494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.867604,
      1,
      2.399770,
      2,
      8,
      NULL,
      1.146542,
      3,
      6,
      3.985362,
      4,
      1.302342,
      9,
      1,
      NULL,
      4.748498,
      1,
      3,
      6.175966,
      NULL,
      7,
      0.803045,
      NULL,
      4.545561,
      7,
      3.416249,
      NULL,
      3.336528,
      4.344855,
      4.486511,
      10.300534,
      NULL,
      3,
      0.300244,
      1,
      1.774966,
      4,
      6.179511,
      0.950662,
      1.100415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.261611,
      NULL,
      1,
      6,
      1,
      0,
      0.773806,
      1,
      0,
      NULL,
      3.872143,
      0,
      0.368894,
      NULL,
      4.929293,
      1,
      0,
      3,
      0,
      0,
      0.617327,
      0,
      0,
      7,
      NULL,
      1,
      1,
      2.957034,
      3,
      6.885274,
      0,
      1,
      NULL,
      5,
      3.921089,
      3,
      NULL,
      0.281295,
      1.175024,
      1.882886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.216045,
      NULL,
      0,
      9,
      0.445655,
      6.036543,
      1,
      9,
      2,
      NULL,
      0.954319,
      NULL,
      2,
      9,
      1.553004,
      NULL,
      2.078582,
      7,
      0.783668,
      0,
      3,
      7,
      3.395149,
      1.473144,
      1.324266,
      0.060355,
      3.746275,
      2,
      3.281661,
      NULL,
      NULL,
      2,
      5,
      4.614913,
      3.236994,
      0,
      4.769910,
      5.664868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.073140,
      5.856904,
      3,
      2,
      3.693594,
      3.079080,
      NULL,
      3,
      4,
      NULL,
      1,
      1,
      0,
      4.896712,
      6,
      1,
      2.621423,
      3,
      NULL,
      3.772984,
      4,
      NULL,
      1,
      2,
      1,
      0,
      1.587109,
      0.379645,
      7,
      4.176556,
      3,
      NULL,
      5.043862,
      NULL,
      3.209630,
      4.068558,
      5.414600,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.260943,
      NULL,
      1.283490,
      0,
      2.118659,
      0.316530,
      0,
      2.312345,
      NULL,
      1.939902,
      5,
      1,
      1.627865,
      NULL,
      3,
      0.786182,
      NULL,
      NULL,
      3.970266,
      3,
      0.285152,
      1.441727,
      3,
      0,
      5,
      0,
      1,
      NULL,
      NULL,
      1.250713,
      2.707904,
      3,
      3,
      0,
      2.405236,
      NULL,
      2,
      1,
      1,
      5,
      3.089913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.709115,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.115324,
      1.712629,
      0.176860,
      0,
      3,
      0,
      1.679446,
      NULL,
      NULL,
      3,
      NULL,
      0.133695,
      6.853357,
      1,
      0.108171,
      0,
      1.505052,
      1.104231,
      2,
      1.453304,
      3,
      3.420058,
      3.668077,
      4.150567,
      5.510574,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.791165,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.515461,
      4.433109,
      2.230150,
      5.744632,
      1.526129,
      2.119844,
      0,
      1.363584,
      1.704325,
      NULL,
      NULL,
      4.315604,
      1.280765,
      NULL,
      4,
      5,
      1.284386,
      0.624260,
      3,
      3,
      3,
      3,
      1.935837,
      2,
      1,
      4,
      5,
      NULL,
      2,
      5.648591,
      0.774439,
      0,
      2,
      NULL,
      0.347805,
      NULL,
      4,
      1,
      7.385473,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.403062,
      0.867116,
      NULL,
      1.824428,
      NULL,
      1,
      8.955554,
      5,
      NULL,
      NULL,
      1.232396,
      2.488338,
      3,
      NULL,
      NULL,
      NULL,
      2,
      4,
      2,
      3.886037,
      NULL,
      NULL,
      5,
      3,
      NULL,
      1,
      3.776306,
      NULL,
      3,
      3,
      2,
      2.967516,
      0,
      2.563624,
      0,
      1,
      3,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333330,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      5.107070,
      1.273414,
      NULL,
      4,
      7,
      4.426023,
      NULL,
      0.574263,
      1,
      1.491352,
      2,
      0,
      NULL,
      3.108815,
      3,
      NULL,
      NULL,
      1.386041,
      1.601645,
      NULL,
      0,
      4,
      3,
      3.611408,
      0,
      7,
      1.962528,
      NULL,
      NULL,
      3.781644,
      1,
      4.935524,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.354741,
      0.456307,
      NULL,
      4.373709,
      7,
      0.119866,
      3.309399,
      2.504219,
      5,
      2,
      2,
      NULL,
      NULL,
      NULL,
      4.881410,
      1,
      NULL,
      NULL,
      4,
      0,
      5,
      2,
      9.006099,
      2,
      4.291830,
      NULL,
      NULL,
      2,
      1,
      2,
      NULL,
      1,
      1.740413,
      2,
      1.866216,
      5.631805,
      NULL,
      2.139631,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.080589,
      1.294561,
      5.193555,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.256162,
      5.493558,
      0,
      0.481329,
      0,
      2,
      1.886619,
      3,
      1.453605,
      3,
      1.783680,
      NULL,
      1.359565,
      3.586304,
      0.964211,
      3,
      1.787928,
      1,
      1.651067,
      0,
      0,
      5.749189,
      NULL,
      0,
      1.207866,
      NULL,
      1,
      1,
      0.619506,
      0.838353,
      0.966958,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.127074,
      1,
      0.443617,
      NULL,
      NULL,
      0,
      1.760615,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0.865975,
      1.902182,
      0.844320,
      0.483889,
      1,
      1,
      1,
      0,
      0.621946,
      0.079931,
      1.125587,
      1.902448,
      0.259321,
      0,
      1,
      0,
      3.286177,
      NULL,
      0,
      0,
      1.786081,
      0,
      0,
      NULL,
      0,
      1.969432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.345261,
      1,
      1.443335,
      0,
      NULL,
      0,
      2,
      1.940139,
      1,
      0,
      NULL,
      1.962021,
      NULL,
      0.824816,
      0,
      1,
      0,
      1.258137,
      NULL,
      NULL,
      1,
      1.359202,
      1.739560,
      1.362378,
      5.011223,
      0,
      2.412204,
      1,
      0.320269,
      0.664381,
      NULL,
      1,
      0,
      NULL,
      1.323666,
      0.077373,
      1.114970,
      1,
      1,
      0.424381,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.045769,
      4,
      0,
      2.071760,
      5.348448,
      1.331505,
      3.835768,
      3,
      7.728164,
      5,
      NULL,
      0.941941,
      5.523552,
      1.779089,
      9.719742,
      5,
      0,
      0.803464,
      7,
      NULL,
      9,
      2,
      7.356539,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.649426,
      6,
      5.950307,
      NULL,
      0.446542,
      6,
      5.380867,
      0.360720,
      1.353693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.810801,
      0,
      NULL,
      5,
      1.400695,
      0,
      1.990233,
      6.792834,
      2,
      8,
      1,
      2.409097,
      2.839908,
      4,
      NULL,
      6,
      2,
      1,
      1,
      2,
      0.787396,
      4.350508,
      0,
      3.434045,
      NULL,
      NULL,
      2,
      3.343507,
      NULL,
      NULL,
      6.726662,
      3.621568,
      NULL,
      3,
      1,
      NULL,
      5.142123,
      0,
      8.132702,
      3.692695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773019,
      2.261751,
      4.894949,
      1,
      5.840272,
      0,
      3,
      1,
      0,
      0,
      4.975977,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2.687857,
      1.096002,
      4,
      1,
      5.409533,
      1,
      1,
      0,
      2,
      0,
      2,
      1.937006,
      NULL,
      3.178820,
      4.749534,
      4,
      1,
      1,
      1.112124,
      0.475225,
      0,
      1,
      NULL,
      0.142719,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.900765,
      0,
      NULL,
      1,
      0.669672,
      NULL,
      0,
      1,
      0,
      0.966168,
      1.352218,
      1,
      0.121830,
      0,
      0.681364,
      1,
      1,
      3,
      1.245932,
      0,
      0.684844,
      1,
      1,
      0.981260,
      0,
      1.240893,
      1.824682,
      0.391895,
      1,
      0,
      1.694804,
      1.289880,
      0.162808,
      0.233986,
      NULL,
      0,
      NULL,
      0.212261,
      1,
      0.120553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      1,
      5,
      1,
      4,
      2,
      2,
      1,
      0,
      1,
      2,
      NULL,
      4,
      1,
      5,
      NULL,
      1,
      0,
      1,
      NULL,
      4,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      NULL,
      1,
      5,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-18-1991',
      NULL,
      NULL,
      ' 0- 6-1993',
      ' 5-18-1992',
      ' 9-27-1981',
      NULL,
      ' 0-24-1989',
      '11- 7-1988',
      ' 5-18-1975',
      ' 7- 0-1985',
      ' 4-17-2002',
      ' 7-16-2001',
      NULL,
      NULL,
      ' 6- 2-1975',
      ' 7- 9-1974',
      '10- 1-1987',
      ' 7-27-1983',
      NULL,
      ' 6-27-1977',
      ' 1-10-1992',
      ' 8-17-1992',
      ' 1-16-1978',
      '11-10-2001',
      ' 5-16-1977',
      NULL,
      ' 0-18-1986',
      ' 7-15-1996',
      ' 2- 4-1993',
      ' 7-17-1998',
      ' 0- 0-1976',
      ' 7-20-1988',
      ' 5-12-1996',
      ' 8-17-1986',
      NULL,
      ' 0-26-1977',
      ' 1- 8-1994',
      ' 9-27-1996',
      ' 8-26-1977',
      '10- 1-1986',
      NULL,
      ' 6-17-1993',
      ' 5-27-1979',
      ' 3-21-1983',
      ' 3-27-1998',
      ' 3-21-1984',
      '11-17-1997',
      NULL,
      ' 3- 9-2002',
      ' 9-20-1974',
      NULL,
      ' 3-17-1979',
      NULL,
      ' 1-21-1999',
      NULL,
      ' 6- 1-1979',
      NULL,
      ' 3- 2-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-25-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419718);
commit;
end;
/


