set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7620831';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      6,
      3,
      0,
      '42031',
      3,
      ' 6-26-2002',
      31,
      NULL,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.903633,
      1,
      3.667063,
      1,
      0,
      NULL,
      NULL,
      1.689994,
      NULL,
      0.271311,
      49,
      3.641887,
      0,
      1.653441,
      NULL,
      3.156653,
      2.439052,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      5,
      NULL,
      1,
      1,
      0,
      1,
      2,
      4,
      2,
      3,
      NULL,
      NULL,
      2,
      3,
      0.958183,
      0.703394,
      2,
      1.416466,
      2,
      2,
      3,
      0.610349,
      NULL,
      7,
      NULL,
      0,
      3.673182,
      3,
      2,
      NULL,
      2,
      8,
      ' 0-14-1980',
      4.116968,
      1.284299,
      NULL,
      3,
      3,
      1,
      4,
      0,
      25.684654,
      NULL,
      4.388733,
      2,
      3,
      25.057008,
      1,
      NULL,
      2,
      139,
      NULL,
      0,
      NULL,
      18,
      3,
      NULL,
      3.190606,
      93,
      3,
      NULL,
      NULL,
      71.645289,
      25,
      1.728359,
      0,
      NULL,
      NULL,
      0,
      14,
      147,
      5.368928,
      3.212109,
      NULL,
      607.880712,
      95.998791,
      2.100426,
      NULL,
      48,
      NULL,
      3,
      0.869974,
      NULL,
      2040.618964,
      3,
      1.390149,
      53,
      NULL,
      3.540214,
      2,
      5.090370,
      206.649777,
      0,
      1.904011,
      NULL,
      397,
      0,
      3,
      145.687844,
      NULL,
      NULL,
      1.451421,
      223,
      48,
      3,
      1.352041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '41341',
      '22413',
      '13131',
      '21203',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '34403',
      '',
      '',
      3,
      NULL,
      1,
      1.962999,
      NULL,
      1.813243,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      0.665889,
      NULL,
      0.997562,
      NULL,
      1.215349,
      NULL,
      0,
      1.415759,
      0,
      NULL,
      ' 1-17-1975',
      NULL,
      3.122685,
      NULL,
      1,
      12.592562,
      19,
      6,
      2,
      15.868601,
      11,
      12.762745,
      8,
      NULL,
      8,
      2,
      12,
      0,
      NULL,
      18.189727,
      2.003779,
      2.806280,
      12,
      NULL,
      3.954353,
      4,
      0,
      7,
      6.849530,
      8.403367,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867555,
      15,
      3.948554,
      7.967263,
      33.842342,
      2,
      NULL,
      10,
      12.102998,
      20.068014,
      45.012541,
      34,
      9,
      18,
      17,
      3,
      3.331201,
      1,
      3.597968,
      0,
      24,
      0.105285,
      1.072019,
      17.621253,
      20.732718,
      1.647918,
      NULL,
      NULL,
      27.136345,
      3,
      38,
      0.278722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62.002992,
      30,
      6.852432,
      147.418226,
      NULL,
      65.506081,
      114.590955,
      37.969222,
      166,
      NULL,
      110,
      21.635494,
      79,
      111.624836,
      162.515801,
      149,
      175.014106,
      NULL,
      NULL,
      68,
      70.531011,
      34,
      42,
      12.226024,
      NULL,
      46.006667,
      27,
      NULL,
      107.611949,
      21.491596,
      29.972417,
      34.923218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248866,
      1.387733,
      0.335071,
      1.901974,
      1.767147,
      3.392888,
      4,
      NULL,
      4.590890,
      1,
      2.639092,
      4,
      0,
      3,
      1.701776,
      5.118624,
      NULL,
      0,
      3,
      9,
      2,
      1,
      2.082632,
      7.369521,
      1,
      7.410693,
      2,
      9.822003,
      5.199795,
      1,
      0.911609,
      0.362287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154101,
      NULL,
      NULL,
      1.194152,
      NULL,
      0,
      NULL,
      0.061529,
      1,
      1.067052,
      0.955129,
      1,
      1.360406,
      0.470157,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.038655,
      1,
      1.098413,
      3.696938,
      NULL,
      5.498631,
      0.035658,
      NULL,
      NULL,
      0,
      1,
      0.700092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.802999,
      1.735326,
      NULL,
      NULL,
      0.934175,
      3.413519,
      5,
      4.914344,
      3,
      3.587738,
      2,
      1,
      0,
      1,
      3,
      5.097583,
      0.739861,
      NULL,
      5.443201,
      0.175470,
      0,
      3.418780,
      4.594875,
      0,
      1.671438,
      NULL,
      5,
      3,
      1,
      1,
      1.261050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.369349,
      NULL,
      1,
      1.327247,
      NULL,
      0.710510,
      NULL,
      4,
      0.282144,
      3.806606,
      NULL,
      NULL,
      NULL,
      0.778121,
      3,
      0,
      NULL,
      2,
      NULL,
      5.876507,
      1.318386,
      1.128128,
      NULL,
      5.885503,
      1,
      1,
      0.286605,
      4.115797,
      NULL,
      0.907662,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.557493,
      1,
      0.889098,
      1,
      0.481382,
      3.982360,
      0,
      1.970727,
      2.340765,
      3.165120,
      3.277914,
      NULL,
      2.772040,
      3.916194,
      1,
      3,
      0.430128,
      2,
      2,
      2.112447,
      NULL,
      3.904378,
      1,
      NULL,
      0.785430,
      1,
      1.846838,
      1.409995,
      0,
      4,
      4.611990,
      3.514265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.266494,
      NULL,
      0.940870,
      1.538202,
      0.678269,
      2,
      1,
      1.148629,
      3.489904,
      1,
      4,
      4,
      NULL,
      0.037074,
      1.669057,
      NULL,
      1.772315,
      7.228654,
      9,
      NULL,
      7.244883,
      3.081666,
      0.594279,
      5,
      NULL,
      0.387975,
      7.281408,
      6.400257,
      3.528425,
      5,
      0.751897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0.683133,
      1.886216,
      3,
      NULL,
      2,
      1.025485,
      NULL,
      4.574561,
      5,
      1.169357,
      2.591607,
      2,
      9,
      1.666777,
      1.265354,
      1,
      5.054052,
      5,
      5.648764,
      NULL,
      2,
      4,
      6,
      0.279489,
      4.014575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1.331520,
      NULL,
      1,
      NULL,
      1.916053,
      1.268859,
      0.440089,
      1.419768,
      1.012768,
      NULL,
      NULL,
      5,
      NULL,
      2.679433,
      0,
      NULL,
      NULL,
      2.667412,
      0,
      0.734634,
      0,
      1,
      0,
      0.977644,
      5.832299,
      7,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807880,
      1,
      0.499147,
      0.560348,
      0.591950,
      2,
      3.571086,
      NULL,
      3,
      1,
      NULL,
      3,
      2.263340,
      3.929259,
      1.961443,
      3,
      NULL,
      5,
      3,
      3,
      0.296042,
      1,
      0.110294,
      3,
      2.171245,
      0,
      3.691522,
      1,
      1,
      0,
      5,
      5.760582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.731373,
      0.344212,
      NULL,
      NULL,
      0.677390,
      0.125269,
      0.427841,
      0,
      NULL,
      0,
      0.056462,
      1,
      1,
      0.670062,
      1.585617,
      1.447389,
      1.800011,
      NULL,
      1.481707,
      1.839684,
      0.056861,
      2,
      NULL,
      NULL,
      1.140938,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.708253,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0.654004,
      1,
      1,
      0,
      1.616494,
      0.106144,
      3,
      3.182186,
      4.341366,
      1,
      1,
      NULL,
      1.800285,
      1.839621,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268335,
      NULL,
      0,
      2,
      0,
      1.150205,
      NULL,
      NULL,
      0,
      NULL,
      3.340746,
      1,
      3,
      2,
      7.810314,
      6,
      6,
      2,
      NULL,
      2,
      NULL,
      1,
      0,
      0.498257,
      0.824242,
      1,
      1.170780,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754447,
      1,
      NULL,
      1,
      1.439146,
      3,
      5,
      4.473867,
      4,
      3.651923,
      3.065901,
      1,
      3,
      NULL,
      3,
      5.266753,
      5,
      4.086653,
      3,
      2.808221,
      NULL,
      3,
      2.645224,
      0.629051,
      2,
      NULL,
      3.060076,
      5.445383,
      0.494588,
      0,
      1.765898,
      1.938140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.308414,
      1.392644,
      3,
      4.074213,
      3.537793,
      1.076198,
      5,
      NULL,
      3,
      1,
      3,
      0,
      0.354968,
      0.976697,
      0.178391,
      7.338706,
      1.268100,
      6.497206,
      3.629752,
      4,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6,
      1.515955,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990262,
      0.740348,
      NULL,
      1,
      1.236907,
      3.914399,
      3,
      3,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.036446,
      1,
      2.420496,
      6,
      5,
      NULL,
      2.522043,
      4,
      5,
      5,
      0.950389,
      4.999677,
      7,
      5,
      5,
      4.435883,
      0.701402,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.310084,
      1,
      1.974282,
      0.877409,
      0,
      0.754832,
      1,
      0.145896,
      1,
      1,
      0,
      1,
      0,
      0.848260,
      0.451965,
      NULL,
      0.655096,
      NULL,
      0.102974,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      2,
      0.801932,
      0.753419,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.540255,
      0,
      1,
      1,
      2,
      3,
      3,
      3,
      NULL,
      NULL,
      3.801015,
      4,
      NULL,
      0,
      2,
      2.493495,
      0.018988,
      NULL,
      NULL,
      NULL,
      3,
      2.514176,
      1,
      1.349942,
      0.084721,
      1,
      0,
      0,
      1.217601,
      NULL,
      0.092380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      3,
      0,
      1,
      NULL,
      3,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      3,
      0,
      4,
      3,
      4,
      NULL,
      7,
      1,
      6,
      5,
      6,
      1,
      1,
      2,
      3,
      1,
      2,
      1,
      0,
      1,
      4,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      3,
      NULL,
      1,
      5,
      0,
      2,
      0,
      0,
      2,
      NULL,
      5,
      3,
      0,
      0,
      NULL,
      2,
      0,
      4,
      1,
      NULL,
      4,
      2,
      1,
      2,
      4,
      4,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-13-1988',
      ' 6- 1-1982',
      ' 8- 5-1992',
      ' 7-20-1983',
      ' 8-26-1989',
      ' 3-19-1975',
      ' 0-16-1983',
      '11- 6-1974',
      '11- 9-1988',
      ' 4-13-1983',
      ' 5-21-1997',
      '10-24-1980',
      NULL,
      NULL,
      ' 8-17-1996',
      NULL,
      ' 0- 5-1976',
      NULL,
      '10-11-1974',
      ' 1-20-1990',
      NULL,
      ' 7-21-1979',
      ' 4- 9-1991',
      ' 7-23-1995',
      NULL,
      NULL,
      ' 8-14-1988',
      ' 8-22-1988',
      NULL,
      ' 0- 4-1974',
      ' 4-12-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 2-2000',
      ' 7- 7-1981',
      ' 0-12-1992',
      ' 3-17-2002',
      ' 3- 2-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043311);
commit;
end;
/


