set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      '1314004',
      0,
      5.920751,
      1,
      '41010',
      NULL,
      ' 1- 1-1988',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.183914,
      1,
      2,
      NULL,
      NULL,
      0.615313,
      1.078780,
      0,
      9,
      NULL,
      NULL,
      1,
      2.655134,
      NULL,
      NULL,
      NULL,
      NULL,
      2.518316,
      NULL,
      5.036477,
      1.174731,
      0.861484,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      5,
      NULL,
      1,
      NULL,
      2,
      0.748898,
      1,
      0.697726,
      0.226520,
      3,
      1,
      NULL,
      1.959730,
      NULL,
      5,
      2.412578,
      0,
      NULL,
      5,
      5.275090,
      0.471743,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      1,
      0.544501,
      3,
      NULL,
      111.688562,
      NULL,
      0,
      0,
      62,
      926.682836,
      NULL,
      7.236111,
      168.355817,
      3020,
      2,
      7,
      178,
      1120.508702,
      2.247804,
      7.041490,
      NULL,
      1332.735800,
      0.855173,
      1.875819,
      192.147023,
      170,
      1,
      3.684081,
      118.028245,
      655.778317,
      3,
      0.362568,
      101.578578,
      309.976612,
      NULL,
      4.165682,
      35.381365,
      988,
      1,
      7,
      169,
      31.232896,
      1.319661,
      1,
      7,
      336.359920,
      3.296275,
      NULL,
      193,
      NULL,
      0,
      1,
      55.683926,
      NULL,
      NULL,
      3,
      226.599008,
      8.870939,
      NULL,
      1,
      NULL,
      NULL,
      3,
      7,
      171,
      21,
      NULL,
      NULL,
      100,
      25,
      0,
      NULL,
      63,
      63,
      NULL,
      5.770764,
      163,
      1.604205,
      1,
      NULL,
      0,
      NULL,
      3,
      1.069759,
      NULL,
      67.735472,
      1.490117,
      0.806808,
      334.779086,
      2,
      3,
      0,
      176.014778,
      617,
      NULL,
      5.677058,
      97.444663,
      1375.155012,
      1,
      2,
      NULL,
      NULL,
      1.095340,
      6,
      150,
      867.083976,
      NULL,
      2.755908,
      103,
      4.192933,
      1.447962,
      NULL,
      NULL,
      NULL,
      4,
      3.152817,
      146.741430,
      50.302786,
      NULL,
      NULL,
      118,
      2,
      4,
      1.873876,
      109.272791,
      98.353353,
      3,
      3,
      123,
      NULL,
      1,
      5.337379,
      NULL,
      6.854908,
      NULL,
      1.642077,
      181.620290,
      10,
      0.795922,
      0.979059,
      162.080404,
      NULL,
      2.695055,
      NULL,
      53.089279,
      2,
      NULL,
      9.858070,
      105.135501,
      NULL,
      3.929642,
      NULL,
      NULL,
      43,
      2.353786,
      2.775173,
      160.813213,
      40.138285,
      0,
      9,
      46.126161,
      NULL,
      0.423659,
      2,
      36.461089,
      13,
      0,
      1.857048,
      127.696650,
      6.675832,
      0,
      0,
      449.708012,
      942.808208,
      1,
      6.572509,
      622.755742,
      348.044941,
      3,
      NULL,
      214,
      10,
      1,
      NULL,
      70,
      13.712251,
      3.325550,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '23241',
      '',
      '',
      '',
      '',
      '',
      0.561988,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      339.947157,
      0.233597,
      NULL,
      1,
      NULL,
      0.317885,
      NULL,
      0.615432,
      NULL,
      0,
      NULL,
      0.137715,
      NULL,
      0.195004,
      NULL,
      0.760425,
      NULL,
      0.604620,
      NULL,
      ' 6- 0-1991',
      6.356554,
      3,
      16,
      0,
      11,
      NULL,
      4,
      9.105002,
      10.573057,
      16.023760,
      22.542480,
      7,
      10,
      2,
      9.604426,
      NULL,
      1,
      25.571494,
      NULL,
      1.037135,
      7.811814,
      9.044692,
      6.995131,
      NULL,
      1.579347,
      7.698956,
      NULL,
      3.547261,
      6,
      20,
      1.278503,
      NULL,
      11.382543,
      5,
      2.098623,
      NULL,
      3,
      0.871512,
      4,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868438,
      3,
      3.849282,
      1.224881,
      10.683998,
      5.870252,
      NULL,
      0.281402,
      7.710261,
      5,
      1,
      NULL,
      13,
      14,
      2.130356,
      NULL,
      NULL,
      21.956569,
      NULL,
      33.469919,
      41.098677,
      0.246685,
      50.989264,
      35,
      NULL,
      NULL,
      25,
      17,
      37.844480,
      25,
      18.665757,
      NULL,
      54,
      2.050956,
      NULL,
      2.136143,
      0,
      NULL,
      2.282116,
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.105418,
      45.072237,
      66,
      107.756141,
      NULL,
      79.904357,
      27,
      NULL,
      75,
      45.831602,
      NULL,
      62.185023,
      51,
      118.276723,
      34,
      NULL,
      53,
      116.449368,
      43.853666,
      152.415210,
      143.600428,
      114,
      101,
      30.715641,
      29,
      67.848255,
      90.564008,
      24.360170,
      70.257393,
      52,
      162.638307,
      127.692210,
      47.182894,
      1.542494,
      160.100710,
      0,
      107,
      108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.084034,
      NULL,
      1.784200,
      5.536591,
      1,
      5,
      0,
      NULL,
      1.067393,
      3,
      1.334181,
      6.063713,
      2.847796,
      NULL,
      NULL,
      2.258506,
      0,
      NULL,
      0.546477,
      3.456261,
      2.172659,
      3,
      NULL,
      3,
      3.542803,
      7,
      3,
      0,
      0,
      6,
      2,
      4.503346,
      NULL,
      1,
      NULL,
      4.556532,
      4.653084,
      1.691833,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.281657,
      4.302637,
      1,
      NULL,
      2,
      NULL,
      5,
      11.402365,
      3.595207,
      NULL,
      2.723800,
      11.681980,
      3,
      NULL,
      3.979799,
      2.177879,
      2.194835,
      8,
      1.164258,
      6.929298,
      0.123935,
      0,
      2.439552,
      4,
      NULL,
      8,
      0,
      3.087270,
      1.269984,
      2,
      0.266287,
      4.317127,
      NULL,
      NULL,
      0,
      1,
      2,
      3,
      2.477221,
      1.714656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.743048,
      1,
      5.453456,
      2.858372,
      5.403880,
      5,
      5.815588,
      NULL,
      2,
      0.602724,
      3.737085,
      1.175406,
      NULL,
      NULL,
      NULL,
      NULL,
      11.293065,
      4.721255,
      8,
      NULL,
      6,
      5.646836,
      0,
      0,
      7.118467,
      3,
      1.225041,
      4.016516,
      0,
      2,
      1,
      NULL,
      7.198665,
      1,
      0.867124,
      4,
      3,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.506464,
      2.554142,
      0.439653,
      1.252051,
      2,
      8.063432,
      1.539182,
      9.571934,
      NULL,
      3,
      NULL,
      0,
      0,
      2.870854,
      3.828020,
      8.203813,
      1.302851,
      5,
      NULL,
      NULL,
      2,
      0.753059,
      2.686410,
      1.785371,
      3,
      3.476713,
      3.887258,
      6,
      4.770442,
      5,
      0,
      2.654567,
      3,
      3.599086,
      0.214636,
      3,
      NULL,
      1.786357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.449803,
      0,
      0.837617,
      1,
      0.094409,
      1,
      0,
      1,
      1,
      2.026161,
      NULL,
      3,
      1.687675,
      1,
      1.555733,
      0,
      0,
      1.388144,
      2.598609,
      NULL,
      1.636340,
      NULL,
      2.879730,
      2.543213,
      0,
      4,
      2,
      4,
      NULL,
      3.346768,
      0.369653,
      1.956348,
      3.574980,
      NULL,
      NULL,
      NULL,
      0.085127,
      1,
      4.293609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.100537,
      1.702568,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      2,
      0,
      1.829739,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1.544636,
      2,
      2.450478,
      NULL,
      3.195427,
      3,
      0.380633,
      7.622058,
      4,
      NULL,
      NULL,
      8.784083,
      3.769889,
      4.519715,
      1.011307,
      NULL,
      2.871521,
      2.613352,
      NULL,
      1.990524,
      11,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647502,
      0.591263,
      1,
      1,
      0.936810,
      NULL,
      1.238281,
      5,
      2.288504,
      0,
      1,
      4,
      1.565539,
      0,
      1.215728,
      2,
      1,
      4,
      NULL,
      3,
      3,
      0.583654,
      3.982394,
      5.360110,
      3.151554,
      4.146231,
      NULL,
      NULL,
      1,
      0,
      0,
      4,
      4.356666,
      1,
      4,
      2.764653,
      3,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.906714,
      NULL,
      1,
      2.973344,
      0,
      1.963404,
      2.017211,
      7.563631,
      NULL,
      NULL,
      1,
      1.378542,
      2,
      1.019860,
      0.219798,
      NULL,
      0.332268,
      3,
      1,
      8,
      1.310116,
      6,
      4,
      0,
      3,
      3.753481,
      2.631838,
      1,
      4,
      2,
      NULL,
      NULL,
      5.469150,
      2,
      5.009323,
      5,
      6.139059,
      0.009775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.012168,
      NULL,
      0,
      3.036176,
      2,
      0.648135,
      1.873406,
      2,
      2,
      NULL,
      NULL,
      1,
      0,
      2,
      1.557883,
      1.732960,
      0,
      0.638142,
      NULL,
      4.715294,
      1,
      1.606886,
      NULL,
      1.650381,
      2,
      1.183687,
      3.145697,
      1,
      5.209865,
      6.704233,
      0.095848,
      1,
      5.301055,
      NULL,
      2,
      1.326645,
      2.546691,
      2,
      11.783056,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.705378,
      3.563316,
      3,
      5,
      5.104636,
      NULL,
      3.961333,
      NULL,
      8,
      NULL,
      1.876181,
      1,
      0,
      0,
      7,
      0.167573,
      2.887867,
      5.617684,
      NULL,
      2.317419,
      5.082359,
      1.817592,
      4,
      7.652376,
      4,
      0.659656,
      1.172368,
      5,
      1.481558,
      1.285814,
      3,
      5.080717,
      4,
      4.537427,
      NULL,
      7.160813,
      NULL,
      NULL,
      1.078130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.333125,
      NULL,
      0,
      4,
      1,
      1.884904,
      0.777301,
      7,
      2.422815,
      8.850468,
      0,
      NULL,
      0,
      1.042557,
      NULL,
      3,
      0.487320,
      9,
      0.863987,
      5.685040,
      0,
      3.161509,
      1,
      1,
      1.129539,
      2.540071,
      0.606777,
      NULL,
      NULL,
      1,
      0.023173,
      1.059951,
      1,
      NULL,
      0.379796,
      0,
      0,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.290516,
      1,
      0.860628,
      1,
      1.225637,
      NULL,
      1.355091,
      0.672965,
      0.191210,
      0,
      NULL,
      1,
      NULL,
      1.732341,
      1,
      0,
      1.118356,
      1,
      1,
      0,
      0.259053,
      1,
      1,
      1.364386,
      NULL,
      1.627642,
      1,
      NULL,
      0,
      0.718514,
      NULL,
      0.847210,
      1.197784,
      NULL,
      NULL,
      0.998308,
      1.069333,
      0.927166,
      NULL,
      0.636955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.596839,
      0.929052,
      NULL,
      1,
      0,
      1.795834,
      NULL,
      0.263483,
      1.383229,
      0,
      1.071003,
      1.944347,
      1.459575,
      NULL,
      NULL,
      0.999242,
      1,
      1.158050,
      0,
      1,
      1,
      0.956277,
      0,
      0.138541,
      1,
      NULL,
      1.814648,
      0,
      1.061147,
      1,
      0.454516,
      1.701356,
      0.801866,
      NULL,
      0,
      1.598400,
      0,
      1.829466,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343140,
      NULL,
      0.102050,
      3.727069,
      4.847495,
      1,
      8,
      2,
      0,
      0,
      NULL,
      3.680604,
      7,
      0.579997,
      NULL,
      0,
      3,
      NULL,
      5.229998,
      0.579322,
      4,
      5.348343,
      1,
      0.951541,
      0.229531,
      5,
      1.096261,
      1,
      3,
      2.742158,
      4.251016,
      2,
      9.032441,
      NULL,
      0.087613,
      NULL,
      2,
      9,
      2.767992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576243,
      0.458193,
      1,
      1,
      NULL,
      0,
      1,
      1.693896,
      0.555704,
      0,
      0.921646,
      3,
      1.645755,
      3.421226,
      3,
      5,
      3.282349,
      2.615214,
      3.356872,
      2,
      0.713007,
      8,
      0.246190,
      0.144610,
      NULL,
      2.858321,
      3,
      3,
      NULL,
      7,
      5,
      NULL,
      4,
      7.896285,
      1,
      2.204705,
      NULL,
      1,
      4,
      2.734678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.350689,
      0,
      0,
      0,
      NULL,
      1.702115,
      0,
      1.613014,
      0,
      1,
      NULL,
      0.180399,
      0,
      0.942190,
      0.965586,
      1,
      0.886479,
      1.421922,
      1.442585,
      0.433610,
      NULL,
      0.947040,
      0.543472,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1.065843,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0.040850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.736697,
      1.370383,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1.621716,
      1.045028,
      1.230479,
      0,
      0.940661,
      0.882823,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1.994837,
      1,
      NULL,
      1.978721,
      0,
      NULL,
      1.278375,
      NULL,
      0.628350,
      NULL,
      0.511227,
      1,
      0,
      NULL,
      0,
      1,
      0.988232,
      1.477508,
      1.516747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      2,
      4,
      2,
      3,
      3,
      0,
      3,
      4,
      2,
      0,
      1,
      3,
      2,
      5,
      3,
      NULL,
      1,
      4,
      2,
      5,
      NULL,
      3,
      3,
      0,
      0,
      3,
      1,
      5,
      1,
      5,
      0,
      1,
      4,
      2,
      NULL,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 9-1977',
      ' 6- 8-1993',
      ' 6- 5-1974',
      ' 8- 0-1984',
      NULL,
      ' 5-14-1988',
      NULL,
      ' 6- 9-1998',
      ' 2- 9-1998',
      NULL,
      ' 1-22-1985',
      ' 5-12-1980',
      ' 9- 7-1982',
      ' 4-22-2003',
      NULL,
      ' 5-14-1977',
      NULL,
      ' 9- 3-2000',
      ' 4-16-1999',
      '10-25-1976',
      ' 9-22-1993',
      NULL,
      NULL,
      NULL,
      ' 4- 2-1988',
      ' 3-24-1992',
      ' 9- 6-1989',
      '10-18-1998',
      ' 5-20-1980',
      ' 0- 7-2002',
      ' 1-24-1974',
      NULL,
      NULL,
      ' 4-28-1991',
      ' 5- 7-1976',
      ' 5- 2-1998',
      ' 6-23-1993',
      ' 2- 3-1986',
      ' 3-26-1999',
      '10- 1-1988',
      ' 3- 7-1999',
      ' 4- 6-1980',
      '11- 0-1979',
      ' 5-17-1980',
      '10-26-1996',
      ' 3-16-1977',
      ' 8- 4-1979',
      NULL,
      ' 2- 1-1974',
      ' 4-10-1986',
      ' 0- 7-1997',
      ' 4-25-1997',
      ' 4-18-1999',
      NULL,
      ' 2- 7-1987',
      NULL,
      ' 2-25-1992',
      ' 5-28-1978',
      ' 8-26-1979',
      ' 4-27-1983',
      NULL,
      ' 4-25-1976',
      '11-17-1979',
      NULL,
      ' 5-22-1982',
      ' 6- 1-1998',
      '10-14-1989',
      ' 7-13-1978',
      ' 7-12-1987',
      ' 5-25-2000',
      ' 2-27-1981',
      NULL,
      NULL,
      ' 9-20-1979',
      ' 7-26-1979',
      ' 1-26-1974',
      '10-23-1975',
      ' 5-11-1974',
      ' 9- 2-1986',
      ' 8-20-2003',
      '11- 0-1977',
      ' 8-17-1979',
      ' 6- 6-1996',
      ' 5-20-1974',
      ' 8-25-1980',
      NULL,
      ' 2- 2-1978',
      ' 0-15-1981',
      ' 1-10-1992',
      ' 3-18-2001',
      ' 8-13-1996',
      NULL,
      '11- 6-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-23-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


