set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '1204004',
      1,
      2,
      2,
      '04103',
      NULL,
      ' 4- 0-1994',
      61,
      NULL,
      0,
      2,
      3.885269,
      1,
      0.280737,
      NULL,
      0,
      2.001830,
      1.267222,
      3.964722,
      0,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4,
      0.206122,
      0.997904,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.170373,
      3,
      4,
      2,
      1,
      0,
      1.278925,
      0,
      0,
      2,
      2,
      1,
      0.229042,
      4,
      NULL,
      3,
      NULL,
      1,
      3.366208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353408,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      82,
      NULL,
      373,
      0,
      NULL,
      NULL,
      200.946498,
      NULL,
      5.609235,
      142,
      3750,
      NULL,
      5,
      134.992063,
      258.922179,
      0,
      1,
      13,
      1659.572121,
      2,
      6,
      39.148266,
      2658.619704,
      NULL,
      7.587669,
      NULL,
      NULL,
      3,
      2.579870,
      96,
      134.765932,
      2,
      NULL,
      130,
      539,
      3.871343,
      3.646071,
      14.485860,
      NULL,
      1.894743,
      8.413845,
      198,
      78,
      3,
      4.314479,
      140.200486,
      295,
      2.515157,
      2,
      103.074173,
      17.263915,
      1,
      NULL,
      178.494198,
      71.404232,
      1.738152,
      3.585512,
      71.531741,
      788,
      2.972420,
      NULL,
      32,
      1562.697082,
      NULL,
      1.082345,
      NULL,
      31.210346,
      1.490889,
      2,
      178.105400,
      64.728560,
      1.121288,
      9,
      241,
      10,
      2.875879,
      0.175242,
      192,
      NULL,
      NULL,
      7,
      NULL,
      239,
      2.677443,
      NULL,
      101.035856,
      5.226265,
      1,
      NULL,
      182,
      663,
      NULL,
      2,
      NULL,
      643,
      NULL,
      1.160465,
      109,
      74.160411,
      NULL,
      5,
      66.158019,
      737.969359,
      0,
      3,
      77,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5,
      5.398674,
      164.411452,
      93,
      2.926696,
      NULL,
      203.107056,
      NULL,
      2.159668,
      0,
      194.888745,
      50,
      5,
      2.086839,
      299.725257,
      7,
      2.195652,
      3,
      181,
      7.127473,
      0,
      0,
      NULL,
      28,
      3.283753,
      NULL,
      112.480333,
      31,
      0.356659,
      8.677406,
      210.810220,
      NULL,
      NULL,
      8,
      NULL,
      16,
      NULL,
      2,
      70.385886,
      6.316867,
      5.770787,
      0,
      NULL,
      NULL,
      5,
      6.697906,
      97.516439,
      15.959965,
      NULL,
      7,
      17,
      13,
      NULL,
      8,
      NULL,
      3.821955,
      1,
      1.223414,
      27,
      2342,
      0,
      NULL,
      738,
      NULL,
      1.291458,
      2,
      NULL,
      6,
      2.678686,
      0,
      NULL,
      3.340267,
      2,
      2.890587,
      NULL,
      NULL,
      NULL,
      3,
      655.790642,
      1561.895304,
      1.280286,
      3,
      119.777720,
      11,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '03401',
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      1,
      30.299358,
      340,
      0.829972,
      NULL,
      NULL,
      NULL,
      0.777259,
      NULL,
      1.337421,
      NULL,
      0.346838,
      NULL,
      1.428177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 0-2000',
      1,
      11.182037,
      10,
      NULL,
      NULL,
      0.601311,
      14,
      6,
      4,
      2,
      14,
      1,
      NULL,
      6,
      14.891945,
      2.777468,
      6,
      NULL,
      0.124579,
      4.664346,
      0,
      17.138697,
      4,
      5,
      NULL,
      6,
      13,
      NULL,
      14.030108,
      NULL,
      1.803294,
      9,
      4,
      2,
      7,
      2.270907,
      0,
      0.205331,
      11,
      6.135544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800791,
      2.975494,
      2.438574,
      1,
      11.097440,
      1,
      NULL,
      0.848413,
      1,
      11,
      2.223637,
      NULL,
      NULL,
      NULL,
      4.141686,
      NULL,
      33,
      9,
      13.173531,
      NULL,
      41.461724,
      7,
      NULL,
      25.028935,
      17,
      NULL,
      3,
      5,
      17,
      13.834018,
      15,
      13.684436,
      24,
      2,
      30,
      2.028862,
      1.541993,
      20.997329,
      3.801877,
      4,
      32.030568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      103,
      NULL,
      95.260240,
      94.942688,
      102.492459,
      NULL,
      49.115028,
      NULL,
      NULL,
      17.984645,
      130.341495,
      129,
      NULL,
      NULL,
      71,
      16.886017,
      79.313545,
      NULL,
      14,
      22.425604,
      36.272567,
      113,
      49,
      44,
      126.049696,
      20,
      130,
      NULL,
      NULL,
      142.074954,
      152.296616,
      126,
      NULL,
      57.008640,
      108.165510,
      19,
      NULL,
      150.969183,
      97.188397,
      NULL,
      70.679840,
      116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.576704,
      NULL,
      2,
      5,
      3.672000,
      1.900598,
      NULL,
      NULL,
      3,
      0,
      0,
      7,
      NULL,
      4,
      1,
      3.928889,
      3,
      7.542961,
      NULL,
      1.517357,
      1.260319,
      NULL,
      3.816128,
      1,
      NULL,
      7,
      1,
      NULL,
      2.336208,
      0,
      3,
      1.640776,
      3,
      2.092753,
      NULL,
      1.133507,
      5.816137,
      0,
      5.383398,
      2.517001,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.473016,
      2.521036,
      0.941346,
      9,
      NULL,
      NULL,
      5.625798,
      3,
      4.577618,
      3,
      0,
      6,
      NULL,
      8,
      NULL,
      7.869324,
      3,
      7.708533,
      0.155166,
      7.747491,
      1.758924,
      5,
      1.753088,
      NULL,
      3.848766,
      5,
      3.776391,
      NULL,
      2,
      1.415676,
      0,
      5,
      1.273221,
      5.889841,
      2,
      NULL,
      2,
      3,
      3,
      1,
      1.494805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      0,
      7,
      NULL,
      NULL,
      0.014837,
      NULL,
      2,
      5,
      NULL,
      1,
      2,
      NULL,
      0.073325,
      NULL,
      3.829756,
      11.025704,
      0,
      5,
      3.199626,
      5.653263,
      NULL,
      0.870981,
      2.498209,
      1.899201,
      NULL,
      0.877416,
      5.792557,
      7.957254,
      3.271916,
      NULL,
      3,
      1.949862,
      NULL,
      3.362605,
      2,
      1.000762,
      8.413461,
      1.516952,
      3.716758,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.108790,
      2,
      1,
      0,
      1,
      5.334509,
      NULL,
      7.582411,
      2.289676,
      2,
      1,
      5,
      1,
      3.574320,
      NULL,
      7,
      0,
      4.097232,
      1,
      0.067619,
      1.855781,
      3.351832,
      2.792616,
      3.289735,
      NULL,
      1,
      NULL,
      0,
      4.444573,
      4.786787,
      2.075028,
      NULL,
      0,
      2.669594,
      1.257653,
      1.776808,
      1,
      0.418431,
      0.089813,
      1.937778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730055,
      1.227940,
      1.042933,
      0,
      0,
      NULL,
      1.956133,
      1,
      0.881229,
      3.151444,
      0.370390,
      2,
      1.165006,
      1,
      2.202913,
      NULL,
      0.553603,
      2.269137,
      0.375455,
      1.556686,
      1.199774,
      1.103102,
      3.299459,
      3,
      4.202617,
      3.451220,
      1.997185,
      4.392224,
      NULL,
      1,
      NULL,
      3,
      3,
      0.362252,
      3,
      1,
      0.180943,
      2.064011,
      6,
      3.985637,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.163998,
      1.170447,
      1,
      1.176108,
      1.533842,
      2.435407,
      3,
      3.092832,
      NULL,
      2,
      0,
      1.642214,
      NULL,
      1.031421,
      0,
      0.122938,
      1,
      NULL,
      1,
      0.760792,
      0.482366,
      1,
      0,
      7,
      4,
      3,
      NULL,
      5.361100,
      1,
      2,
      3,
      4.733998,
      1.933292,
      NULL,
      1.435287,
      3,
      6.536107,
      0.878755,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.403424,
      0.348626,
      0.884997,
      3,
      2,
      NULL,
      1,
      0.506667,
      5.583976,
      NULL,
      NULL,
      0.673554,
      3.738133,
      0.310477,
      2,
      3.830534,
      2.700600,
      NULL,
      2,
      4,
      5,
      NULL,
      2.261452,
      3.844473,
      1,
      0.320095,
      3.517717,
      2.544823,
      6.310790,
      NULL,
      1.869068,
      4,
      4.836542,
      1.694983,
      1.814919,
      NULL,
      0,
      6,
      NULL,
      1.101856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.837017,
      NULL,
      1,
      2.646415,
      1,
      3.201211,
      0,
      4,
      0,
      1,
      3.841763,
      NULL,
      3.956140,
      3,
      NULL,
      5,
      3.968530,
      1,
      5,
      6.591702,
      1,
      4,
      1,
      7,
      NULL,
      7.877694,
      4.449262,
      2.894767,
      1.914177,
      7,
      5,
      6,
      2.294294,
      3.955339,
      NULL,
      4.919372,
      2.992682,
      NULL,
      5.572799,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.255263,
      1,
      1.787850,
      0,
      0.562848,
      NULL,
      2.793229,
      2.328925,
      0,
      1,
      0,
      NULL,
      3,
      4.195075,
      NULL,
      5,
      2,
      4,
      NULL,
      1.211772,
      0,
      3.202663,
      NULL,
      4,
      1.195996,
      5.389523,
      2,
      5,
      NULL,
      5,
      NULL,
      2.026419,
      2,
      NULL,
      2.472782,
      NULL,
      1.824303,
      1.348656,
      0.332094,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.947926,
      4,
      0.516323,
      3,
      4.578631,
      1.201473,
      2.429945,
      NULL,
      3,
      4,
      0.256525,
      NULL,
      0.881397,
      1.366820,
      3.198473,
      3,
      0,
      4.883336,
      5.108928,
      NULL,
      2.230067,
      NULL,
      1.420874,
      1.916136,
      5,
      3,
      0.623006,
      0,
      5,
      0,
      NULL,
      4.310927,
      NULL,
      4,
      0.784533,
      1,
      NULL,
      1.938728,
      6.990375,
      5.651670,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      4.512931,
      0,
      NULL,
      0.336064,
      NULL,
      2.358156,
      5.578147,
      0.366544,
      1.743146,
      3,
      NULL,
      0.132269,
      3.415598,
      0,
      0.207051,
      0,
      1,
      1.827202,
      NULL,
      0.852697,
      1,
      0,
      NULL,
      0.496007,
      3.662449,
      0.637511,
      5,
      NULL,
      2,
      0.638020,
      1.483333,
      0.611166,
      1,
      0.062548,
      NULL,
      0,
      1,
      NULL,
      1.983973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714215,
      NULL,
      NULL,
      0,
      1.089745,
      1.017438,
      0.610682,
      1,
      1,
      1.696448,
      1.513900,
      0.945492,
      1.435163,
      0,
      1,
      0,
      1,
      NULL,
      1.013811,
      NULL,
      1,
      0.698494,
      1,
      0.925437,
      0.175803,
      1,
      0.937820,
      0,
      NULL,
      NULL,
      1.208894,
      NULL,
      1.376726,
      1.417696,
      1,
      0.663310,
      1,
      1.398201,
      0.909561,
      0,
      0.527659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295893,
      0,
      1.895166,
      1.346078,
      0,
      1.341230,
      NULL,
      1,
      0.549317,
      NULL,
      0,
      0,
      1,
      0,
      0.969050,
      NULL,
      0,
      NULL,
      1,
      0.520814,
      1.934957,
      0,
      0.301316,
      1.347858,
      1,
      NULL,
      0,
      NULL,
      0.826543,
      NULL,
      1.478030,
      0.583667,
      0,
      0.813656,
      1,
      1,
      1,
      0.368062,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.708978,
      7.187514,
      0.012233,
      3.057040,
      5,
      8,
      1.326147,
      5.321891,
      3.216078,
      2.724132,
      2,
      NULL,
      1.334239,
      4,
      2.198623,
      5.798983,
      0,
      7,
      0.070752,
      NULL,
      2,
      NULL,
      2.783657,
      5.425060,
      0.970615,
      1.303096,
      1,
      NULL,
      1.017565,
      NULL,
      NULL,
      NULL,
      3.851179,
      7.240166,
      4,
      2.765624,
      4.859757,
      1,
      6.275326,
      2.291393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.188822,
      1,
      2.949995,
      NULL,
      1,
      0.726391,
      4,
      NULL,
      NULL,
      0.574918,
      3.371696,
      1.701085,
      NULL,
      3.853312,
      0,
      NULL,
      1,
      0.375606,
      1,
      NULL,
      7,
      0.592149,
      NULL,
      NULL,
      0,
      3,
      3.473324,
      NULL,
      8,
      5,
      0,
      2.397814,
      4.440256,
      0,
      2.273708,
      4,
      0.720883,
      10.917959,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.982374,
      1,
      1,
      0.099173,
      1,
      0,
      0.268278,
      0.737606,
      NULL,
      0,
      0,
      0,
      NULL,
      0.104562,
      0,
      NULL,
      1.146255,
      NULL,
      0.913126,
      0,
      0,
      1,
      1,
      0.242999,
      1.838537,
      0,
      0,
      0.455298,
      1.636650,
      1.850394,
      0,
      1,
      0.100773,
      1.029958,
      1,
      0.663012,
      1,
      0,
      1,
      NULL,
      1,
      0.300141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.799311,
      0.650678,
      NULL,
      1,
      1.646581,
      1.341016,
      1,
      0,
      0,
      0.314036,
      1,
      0.464984,
      NULL,
      1.449947,
      1,
      1,
      1.792497,
      1.003812,
      0.946905,
      0,
      NULL,
      1.145235,
      1,
      0.565233,
      0,
      1.253128,
      0.667548,
      1,
      0,
      1.175417,
      NULL,
      NULL,
      0,
      1.223891,
      0,
      1.172752,
      0,
      0,
      1.501117,
      1.030913,
      1.792977,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      2,
      4,
      2,
      NULL,
      1,
      3,
      3,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      4,
      NULL,
      4,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      5,
      0,
      1,
      3,
      5,
      NULL,
      0,
      2,
      1,
      NULL,
      2,
      4,
      0,
      4,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 2-1984',
      ' 1- 2-1997',
      NULL,
      ' 8- 2-1986',
      ' 6-18-2003',
      ' 4- 0-1998',
      ' 8-16-1975',
      ' 9-16-1987',
      NULL,
      ' 4-17-1979',
      ' 6- 8-2001',
      '11-24-1977',
      ' 4-13-1979',
      NULL,
      '10- 2-1999',
      ' 1-10-1978',
      '10-15-1992',
      '11- 6-1988',
      ' 9-22-1997',
      NULL,
      ' 5-24-1988',
      ' 6-15-1974',
      ' 6-18-1987',
      ' 4-27-1982',
      ' 6- 2-1977',
      ' 6-20-1984',
      ' 1-13-1994',
      '11-11-1996',
      ' 7-17-1983',
      NULL,
      ' 8-19-1978',
      ' 3-22-1982',
      '11-10-1977',
      '10- 5-1984',
      ' 4- 7-1979',
      ' 1- 2-1980',
      NULL,
      ' 1-29-1996',
      NULL,
      ' 3-15-1999',
      ' 6- 3-1992',
      ' 2-12-1990',
      '11-15-1983',
      ' 6- 2-1983',
      ' 6- 3-1991',
      ' 5- 1-2003',
      ' 0- 2-1997',
      ' 7- 2-1989',
      '11-17-2001',
      ' 0-26-1977',
      ' 7-28-1979',
      ' 6- 3-1982',
      ' 2-28-1983',
      ' 1-10-1988',
      ' 1-15-1979',
      ' 9-18-1978',
      ' 5- 5-1985',
      ' 0- 6-1996',
      ' 4- 6-1976',
      ' 8-17-1989',
      ' 3- 3-1982',
      ' 1- 8-1995',
      ' 8-18-2000',
      ' 2-15-1997',
      NULL,
      ' 0- 6-1991',
      NULL,
      ' 5- 8-1996',
      ' 5- 2-1999',
      ' 8-15-1996',
      NULL,
      ' 2-10-1980',
      ' 7-19-1981',
      ' 9- 4-1986',
      ' 8-20-1981',
      ' 2-22-1980',
      NULL,
      ' 8-15-2001',
      NULL,
      ' 9-25-1992',
      ' 9-17-1993',
      ' 5-21-1987',
      NULL,
      ' 4-13-1991',
      NULL,
      ' 7-11-1997',
      '10- 1-2001',
      ' 1- 4-2001',
      '10-17-1996',
      ' 9- 5-1974',
      NULL,
      ' 3- 1-1979',
      ' 6-13-1979',
      ' 1-16-1999',
      '11-20-1983',
      NULL,
      ' 6-19-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-15-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


