set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215884';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '304',
      '12422301',
      57.563093,
      45,
      '2204312',
      NULL,
      1.370279,
      NULL,
      '30010',
      4,
      NULL,
      95,
      NULL,
      NULL,
      NULL,
      3.944768,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      0.729186,
      NULL,
      7,
      NULL,
      NULL,
      2.186949,
      NULL,
      1.634358,
      15.017374,
      1.399993,
      2.692447,
      NULL,
      NULL,
      3.677769,
      3.380194,
      0.638075,
      4.178419,
      NULL,
      NULL,
      1,
      5,
      5,
      0,
      1,
      NULL,
      2,
      6,
      0,
      0,
      5,
      NULL,
      6,
      NULL,
      5,
      7,
      7,
      1,
      NULL,
      1,
      0.502270,
      NULL,
      NULL,
      0.254033,
      1,
      2.413389,
      5,
      3.601765,
      2,
      0,
      NULL,
      5.707794,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.474873,
      1.361396,
      NULL,
      0,
      4,
      NULL,
      0,
      NULL,
      140,
      NULL,
      NULL,
      0,
      122,
      NULL,
      3,
      1,
      697.927407,
      5.146680,
      NULL,
      1.171405,
      NULL,
      NULL,
      3.825131,
      1.171365,
      74,
      3.535390,
      NULL,
      2.887913,
      66,
      2.991720,
      2,
      0.000694,
      453.644039,
      NULL,
      2,
      NULL,
      558.687224,
      1492.410493,
      NULL,
      2.148640,
      NULL,
      186,
      0,
      3.128114,
      527,
      114.084030,
      NULL,
      NULL,
      600,
      8.239477,
      1,
      NULL,
      63,
      136.152696,
      NULL,
      0,
      90,
      185.935927,
      NULL,
      3.198517,
      416,
      3,
      2,
      0.458316,
      NULL,
      13,
      3.034002,
      3,
      760,
      10.728194,
      0.519134,
      2.755788,
      NULL,
      3,
      1,
      2.327257,
      351,
      16.318189,
      NULL,
      NULL,
      182.129835,
      34.453722,
      1.698202,
      1.454981,
      667,
      82.360379,
      3,
      0,
      793,
      NULL,
      2,
      1,
      170.661741,
      121,
      NULL,
      3.170099,
      227,
      107.342151,
      1,
      NULL,
      NULL,
      24.558012,
      3,
      NULL,
      235.363803,
      4.378457,
      3,
      NULL,
      129,
      154.792185,
      2,
      2,
      403,
      NULL,
      NULL,
      0.217758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.045190,
      '40443',
      '12304',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      7.064552,
      '43210',
      '2020',
      NULL,
      3,
      0,
      NULL,
      1,
      338,
      NULL,
      NULL,
      0,
      NULL,
      0.249594,
      NULL,
      1,
      NULL,
      0,
      89.472825,
      1.779496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-17-1984',
      25.473440,
      NULL,
      6,
      10.581451,
      NULL,
      6,
      NULL,
      2.536116,
      16,
      3.366873,
      0.074903,
      NULL,
      3,
      7.541154,
      12,
      NULL,
      11.925205,
      12.909025,
      9,
      17.112758,
      21,
      11.075950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.104278,
      NULL,
      1,
      NULL,
      16.223343,
      NULL,
      8.128313,
      NULL,
      NULL,
      6,
      5,
      7.481133,
      12,
      35.651110,
      3.921949,
      25.460979,
      NULL,
      42,
      29.159170,
      26,
      32,
      3.598666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      87.504987,
      53,
      114.710430,
      143,
      132,
      191.954635,
      0.789164,
      NULL,
      NULL,
      1.742807,
      NULL,
      0.007052,
      NULL,
      NULL,
      2.350617,
      NULL,
      7.513580,
      NULL,
      0,
      6.126826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783723,
      2.616332,
      5.450902,
      4.070838,
      6,
      1,
      0.553831,
      5.514045,
      6.667085,
      1,
      NULL,
      2,
      NULL,
      NULL,
      4,
      2,
      9.610249,
      1.388927,
      6,
      1.141406,
      0.684936,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.842181,
      1,
      1,
      1.325523,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.734512,
      1.685607,
      0,
      1.342270,
      2,
      4.183896,
      5.707505,
      4.524167,
      3.164792,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.916897,
      0,
      1,
      1.625239,
      NULL,
      1.823946,
      0,
      1,
      0.575385,
      0.053533,
      1.668009,
      0.917237,
      0,
      NULL,
      0,
      1,
      NULL,
      1.143747,
      1.534818,
      1.296888,
      0.118416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.318991,
      NULL,
      6,
      4,
      NULL,
      2.477623,
      1.820137,
      1,
      5,
      1.800353,
      2.432213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.790620,
      1,
      1,
      0.178948,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0.712220,
      NULL,
      NULL,
      0,
      1,
      0.395909,
      0.389625,
      1.468606,
      1.914974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.144765,
      5.692059,
      3,
      2,
      NULL,
      2.215905,
      6.814625,
      5,
      2,
      7,
      5.066826,
      1,
      3.757673,
      4.362725,
      6,
      NULL,
      4,
      0.049669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      3.894828,
      3,
      1.046129,
      9.177209,
      3.562032,
      6.711953,
      9.723955,
      NULL,
      7,
      5,
      4.537497,
      3.947482,
      2,
      3,
      8.997775,
      NULL,
      7.569702,
      5.356325,
      0.119434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.880994,
      2,
      NULL,
      4,
      3,
      3,
      4,
      5,
      4,
      3.278232,
      2,
      2.089057,
      NULL,
      0.675979,
      NULL,
      1.445390,
      3.414287,
      3.597892,
      2,
      1.875481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584076,
      1,
      1.958322,
      0.929131,
      1,
      0.657506,
      NULL,
      1.457301,
      1,
      NULL,
      1.512567,
      1,
      0.416017,
      1.373504,
      0,
      0.079863,
      1,
      1.524251,
      0.061959,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.218714,
      NULL,
      NULL,
      0.301957,
      0,
      0,
      1.722956,
      0.236537,
      1,
      NULL,
      1.342258,
      1,
      0.553205,
      1.863629,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.515547,
      0.107804,
      1,
      0.787077,
      0.910024,
      1.064480,
      1,
      0.078611,
      0.006039,
      NULL,
      1,
      0,
      0,
      1,
      0.631383,
      0,
      1.914030,
      0.326836,
      0,
      NULL,
      0.270070,
      0.787546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.097738,
      1,
      1,
      0.684469,
      1.582065,
      5,
      5,
      4.006201,
      5.994838,
      0,
      5,
      NULL,
      3,
      NULL,
      1.736564,
      0.305212,
      1.698434,
      1,
      1,
      2,
      3.628411,
      1.212602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4.526018,
      3.089329,
      4.995560,
      2.784694,
      3,
      1,
      2.065317,
      7.087293,
      NULL,
      2.953275,
      6.294170,
      5,
      0.082964,
      4.370952,
      6.181422,
      2,
      2,
      5.882183,
      4,
      3.868741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.586791,
      NULL,
      2.147882,
      3,
      0.834970,
      2,
      NULL,
      NULL,
      7.855983,
      NULL,
      NULL,
      NULL,
      4,
      6,
      6,
      9,
      2,
      NULL,
      0.870594,
      3.714600,
      3.641483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      6.226515,
      7,
      7,
      3,
      7.321963,
      4,
      NULL,
      1.453270,
      3,
      0,
      8,
      3,
      0,
      1,
      3,
      0.762150,
      7,
      5,
      7.694620,
      3,
      6.710214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.861825,
      1.464272,
      0,
      0,
      0.988379,
      0,
      1.700166,
      0,
      1,
      0,
      1.912631,
      0.700729,
      1.030575,
      0,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      0.567640,
      1.137940,
      3.406605,
      2.587852,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.828067,
      0,
      1.509115,
      NULL,
      0,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      2,
      0,
      3,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      4,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      2,
      3,
      0,
      1,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      3,
      3,
      2,
      5,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      2,
      2,
      0,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      2,
      2,
      0,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      3,
      0,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-13-1977',
      '10- 7-1998',
      ' 9-27-1992',
      ' 1-19-1982',
      ' 5-27-1997',
      NULL,
      '11-11-2002',
      '10-17-1991',
      ' 1-27-1977',
      ' 3-14-1999',
      NULL,
      NULL,
      NULL,
      ' 3-20-1974',
      NULL,
      ' 8- 8-1977',
      ' 6-25-1984',
      '10- 4-2003',
      '11-29-2000',
      NULL,
      ' 8-29-1975',
      NULL,
      ' 2- 9-1998',
      ' 3- 4-1993',
      NULL,
      ' 8-16-1998',
      NULL,
      ' 2-21-1992',
      ' 9-24-1993',
      NULL,
      ' 9- 4-1984',
      ' 5- 6-1993',
      '11-24-2003',
      '10- 0-1981',
      ' 1-10-1989',
      ' 4-28-1983',
      ' 3-12-1995',
      NULL,
      ' 3-17-1985',
      ' 4- 2-1990',
      ' 1-12-1996',
      ' 6-24-1985',
      NULL,
      ' 1-10-1999',
      ' 8- 3-1982',
      NULL,
      ' 2-22-1985',
      ' 5-14-1991',
      NULL,
      ' 4- 0-1991',
      '11-11-1986',
      NULL,
      ' 1-21-1975',
      ' 5- 3-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-11-1988',
      NULL,
      ' 6-28-1986',
      ' 0-18-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


