set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9223065';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      NULL,
      NULL,
      '4424240',
      1,
      2.668591,
      2,
      '40102',
      2,
      ' 8-17-1994',
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      3.774853,
      NULL,
      NULL,
      0.071481,
      1.704495,
      4,
      NULL,
      NULL,
      NULL,
      1.650474,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      5,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      0,
      0,
      1,
      0.723861,
      1,
      NULL,
      NULL,
      0,
      6.400906,
      2,
      3,
      7,
      NULL,
      1,
      2,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.724815,
      NULL,
      4,
      0,
      NULL,
      1.112687,
      1,
      72,
      49.617468,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3,
      6.335854,
      2.422312,
      146,
      2,
      2.745380,
      69.861887,
      250.126744,
      2,
      7.669891,
      111.145214,
      184.602621,
      0.448360,
      3.522036,
      134.540013,
      264,
      1.537908,
      3,
      NULL,
      NULL,
      1,
      4.762643,
      75.391304,
      54.640971,
      3,
      6.251748,
      179.884168,
      364,
      3.735293,
      3.439570,
      13.543659,
      NULL,
      2.646402,
      1.498515,
      NULL,
      497,
      1.716824,
      7.708617,
      115,
      424.270074,
      NULL,
      6,
      48,
      246.221262,
      2.029381,
      3.999021,
      91,
      218.205998,
      NULL,
      1.548995,
      198.297509,
      234.166234,
      2,
      4,
      14,
      69,
      2.225030,
      6,
      54,
      38.861343,
      NULL,
      6.435161,
      171,
      5.200381,
      2.179458,
      0,
      NULL,
      NULL,
      2.632540,
      5.359443,
      9,
      18.986658,
      2.628332,
      5.635799,
      NULL,
      64,
      8.446401,
      NULL,
      178,
      185,
      9,
      NULL,
      196,
      13,
      3.711245,
      2,
      27,
      86.359992,
      NULL,
      5.485241,
      NULL,
      NULL,
      2.287382,
      4,
      90,
      NULL,
      NULL,
      NULL,
      21.584446,
      82.020629,
      NULL,
      NULL,
      NULL,
      NULL,
      3.910602,
      NULL,
      NULL,
      65.921638,
      2.457318,
      2.400102,
      52.788830,
      84,
      NULL,
      7.082473,
      155,
      35,
      0.455962,
      NULL,
      80.711225,
      245.611425,
      0,
      7.473869,
      127.892840,
      NULL,
      2.398381,
      NULL,
      225,
      NULL,
      1,
      4.010448,
      136,
      166,
      1.140418,
      2,
      187.461358,
      NULL,
      2,
      NULL,
      NULL,
      1.575176,
      1,
      1,
      NULL,
      5.782481,
      3,
      1.012148,
      NULL,
      3,
      2.153251,
      5,
      2.763907,
      2.026964,
      2.992539,
      4.890089,
      162.864724,
      NULL,
      2,
      1.836096,
      20.642249,
      193,
      1,
      9.885668,
      57.610120,
      164.785155,
      1.398563,
      4,
      97,
      NULL,
      NULL,
      NULL,
      376,
      NULL,
      1.925762,
      4.019472,
      41.570339,
      63,
      NULL,
      7,
      449.454690,
      25.562791,
      3.086133,
      1.394399,
      NULL,
      74.386561,
      2,
      0,
      392.821020,
      286,
      NULL,
      5.370875,
      447.856686,
      115.290174,
      0,
      3,
      NULL,
      NULL,
      NULL,
      3.830360,
      379,
      54,
      3.649281,
      NULL,
      298,
      1196.435403,
      NULL,
      5.456451,
      282,
      888.689194,
      1.996574,
      7,
      NULL,
      1398,
      0,
      9.157160,
      220,
      3.561895,
      3.328029,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '00431',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      0.943374,
      '',
      '',
      '',
      5,
      1,
      NULL,
      1.343425,
      18.210386,
      1.515387,
      NULL,
      0.593096,
      NULL,
      0.432631,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      7.125487,
      2.995119,
      3.044933,
      4.818434,
      3.398511,
      2,
      1,
      0.002813,
      NULL,
      1,
      5.181385,
      NULL,
      0,
      1.815061,
      9.068311,
      NULL,
      2.756550,
      14,
      3,
      NULL,
      0,
      13.870393,
      8.699055,
      11,
      NULL,
      NULL,
      8.887276,
      8.907586,
      4,
      3,
      0.708648,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      14,
      NULL,
      58.901851,
      5.949993,
      13,
      NULL,
      11,
      15.949904,
      NULL,
      45.748204,
      3,
      13.556600,
      NULL,
      NULL,
      3,
      45.474569,
      NULL,
      15,
      NULL,
      3,
      25,
      NULL,
      14.593944,
      29,
      46.823722,
      1.045074,
      4,
      28.125643,
      39.962086,
      9.070565,
      5.774867,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      100,
      138.300430,
      11,
      135,
      NULL,
      NULL,
      104,
      17,
      106,
      60,
      0.655809,
      166.711828,
      88.048827,
      140,
      1.573695,
      135.538441,
      142.849368,
      NULL,
      91,
      89.554092,
      61.498201,
      73.774654,
      NULL,
      28.108304,
      138,
      158,
      69.625824,
      NULL,
      NULL,
      133.322913,
      60.441684,
      NULL,
      64,
      115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.389753,
      1,
      0,
      4,
      3,
      5.847899,
      1.623193,
      7.079588,
      1,
      NULL,
      NULL,
      NULL,
      1.590342,
      NULL,
      1,
      1.199237,
      1.260104,
      6,
      0.823735,
      2,
      2.387280,
      2.957931,
      5.195145,
      2.867445,
      5.969640,
      NULL,
      8,
      5.404342,
      5,
      3,
      5,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.794125,
      0.320099,
      0,
      1,
      5,
      0,
      0,
      0,
      NULL,
      1,
      0.697279,
      NULL,
      1.260779,
      NULL,
      NULL,
      1.348662,
      0.618581,
      1,
      9,
      0.245121,
      1.846158,
      NULL,
      1.470913,
      NULL,
      2,
      0,
      2.894233,
      3,
      0,
      1,
      1.919264,
      0.662297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.610282,
      1,
      3,
      1,
      8,
      NULL,
      1.347078,
      1.923528,
      5,
      0,
      7.228381,
      0.849644,
      NULL,
      NULL,
      2.723601,
      1.454483,
      1.701937,
      0,
      0,
      0.437974,
      5.893263,
      0.192726,
      NULL,
      0.098814,
      4.122964,
      0.670719,
      4.014860,
      0.426251,
      1,
      4.392196,
      NULL,
      1,
      1.599852,
      0.740067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.627498,
      1,
      0.807680,
      3,
      1,
      1,
      1.313928,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.566200,
      3.387348,
      4.489476,
      6,
      NULL,
      NULL,
      1.268149,
      5.218881,
      NULL,
      5.413508,
      9,
      4.895177,
      0,
      6.566731,
      0.496579,
      4,
      2.216795,
      3.091166,
      3.584991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.903033,
      0,
      1.607547,
      3,
      0,
      1,
      NULL,
      1,
      1.797846,
      1.016078,
      0.440626,
      NULL,
      0.693086,
      1.392329,
      0.345781,
      1,
      0,
      0,
      NULL,
      0.073978,
      NULL,
      8,
      NULL,
      1,
      3,
      0.773079,
      4.500226,
      6,
      6.242669,
      1,
      2,
      0.857830,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241687,
      1,
      0,
      6.139758,
      NULL,
      6.942114,
      NULL,
      NULL,
      6.663679,
      0,
      8,
      5,
      1.365643,
      2,
      6.604648,
      5.051545,
      6,
      6,
      NULL,
      0,
      8,
      4,
      9,
      2.204510,
      0.839378,
      5.550481,
      4.516603,
      5,
      6,
      7,
      3,
      0,
      3,
      2.789829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.917030,
      4.881144,
      2.372068,
      NULL,
      0,
      2,
      0,
      NULL,
      1.198081,
      3.561936,
      4.171404,
      7.093906,
      3.163301,
      1.027571,
      1,
      NULL,
      1.411345,
      4,
      1.721048,
      3.660920,
      0.311840,
      2,
      0,
      5.698904,
      5,
      3.246529,
      1.995053,
      2,
      6.163713,
      6,
      5,
      3.655008,
      5.690115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1.764567,
      6.339116,
      1.569413,
      6,
      NULL,
      0.692340,
      1.756309,
      2,
      NULL,
      4,
      1.247346,
      NULL,
      2,
      2,
      0.574396,
      NULL,
      NULL,
      0,
      4.805132,
      3.014029,
      NULL,
      NULL,
      0,
      5.038330,
      0,
      1.746749,
      NULL,
      NULL,
      3.583583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982472,
      1,
      NULL,
      0.303354,
      1.642282,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0.656589,
      3,
      0,
      5.542537,
      1.631772,
      0.336428,
      1,
      6,
      0,
      0,
      1.068067,
      3,
      1,
      3,
      0.826817,
      NULL,
      2,
      2,
      1,
      NULL,
      1.630860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.952908,
      5,
      0,
      4.584472,
      0.548760,
      0,
      NULL,
      0.848062,
      0,
      NULL,
      0,
      NULL,
      0,
      1.921823,
      1.858110,
      0.134122,
      0.612716,
      1.071443,
      1.981364,
      7.504355,
      0.054869,
      3,
      7.567717,
      5,
      4,
      NULL,
      NULL,
      5.604310,
      6,
      0,
      0,
      4.938726,
      2.535048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.989460,
      1,
      0.478794,
      0,
      0.777818,
      0,
      0.725530,
      1.628567,
      1.283618,
      1.314207,
      1,
      0,
      1,
      0,
      0,
      0.876781,
      0,
      1,
      0,
      0,
      0.566974,
      1,
      NULL,
      1.673174,
      NULL,
      1,
      0,
      1,
      NULL,
      1.198052,
      1,
      0.107689,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993349,
      0.500930,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      3,
      NULL,
      1.462567,
      3.907288,
      1,
      0.709199,
      0,
      NULL,
      0.852734,
      5,
      3,
      7.418602,
      2.180445,
      1,
      3,
      0,
      0.169357,
      1,
      5.280842,
      3,
      4,
      1.327853,
      1,
      1.605061,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527943,
      1,
      1.563989,
      0,
      1,
      1.280965,
      0.506105,
      NULL,
      0,
      0,
      7,
      NULL,
      4.975925,
      1,
      1.918353,
      0.134241,
      NULL,
      1.101744,
      0.978654,
      1,
      0,
      NULL,
      3,
      4.628218,
      5.750206,
      1.535289,
      5.484319,
      NULL,
      3.086509,
      3,
      1.129928,
      NULL,
      1,
      1.611512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.205603,
      1,
      NULL,
      1.701733,
      2,
      3.517291,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0.652573,
      0.421344,
      1,
      7,
      0,
      NULL,
      3.262708,
      6.250052,
      1,
      1,
      3,
      9.072797,
      6,
      NULL,
      NULL,
      3.019263,
      8.969004,
      5.043088,
      1,
      2,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165005,
      0,
      7.128563,
      NULL,
      1,
      5.031129,
      4.360742,
      2,
      3.970898,
      2,
      3.803444,
      2.203291,
      6,
      5,
      7,
      4,
      1.818285,
      3,
      0.235000,
      NULL,
      4.583688,
      NULL,
      2,
      1,
      8,
      1.253859,
      8,
      NULL,
      3,
      0,
      NULL,
      5.543450,
      1.706397,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755957,
      1.849348,
      0.636891,
      0,
      0,
      NULL,
      1.925588,
      NULL,
      0.428161,
      NULL,
      0.117094,
      1,
      1,
      1.704033,
      0.845013,
      NULL,
      0,
      1,
      NULL,
      0.620972,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0.035403,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692763,
      NULL,
      0,
      0.439150,
      0.567810,
      0.585901,
      0.870202,
      0.894561,
      NULL,
      0,
      0.756428,
      1,
      1,
      1,
      0,
      1.936146,
      0.208489,
      1,
      1.954594,
      NULL,
      1.021186,
      0,
      1,
      0.602802,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.886864,
      1.961030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      3,
      3,
      2,
      2,
      0,
      3,
      1,
      0,
      NULL,
      2,
      2,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      0,
      3,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      2,
      1,
      3,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      3,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-29-1997',
      ' 1-26-1980',
      '10-23-1978',
      ' 8-28-1994',
      NULL,
      ' 8-22-1999',
      ' 6-25-1983',
      NULL,
      NULL,
      ' 7-22-1983',
      ' 1-29-2000',
      ' 6- 0-1985',
      NULL,
      ' 7-11-1978',
      ' 3-20-1992',
      ' 2- 5-1999',
      ' 8- 1-1984',
      ' 2- 4-1994',
      ' 7-23-1993',
      ' 7-28-1974',
      NULL,
      '10-27-1989',
      ' 8- 3-1992',
      ' 5-28-1999',
      ' 2-22-1982',
      ' 6-21-1990',
      ' 6-27-1974',
      ' 6- 9-1998',
      ' 1-18-1992',
      NULL,
      ' 3-10-1977',
      '11-20-1982',
      '10-18-1992',
      ' 7-15-1980',
      ' 9- 2-2001',
      ' 8-19-2000',
      ' 1-11-1984',
      ' 6- 8-1974',
      ' 8- 3-1981',
      ' 4- 9-1999',
      '10-26-1976',
      ' 0-28-1998',
      ' 5-24-1987',
      NULL,
      ' 8-22-1983',
      ' 6- 9-1991',
      NULL,
      ' 5-28-1987',
      '10- 7-1979',
      ' 6-26-1992',
      ' 4-20-2001',
      NULL,
      ' 4- 5-1981',
      '11- 3-1983',
      NULL,
      ' 3- 5-1977',
      NULL,
      ' 0- 5-1985',
      ' 7- 5-1999',
      ' 8-11-1995',
      ' 3-23-2003',
      '11-15-1978',
      ' 1-11-1998',
      ' 6- 1-1992',
      ' 8-29-1977',
      NULL,
      '11- 8-1996',
      ' 9-15-1990',
      '10-26-1981',
      ' 4- 1-1988',
      '11-10-2000',
      ' 2- 5-1988',
      ' 3- 5-1980',
      NULL,
      ' 9-14-1983',
      '10-27-1980',
      ' 9-26-1994',
      '11- 9-1974',
      NULL,
      ' 5- 3-1978',
      ' 9-20-1995',
      ' 5-20-1975',
      ' 0-18-1993',
      ' 2- 2-2001',
      ' 8- 2-1976',
      NULL,
      NULL,
      ' 4-24-1981',
      '10-22-1982',
      NULL,
      NULL,
      NULL,
      ' 3-15-1995',
      ' 7- 3-2002',
      NULL,
      ' 0-10-1980',
      ' 3- 8-1999',
      ' 8- 9-1991',
      ' 8-12-1997',
      ' 1- 6-1981',
      ' 2- 2-1987',
      NULL,
      ' 6-27-1998',
      ' 3-21-1999',
      ' 8- 4-1995',
      NULL,
      ' 9-18-1979',
      ' 5-23-1974',
      NULL,
      NULL,
      ' 2-19-1980',
      ' 5- 9-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 4-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.624720);
commit;
end;
/


