set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7712658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      '0430304',
      2,
      2,
      0,
      '10140',
      1.531545,
      '10-25-1976',
      50.026781,
      NULL,
      0,
      3,
      NULL,
      0.224139,
      1.903318,
      2,
      2,
      3,
      1.354665,
      NULL,
      0.751491,
      5,
      1,
      NULL,
      3,
      NULL,
      0.923649,
      NULL,
      3,
      1,
      0,
      NULL,
      4.386226,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      7,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      4,
      2.250957,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.952582,
      0,
      3,
      NULL,
      2.540491,
      2.727874,
      9,
      0,
      5,
      NULL,
      7,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.279908,
      6,
      1,
      4,
      8,
      NULL,
      0.587225,
      690,
      591.061511,
      2.551262,
      7.323428,
      759.248955,
      1247,
      2,
      NULL,
      656,
      1430.855462,
      2.289524,
      7.885396,
      557.491806,
      NULL,
      0,
      NULL,
      NULL,
      1355,
      NULL,
      6.703914,
      NULL,
      1382,
      2,
      3.470724,
      140.022462,
      25,
      3.354455,
      0.623497,
      930.636923,
      11.191565,
      NULL,
      1.088956,
      NULL,
      12.485198,
      3,
      3.119986,
      22,
      19.566278,
      3.004539,
      3.510795,
      6,
      218,
      3.948496,
      3,
      196,
      13.884142,
      2.644505,
      6,
      81.220792,
      1.600164,
      2.661505,
      0.483827,
      231,
      54,
      NULL,
      1.042311,
      60.480970,
      NULL,
      NULL,
      NULL,
      1369,
      323,
      0.342708,
      0,
      560.885792,
      1433,
      NULL,
      4,
      209.220084,
      NULL,
      2,
      6.943155,
      NULL,
      1368,
      3,
      18.941767,
      120,
      NULL,
      1.998929,
      7.045447,
      NULL,
      73,
      2,
      2,
      30,
      3,
      2,
      3.410277,
      24,
      0.281529,
      NULL,
      3.199320,
      159,
      9,
      NULL,
      0.217920,
      106,
      1.054406,
      2.439263,
      2,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '04243',
      NULL,
      '24000',
      '33010',
      '12203',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      0.754502,
      67,
      3.666864,
      NULL,
      NULL,
      3.501699,
      1,
      NULL,
      2.104268,
      2,
      1,
      NULL,
      3.131364,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      15.708173,
      8.164724,
      2.799907,
      2,
      2.681776,
      5.549988,
      NULL,
      14.224512,
      15.857683,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      14.769990,
      4,
      NULL,
      NULL,
      0.513219,
      12.341461,
      0,
      11,
      13.180990,
      2.641454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7,
      19.091987,
      13.706700,
      20.917664,
      6,
      11.116776,
      10.012109,
      23,
      0,
      NULL,
      4.961621,
      NULL,
      1,
      3.091197,
      8.884940,
      9,
      1.198922,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      86.196209,
      NULL,
      NULL,
      NULL,
      90.579951,
      112.758009,
      NULL,
      128.985281,
      98,
      NULL,
      120.065242,
      NULL,
      78.440278,
      8,
      10.539294,
      101.912817,
      NULL,
      61,
      82,
      NULL,
      NULL,
      46,
      88.377307,
      40.805671,
      58.358532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      3.665288,
      7.547567,
      0.757841,
      NULL,
      7.370539,
      6.189414,
      5,
      0,
      1.071915,
      0.931776,
      4,
      0,
      5,
      1,
      NULL,
      5,
      7,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      9,
      4,
      1,
      NULL,
      0,
      7,
      9.932243,
      1.178888,
      4,
      4,
      3.577414,
      10.722915,
      7,
      8,
      1,
      2.054937,
      2,
      7,
      6.423961,
      0.788888,
      NULL,
      0.868126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.044867,
      4,
      3,
      1.111750,
      1,
      3,
      0.016329,
      3,
      2.718382,
      NULL,
      0.964585,
      1,
      NULL,
      0.087548,
      0.164215,
      1,
      1.735595,
      1,
      1.462796,
      2.944423,
      1.543324,
      0.529170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.768535,
      2,
      NULL,
      4,
      2,
      NULL,
      1,
      3,
      NULL,
      7.576975,
      NULL,
      0,
      1,
      0.470861,
      0,
      NULL,
      5.105672,
      4.496029,
      8.965943,
      2,
      3,
      0.261845,
      6.916601,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647093,
      0.515266,
      1.341541,
      1,
      0.196708,
      3,
      0,
      NULL,
      3.433128,
      NULL,
      0,
      1.363823,
      0,
      1,
      0.356289,
      3.791963,
      5,
      NULL,
      0,
      1.625502,
      1,
      1.249607,
      1.663779,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      0.020763,
      1,
      NULL,
      4,
      5,
      0,
      3,
      1.753064,
      3.460742,
      NULL,
      2,
      0,
      3.825546,
      0.780992,
      NULL,
      4.478519,
      1.359711,
      NULL,
      4.717025,
      3.106729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.371233,
      NULL,
      5,
      1.218500,
      1.404931,
      1.976432,
      5.681763,
      1.758507,
      7.029860,
      2.868763,
      2.570001,
      1,
      3.949505,
      NULL,
      2,
      5.900310,
      NULL,
      5.895401,
      4,
      1.489636,
      3.777333,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231824,
      1.819160,
      1.162116,
      NULL,
      0.633303,
      0.612564,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      4,
      1,
      4,
      1.109508,
      4.784217,
      4.720432,
      5.319477,
      5.167656,
      0.093299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.434105,
      0.971278,
      3.480473,
      1,
      0.103422,
      0,
      1,
      3,
      0,
      0,
      1,
      2.403577,
      0,
      3,
      2,
      4.322789,
      2,
      1.440105,
      0.517717,
      3,
      4,
      2.286771,
      0.008691,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.199078,
      1.517101,
      0,
      2.006474,
      0,
      6.299607,
      1.215267,
      NULL,
      6,
      NULL,
      2,
      NULL,
      1.703593,
      0,
      3.288137,
      0,
      1.784692,
      1,
      6,
      4.969375,
      2,
      2.643945,
      1,
      0.476688,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640929,
      2.221038,
      1,
      NULL,
      NULL,
      5.968991,
      2,
      1,
      1,
      2,
      3.855348,
      0,
      0,
      NULL,
      1.601997,
      NULL,
      3,
      2.151973,
      3.417178,
      5.919313,
      3,
      NULL,
      1,
      1.863152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234984,
      0.177660,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      4.134556,
      1,
      NULL,
      1,
      2.798244,
      1.794245,
      5.464468,
      NULL,
      0,
      2,
      0,
      0,
      1,
      3.072907,
      3.466821,
      NULL,
      1.420826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.607896,
      NULL,
      0.049756,
      4.250790,
      6,
      3.045028,
      0.672521,
      1.956126,
      0.766099,
      0.742554,
      0.619305,
      NULL,
      0.857555,
      1,
      0.667829,
      1,
      0,
      2.038673,
      0,
      0.067243,
      NULL,
      0.624847,
      0.994476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245464,
      1,
      0,
      9,
      7,
      6.423204,
      2.804742,
      2.677017,
      2.058519,
      2,
      5,
      3.518192,
      2.633944,
      0.569348,
      9.601155,
      1,
      7,
      6.831082,
      7,
      0.674291,
      NULL,
      7.268858,
      NULL,
      1.744114,
      1.791060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.916280,
      3,
      1,
      5,
      NULL,
      4,
      2.931917,
      9.108755,
      6.707363,
      NULL,
      0.928561,
      0,
      NULL,
      0,
      0,
      1.581178,
      2,
      1.040639,
      NULL,
      2.769669,
      NULL,
      7,
      2.471868,
      NULL,
      0.860032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.083103,
      NULL,
      4,
      0.288367,
      NULL,
      NULL,
      0.689274,
      5.245503,
      0,
      0,
      1,
      0.550923,
      0.972158,
      1.389073,
      0,
      3,
      5.868410,
      0.857818,
      2.232710,
      1,
      0.889275,
      1,
      1.515587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0,
      5.869961,
      1,
      1,
      0,
      1,
      3,
      0.377302,
      6.941359,
      5.803511,
      0,
      4,
      1,
      0.899145,
      3.171195,
      2.582471,
      0.915227,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      NULL,
      4,
      NULL,
      7,
      4,
      1,
      1,
      1,
      0,
      0,
      4,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      6,
      4,
      3,
      6,
      0,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      4,
      3,
      3,
      3,
      2,
      1,
      5,
      NULL,
      0,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-26-1989',
      ' 5-27-1985',
      NULL,
      ' 3-23-1992',
      ' 3- 4-1998',
      ' 1-10-2000',
      NULL,
      ' 2-23-1989',
      '10-12-1985',
      ' 7-17-1996',
      ' 0-12-1994',
      ' 5-15-1982',
      '11- 2-1988',
      ' 3-29-2003',
      ' 0-13-1980',
      NULL,
      ' 1- 1-1976',
      ' 5-18-1997',
      ' 3-29-1997',
      ' 3-27-1999',
      ' 2- 7-2002',
      ' 5-20-2002',
      ' 4-27-1997',
      ' 6-15-1978',
      ' 0-21-1994',
      ' 0-17-1998',
      ' 4-13-1985',
      ' 0- 9-2001',
      ' 6-23-1998',
      ' 6-26-1984',
      ' 5-24-1983',
      ' 9- 0-1978',
      ' 1-21-1993',
      '11-13-1981',
      ' 9-10-1990',
      ' 1-16-1999',
      NULL,
      ' 4- 5-1993',
      ' 7-10-1994',
      ' 3- 5-1982',
      NULL,
      NULL,
      '11- 5-1997',
      ' 3- 6-1999',
      ' 0-10-1999',
      NULL,
      NULL,
      NULL,
      ' 9-29-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 0-1975',
      ' 6-14-1976',
      ' 5- 5-1985',
      ' 5-26-1979',
      NULL,
      '11-19-1991',
      NULL,
      ' 0-22-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


