set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303748';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-4-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      1,
      0.482970,
      NULL,
      NULL,
      NULL,
      '11- 8-1985',
      47,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.313596,
      NULL,
      NULL,
      1.026945,
      9,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.719119,
      NULL,
      NULL,
      0,
      0.500818,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      0,
      NULL,
      4,
      0,
      0,
      0,
      2,
      1,
      2.400650,
      7,
      4.863867,
      NULL,
      0.390979,
      2,
      1.678674,
      0.846043,
      3,
      3,
      NULL,
      3.075632,
      2.195435,
      0,
      2.713012,
      0,
      NULL,
      2,
      9.069969,
      0.651696,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      1,
      1,
      2,
      3,
      0,
      2.463146,
      71.704427,
      42,
      1,
      NULL,
      200,
      33,
      2,
      3.466274,
      31.607536,
      1,
      3.236557,
      NULL,
      168,
      201,
      NULL,
      1,
      37,
      4.614351,
      1.599486,
      1,
      975.988479,
      2.471274,
      1,
      2,
      92.267880,
      299,
      2.898300,
      2,
      NULL,
      1,
      1,
      1.984295,
      383.903084,
      5.806713,
      2.409942,
      NULL,
      203,
      0,
      NULL,
      0,
      77.317895,
      136,
      2.142862,
      1,
      592.942355,
      NULL,
      2,
      9.201250,
      304.243982,
      8,
      0.797283,
      2.254658,
      65.972210,
      28,
      1,
      NULL,
      NULL,
      NULL,
      2.146606,
      0.121464,
      NULL,
      0.252093,
      3.609870,
      0,
      228,
      74,
      3,
      2.788970,
      NULL,
      81,
      0.454184,
      1.404268,
      NULL,
      NULL,
      3.947518,
      NULL,
      73,
      18.742618,
      3,
      2.095716,
      530,
      17,
      0,
      NULL,
      108,
      2.414205,
      0.183300,
      0,
      NULL,
      4,
      1.106608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      '13132',
      '33323',
      '42404',
      '',
      '',
      '',
      0.761419,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      0,
      0.071578,
      NULL,
      0,
      205.936492,
      1,
      NULL,
      0.368179,
      NULL,
      3,
      2,
      0,
      NULL,
      2,
      320,
      1,
      NULL,
      0,
      NULL,
      1.726933,
      NULL,
      ' 9-20-1994',
      NULL,
      5,
      8,
      4.386170,
      19,
      16.307405,
      4.834997,
      NULL,
      2.863868,
      5,
      17.113443,
      21.235569,
      20.275862,
      NULL,
      NULL,
      19,
      9.548940,
      6,
      1,
      6,
      NULL,
      NULL,
      17.008270,
      NULL,
      0,
      1.085300,
      1.291741,
      6.998367,
      6.302116,
      NULL,
      5.284429,
      2.890770,
      7.431213,
      5.068216,
      7,
      5.358302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.009075,
      3,
      13,
      NULL,
      NULL,
      0,
      24.065540,
      9.515098,
      30.905464,
      NULL,
      3,
      7.740871,
      20,
      37.538905,
      0.360148,
      NULL,
      15.857502,
      3.964227,
      25,
      43,
      0,
      35.752492,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      13.247681,
      26,
      40,
      19.176148,
      1.971477,
      NULL,
      29,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      147,
      101,
      12.937371,
      NULL,
      162.233959,
      91,
      80.193960,
      33.510866,
      NULL,
      NULL,
      117,
      141.097154,
      82.204845,
      121.669785,
      175.731435,
      2,
      NULL,
      66,
      56.678454,
      152,
      177.474526,
      NULL,
      123,
      NULL,
      11,
      2.496270,
      NULL,
      85,
      40.901567,
      0.496007,
      11.694653,
      153.381175,
      95,
      85,
      NULL,
      99.959641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.088832,
      NULL,
      6,
      3,
      3,
      5,
      NULL,
      NULL,
      7.961208,
      NULL,
      0.243771,
      3.426838,
      3.723664,
      6,
      6,
      6.845153,
      2,
      8,
      2,
      0.223420,
      7,
      2,
      2,
      9.761289,
      0.532032,
      3,
      5,
      1.301333,
      4,
      3,
      7,
      2,
      0,
      6,
      6.019111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      8,
      NULL,
      3.136643,
      NULL,
      1,
      NULL,
      1.776029,
      3.851954,
      1,
      3,
      5.669966,
      4,
      7.100236,
      NULL,
      4.785272,
      NULL,
      6,
      4.096863,
      8.682588,
      5.143705,
      2.075764,
      3.039342,
      5.530780,
      1.011590,
      9,
      3,
      4,
      2.453731,
      5,
      1.611872,
      3.818750,
      7,
      1.046646,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890017,
      0,
      5.594711,
      6.104198,
      0.082780,
      NULL,
      0.473932,
      4,
      0,
      NULL,
      1.508976,
      NULL,
      NULL,
      1.636697,
      5.250717,
      0.470509,
      2,
      NULL,
      4.371226,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      0,
      3.059672,
      NULL,
      3,
      3,
      3.001417,
      4,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.662234,
      6,
      4.356315,
      4.143296,
      7.441697,
      NULL,
      3,
      NULL,
      NULL,
      3.351551,
      1,
      NULL,
      1.403709,
      1.539885,
      0.431022,
      5,
      0,
      6.626025,
      0,
      1.114004,
      2,
      3,
      1.661055,
      7,
      NULL,
      5,
      5,
      2.613523,
      4.223025,
      5,
      3.041606,
      9,
      NULL,
      7,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      9,
      0.643797,
      3,
      4,
      1,
      0.659360,
      1.603055,
      2.593777,
      0.378788,
      1.859717,
      0,
      0,
      1,
      0.636096,
      0.315069,
      1.773079,
      1.372267,
      0.759270,
      4.610071,
      4,
      5.228956,
      1.248386,
      NULL,
      3,
      3.511157,
      5.407248,
      2,
      NULL,
      4,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      NULL,
      3.447358,
      2.376546,
      7,
      8,
      5.719486,
      7,
      3,
      NULL,
      3.621735,
      0,
      NULL,
      5.155964,
      0.482730,
      1.406859,
      6,
      0.136484,
      4.035089,
      5.107223,
      2,
      NULL,
      NULL,
      3,
      7,
      0,
      4.061648,
      0.610882,
      0,
      5,
      8.672754,
      2,
      1.475442,
      6.917082,
      7.357078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      7,
      2,
      0.424329,
      NULL,
      NULL,
      5,
      5.179336,
      2,
      NULL,
      0.795658,
      NULL,
      NULL,
      3,
      3.433154,
      6,
      7,
      1,
      1.638088,
      NULL,
      7.164010,
      2.819809,
      NULL,
      5.335666,
      4.939576,
      7,
      6,
      6.292862,
      5,
      6.315734,
      3,
      NULL,
      2.829210,
      0,
      7,
      7.750872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.918930,
      NULL,
      9,
      4,
      4,
      5,
      6,
      NULL,
      0,
      4,
      5,
      NULL,
      1.099870,
      3,
      3.693350,
      8.022396,
      3.637697,
      NULL,
      NULL,
      0.402246,
      NULL,
      6,
      4.596700,
      9.753307,
      3.658513,
      7.986972,
      5.287450,
      5,
      NULL,
      2.613440,
      NULL,
      6.899239,
      5,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      8,
      0,
      0.247542,
      1,
      1.798348,
      0,
      0.345306,
      1,
      1,
      3.856678,
      2.834717,
      2.035861,
      1.595062,
      1,
      0.872340,
      NULL,
      3.201252,
      0,
      NULL,
      1.871600,
      1,
      0.944767,
      NULL,
      NULL,
      0.323119,
      1,
      2,
      5.271951,
      3.306391,
      5.987746,
      4.951090,
      2.117150,
      0.390399,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.990234,
      0.142609,
      1.319822,
      1.612231,
      0,
      4.628883,
      1.732942,
      1.290121,
      0.557837,
      NULL,
      0,
      1.583370,
      1.046972,
      0,
      1.803891,
      0.316149,
      0.278605,
      1.157852,
      0,
      0.549408,
      2.447903,
      7,
      NULL,
      7.400329,
      7.490769,
      NULL,
      5,
      0.812945,
      1.385845,
      0.246044,
      1,
      3.481571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.078267,
      1,
      1,
      0.328880,
      0.369793,
      NULL,
      0.249299,
      0,
      0.205402,
      0,
      0.274613,
      1.840032,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1.109172,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      1.348930,
      0,
      1,
      0.174363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0,
      5,
      8,
      2,
      3.499584,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.266197,
      0,
      3,
      2,
      NULL,
      4,
      9,
      1.962987,
      1.945647,
      1,
      3,
      0,
      4.353124,
      4,
      0,
      0.618382,
      3,
      0.276532,
      0,
      1.643947,
      1.064707,
      1.999305,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.627618,
      0,
      1.831504,
      1.764181,
      0,
      0.404398,
      NULL,
      0,
      NULL,
      0.704284,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1.517104,
      1.188843,
      1,
      0.877243,
      1.321536,
      7,
      0.204138,
      4.470204,
      1.047837,
      NULL,
      1,
      4,
      NULL,
      5.640554,
      5,
      NULL,
      0.230802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.016970,
      6,
      3,
      9,
      4.593813,
      1,
      1,
      2.719917,
      6,
      NULL,
      6,
      2,
      4.056755,
      0,
      NULL,
      2,
      5.563887,
      8,
      3.280025,
      2,
      4.843848,
      5.133315,
      2.610311,
      7.242198,
      6,
      4,
      7.319316,
      1.780057,
      9,
      8.722873,
      NULL,
      NULL,
      7.410740,
      1,
      9,
      4.041753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.871288,
      3,
      5.696065,
      0,
      4.731616,
      NULL,
      5,
      2,
      3.329256,
      5.713573,
      6.131425,
      1.323806,
      1,
      NULL,
      0,
      0,
      7,
      1.455016,
      4,
      4,
      4.783360,
      4,
      NULL,
      NULL,
      7.551942,
      NULL,
      7,
      1.213501,
      4.883295,
      9.667179,
      7.703853,
      NULL,
      NULL,
      NULL,
      5.444645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494056,
      1.904205,
      NULL,
      1,
      0.793524,
      1,
      NULL,
      0.327134,
      0.836516,
      1,
      0,
      1,
      1,
      1,
      0.085728,
      0,
      NULL,
      1,
      0.569471,
      1,
      1.313634,
      1.650310,
      1,
      1,
      NULL,
      1.923458,
      0,
      0.678750,
      1.531116,
      NULL,
      1.070329,
      0.736687,
      0.374515,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.185991,
      1,
      NULL,
      3.740594,
      1.180308,
      0,
      NULL,
      0,
      0.246960,
      NULL,
      3,
      1,
      NULL,
      3,
      1,
      NULL,
      1,
      4,
      3.567227,
      0,
      1.991257,
      0.651881,
      2.360328,
      5,
      3.353060,
      1.176972,
      1,
      0,
      3,
      2,
      NULL,
      0.253841,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      0,
      NULL,
      7,
      4,
      1,
      1,
      1,
      3,
      0,
      5,
      NULL,
      4,
      0,
      6,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1,
      5,
      3,
      NULL,
      3,
      0,
      2,
      2,
      NULL,
      1,
      4,
      1,
      2,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      3,
      NULL,
      1,
      2,
      3,
      3,
      3,
      4,
      NULL,
      0,
      4,
      NULL,
      0,
      0,
      0,
      5,
      0,
      NULL,
      0,
      4,
      3,
      3,
      3,
      0,
      2,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-29-1993',
      NULL,
      ' 0- 0-1985',
      NULL,
      NULL,
      ' 3-10-1983',
      ' 4-22-1985',
      ' 2-13-1978',
      ' 8-13-1981',
      NULL,
      ' 4-24-1990',
      ' 6- 5-2000',
      ' 7- 6-1996',
      ' 9-25-2001',
      ' 8- 4-1983',
      '10- 5-2001',
      NULL,
      ' 5-13-1983',
      '11-17-1994',
      '10-18-1995',
      ' 5- 5-1976',
      '11-10-1995',
      NULL,
      ' 0-16-1987',
      ' 3-27-1994',
      ' 5-27-2000',
      '10-16-1980',
      ' 1- 4-2002',
      ' 5- 5-1986',
      ' 4-14-1989',
      ' 8-17-1976',
      NULL,
      ' 3-17-1991',
      '10- 6-1979',
      ' 9-29-2000',
      NULL,
      NULL,
      ' 6- 4-1996',
      ' 0- 8-1999',
      NULL,
      NULL,
      NULL,
      ' 8- 3-1999',
      NULL,
      '10-11-1985',
      '11-12-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-21-1986',
      ' 1-21-1979',
      ' 0- 9-1977',
      NULL,
      ' 2-23-1987',
      ' 4-13-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


