set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9537000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '100',
      '22202322',
      39,
      13.682031,
      '2032320',
      NULL,
      NULL,
      0,
      NULL,
      4.947539,
      ' 9-12-2002',
      NULL,
      NULL,
      1.198693,
      5,
      1.763964,
      NULL,
      0,
      0,
      1.355955,
      1,
      NULL,
      3.426019,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      11.846992,
      6,
      2,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      4,
      NULL,
      5.782911,
      0,
      1.200360,
      NULL,
      0,
      0.695208,
      0,
      3,
      0.607502,
      1,
      NULL,
      7,
      NULL,
      NULL,
      7,
      NULL,
      1.883565,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      0,
      3,
      NULL,
      2,
      9.540473,
      NULL,
      14.300417,
      0.568498,
      2.872777,
      160,
      4.734873,
      3.224624,
      1.544148,
      193,
      7,
      NULL,
      NULL,
      NULL,
      8.404216,
      3.469661,
      NULL,
      368,
      164,
      3,
      2.813325,
      325,
      NULL,
      0.441148,
      8.271400,
      84.601687,
      245,
      1.863540,
      2.163465,
      92,
      1,
      3.190947,
      6,
      172.546562,
      3,
      2,
      NULL,
      NULL,
      5.526165,
      2.798348,
      4,
      199.834995,
      7,
      NULL,
      0,
      45.720520,
      1.324357,
      NULL,
      NULL,
      184,
      5.271226,
      NULL,
      NULL,
      24,
      0,
      NULL,
      NULL,
      112,
      18.045958,
      NULL,
      1.297105,
      NULL,
      10.718841,
      2.876009,
      NULL,
      NULL,
      9.148339,
      3,
      3.926753,
      204,
      NULL,
      NULL,
      1.492227,
      97.286637,
      149,
      0.436020,
      7,
      4.958373,
      NULL,
      NULL,
      2,
      249.784457,
      NULL,
      2,
      0,
      213.267356,
      90.008946,
      2,
      3.239402,
      360.572931,
      203,
      2,
      2,
      504,
      123.896512,
      3,
      1,
      179,
      10,
      1,
      1.162832,
      483.386932,
      0,
      2.415987,
      3.943716,
      195,
      0,
      1.898017,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.441281,
      '20010',
      NULL,
      '',
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      3,
      1,
      NULL,
      NULL,
      210.181012,
      0.213944,
      NULL,
      1.321681,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.854262,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.792678,
      NULL,
      NULL,
      11.178442,
      2,
      17,
      19,
      8.064008,
      0,
      1.867900,
      NULL,
      9.725531,
      5.513190,
      10.201286,
      NULL,
      6.269767,
      7,
      11,
      9.260762,
      7.747097,
      8.471238,
      15.387558,
      17,
      3,
      6.864190,
      17,
      5,
      4,
      0,
      12.911715,
      0.186118,
      18,
      1.398851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      10.613660,
      54,
      NULL,
      3.706154,
      7,
      1,
      0.571889,
      NULL,
      30,
      41.529088,
      20.267358,
      2.258024,
      18.342380,
      6.275450,
      NULL,
      4.024791,
      24.349568,
      35,
      NULL,
      1.393740,
      4.465320,
      6,
      51.874251,
      12.758855,
      28,
      11,
      26.699372,
      11,
      6.005698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.276897,
      26,
      49,
      65.050250,
      46.581878,
      104.370308,
      85.974888,
      NULL,
      52.137087,
      166,
      38.021506,
      88.733215,
      134.151643,
      25.725039,
      3.958132,
      3.323077,
      1.798555,
      NULL,
      3,
      5,
      2,
      1.377070,
      7,
      0.683803,
      3.405794,
      NULL,
      2.874126,
      3,
      1.509580,
      5.976676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.909011,
      NULL,
      4.751589,
      1.191206,
      9,
      NULL,
      NULL,
      0,
      0.928366,
      NULL,
      8,
      1,
      8.918845,
      NULL,
      NULL,
      NULL,
      4.726633,
      9.325732,
      7.976762,
      8,
      NULL,
      4,
      3,
      NULL,
      4,
      1.417254,
      6.101298,
      10,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018191,
      0.588651,
      2,
      0.398727,
      NULL,
      6.648392,
      5,
      9.737057,
      NULL,
      7,
      0.728916,
      4,
      3.576124,
      4.826503,
      3,
      3.362933,
      7,
      1,
      3.183725,
      2.814837,
      4,
      1,
      4.471246,
      5,
      NULL,
      5,
      4.243075,
      NULL,
      3.562864,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8.631772,
      5.897171,
      7,
      5.148022,
      2,
      1,
      0.264882,
      5.772022,
      0,
      NULL,
      NULL,
      5,
      2,
      5.720107,
      4.410959,
      6.607288,
      4,
      NULL,
      3.639415,
      0.775626,
      0,
      NULL,
      NULL,
      4.439203,
      1.925637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257673,
      0,
      2.696562,
      3,
      5.620504,
      NULL,
      3.195230,
      0,
      6,
      5,
      NULL,
      4.098106,
      7,
      0.852998,
      2.801269,
      6,
      NULL,
      1,
      5,
      1,
      4,
      NULL,
      2.727813,
      4.898012,
      0.615083,
      NULL,
      NULL,
      NULL,
      0,
      7.403565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      4,
      6,
      5.998775,
      NULL,
      NULL,
      4.596660,
      0.478231,
      2,
      2,
      4.330557,
      1.988130,
      NULL,
      2,
      4.078978,
      5.863587,
      2,
      3.389479,
      1,
      5,
      2.503008,
      NULL,
      1,
      3.286639,
      5,
      1,
      4.290094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.269933,
      3,
      0.193917,
      4,
      6,
      NULL,
      NULL,
      8,
      NULL,
      3.131454,
      4.049307,
      1.544515,
      3,
      6.689329,
      5,
      NULL,
      4,
      7.703171,
      1,
      NULL,
      NULL,
      0.939749,
      9.005550,
      NULL,
      9,
      1,
      0,
      6.294537,
      6.563242,
      2.210543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.205899,
      1.681152,
      4,
      1,
      0,
      0,
      3.107597,
      NULL,
      6,
      4,
      NULL,
      NULL,
      1.378546,
      1.241941,
      2,
      2.345620,
      6.964159,
      1.802945,
      NULL,
      0.916572,
      4.835666,
      5.125874,
      6,
      2.067404,
      2,
      NULL,
      8,
      3,
      5.857229,
      4.037454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      3.314268,
      1.206255,
      4,
      1,
      5,
      5.445459,
      2.042955,
      0,
      2.565103,
      4,
      3,
      1,
      3.854164,
      NULL,
      0.089036,
      1.646819,
      3,
      2.546135,
      0,
      2.452977,
      2,
      3.479116,
      NULL,
      1.681611,
      1.050806,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.163289,
      2,
      4,
      6,
      0.795272,
      NULL,
      2.574562,
      NULL,
      3.000419,
      1,
      NULL,
      0,
      6,
      1,
      2,
      1.215369,
      1.021992,
      3.002244,
      4,
      5.710321,
      NULL,
      2,
      4,
      5.469540,
      4,
      3,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.631812,
      1.518274,
      1.262517,
      1,
      0.540949,
      NULL,
      0,
      NULL,
      0.393015,
      0.224099,
      1.350426,
      0.274333,
      NULL,
      0.762311,
      0.576862,
      0.069793,
      NULL,
      0,
      0.105560,
      1.239315,
      NULL,
      0,
      0.078395,
      1.903458,
      1,
      1.908737,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      0,
      2,
      0.919616,
      1.309432,
      1,
      0.680820,
      1,
      0,
      1.180038,
      1.901141,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1.541165,
      0.061141,
      0,
      0.753259,
      1.754634,
      0,
      1,
      1.217205,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.485665,
      1,
      0.089171,
      1,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0.365426,
      NULL,
      NULL,
      0.895691,
      1.074149,
      1.602589,
      0.532264,
      0,
      0,
      3,
      NULL,
      NULL,
      0.241914,
      1.232053,
      0,
      1,
      1.076742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.903482,
      3,
      1.466042,
      0,
      1.886780,
      3.980223,
      4.882953,
      0.052666,
      3.819503,
      2,
      0,
      6.068468,
      2.377999,
      3.812132,
      3,
      6,
      2,
      5,
      0,
      NULL,
      2.744299,
      NULL,
      2,
      4.470728,
      1,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.948772,
      1.061384,
      3,
      0.636158,
      3,
      4,
      7,
      3.175142,
      1,
      10.192997,
      6.201500,
      5,
      NULL,
      8.465578,
      3.452286,
      8.810131,
      NULL,
      0,
      NULL,
      7.930298,
      5.502543,
      6.427734,
      8,
      9.359124,
      1.192490,
      5,
      4,
      3,
      6,
      9.645573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.108648,
      3,
      0.607960,
      5.355000,
      3,
      1,
      3.912246,
      7,
      7,
      5,
      6.213931,
      7,
      6,
      1,
      5.260973,
      0,
      1.283729,
      7.749694,
      1,
      4.833035,
      1,
      7.220241,
      8.237845,
      8,
      3.284252,
      9.192868,
      2.791862,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674648,
      1,
      1,
      NULL,
      0,
      NULL,
      0.725368,
      0.050970,
      NULL,
      NULL,
      0,
      0,
      1.004071,
      0.959156,
      0.751369,
      0.412232,
      NULL,
      1.885976,
      0,
      0,
      1,
      NULL,
      1,
      1.048431,
      1,
      0,
      NULL,
      1.900449,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0.370226,
      NULL,
      0,
      NULL,
      0.725159,
      0.795087,
      NULL,
      0.820120,
      1.526399,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.889506,
      1,
      2,
      0,
      2,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      3,
      0,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5,
      4,
      3,
      1,
      NULL,
      1,
      1,
      5,
      1,
      3,
      NULL,
      0,
      NULL,
      2,
      0,
      3,
      3,
      3,
      2,
      1,
      4,
      NULL,
      4,
      3,
      2,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-12-1975',
      NULL,
      ' 3- 0-1996',
      ' 5-25-1994',
      ' 4-23-1976',
      NULL,
      ' 0- 9-1984',
      ' 8- 6-1986',
      ' 6-28-1981',
      ' 4-28-1988',
      NULL,
      NULL,
      '11- 3-1998',
      ' 5- 0-1980',
      ' 9-28-2002',
      '10-11-1975',
      ' 8-13-2002',
      ' 1- 9-1993',
      ' 2-11-1996',
      ' 7- 3-1995',
      ' 2-29-1994',
      ' 7-24-2000',
      NULL,
      NULL,
      ' 7-19-1974',
      ' 5-21-1974',
      NULL,
      ' 7- 4-1977',
      NULL,
      ' 2-16-1977',
      NULL,
      NULL,
      ' 0- 6-1985',
      '10- 5-1991',
      ' 3-26-1985',
      ' 6-12-1995',
      ' 9-25-1975',
      ' 4-24-1994',
      ' 5-25-1989',
      ' 6-11-1979',
      '11- 1-1982',
      '10- 4-1979',
      ' 2-28-1992',
      NULL,
      ' 2- 7-1984',
      NULL,
      ' 2-13-1991',
      NULL,
      NULL,
      ' 2- 0-1999',
      ' 9- 9-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-13-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


