set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005690';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '4220321',
      2,
      1,
      1,
      '11310',
      1,
      NULL,
      23,
      NULL,
      0.277446,
      0,
      3.194962,
      1.181856,
      1,
      2,
      NULL,
      3.760855,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.238770,
      3.023943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811556,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      5,
      4,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1,
      3.109555,
      9,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.572665,
      0,
      0,
      6,
      8.119038,
      4,
      2.307083,
      3,
      0.079080,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      0,
      0,
      4.055770,
      NULL,
      0.734541,
      144,
      NULL,
      0,
      3,
      52,
      2697.894319,
      3.555897,
      1.337661,
      151,
      54,
      NULL,
      1.878747,
      352.119127,
      5,
      0,
      3,
      107.426462,
      39.898565,
      NULL,
      5.004575,
      NULL,
      103,
      NULL,
      7,
      239,
      44,
      3,
      NULL,
      170,
      85,
      2.235208,
      1.694870,
      NULL,
      10,
      1.808258,
      5,
      212.402765,
      230,
      2.654850,
      5.661946,
      NULL,
      10,
      5.983177,
      NULL,
      143,
      11.162582,
      3,
      1.301892,
      180.765623,
      6.116539,
      2,
      NULL,
      913.800331,
      10.161208,
      0.040831,
      0,
      142.037078,
      NULL,
      NULL,
      5.882485,
      338,
      29,
      1.190948,
      1,
      120.999027,
      95,
      1,
      NULL,
      265.579294,
      NULL,
      1,
      1.058373,
      72.421239,
      94,
      2.242511,
      2,
      118,
      83.778754,
      2.052696,
      4.842293,
      17.778627,
      10.917381,
      1.552169,
      1,
      73,
      NULL,
      1.848542,
      4,
      64,
      43.976673,
      NULL,
      3,
      195,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      1.570376,
      188,
      NULL,
      2,
      NULL,
      162.184436,
      NULL,
      1,
      5.475531,
      149,
      7,
      NULL,
      0.634959,
      16.492056,
      NULL,
      NULL,
      NULL,
      NULL,
      36.180077,
      NULL,
      NULL,
      199.716271,
      76,
      0.766756,
      0,
      191.769906,
      241.917204,
      3,
      5.364310,
      202.597343,
      NULL,
      0.431267,
      0,
      NULL,
      118,
      3,
      5,
      NULL,
      99.091646,
      2.368860,
      1.750620,
      38,
      165.058509,
      2,
      7,
      191,
      NULL,
      NULL,
      NULL,
      NULL,
      165,
      0.641111,
      NULL,
      190.424616,
      340.761871,
      1,
      5,
      NULL,
      626.233467,
      3.490375,
      2.585891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '20333',
      NULL,
      '13014',
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      2.150762,
      1615,
      1,
      NULL,
      0.597821,
      NULL,
      1.173471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.905987,
      NULL,
      3,
      279.602375,
      NULL,
      NULL,
      NULL,
      2,
      9,
      0.489525,
      3.995153,
      NULL,
      4,
      3,
      2,
      6,
      13,
      8.803921,
      3.835787,
      2,
      2,
      NULL,
      NULL,
      3.980068,
      NULL,
      8.189404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31.157517,
      NULL,
      24,
      14.797824,
      NULL,
      25,
      31,
      1.468016,
      2.458116,
      12,
      11.252812,
      NULL,
      0.024654,
      NULL,
      23.673894,
      11.396497,
      4.258799,
      22.234911,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      NULL,
      36.547506,
      NULL,
      98,
      140,
      47,
      116.256267,
      11.742398,
      26.621864,
      68.795888,
      2,
      55,
      102,
      136.917423,
      130,
      4,
      116.453480,
      97,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962895,
      0.157253,
      1.168917,
      1,
      0,
      6,
      8,
      9.154799,
      5.359796,
      2,
      NULL,
      NULL,
      8,
      NULL,
      0,
      5.730821,
      7.732529,
      9,
      1.055821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.141014,
      5.898088,
      7.298496,
      7,
      4.124278,
      6,
      NULL,
      2,
      7,
      4.392198,
      1,
      10.265477,
      3,
      NULL,
      NULL,
      2.708767,
      0.123677,
      2.582723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.564925,
      2,
      6.285175,
      6,
      NULL,
      3,
      4,
      1.443729,
      NULL,
      NULL,
      4,
      NULL,
      5,
      1,
      3.124901,
      NULL,
      2.477515,
      1.825421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.447836,
      1,
      NULL,
      NULL,
      0.865876,
      1,
      5,
      NULL,
      4.150923,
      0,
      NULL,
      0,
      3,
      5.949028,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852181,
      2.491343,
      NULL,
      1,
      NULL,
      NULL,
      5,
      5.292812,
      4,
      5.872817,
      2,
      5,
      5.956535,
      7,
      NULL,
      NULL,
      NULL,
      3.407171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.775021,
      3,
      6,
      1.886023,
      1.230004,
      7.986705,
      3,
      8.246051,
      2,
      4,
      9,
      5.335700,
      3.745776,
      3.056984,
      8.905809,
      0.383920,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      5,
      NULL,
      0.872771,
      6,
      9,
      NULL,
      0.700785,
      7.232516,
      1.139348,
      7,
      3.085451,
      2.850047,
      0.752353,
      3.701266,
      1.197029,
      2.420125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068370,
      1.931740,
      4.252598,
      3,
      6.517294,
      NULL,
      NULL,
      9,
      7,
      9,
      6,
      4.364905,
      5,
      4.080778,
      1,
      NULL,
      6,
      9.236442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.879755,
      NULL,
      2.568075,
      NULL,
      1,
      5.247589,
      1,
      2.147905,
      NULL,
      2.470889,
      NULL,
      3,
      2.229546,
      2.190926,
      5.729608,
      0.278040,
      1,
      2.899716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995623,
      1,
      0,
      1.883852,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      0.326856,
      0.490102,
      1,
      1,
      NULL,
      0,
      1.384294,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.595233,
      1,
      0,
      1.105387,
      NULL,
      0.918000,
      1.862809,
      1.492579,
      1,
      1.436308,
      1,
      1.529877,
      0.913968,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5.696495,
      4,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      5.673253,
      0,
      3,
      2,
      0.059879,
      1.078010,
      0.285605,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.219053,
      NULL,
      1.881842,
      NULL,
      0,
      2.965565,
      2.570292,
      3.984713,
      NULL,
      NULL,
      3.124422,
      1.429869,
      NULL,
      NULL,
      2.285469,
      2.273168,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.023121,
      0,
      5,
      0.365117,
      NULL,
      NULL,
      3.967568,
      1.528779,
      3,
      5,
      3,
      1.769218,
      0,
      2,
      3.727874,
      2,
      4.933743,
      6.093781,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975780,
      0.636207,
      NULL,
      0.506522,
      7,
      7,
      6,
      5,
      NULL,
      NULL,
      5,
      NULL,
      1,
      2.487706,
      NULL,
      7,
      6.906831,
      3,
      4.239711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161650,
      1,
      1,
      1,
      0,
      0,
      1.118779,
      0,
      NULL,
      0,
      1,
      0.243063,
      1,
      NULL,
      NULL,
      1.362267,
      0,
      NULL,
      1.800116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.612324,
      0,
      0,
      2.076087,
      2.520319,
      0.324863,
      2,
      0.041124,
      NULL,
      2,
      3.978053,
      0.564896,
      1,
      0.623300,
      2.224856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      3,
      2,
      3,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      2,
      3,
      1,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      2,
      3,
      1,
      3,
      2,
      1,
      0,
      3,
      0,
      2,
      NULL,
      4,
      2,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.326843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 4-1995',
      NULL,
      ' 7-16-1989',
      ' 2- 0-1977',
      ' 0-22-2000',
      ' 0- 2-1991',
      ' 3-26-1986',
      ' 4-24-1999',
      ' 3-11-1979',
      ' 2-23-1982',
      ' 0- 0-1975',
      ' 9-21-1978',
      ' 4-27-1997',
      ' 0-16-1988',
      ' 7- 2-1991',
      ' 0-17-1997',
      ' 3-25-1987',
      NULL,
      NULL,
      ' 4-14-1987',
      ' 4-28-1990',
      ' 4-29-1987',
      ' 1-25-1984',
      ' 8- 8-1988',
      ' 0-10-1996',
      ' 0-26-1987',
      ' 0-14-1981',
      ' 0- 7-1995',
      NULL,
      ' 9-28-1997',
      ' 0- 7-1990',
      ' 4-18-1979',
      ' 0-29-1992',
      NULL,
      ' 8-10-1993',
      ' 0- 9-1984',
      NULL,
      ' 6- 5-1986',
      ' 4-21-2003',
      NULL,
      ' 5-21-1977',
      ' 9-12-1997',
      ' 9-25-1988',
      ' 1-23-2002',
      ' 4-23-1986',
      ' 3-20-1976',
      NULL,
      ' 9-21-1991',
      ' 4-23-2002',
      ' 3-16-1981',
      '11- 2-1999',
      '11-14-1981',
      ' 7-19-1976',
      '11-21-1986',
      ' 6- 1-2003',
      ' 7-15-1979',
      '11- 3-1980',
      ' 5- 8-1999',
      ' 4- 3-2003',
      NULL,
      ' 0-28-1995',
      ' 0-26-1987',
      '11-21-1991',
      ' 8-28-1994',
      NULL,
      ' 7- 8-1979',
      NULL,
      ' 6-13-1998',
      ' 0- 9-1988',
      '10- 8-2002',
      ' 4-10-1986',
      NULL,
      ' 6-29-1989',
      ' 3- 6-2002',
      '11-26-1999',
      ' 5-27-1976',
      ' 0- 0-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 3-2001',
      NULL,
      ' 4- 5-2002',
      ' 3- 0-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


