set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733813';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      '43442',
      NULL,
      ' 9-28-1987',
      57.926253,
      NULL,
      0,
      1,
      1.267195,
      1,
      0,
      NULL,
      NULL,
      1,
      0.620589,
      3.665337,
      1.780948,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      35.710306,
      2,
      6,
      1.585639,
      NULL,
      9.479996,
      NULL,
      0.241897,
      1.746489,
      NULL,
      NULL,
      NULL,
      7,
      1,
      3,
      NULL,
      0,
      0,
      0,
      5,
      1,
      1,
      NULL,
      NULL,
      3.190171,
      3,
      1,
      5,
      1,
      0.757586,
      0,
      NULL,
      2,
      2,
      0.286764,
      NULL,
      7,
      5,
      6.948768,
      7,
      NULL,
      4,
      6.445426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      3,
      0,
      NULL,
      179.198342,
      6,
      0,
      NULL,
      0.175345,
      3.780198,
      1.372618,
      3,
      73.587490,
      NULL,
      2,
      3,
      172,
      8,
      NULL,
      2,
      49,
      2.581208,
      NULL,
      0,
      NULL,
      26,
      0,
      6,
      NULL,
      NULL,
      2,
      0.595010,
      126,
      14.082855,
      2.707220,
      2,
      NULL,
      9.409834,
      0.339514,
      0.352418,
      108,
      26,
      2,
      3.820080,
      163,
      NULL,
      NULL,
      NULL,
      155,
      2,
      0.469442,
      7.062747,
      92.107470,
      23,
      2.773173,
      3.900026,
      29.746133,
      6.463839,
      1,
      NULL,
      NULL,
      35,
      NULL,
      0.399245,
      NULL,
      3.184034,
      NULL,
      1.216565,
      172.705732,
      21,
      2.425155,
      NULL,
      72,
      1.020658,
      1,
      NULL,
      175.045570,
      NULL,
      0.376383,
      1.751042,
      548,
      28,
      NULL,
      0.903692,
      36,
      7,
      2.824701,
      NULL,
      352,
      NULL,
      NULL,
      0.729571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.342833,
      '01332',
      '10002',
      NULL,
      '',
      NULL,
      '',
      3,
      '42441',
      '',
      '',
      4.498329,
      '0411',
      '0314',
      '0123',
      NULL,
      NULL,
      182,
      NULL,
      226,
      0,
      NULL,
      1,
      NULL,
      2,
      10,
      0,
      NULL,
      NULL,
      221.602688,
      1.398577,
      NULL,
      0.621396,
      NULL,
      1.671163,
      NULL,
      ' 4-13-1985',
      12,
      9.638664,
      7,
      4.996987,
      18.775385,
      9,
      7,
      13,
      8,
      12.538147,
      3.211887,
      20.911496,
      4.419869,
      0.178196,
      20,
      2,
      1.435661,
      1.787591,
      16.277622,
      16.284994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.130924,
      14.278575,
      8,
      18,
      30.825727,
      NULL,
      NULL,
      16,
      25,
      1.067947,
      57,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.762764,
      NULL,
      2.948443,
      11.326676,
      15,
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      131,
      NULL,
      111,
      NULL,
      NULL,
      90,
      58,
      62,
      85.455553,
      10,
      54,
      14,
      42.803044,
      8,
      122,
      85.851868,
      NULL,
      104,
      20,
      127,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.515914,
      2.658826,
      3.261962,
      NULL,
      7,
      9.402674,
      2,
      1.828368,
      2,
      4,
      4,
      4.092140,
      9,
      3,
      0.363478,
      1,
      7.834412,
      7,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      6.925248,
      0,
      0,
      5.371693,
      3.705804,
      4.703889,
      6.330464,
      6,
      0.185674,
      2,
      0,
      3,
      2.864067,
      1,
      5,
      1.128568,
      4.374584,
      7.840198,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.127910,
      1.708458,
      7.023504,
      NULL,
      1.326180,
      0.076109,
      5,
      1.944002,
      NULL,
      NULL,
      1,
      2,
      2.885147,
      5.208896,
      0.452011,
      1,
      4,
      4.511857,
      2,
      NULL,
      0.387395,
      1.288075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.316850,
      1.382209,
      0.551699,
      1.760704,
      2.346565,
      NULL,
      1,
      3,
      6,
      3,
      6.752764,
      3.470766,
      2.713457,
      6.404324,
      NULL,
      0.364049,
      2,
      3.088841,
      0.060146,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.439603,
      3.965425,
      5.857331,
      3.834385,
      1,
      0.914841,
      1.623801,
      1,
      4,
      0.304280,
      0.642961,
      0.662028,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1.576458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.775791,
      4.212962,
      5,
      2.122380,
      2,
      7,
      NULL,
      7.351451,
      4,
      2,
      6,
      5,
      2,
      1.891430,
      3.695502,
      5,
      0.584726,
      6.313664,
      NULL,
      2.254778,
      3.750773,
      0.124319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0.352080,
      3.239812,
      1,
      NULL,
      3.459328,
      3.618219,
      NULL,
      5.806346,
      9,
      7.796834,
      NULL,
      1.234263,
      5,
      3.965412,
      1.575747,
      5.244683,
      5.352997,
      2.410696,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476589,
      3.788509,
      1,
      2.904592,
      0,
      5,
      NULL,
      3.086010,
      0.696194,
      0.377142,
      NULL,
      1,
      0,
      0,
      0.749955,
      0.598754,
      1.526670,
      0.030377,
      2.887269,
      3.223990,
      2,
      1.637938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.747323,
      NULL,
      5.320256,
      1.638892,
      0,
      4,
      2,
      5.509741,
      2.766315,
      4,
      4.837443,
      NULL,
      4.163953,
      4,
      0,
      5,
      5.110767,
      4,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2.533441,
      NULL,
      2,
      0.245599,
      0,
      1.931793,
      NULL,
      NULL,
      1,
      1,
      1.512140,
      0,
      1.574307,
      1.211316,
      1.329774,
      1.078678,
      0.984936,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.509553,
      NULL,
      NULL,
      0,
      1.110849,
      1,
      NULL,
      0.014866,
      NULL,
      1.855376,
      1.528841,
      0.823156,
      1,
      NULL,
      1.975498,
      0.460163,
      NULL,
      0.740200,
      NULL,
      1,
      0.529113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.310556,
      0,
      0.659618,
      0.683885,
      0,
      1.852503,
      0.061166,
      NULL,
      NULL,
      1.557135,
      0,
      NULL,
      1.574951,
      1,
      NULL,
      NULL,
      7.419783,
      4.650533,
      5.646636,
      4,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.181818,
      0.416825,
      NULL,
      0,
      1,
      1,
      0,
      0.927155,
      NULL,
      NULL,
      0,
      4.605448,
      2,
      3.114558,
      6,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      NULL,
      NULL,
      4,
      0,
      1,
      NULL,
      5.297014,
      8,
      0.081105,
      9.780409,
      NULL,
      3.014889,
      NULL,
      3,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144554,
      NULL,
      0,
      2.099175,
      2.803479,
      6.836440,
      6,
      4,
      4.214622,
      2.097797,
      1.626705,
      3.418013,
      NULL,
      0.954739,
      1.494955,
      NULL,
      NULL,
      5,
      4.491450,
      1.821257,
      3.648282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827954,
      NULL,
      1,
      1,
      0.170140,
      1,
      0.912410,
      0,
      1.417177,
      1.521602,
      0,
      0.680550,
      0.509247,
      0,
      0,
      1.136756,
      0,
      1,
      0.917719,
      NULL,
      1,
      1.932995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360891,
      NULL,
      0.928536,
      0,
      0.826559,
      0.620384,
      1,
      1.622369,
      1.706693,
      NULL,
      0,
      NULL,
      1,
      1.878950,
      NULL,
      NULL,
      5.333550,
      5.287501,
      2.306494,
      0,
      4.666318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      2,
      0,
      0,
      2,
      5,
      2,
      0,
      2,
      0,
      0,
      5,
      1,
      5,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      6,
      2,
      NULL,
      0,
      NULL,
      3,
      0,
      1,
      4,
      1,
      NULL,
      4,
      3,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-14-1986',
      '11-11-1989',
      ' 1-21-1992',
      ' 0- 7-1981',
      NULL,
      ' 4- 6-1985',
      ' 9-10-1981',
      ' 9-14-1986',
      NULL,
      '10-19-1982',
      ' 6-13-1994',
      ' 7-11-1981',
      ' 5- 2-1996',
      NULL,
      ' 8-18-1977',
      '11- 9-1993',
      ' 0- 5-1989',
      ' 4-12-2001',
      ' 3-15-2002',
      ' 3-15-1983',
      '10- 9-1974',
      ' 5- 5-2001',
      ' 9-21-1989',
      ' 0- 3-1980',
      '11-26-1996',
      ' 2- 0-1994',
      ' 1-23-1992',
      ' 5-17-1996',
      ' 5- 4-1991',
      ' 4-28-2000',
      '11- 3-1990',
      ' 2- 8-1983',
      '10-24-2000',
      ' 1- 4-1990',
      ' 8- 1-1996',
      NULL,
      ' 4-29-2003',
      ' 5-27-1987',
      NULL,
      '11-12-2001',
      ' 9- 0-1981',
      NULL,
      ' 2- 1-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-12-1977',
      ' 1-10-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 4-1974',
      ' 8- 3-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      0.435147);
commit;
end;
/


