set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      NULL,
      '3441004',
      3,
      3.600145,
      3,
      '21240',
      2,
      ' 2-19-1990',
      58,
      NULL,
      0,
      0,
      0.074671,
      NULL,
      1.060686,
      0,
      1,
      0,
      NULL,
      1.097582,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.311098,
      53.699254,
      6,
      3,
      0,
      NULL,
      11.618809,
      NULL,
      1.346894,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      5,
      NULL,
      1,
      0,
      NULL,
      4,
      5,
      1,
      NULL,
      2,
      15.666010,
      6,
      2,
      1,
      0.360820,
      0.292894,
      0,
      1,
      3,
      2,
      2.268030,
      1,
      NULL,
      NULL,
      0,
      5,
      5.121126,
      7,
      2,
      0,
      3,
      NULL,
      ' 0- 4-1983',
      13.700587,
      2.498279,
      4,
      NULL,
      2,
      1,
      1,
      4,
      1.255005,
      713.991977,
      0.394042,
      2,
      NULL,
      369.048888,
      208,
      2,
      0.777462,
      104.304737,
      21.851309,
      NULL,
      2.130874,
      350,
      NULL,
      1,
      NULL,
      589.945618,
      NULL,
      0,
      3,
      160.495760,
      NULL,
      0,
      2.450910,
      382,
      29.214499,
      1,
      7,
      NULL,
      13,
      1.371993,
      3,
      NULL,
      6,
      3,
      2.751027,
      120,
      238,
      NULL,
      3.517153,
      457.053130,
      189,
      NULL,
      0.522733,
      NULL,
      70.071305,
      NULL,
      0,
      68,
      25,
      1.932368,
      0.346650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '42301',
      '43311',
      '',
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.560176,
      '',
      NULL,
      '',
      0,
      NULL,
      31.662997,
      NULL,
      45,
      0,
      5.692308,
      1.652342,
      NULL,
      3,
      3,
      1.962084,
      NULL,
      0.604241,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      6,
      2.401586,
      10.491787,
      0.345121,
      13,
      3,
      2.893502,
      17.512780,
      0,
      6.006912,
      2,
      NULL,
      4,
      2.439697,
      1.161169,
      10.234618,
      8.337294,
      15,
      NULL,
      0,
      6,
      NULL,
      4,
      0,
      21,
      2,
      0.740829,
      4.755329,
      NULL,
      5,
      11.809446,
      10.639648,
      15.312641,
      23.409000,
      20.392709,
      10.047922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      16.187443,
      0.063227,
      15.030274,
      1,
      40.647469,
      0,
      47.288350,
      NULL,
      2.678154,
      16,
      15.081864,
      NULL,
      20.640910,
      1,
      9,
      5.191331,
      7,
      36,
      11.369748,
      13,
      29.303900,
      NULL,
      NULL,
      6,
      26,
      0.647482,
      2.143242,
      1.946347,
      0.008810,
      2.992302,
      NULL,
      2.717925,
      6.822969,
      6.311449,
      50,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      174,
      116.936394,
      NULL,
      NULL,
      24.423705,
      172,
      159.947154,
      47,
      24.270740,
      143.543852,
      148,
      NULL,
      27,
      NULL,
      137.175826,
      NULL,
      NULL,
      38,
      NULL,
      NULL,
      36,
      115.533787,
      125.260721,
      NULL,
      90,
      165,
      12,
      NULL,
      24.911840,
      NULL,
      NULL,
      NULL,
      106,
      64,
      62,
      13,
      172.460930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.593514,
      4.301795,
      NULL,
      NULL,
      NULL,
      2.519566,
      NULL,
      0.312156,
      0,
      1.453532,
      1.307318,
      1.328433,
      0,
      1.887649,
      0.668986,
      0,
      NULL,
      0,
      1.827224,
      0,
      1,
      1.461705,
      5.059693,
      3.344063,
      2.863108,
      1,
      3,
      9,
      5.251395,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.599909,
      0,
      1.084682,
      NULL,
      1.785966,
      1,
      1.837390,
      0.084514,
      1,
      NULL,
      NULL,
      0,
      1.421124,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0.313776,
      0,
      NULL,
      1,
      0.574554,
      0.080501,
      0,
      0.206973,
      1,
      1.425886,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.264866,
      1,
      0,
      1,
      0,
      5.327982,
      0.844224,
      NULL,
      NULL,
      0.919105,
      1.914570,
      NULL,
      1,
      1,
      1,
      1.674777,
      0,
      1,
      1,
      0.593940,
      0.930562,
      0.472925,
      NULL,
      1,
      NULL,
      0,
      1.986178,
      1.497014,
      1.963045,
      NULL,
      1.038412,
      0.513534,
      NULL,
      1.010509,
      1,
      0.686584,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733176,
      1,
      1,
      1,
      1,
      NULL,
      1.625021,
      0.379179,
      NULL,
      0.108090,
      0,
      1.712242,
      1,
      1.167193,
      0.102331,
      NULL,
      0.632360,
      0.414092,
      0,
      NULL,
      1,
      0.141649,
      1.985491,
      0.448854,
      0.674490,
      1.852044,
      1,
      1,
      NULL,
      1,
      1.457486,
      0,
      1.537133,
      1,
      0.918511,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      0.272337,
      NULL,
      2,
      NULL,
      1,
      3,
      1,
      NULL,
      7,
      0,
      4,
      2,
      3.493022,
      2.833527,
      0,
      3,
      NULL,
      0.390109,
      NULL,
      1.408935,
      1.849054,
      NULL,
      NULL,
      NULL,
      1.205313,
      2.858821,
      4.266062,
      0,
      5,
      5,
      4,
      5,
      3.028462,
      3.253708,
      0.404872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.971474,
      NULL,
      7,
      0,
      1.913117,
      4,
      4.635910,
      4,
      1.295606,
      NULL,
      7,
      9,
      6.630907,
      5.760042,
      7.729273,
      NULL,
      NULL,
      3,
      0,
      0.585347,
      0,
      0.411683,
      0,
      0.252160,
      1.948412,
      1,
      1.058312,
      5.468657,
      4.910985,
      7.798758,
      NULL,
      8,
      3.189204,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      4,
      0.712536,
      NULL,
      4.894057,
      NULL,
      NULL,
      7.579303,
      9,
      7.581615,
      4,
      4,
      6.061609,
      7.251473,
      4.442267,
      NULL,
      4,
      1,
      1.848061,
      1,
      0,
      NULL,
      1,
      1,
      1.812470,
      NULL,
      2,
      NULL,
      6.178930,
      7,
      NULL,
      1,
      3,
      NULL,
      5.488400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      0,
      NULL,
      4,
      2,
      0.378043,
      5.585585,
      NULL,
      3.033768,
      1.364966,
      NULL,
      2.860762,
      NULL,
      5.413350,
      0,
      1.135627,
      NULL,
      1.182229,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      2.417760,
      3.087576,
      1,
      4.812715,
      NULL,
      6.599236,
      1.908048,
      NULL,
      4,
      3.195707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      6.428473,
      0,
      3,
      2.244102,
      NULL,
      0,
      NULL,
      4,
      1,
      2,
      2,
      3,
      1.435556,
      2.004893,
      2.635374,
      2,
      1.074557,
      1.715949,
      1,
      NULL,
      1,
      1,
      0.072981,
      0.100927,
      1,
      1,
      NULL,
      3.047610,
      NULL,
      2.123998,
      2.628243,
      3.839734,
      2,
      NULL,
      NULL,
      1.662531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.415713,
      NULL,
      NULL,
      0.178422,
      1,
      0.919305,
      0.049796,
      0,
      0.599915,
      1,
      0,
      1,
      0,
      0.562629,
      0,
      1.044135,
      1.858265,
      1,
      1.799289,
      0.639295,
      NULL,
      1.688630,
      1.555483,
      NULL,
      NULL,
      0,
      1.356110,
      1,
      NULL,
      1.476479,
      0.091398,
      1.771462,
      0.702881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044779,
      1.005087,
      1.057016,
      0.963363,
      0.984786,
      NULL,
      0.966062,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.719501,
      0.727744,
      NULL,
      1.313992,
      NULL,
      0.245159,
      0,
      0,
      0,
      0,
      0,
      1,
      0.181992,
      NULL,
      NULL,
      0.308225,
      NULL,
      1.521892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      2,
      4,
      1,
      NULL,
      1,
      3,
      NULL,
      4.153238,
      1.509267,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0.811162,
      1,
      1.953757,
      1.131614,
      1,
      1,
      0.298430,
      1.459794,
      5,
      2,
      2,
      NULL,
      NULL,
      6.985035,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378317,
      NULL,
      5.178895,
      4.723361,
      1.532012,
      5,
      7,
      NULL,
      0,
      3.150673,
      1.329838,
      1.662106,
      3.741167,
      4.434984,
      NULL,
      0.615293,
      2.732028,
      NULL,
      1.420875,
      0,
      1.698286,
      5,
      2.064773,
      0.189780,
      1,
      2.396184,
      1.843445,
      0.245397,
      0.125720,
      NULL,
      NULL,
      0.750051,
      1.401538,
      1.190951,
      0.449775,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      2,
      4,
      NULL,
      2,
      4.705534,
      7.649339,
      1,
      1,
      2.266370,
      1,
      1.401891,
      NULL,
      0.909407,
      1.559543,
      1.650816,
      1,
      0,
      0,
      NULL,
      NULL,
      1.347065,
      0.457675,
      NULL,
      3.547412,
      3,
      3.438099,
      6,
      8.947723,
      0.663552,
      0,
      6.068256,
      7.002344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      5.764636,
      2,
      NULL,
      NULL,
      NULL,
      6.101722,
      1.175525,
      3,
      1.436079,
      7,
      3,
      1.497625,
      NULL,
      6,
      0,
      NULL,
      3.130288,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.018796,
      0,
      2.662860,
      2.927143,
      NULL,
      NULL,
      1.601378,
      5,
      0.666827,
      3.041778,
      3.364251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.713606,
      0,
      1.965728,
      1,
      0.184231,
      9,
      2,
      3.857447,
      1.277807,
      1,
      1,
      0.495316,
      0.769916,
      1.768449,
      1.611077,
      1,
      0,
      1.978384,
      1.038742,
      NULL,
      0,
      0.535851,
      0.515131,
      0.812088,
      1,
      NULL,
      1,
      1.276629,
      1,
      0.022671,
      1.449154,
      0.570971,
      NULL,
      1.731608,
      0.947363,
      0,
      1.775827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822998,
      4.040531,
      4.419184,
      3.091844,
      1,
      NULL,
      1.150445,
      1.289035,
      0,
      2,
      4.315005,
      3,
      0,
      2,
      1,
      0,
      0.089865,
      1.898510,
      NULL,
      1.155332,
      1,
      0,
      1.510017,
      0.954448,
      0,
      NULL,
      NULL,
      2,
      0.531846,
      NULL,
      2,
      3.589303,
      0.447973,
      4.315853,
      3.571061,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      2,
      1,
      3,
      0,
      1,
      0,
      3,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      3,
      3,
      3,
      1,
      0,
      1,
      1,
      3,
      2,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      4,
      5,
      2,
      2,
      2,
      1,
      5,
      3,
      5,
      1,
      3,
      NULL,
      4,
      NULL,
      NULL,
      2,
      4,
      1,
      1,
      4,
      2,
      3,
      NULL,
      3,
      NULL,
      5,
      4,
      4,
      2,
      3,
      0,
      1,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-24-1987',
      ' 5-25-2003',
      ' 8- 0-1997',
      '10- 4-1976',
      ' 3-25-1990',
      NULL,
      '10- 9-1979',
      NULL,
      ' 9- 4-1984',
      ' 7- 1-1979',
      ' 4-28-2000',
      ' 3- 1-1989',
      NULL,
      ' 9- 0-1985',
      NULL,
      ' 7- 2-1989',
      ' 0-18-1976',
      ' 2-23-1981',
      '11- 0-2000',
      ' 2-13-1979',
      ' 8-11-2001',
      ' 2-17-1997',
      ' 8-19-1978',
      ' 6-11-1989',
      ' 0-16-2003',
      ' 0-25-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-27-1978',
      ' 5- 8-1981',
      ' 6-18-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


