set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8011440';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      NULL,
      '4122104',
      0,
      1.623779,
      2,
      '44241',
      0.897829,
      ' 0-19-1978',
      37,
      NULL,
      1.675883,
      NULL,
      2.227855,
      NULL,
      NULL,
      2.934523,
      NULL,
      NULL,
      0.094140,
      NULL,
      0.225424,
      1,
      NULL,
      NULL,
      1,
      1.640912,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.488575,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      4,
      4.986110,
      NULL,
      2,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1,
      2.552092,
      1,
      0,
      7,
      6.739713,
      4,
      4,
      3,
      NULL,
      3.559325,
      1,
      15,
      ' 6-23-1989',
      17,
      1,
      1,
      3,
      3,
      0,
      2,
      2,
      31.111278,
      NULL,
      0.777890,
      2.775782,
      1,
      201.918480,
      1,
      0.499670,
      NULL,
      236,
      377.480523,
      2,
      0.230990,
      208,
      NULL,
      0,
      NULL,
      866.053465,
      40.978730,
      1,
      NULL,
      NULL,
      29,
      3,
      NULL,
      NULL,
      213.194361,
      3.479439,
      1,
      758,
      20,
      3,
      1.521484,
      NULL,
      9.012188,
      2.342688,
      2.516526,
      108,
      1525.875966,
      NULL,
      2,
      114,
      26,
      2,
      2.598792,
      284.110991,
      5.518971,
      NULL,
      3.028461,
      113.791513,
      NULL,
      NULL,
      NULL,
      163,
      30.167271,
      1,
      3,
      154,
      3.665650,
      3.751719,
      3,
      208.752191,
      42,
      0.730107,
      2.869314,
      332.265845,
      0.740181,
      NULL,
      NULL,
      28,
      18.250912,
      0,
      3.148937,
      217,
      2,
      2,
      2,
      165.956020,
      263.615876,
      NULL,
      NULL,
      315,
      3.368652,
      1,
      0,
      45,
      62.046533,
      2,
      8.150865,
      1228.157753,
      283,
      1.177867,
      3,
      28,
      313,
      2.591618,
      NULL,
      84.321258,
      94.179825,
      3.099590,
      NULL,
      955,
      426,
      2,
      NULL,
      52.360448,
      134,
      1,
      NULL,
      137,
      5,
      1.185778,
      2,
      98,
      327.638417,
      1.855660,
      2.276642,
      24.570599,
      25.045878,
      2.553131,
      NULL,
      162,
      342,
      1.109087,
      NULL,
      63.035067,
      NULL,
      0.506540,
      NULL,
      814.536214,
      0,
      0,
      7.190430,
      184,
      182.918423,
      1.340296,
      0.173356,
      183,
      NULL,
      1.694056,
      NULL,
      487,
      1,
      NULL,
      5.182206,
      56.972629,
      1.616812,
      1,
      0,
      139,
      17.635249,
      NULL,
      6,
      213.086229,
      NULL,
      3.214616,
      NULL,
      NULL,
      45.114235,
      NULL,
      NULL,
      109.778952,
      187,
      NULL,
      1,
      2,
      218,
      1.740259,
      3.904833,
      15.211088,
      247,
      1.962736,
      3,
      NULL,
      75.751568,
      1,
      NULL,
      187,
      130.320809,
      0.612871,
      2.863918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.348279,
      NULL,
      '',
      '',
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      0,
      0.989367,
      NULL,
      1.108746,
      784,
      0.988194,
      NULL,
      NULL,
      NULL,
      0.032982,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.672991,
      NULL,
      1.348131,
      NULL,
      0,
      NULL,
      ' 4- 5-1996',
      NULL,
      13,
      10,
      NULL,
      NULL,
      15.465562,
      3.579474,
      4,
      19,
      NULL,
      2.665305,
      16,
      13.487771,
      0,
      4.663622,
      8,
      NULL,
      NULL,
      1,
      1.435011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      19,
      3,
      6,
      0.276299,
      2.731079,
      13,
      NULL,
      0.187364,
      0,
      3.266323,
      0.826433,
      NULL,
      5,
      3.121084,
      0,
      2.221007,
      28.019365,
      11,
      17.638437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      105.543646,
      121,
      98,
      NULL,
      23,
      34,
      140,
      NULL,
      73,
      111,
      NULL,
      NULL,
      138,
      98,
      9,
      NULL,
      NULL,
      180,
      92.215924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      4.175370,
      4.607094,
      9.838141,
      1.090894,
      4.552479,
      3,
      6.333286,
      0,
      5,
      8.506773,
      NULL,
      9.107674,
      1,
      3.518454,
      3.278159,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.074869,
      3,
      5.983609,
      NULL,
      0.296484,
      2.326272,
      5,
      NULL,
      NULL,
      NULL,
      9,
      6,
      5,
      9,
      6,
      2,
      3,
      4,
      2.880213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.492473,
      4.719055,
      3.200971,
      NULL,
      5,
      2.461925,
      11,
      5,
      3.103865,
      1.053870,
      NULL,
      5.592002,
      2.350480,
      4.366524,
      NULL,
      NULL,
      1.815656,
      2.558369,
      3.259772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      4.313381,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2.712864,
      1,
      5,
      4.349457,
      7.098522,
      3,
      NULL,
      7,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.431581,
      2,
      2.973857,
      1,
      NULL,
      4.003506,
      2,
      7.594959,
      4,
      0,
      7.728377,
      1,
      4,
      8,
      7,
      5.068081,
      6,
      7,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      7.113556,
      6,
      NULL,
      8.462410,
      8,
      2,
      3,
      NULL,
      NULL,
      6.446696,
      NULL,
      2,
      NULL,
      3.058534,
      4.419865,
      8.453847,
      9,
      2.665350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281668,
      5,
      4,
      7,
      4,
      3,
      0,
      5.823210,
      NULL,
      2,
      6.380513,
      7,
      1.182502,
      2.777807,
      0.183450,
      1.540341,
      3,
      NULL,
      1,
      2.120507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      5.089476,
      3.250338,
      0.823241,
      2,
      NULL,
      6.369566,
      5.089004,
      5,
      NULL,
      0,
      6.577527,
      0,
      7.892577,
      6.189249,
      1.439277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.096189,
      7,
      5,
      7.054737,
      5.478020,
      6,
      NULL,
      NULL,
      1.263353,
      6.547476,
      7.598076,
      3,
      8.567564,
      0,
      6,
      0,
      11.508583,
      3.193530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418470,
      5,
      1,
      0.364037,
      1.247106,
      3,
      1.829314,
      3.096209,
      3,
      5,
      2,
      7.346575,
      NULL,
      NULL,
      5.726811,
      4,
      2.134063,
      3.224123,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.247210,
      1,
      0.961016,
      1.352700,
      0.784496,
      NULL,
      0.837034,
      0.835747,
      NULL,
      1.901433,
      0,
      0,
      0,
      0.304074,
      1.030797,
      0.252765,
      1,
      0.375813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.707915,
      0.276736,
      4.878557,
      3,
      NULL,
      NULL,
      0.858669,
      NULL,
      0,
      3.746081,
      0.195972,
      0.437847,
      0.095177,
      1,
      1.001943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.909551,
      0,
      4.716959,
      NULL,
      NULL,
      4.270735,
      4.152897,
      1,
      2.523424,
      3.483488,
      2.461777,
      4,
      NULL,
      4,
      0.633542,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.595935,
      NULL,
      NULL,
      0,
      9,
      NULL,
      NULL,
      NULL,
      1.843741,
      NULL,
      6.425832,
      8,
      NULL,
      0.266774,
      2,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      1.272322,
      2.691094,
      2,
      7,
      1,
      2.777394,
      NULL,
      0.076209,
      7,
      1,
      NULL,
      1,
      NULL,
      6,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.934352,
      0,
      0,
      0,
      1.315115,
      1.633802,
      NULL,
      NULL,
      1,
      0,
      0.614915,
      1.301296,
      0,
      1.498895,
      0.969746,
      1,
      0.274778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486810,
      0,
      2,
      1,
      0.801527,
      3.702458,
      0,
      3,
      1,
      1,
      5.849625,
      2,
      NULL,
      2,
      2,
      3.448668,
      2.726350,
      2.414018,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1,
      NULL,
      6,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      3,
      0,
      3,
      3,
      3,
      NULL,
      2,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081373,
      1,
      NULL,
      1,
      3,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 2-2001',
      NULL,
      ' 1-19-2002',
      '11-15-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-22-1988',
      ' 5-24-1991',
      ' 5- 9-1984',
      '11-26-1978',
      ' 0-18-1977',
      ' 4- 7-1984',
      '11-13-1985',
      '10-12-1984',
      ' 9-27-1981',
      '11-22-1984',
      ' 6- 8-1993',
      NULL,
      ' 3-18-1975',
      ' 9-28-1984',
      ' 6-16-1992',
      ' 1-28-1986',
      ' 3-13-1997',
      '11-13-1993',
      ' 2-22-1998',
      '10-28-1975',
      ' 8- 7-1980',
      '11-29-1997',
      ' 6-17-1985',
      ' 4- 0-2003',
      ' 5- 6-1975',
      ' 7- 9-2001',
      ' 3-12-2000',
      ' 8-19-1994',
      NULL,
      ' 3-29-1977',
      ' 7-11-1978',
      ' 3-16-1996',
      ' 2-25-1992',
      ' 4- 9-2003',
      '10- 2-1978',
      ' 8-25-1987',
      '10- 8-1978',
      ' 0- 7-1979',
      ' 4-20-1975',
      ' 3- 0-2001',
      ' 3-14-1995',
      ' 6- 1-1974',
      NULL,
      '10-12-1987',
      NULL,
      ' 1- 4-1990',
      ' 4-12-1994',
      ' 1-15-1981',
      NULL,
      '10-15-2000',
      NULL,
      NULL,
      '10-24-1976',
      ' 8-13-1981',
      ' 6-15-2002',
      ' 4- 8-1975',
      ' 1-22-1990',
      ' 3-19-1977',
      ' 8-29-1989',
      ' 3-28-2000',
      NULL,
      ' 7- 7-1984',
      ' 1-23-1982',
      ' 2-29-1982',
      '10-10-1992',
      ' 7-28-1989',
      ' 9- 0-2002',
      ' 3- 8-2002',
      ' 0-16-1992',
      '11-20-1998',
      ' 5-21-1997',
      ' 6- 2-1989',
      ' 3- 3-1992',
      ' 5-12-1983',
      ' 2-12-1988',
      ' 3- 1-1999',
      NULL,
      '11- 0-1992',
      '11-27-2002',
      ' 5-19-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


