set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410455';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '4243140',
      0,
      0,
      0,
      '21110',
      3,
      ' 1-11-1984',
      73,
      NULL,
      0.658557,
      3,
      3,
      NULL,
      NULL,
      1,
      0,
      1.143322,
      2.035474,
      NULL,
      NULL,
      9,
      9,
      1.468251,
      NULL,
      3.465343,
      NULL,
      NULL,
      NULL,
      NULL,
      1.709630,
      NULL,
      NULL,
      0.530163,
      0,
      0.334093,
      NULL,
      NULL,
      4,
      4,
      2,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      6.598636,
      NULL,
      4,
      3,
      1.995400,
      NULL,
      1,
      NULL,
      3,
      1,
      1.462618,
      NULL,
      2.669926,
      4,
      4.639352,
      NULL,
      7,
      8,
      3.224552,
      NULL,
      1,
      23.232667,
      ' 6-21-1994',
      NULL,
      2.686239,
      4,
      NULL,
      2,
      1,
      1,
      NULL,
      64.052912,
      NULL,
      30,
      1,
      0,
      70.003809,
      NULL,
      0,
      6.785218,
      175.091360,
      36.328379,
      3,
      9,
      96,
      4.338391,
      2,
      3.784046,
      126.508864,
      NULL,
      3,
      2,
      NULL,
      61.508936,
      2,
      6,
      69,
      42,
      NULL,
      2.743480,
      13.024789,
      137.651604,
      0.807180,
      2.144687,
      71,
      165,
      3,
      NULL,
      144.689700,
      109,
      0,
      1,
      9.478182,
      215.772687,
      NULL,
      9,
      166,
      518.163387,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      178.890347,
      51,
      1.900308,
      0.179205,
      91.389386,
      361.056470,
      NULL,
      NULL,
      534,
      81.141756,
      1,
      1.567532,
      598.035725,
      NULL,
      1,
      NULL,
      NULL,
      221,
      3.548790,
      0,
      396,
      NULL,
      NULL,
      3.083712,
      318,
      NULL,
      2.967561,
      0.204930,
      56,
      297,
      3,
      4.974235,
      114.638335,
      NULL,
      NULL,
      NULL,
      152.935635,
      49,
      2.192279,
      0.823007,
      460,
      2,
      1,
      1,
      435,
      242,
      0,
      7.813740,
      65.555420,
      NULL,
      3,
      3,
      167,
      41,
      1.433840,
      2.459971,
      25.249884,
      48,
      3,
      NULL,
      473.285935,
      3.794729,
      NULL,
      0,
      216,
      77.423574,
      0.793789,
      2.205122,
      210,
      78,
      3.918117,
      8.222760,
      377,
      152,
      2.962030,
      2.589806,
      141.383294,
      NULL,
      NULL,
      NULL,
      NULL,
      11.077151,
      3,
      2.886011,
      228.720817,
      81,
      3,
      1,
      17,
      17,
      1.598512,
      7.994615,
      612.760574,
      NULL,
      0.147246,
      NULL,
      665,
      NULL,
      1.473192,
      2,
      571.433855,
      866,
      3.660039,
      4,
      48,
      316.113589,
      2.237701,
      NULL,
      1100,
      108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.345758,
      '3133',
      '23033',
      '',
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      '',
      0.961474,
      '',
      '',
      '',
      3,
      3.361370,
      24,
      2,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.540488,
      0.126182,
      3.664465,
      NULL,
      NULL,
      1.433345,
      NULL,
      1.760402,
      NULL,
      1.771513,
      NULL,
      ' 0-26-1982',
      10.850830,
      NULL,
      9,
      NULL,
      7,
      9.822033,
      0.848435,
      NULL,
      1,
      18.526091,
      15.590005,
      18.540910,
      11,
      0.729190,
      1,
      NULL,
      4.858348,
      NULL,
      6.936983,
      4,
      2.844690,
      1.824667,
      5,
      1,
      NULL,
      1.572435,
      7.436671,
      10.278691,
      11,
      15.127727,
      4.961332,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      22,
      NULL,
      5,
      26.073302,
      4.875243,
      NULL,
      NULL,
      48,
      NULL,
      37.840138,
      5.785563,
      8.621142,
      NULL,
      44.186800,
      6.668111,
      10.402669,
      12.998158,
      2,
      7,
      17,
      14,
      6.001478,
      3,
      0.975948,
      18.713868,
      0.451653,
      16.863919,
      24.426104,
      16,
      41,
      27,
      1.274924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      41,
      19.816776,
      NULL,
      NULL,
      143,
      113.129358,
      135,
      NULL,
      4.027617,
      111,
      119.512687,
      NULL,
      55.549216,
      140,
      NULL,
      19,
      170,
      27.745059,
      68.450930,
      145.078925,
      125,
      146,
      46.125360,
      NULL,
      59,
      184,
      56,
      44,
      145,
      132,
      135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565957,
      3.874218,
      NULL,
      0.664104,
      NULL,
      2,
      NULL,
      1.756543,
      0,
      0,
      5.246490,
      1,
      5.609126,
      5.279753,
      1,
      0,
      1,
      1,
      1.689790,
      1,
      1.940058,
      3,
      3,
      1.077654,
      1.886850,
      0.108947,
      1,
      2,
      NULL,
      0,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5.684032,
      0.650752,
      1,
      1,
      1.767050,
      NULL,
      2.633178,
      1.947513,
      1.435914,
      0.764053,
      NULL,
      6.529772,
      1,
      5.420107,
      1.631832,
      0,
      2.125064,
      NULL,
      3,
      0.352022,
      0,
      0.400571,
      NULL,
      3.847762,
      1,
      2.364737,
      1,
      NULL,
      2.836070,
      1.899404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1.382139,
      0.417179,
      0,
      NULL,
      1,
      1.780667,
      1.087091,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.174837,
      0.628579,
      0,
      1.523891,
      0.298168,
      0.031473,
      1,
      0.356437,
      1.015772,
      NULL,
      0.546745,
      NULL,
      0.866563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.466176,
      0.194866,
      0.087105,
      NULL,
      1.533729,
      NULL,
      0.525099,
      0.902251,
      NULL,
      0,
      NULL,
      1.137052,
      1,
      0,
      1.020496,
      0,
      0.112941,
      NULL,
      0,
      1,
      0.192618,
      NULL,
      1.185275,
      0.845327,
      1,
      0,
      1,
      1,
      0,
      0.784449,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.784659,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.892445,
      1.630017,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1.517596,
      0.204666,
      NULL,
      0,
      1.867706,
      NULL,
      0,
      1,
      0.832665,
      1.772799,
      1.620880,
      0,
      0,
      0.808344,
      1,
      1.909889,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      2,
      2.809776,
      3,
      1.335346,
      2,
      1,
      3,
      NULL,
      5,
      0.482776,
      5.152582,
      NULL,
      NULL,
      0.591118,
      NULL,
      2.141678,
      2.954732,
      3.351149,
      NULL,
      NULL,
      1,
      4,
      0,
      3.724915,
      4.094406,
      3.201755,
      6.485621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.019472,
      0,
      0,
      1,
      0,
      1.204734,
      1.835365,
      NULL,
      2,
      1,
      1,
      5,
      5.249530,
      0.987913,
      NULL,
      0.929934,
      0.254235,
      NULL,
      NULL,
      2,
      4,
      1.796847,
      4,
      5,
      1.886525,
      0,
      NULL,
      NULL,
      0,
      1.831557,
      4.574168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.749191,
      1.915143,
      NULL,
      0.788261,
      1.216340,
      0.791159,
      1,
      0.165929,
      1.289567,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1.916955,
      0.557160,
      0,
      0,
      NULL,
      0,
      1.046277,
      0,
      1.352023,
      2.072085,
      6.047101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.110824,
      0.520496,
      0,
      0,
      NULL,
      1,
      1,
      3.464601,
      1.819013,
      0.867498,
      1.712504,
      1,
      1,
      0.964693,
      0,
      0.440962,
      0.381559,
      NULL,
      1,
      0,
      0,
      0.741314,
      0,
      1.682680,
      1,
      0.507852,
      1.788577,
      1.317655,
      NULL,
      4.002360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.358258,
      NULL,
      1,
      1,
      0,
      1.750403,
      1,
      0,
      1,
      0.843102,
      0.233648,
      1.098812,
      1.220234,
      1,
      1,
      0.068530,
      NULL,
      0,
      1.951090,
      NULL,
      1,
      NULL,
      1,
      1.286744,
      1.411747,
      0,
      NULL,
      1.988324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.685822,
      NULL,
      1.603449,
      1,
      1.912270,
      1.453244,
      0,
      1.179548,
      0.655840,
      NULL,
      NULL,
      1,
      0.225405,
      0,
      0.500238,
      1.249647,
      1.281880,
      NULL,
      0,
      0,
      1.658496,
      0,
      NULL,
      NULL,
      0,
      1,
      0.403413,
      0.787614,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.867439,
      0.566278,
      2.223553,
      2,
      3.459029,
      NULL,
      NULL,
      4.616138,
      NULL,
      0.371852,
      0,
      NULL,
      NULL,
      0.791190,
      1.455091,
      2,
      7,
      NULL,
      NULL,
      0.044056,
      NULL,
      4,
      1,
      2.264422,
      0.976127,
      NULL,
      2.340411,
      5,
      3.443953,
      3,
      3.936524,
      3,
      6.304236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.476249,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      0,
      1.515747,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0.567955,
      1.188298,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.134716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.482857,
      NULL,
      0.597873,
      NULL,
      3.197478,
      NULL,
      5.566539,
      3,
      3.713434,
      0,
      1.306194,
      4.784338,
      7,
      1,
      4,
      6,
      3.770607,
      5.270430,
      0,
      2,
      2,
      5.102983,
      0.784551,
      4,
      3,
      1.060042,
      NULL,
      5,
      1,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.694875,
      NULL,
      0,
      0.193529,
      1.422573,
      2,
      0.332265,
      0.663746,
      0.255733,
      0,
      4.917117,
      NULL,
      NULL,
      4,
      4.180579,
      NULL,
      5.463161,
      3.177153,
      5.586728,
      5.777080,
      3.641459,
      1.648207,
      NULL,
      5.999413,
      3.662501,
      4.958710,
      NULL,
      2,
      2.455468,
      NULL,
      5,
      0.913455,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.619412,
      0.658842,
      0,
      NULL,
      0.274386,
      0.662700,
      1.724361,
      0,
      1.671100,
      1,
      1.116187,
      1.728481,
      NULL,
      0.195875,
      NULL,
      0.253492,
      1,
      0,
      1,
      0,
      1,
      1.696503,
      1.522906,
      1.033329,
      0,
      0.292802,
      NULL,
      0,
      1.263752,
      0,
      1.299107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173279,
      5.593029,
      1.830247,
      5.195605,
      5,
      3,
      NULL,
      NULL,
      0.648235,
      2.482673,
      2,
      3,
      NULL,
      2.421017,
      0,
      1.075172,
      3.045827,
      3,
      3.842614,
      0,
      NULL,
      2,
      0,
      1,
      NULL,
      4,
      0.862367,
      4.330101,
      NULL,
      NULL,
      NULL,
      2.611534,
      3.395999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      3,
      NULL,
      0,
      0,
      5,
      5,
      5,
      2,
      2,
      3,
      1,
      0,
      3,
      NULL,
      2,
      5,
      5,
      2,
      5,
      2,
      0,
      0,
      NULL,
      1,
      NULL,
      4,
      1,
      5,
      5,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-23-1983',
      ' 4-23-1992',
      ' 8- 8-2001',
      ' 6-11-1991',
      ' 7- 1-1980',
      ' 9-28-2000',
      '10-16-1993',
      ' 1- 1-1994',
      NULL,
      ' 2-12-1991',
      ' 9-12-1988',
      ' 0- 9-1992',
      ' 2-23-1997',
      NULL,
      NULL,
      ' 9-26-1990',
      ' 6-24-1998',
      ' 3- 7-1988',
      ' 9-18-1994',
      ' 6-24-1979',
      ' 9-16-1976',
      ' 2-28-1991',
      NULL,
      NULL,
      ' 5-29-1975',
      NULL,
      ' 1-16-1982',
      ' 5- 2-1977',
      ' 6- 1-1998',
      ' 4-10-1997',
      ' 0- 4-1991',
      '10- 4-1983',
      ' 2-12-1991',
      NULL,
      ' 2-27-1999',
      '10-12-2003',
      ' 9-24-1988',
      ' 9- 0-2000',
      NULL,
      NULL,
      ' 1- 0-1995',
      NULL,
      '10-29-1992',
      ' 0-21-1974',
      NULL,
      NULL,
      ' 5-26-1981',
      ' 1- 7-2000',
      NULL,
      ' 7- 5-1994',
      ' 8-15-1980',
      ' 1-24-1991',
      ' 6- 0-1994',
      '10- 9-1990',
      '10-11-1983',
      ' 0- 1-1990',
      ' 9-24-1982',
      NULL,
      ' 7- 7-1998',
      ' 0- 9-1997',
      ' 4-19-1985',
      ' 0-25-1990',
      ' 1-14-1990',
      ' 8- 2-1980',
      ' 1- 5-1977',
      ' 5-15-1995',
      ' 3- 6-1985',
      '11- 3-2000',
      NULL,
      ' 4-21-1995',
      NULL,
      ' 2-18-1978',
      ' 4-29-2003',
      ' 2-24-1999',
      '10- 2-2000',
      ' 0-28-1993',
      ' 0-17-1993',
      ' 9- 7-1974',
      ' 8-24-1994',
      ' 0-14-1986',
      ' 7- 9-2001',
      ' 3- 5-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 6-2001',
      NULL,
      ' 8-17-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


