set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9428112';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12144312',
      39,
      31,
      '1222121',
      0,
      3,
      NULL,
      '01020',
      0,
      ' 3-26-1993',
      192.450914,
      NULL,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032034,
      3,
      NULL,
      1.899219,
      0.107096,
      NULL,
      NULL,
      NULL,
      2.587143,
      NULL,
      19.905410,
      43.849800,
      5,
      2.322439,
      1.581598,
      NULL,
      NULL,
      0.332165,
      2,
      NULL,
      0,
      4.205517,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      2,
      4.941009,
      NULL,
      NULL,
      1.413408,
      0.761230,
      0,
      3,
      4,
      5.901321,
      3.452186,
      7,
      1,
      0,
      0,
      1.499647,
      0,
      3.007842,
      0.849750,
      NULL,
      NULL,
      NULL,
      NULL,
      0.628276,
      2,
      5,
      1,
      NULL,
      NULL,
      NULL,
      28.350514,
      NULL,
      44.147503,
      3,
      9.646923,
      NULL,
      15,
      3,
      4,
      153,
      36,
      0,
      6,
      128.590253,
      15,
      3.593516,
      NULL,
      191,
      14.152149,
      0,
      2.048996,
      106.133583,
      4,
      3.976682,
      6,
      160.058080,
      2.592447,
      3,
      5.968723,
      NULL,
      5,
      0.095952,
      3.779809,
      0,
      4.699974,
      2,
      NULL,
      98.773461,
      NULL,
      2.133327,
      2,
      80,
      19,
      1,
      2,
      324.069547,
      NULL,
      3.538621,
      3,
      11,
      4.110527,
      NULL,
      2,
      261,
      NULL,
      2.362644,
      7.532405,
      64.308976,
      NULL,
      2,
      NULL,
      NULL,
      6.740708,
      NULL,
      NULL,
      185.394596,
      0.450224,
      2,
      2,
      1367,
      NULL,
      NULL,
      0,
      400.968661,
      17.664774,
      2.864266,
      1,
      856.521921,
      7,
      NULL,
      1,
      64,
      344.666803,
      0,
      3,
      NULL,
      NULL,
      NULL,
      2.642898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '41032',
      '',
      '',
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.375437,
      '',
      '',
      '',
      1,
      2.887313,
      35,
      NULL,
      21.754064,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.042935,
      NULL,
      1.087650,
      NULL,
      1.163649,
      NULL,
      NULL,
      NULL,
      1.766011,
      NULL,
      NULL,
      13.450521,
      NULL,
      5,
      0,
      NULL,
      0,
      NULL,
      11.319942,
      1.735404,
      7.317994,
      11,
      10.186418,
      5.117102,
      1.612233,
      17.641555,
      6,
      2,
      12,
      20.914861,
      0.373388,
      6,
      18,
      NULL,
      5.288260,
      7.144394,
      2.130353,
      5,
      19.165212,
      9.442398,
      0,
      4.520773,
      8,
      2,
      1.293108,
      10,
      18.300292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.493177,
      2,
      18,
      6,
      NULL,
      2,
      6.834481,
      28,
      22.716207,
      36.553114,
      2,
      NULL,
      NULL,
      1,
      7,
      0.362345,
      5,
      32,
      0.731816,
      23,
      NULL,
      0.349483,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      2,
      39,
      2,
      8.520091,
      56.398118,
      0,
      0,
      4.015348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31.255621,
      64.157609,
      183.362721,
      29.306191,
      166.630903,
      17,
      86.153029,
      139.957925,
      76.639103,
      30,
      14.562217,
      5.401748,
      65,
      78,
      60.093516,
      46,
      192.129171,
      92.910721,
      161.788178,
      0,
      NULL,
      1.728181,
      0.422216,
      2,
      2.693518,
      3.623951,
      2.802103,
      NULL,
      0,
      5,
      4,
      1,
      4,
      2.111204,
      0.740603,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767830,
      1.528063,
      NULL,
      5,
      0,
      6.301408,
      2.567126,
      3.262864,
      0,
      0,
      0.164729,
      0,
      1.401749,
      1,
      0.662182,
      0.793964,
      1.803267,
      0.587669,
      1.765609,
      1.057677,
      1,
      0.102853,
      5.881012,
      3,
      4.608565,
      NULL,
      3.761424,
      0.475446,
      NULL,
      0.598129,
      1.951475,
      3,
      1.001433,
      NULL,
      8.875729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608941,
      0,
      1,
      8.034180,
      4.762101,
      6.145988,
      2.475304,
      6,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.891172,
      1,
      0,
      1,
      NULL,
      1.670745,
      1,
      0,
      0.620635,
      4,
      4,
      4,
      2.982054,
      2,
      1,
      0.462286,
      1,
      5,
      4.764282,
      NULL,
      5,
      1.077188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.708213,
      1.625004,
      1,
      0.482751,
      3,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1.758209,
      1,
      1.429546,
      NULL,
      NULL,
      0.906497,
      0.720440,
      NULL,
      NULL,
      NULL,
      5,
      3,
      0.266576,
      0,
      1.236152,
      4,
      NULL,
      3.606090,
      1.311599,
      1,
      1.127388,
      6.209159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.433937,
      NULL,
      0,
      3.520727,
      3,
      0,
      3,
      NULL,
      0,
      0,
      1.600356,
      0,
      0.139258,
      0,
      0.681006,
      0.601824,
      NULL,
      1,
      1,
      1,
      NULL,
      0.086439,
      0.852496,
      NULL,
      NULL,
      1.921035,
      1.209968,
      2.450110,
      1,
      NULL,
      0.527679,
      5,
      1.202371,
      NULL,
      1.464039,
      1.004470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.389564,
      2,
      7,
      NULL,
      NULL,
      3,
      3,
      1.924615,
      NULL,
      0.568825,
      1,
      0.817959,
      1,
      NULL,
      1.010527,
      1,
      1,
      1.346042,
      0.560342,
      0,
      0.802460,
      1,
      0.542457,
      1,
      1.197845,
      0.847338,
      0,
      1.741921,
      NULL,
      1.071510,
      5.847682,
      4,
      3.123527,
      1.211311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      8.283111,
      7.449719,
      7,
      8.697039,
      1.354244,
      6,
      0,
      2,
      NULL,
      3,
      1.523311,
      1.370936,
      NULL,
      NULL,
      NULL,
      5,
      5.039412,
      2.922554,
      3.666759,
      1.413098,
      2,
      9,
      3,
      NULL,
      6.308431,
      1,
      5,
      3.237865,
      5,
      0,
      2,
      5,
      2.559273,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.158116,
      NULL,
      0.497014,
      7.348129,
      6.465648,
      NULL,
      1.510719,
      3,
      0.105916,
      0.703156,
      NULL,
      0,
      1,
      1,
      0.324291,
      5,
      2,
      1,
      4.950264,
      1.292916,
      5.719988,
      6,
      0,
      6.966190,
      1,
      0.992092,
      0.678216,
      NULL,
      3.789835,
      4,
      3,
      4,
      4.642541,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.416890,
      2.747317,
      4,
      7,
      1.893902,
      2.930892,
      NULL,
      4.707163,
      3.020612,
      4.117539,
      5,
      2.486942,
      1.143508,
      4.106217,
      2.527390,
      4,
      0,
      5.638053,
      4.037653,
      2.668653,
      5.665083,
      0.475428,
      0,
      0,
      3,
      NULL,
      0,
      3,
      5,
      2,
      5,
      4,
      1,
      4.175413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.092876,
      3.189773,
      5.345860,
      5,
      0,
      5,
      4,
      1,
      2.493516,
      1.395232,
      0.382369,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0.105342,
      1.779761,
      1,
      4.595920,
      1.525950,
      4,
      0.121764,
      0,
      2.810556,
      2.615806,
      NULL,
      3,
      NULL,
      1,
      NULL,
      6,
      4.603265,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962705,
      0,
      0,
      0.293341,
      0,
      NULL,
      NULL,
      1.971237,
      3,
      4,
      2,
      1.673742,
      NULL,
      NULL,
      0,
      1.692196,
      1.782676,
      1.256436,
      1.115492,
      0.203608,
      NULL,
      1,
      6,
      NULL,
      4.767388,
      1.298331,
      NULL,
      NULL,
      3,
      4.180197,
      NULL,
      4,
      2.353129,
      0.309084,
      9.051510,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0.159280,
      1,
      NULL,
      0,
      0.838254,
      NULL,
      1,
      0.936087,
      1.601378,
      0,
      1.393480,
      1,
      NULL,
      0,
      0.732866,
      0.164797,
      0.265300,
      0,
      0.231308,
      1,
      0.939643,
      1,
      1.307577,
      0.790065,
      NULL,
      NULL,
      0,
      0,
      1,
      0.075436,
      NULL,
      1.545652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588596,
      2.574830,
      5,
      NULL,
      4,
      0.450019,
      0,
      3,
      NULL,
      0.781463,
      1,
      NULL,
      1,
      0.713993,
      0.676044,
      0,
      4.002202,
      3,
      NULL,
      1,
      3.852648,
      0.648241,
      0,
      NULL,
      0,
      1.357093,
      1.058976,
      0.283787,
      NULL,
      NULL,
      1.820324,
      2,
      2.367007,
      NULL,
      0.255854,
      4.812829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.405118,
      5,
      7,
      0,
      5,
      NULL,
      0,
      4,
      3,
      0.815572,
      NULL,
      NULL,
      0,
      NULL,
      1.603215,
      0,
      0.352742,
      1,
      1,
      0,
      0,
      1.002721,
      NULL,
      3.094282,
      NULL,
      4,
      1,
      NULL,
      5,
      NULL,
      NULL,
      5.570705,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.661911,
      0,
      NULL,
      6,
      6.980190,
      NULL,
      1,
      3,
      5,
      0,
      0,
      1.675709,
      0.365619,
      0,
      1.593154,
      1.859299,
      1.308707,
      1.691870,
      1,
      1,
      1.181761,
      0.472573,
      3,
      5.739050,
      7.138185,
      1,
      2,
      1,
      0,
      2.229723,
      NULL,
      NULL,
      1.678803,
      1.517955,
      7.532884,
      7.700923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.834238,
      1.913351,
      NULL,
      6,
      3,
      6.337829,
      NULL,
      NULL,
      NULL,
      0,
      1.680774,
      NULL,
      NULL,
      NULL,
      3.319465,
      4.916075,
      2.059789,
      4.755231,
      5,
      0.215561,
      0,
      2,
      7,
      2,
      1.192978,
      3,
      0,
      1,
      4,
      4,
      2.426654,
      NULL,
      7,
      2,
      1.483801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.058044,
      NULL,
      1,
      0.282934,
      1,
      NULL,
      NULL,
      0.487869,
      0,
      1.670938,
      NULL,
      0,
      0.103518,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0.625975,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      3.845493,
      5,
      0,
      NULL,
      3.009689,
      NULL,
      NULL,
      0.135403,
      NULL,
      0.975419,
      1.122157,
      0,
      0,
      NULL,
      4.395275,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272755,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      3,
      2,
      2,
      3,
      NULL,
      NULL,
      2,
      7,
      7,
      4,
      0,
      0,
      NULL,
      2,
      5,
      2,
      1,
      1,
      NULL,
      4,
      1,
      NULL,
      1,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      0,
      NULL,
      1,
      0,
      0,
      0,
      4,
      3,
      3,
      0,
      4,
      0,
      3,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      4,
      3,
      NULL,
      4,
      0,
      5,
      1,
      5,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.569354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-26-1978',
      '10- 8-1996',
      ' 3-13-1980',
      ' 7- 7-2003',
      NULL,
      '10-27-1988',
      ' 5- 2-2001',
      ' 8-15-1977',
      ' 7- 0-1982',
      NULL,
      ' 9-28-1989',
      ' 2- 9-1991',
      ' 6-28-1999',
      ' 3- 7-1999',
      '11- 7-1992',
      ' 4-16-1992',
      ' 3- 3-1990',
      '11- 2-1983',
      NULL,
      ' 9-16-1993',
      ' 9-18-1990',
      ' 0-28-1999',
      ' 3-23-1979',
      ' 5-19-2002',
      ' 0-12-1984',
      ' 1-13-1983',
      ' 3-18-2001',
      ' 6-10-1977',
      ' 1-29-1991',
      ' 8-23-2001',
      NULL,
      NULL,
      ' 8- 5-1996',
      ' 8-19-1988',
      ' 5-12-1998',
      ' 7-24-1997',
      ' 1-17-1988',
      '10- 9-1982',
      ' 9-18-2002',
      NULL,
      ' 9-22-1988',
      ' 6-26-1993',
      ' 6- 6-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 9-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


