set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9716837';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '403',
      '31142033',
      1,
      1,
      '4402010',
      NULL,
      0.733105,
      NULL,
      '23100',
      6.005374,
      ' 5-19-1994',
      31.300618,
      NULL,
      NULL,
      0,
      3.871141,
      0,
      1.430552,
      NULL,
      NULL,
      3.257031,
      2.808614,
      3,
      1.152115,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.641528,
      64.640204,
      10,
      NULL,
      3.698256,
      NULL,
      1,
      1.461547,
      1,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      3,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      5,
      3,
      0,
      NULL,
      1,
      0,
      NULL,
      0.403843,
      NULL,
      0,
      3,
      3,
      NULL,
      0.566056,
      9,
      6,
      1,
      0,
      NULL,
      NULL,
      1.268432,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      1,
      NULL,
      2,
      25.833328,
      86,
      11.876376,
      0.651420,
      3,
      80.787462,
      NULL,
      0,
      NULL,
      125.043038,
      NULL,
      1.327963,
      3,
      185.457198,
      NULL,
      1,
      0.692006,
      NULL,
      NULL,
      2.869527,
      3,
      NULL,
      NULL,
      3.876274,
      NULL,
      165.538012,
      3.510644,
      0.463415,
      4,
      67.040038,
      447.204486,
      NULL,
      0.083210,
      NULL,
      127.114097,
      3,
      NULL,
      177.149066,
      3,
      1,
      1,
      206.235024,
      8.644115,
      0,
      NULL,
      714.663153,
      2.735695,
      2,
      5.277141,
      179,
      6.659759,
      1.497196,
      7.325770,
      117.936969,
      6.883802,
      NULL,
      6.315621,
      106.818244,
      4,
      1.143100,
      NULL,
      219.208095,
      0.076153,
      2,
      1,
      202.727612,
      57.062636,
      NULL,
      NULL,
      194.155950,
      13,
      1.035973,
      5.291593,
      115.153456,
      NULL,
      2,
      NULL,
      43,
      NULL,
      3,
      1.884558,
      1157.709601,
      1,
      2,
      NULL,
      143.833127,
      NULL,
      1,
      NULL,
      774.151774,
      5,
      3,
      NULL,
      139,
      7.822388,
      3,
      7.552213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825499,
      3.452540,
      109.903740,
      4,
      3.359572,
      5,
      1016,
      492.475391,
      1,
      3,
      173,
      31.088361,
      2,
      0.450169,
      183,
      9.350241,
      2,
      0,
      126,
      562,
      NULL,
      1.583142,
      56.986727,
      188.643803,
      2.891697,
      NULL,
      118.110680,
      NULL,
      NULL,
      0.592232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.195360,
      '11140',
      '24030',
      '',
      '',
      '',
      '',
      1.099569,
      NULL,
      '',
      '',
      1,
      '42300',
      '',
      '',
      4,
      0.522622,
      NULL,
      1.628179,
      NULL,
      NULL,
      NULL,
      1.506798,
      NULL,
      4,
      11.691728,
      NULL,
      NULL,
      1.098652,
      767,
      NULL,
      NULL,
      0.375231,
      524.445463,
      1.348594,
      NULL,
      NULL,
      4,
      NULL,
      2,
      NULL,
      0,
      NULL,
      16.032650,
      NULL,
      18.261418,
      7.578180,
      23,
      15,
      8.653171,
      3,
      4,
      3.351168,
      1,
      2,
      NULL,
      NULL,
      11.737030,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.582576,
      1,
      NULL,
      2.262247,
      2,
      0.604270,
      2,
      3,
      2.540984,
      0,
      39.514053,
      31.531954,
      NULL,
      19.262837,
      NULL,
      13,
      12,
      NULL,
      14.070097,
      NULL,
      NULL,
      5,
      26,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      151,
      18.029059,
      38,
      70.936263,
      120.256938,
      7,
      1,
      0,
      NULL,
      3,
      2.237399,
      2,
      1,
      1,
      1.104436,
      5,
      NULL,
      1.800975,
      4,
      0,
      4,
      0,
      4.302881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.920202,
      1,
      0.849201,
      3.133888,
      NULL,
      1,
      5.065293,
      4.217683,
      1.153773,
      1,
      4,
      4,
      5.837995,
      7.672452,
      9,
      6,
      1,
      7.506276,
      4,
      NULL,
      7.969638,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      1,
      3,
      9,
      4.642342,
      1.614335,
      3.956615,
      2.219573,
      2,
      0,
      6,
      10,
      2,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.169436,
      8,
      4.981932,
      3.949591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.393249,
      1.316034,
      NULL,
      0,
      1.667139,
      1.030062,
      0.204004,
      NULL,
      NULL,
      0,
      4,
      0.930721,
      11.756081,
      0,
      5,
      0,
      0.410892,
      NULL,
      1,
      4.835228,
      1,
      0.063981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.266460,
      1.426352,
      0.130790,
      0.688951,
      0.163770,
      0.120649,
      0.230230,
      1.893880,
      NULL,
      0,
      0,
      1,
      1,
      0.981216,
      1.291977,
      1.927450,
      1.140925,
      1.476415,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087223,
      1.246580,
      4.556440,
      9.419814,
      4,
      NULL,
      1,
      4.412856,
      8.089572,
      NULL,
      NULL,
      9,
      6,
      9,
      2,
      1,
      NULL,
      8,
      8.917461,
      4.144179,
      5,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.726105,
      6.737554,
      3.955770,
      8,
      7.129795,
      7.565359,
      1,
      NULL,
      2,
      3,
      NULL,
      6.767014,
      3,
      6.962511,
      7,
      0.662950,
      1.278168,
      2,
      9.141063,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      10,
      2,
      0.073916,
      NULL,
      1.794413,
      5.752641,
      NULL,
      8,
      8,
      0.736388,
      0,
      8.287106,
      5,
      4,
      6.106295,
      5.773333,
      10,
      NULL,
      6,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.881620,
      1.130183,
      0.614941,
      8,
      0.157682,
      NULL,
      5.457219,
      2.458504,
      9.940552,
      7.478081,
      2,
      9.670038,
      5.885433,
      1.022881,
      1,
      0,
      5,
      9,
      7,
      6.677535,
      2.488988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.534203,
      NULL,
      1.710076,
      1,
      1,
      NULL,
      0,
      1.720492,
      0,
      0.468897,
      NULL,
      NULL,
      1.251739,
      1,
      NULL,
      1.527295,
      1.282593,
      NULL,
      0.078228,
      1.002941,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006507,
      1.238727,
      NULL,
      1,
      1.925398,
      0.703393,
      0,
      0.020945,
      0,
      1,
      1.361838,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      1.587450,
      0.389603,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.593760,
      0.319859,
      0.319307,
      0,
      0.702976,
      1,
      0.567594,
      1,
      1,
      1.715347,
      1,
      1,
      0.316697,
      NULL,
      0,
      1.438946,
      0.519108,
      1,
      1.760622,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295441,
      1,
      0.408154,
      NULL,
      1,
      0.409600,
      0,
      1.268669,
      0,
      NULL,
      0,
      4.415708,
      6.386279,
      5.646171,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.993094,
      NULL,
      0.350495,
      NULL,
      1.366039,
      0,
      0.280072,
      5,
      0.099424,
      5.105751,
      NULL,
      2.005283,
      1,
      7.918759,
      4.214949,
      7,
      5,
      1.306406,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      9,
      8,
      7,
      1.539079,
      NULL,
      5.808081,
      4.061663,
      5,
      5,
      2,
      6,
      0.533102,
      3.993633,
      5.291578,
      6.070235,
      NULL,
      1.703407,
      0.451514,
      5.679078,
      4.561075,
      4.720635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5.076074,
      7,
      6.939039,
      NULL,
      0.240014,
      1,
      3.645186,
      9.565477,
      6,
      0,
      3.293940,
      3,
      6.635488,
      5,
      NULL,
      NULL,
      NULL,
      9.027818,
      6.959278,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.467101,
      0,
      0.253696,
      1.390450,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.888518,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0.358803,
      1.408413,
      0.806945,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.009453,
      0.203809,
      NULL,
      NULL,
      4,
      1,
      0.574567,
      1,
      1.925197,
      0,
      2.985383,
      1.354706,
      NULL,
      NULL,
      1,
      0.790894,
      NULL,
      0,
      NULL,
      3.916081,
      1,
      1,
      1.461945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      2,
      0,
      1,
      1,
      1,
      1,
      NULL,
      4,
      3,
      1,
      2,
      NULL,
      0,
      1,
      1,
      4,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-11-1993',
      ' 3-17-1978',
      ' 5- 8-1975',
      ' 7-20-1990',
      ' 9- 4-1986',
      ' 3- 2-1994',
      '11-16-1976',
      ' 2-13-1974',
      '11-21-1993',
      ' 0-16-1992',
      NULL,
      ' 9- 1-1988',
      '10-10-1977',
      ' 0- 9-1991',
      ' 4-22-1981',
      NULL,
      ' 1-22-1998',
      ' 8- 3-1997',
      NULL,
      NULL,
      NULL,
      '11-27-1974',
      ' 8-20-1974',
      ' 4-28-2002',
      NULL,
      NULL,
      NULL,
      ' 7-29-1998',
      ' 2-21-1986',
      ' 6- 5-1984',
      ' 6- 0-1983',
      NULL,
      ' 2-21-1990',
      ' 8-27-1998',
      '11- 6-1980',
      ' 9-17-2002',
      NULL,
      ' 0-22-2000',
      ' 3-16-1983',
      ' 8-22-1977',
      ' 0-12-2001',
      ' 4- 9-2000',
      ' 3- 0-1974',
      ' 6- 3-1995',
      '11- 4-2003',
      '10-13-1998',
      ' 7-21-1994',
      NULL,
      ' 6-19-1995',
      ' 0-15-1992',
      ' 5- 2-1981',
      ' 8-10-1986',
      NULL,
      ' 3- 4-1988',
      ' 5-21-1994',
      '10- 5-1987',
      NULL,
      ' 9- 7-1989',
      '10- 0-1976',
      NULL,
      ' 4-22-1989',
      NULL,
      ' 7-26-1997',
      ' 6-13-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-29-1990',
      ' 0-29-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


