set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9670225';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '13041',
      NULL,
      ' 4-25-1989',
      122.726223,
      NULL,
      NULL,
      1,
      3.372029,
      1,
      1.813559,
      2,
      1,
      0,
      2.379158,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.916597,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.424927,
      1,
      0.397581,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      7,
      0.442433,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0.691307,
      1.171471,
      2,
      NULL,
      4,
      2,
      NULL,
      NULL,
      0,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.911537,
      2.481250,
      3,
      NULL,
      0,
      1,
      1,
      26,
      97.955022,
      3.892191,
      2,
      3.880449,
      111,
      77.723025,
      2,
      1,
      303.105632,
      NULL,
      0,
      3.870519,
      88.927723,
      2,
      NULL,
      2,
      199,
      85,
      1,
      3,
      203,
      3,
      3.803694,
      3,
      NULL,
      92.123695,
      2.636430,
      NULL,
      239,
      11,
      2,
      5,
      75,
      NULL,
      2.300665,
      7,
      814.218764,
      1916.085085,
      3.135577,
      2,
      162.643430,
      28,
      2,
      2.639220,
      141.863725,
      3.148351,
      3.881479,
      5.772036,
      NULL,
      2,
      NULL,
      0,
      94,
      45.630098,
      0,
      NULL,
      165,
      2,
      3,
      0.825847,
      457,
      121.009994,
      2.739965,
      NULL,
      39,
      5.483592,
      NULL,
      7,
      211.732718,
      8.859918,
      2,
      NULL,
      21,
      14.239616,
      1.130427,
      4.186479,
      NULL,
      4,
      1,
      2.863932,
      596,
      46.854716,
      3,
      NULL,
      344.686631,
      210,
      NULL,
      0,
      34.731479,
      8.230940,
      1,
      NULL,
      NULL,
      8.155747,
      2.080290,
      NULL,
      NULL,
      5,
      2.565447,
      NULL,
      NULL,
      10,
      1,
      1,
      280.829918,
      1594,
      3,
      1,
      NULL,
      6.023455,
      0.127142,
      2.215009,
      290,
      2,
      2,
      2.601318,
      340.630076,
      7.006309,
      NULL,
      NULL,
      41,
      2,
      2,
      NULL,
      215,
      1.139174,
      0,
      3,
      51.396509,
      3.573341,
      3,
      3.254897,
      709.292882,
      7,
      2.289669,
      2.569240,
      NULL,
      4.215237,
      1,
      NULL,
      1138,
      2891,
      NULL,
      NULL,
      24.236958,
      2735,
      0.968238,
      9.490823,
      195.440949,
      1,
      NULL,
      NULL,
      NULL,
      113.602476,
      2.932222,
      2.028981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878798,
      '30433',
      '03333',
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3,
      '03030',
      NULL,
      '',
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      1.891736,
      NULL,
      1.658108,
      NULL,
      0,
      NULL,
      3.371395,
      185.870649,
      1,
      NULL,
      '10-21-1983',
      NULL,
      8.127310,
      2,
      3.056122,
      1.533175,
      12.319927,
      NULL,
      4,
      1.413265,
      NULL,
      14,
      6.786351,
      13.728352,
      8,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.445596,
      NULL,
      NULL,
      18,
      27.161125,
      3.514043,
      4.982162,
      2,
      8,
      31.052740,
      NULL,
      NULL,
      17,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.640273,
      100,
      28,
      144,
      1,
      NULL,
      126,
      109,
      NULL,
      NULL,
      158.706531,
      90,
      90.144761,
      144,
      115.446741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.813025,
      5,
      NULL,
      11.941888,
      6.128411,
      6.881653,
      6,
      7.653201,
      NULL,
      3,
      NULL,
      0,
      6,
      7,
      6.594045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.124136,
      NULL,
      9.728125,
      NULL,
      NULL,
      1.046215,
      7.355264,
      NULL,
      3,
      NULL,
      NULL,
      4.077885,
      0,
      9.966381,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.331709,
      6.539688,
      3,
      7,
      2.674236,
      1,
      NULL,
      0.321403,
      0,
      NULL,
      0.171461,
      4,
      9.610031,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      9.911312,
      0,
      0.723463,
      0.317022,
      1,
      NULL,
      NULL,
      0.133439,
      5.149382,
      5.142903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.518887,
      0.029909,
      NULL,
      0,
      1.884455,
      0.787579,
      1.445355,
      NULL,
      1.925441,
      1,
      4,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      5,
      NULL,
      4.788559,
      7.990807,
      9.087139,
      2,
      NULL,
      6.236869,
      1,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      7,
      3,
      NULL,
      6,
      4.313480,
      NULL,
      2,
      2.348696,
      5.087520,
      10.795343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.999480,
      NULL,
      2,
      NULL,
      5.419435,
      3,
      1,
      5.794735,
      NULL,
      1.473883,
      2.829529,
      0.538635,
      0.569147,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.275629,
      1.695918,
      0.103757,
      0.512662,
      NULL,
      1.433197,
      1.596079,
      1.349533,
      0,
      8.066006,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.039411,
      0.161144,
      7.698023,
      NULL,
      NULL,
      1,
      0,
      1.708615,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.116253,
      1,
      1,
      2.619268,
      0,
      3.303802,
      1,
      NULL,
      0,
      NULL,
      6.286789,
      3.429260,
      4,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.904952,
      0,
      0.245606,
      1.823027,
      NULL,
      0,
      0.657696,
      1,
      1.026236,
      1,
      1.425809,
      0.894857,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020854,
      1.796793,
      NULL,
      1,
      1,
      1.569278,
      1,
      1.658162,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      8,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4.303973,
      0,
      1,
      7,
      3.975294,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      7.618748,
      2,
      4,
      0,
      4,
      4,
      2.184799,
      1,
      3.843131,
      NULL,
      5,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.200316,
      2,
      1,
      3.926168,
      1,
      0.512589,
      NULL,
      3,
      1.669045,
      5,
      2,
      0.513250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716076,
      1.273675,
      4,
      1,
      0.191413,
      1.590591,
      1.483279,
      0.597306,
      NULL,
      0.384741,
      1,
      1,
      1.287314,
      1,
      1.051194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      1,
      4,
      1,
      0,
      5,
      0,
      0,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-10-1979',
      ' 2-16-1998',
      ' 6- 8-1984',
      ' 8-21-1990',
      ' 2-21-1979',
      ' 2-25-1979',
      NULL,
      ' 7- 6-1993',
      ' 2- 5-1980',
      ' 9- 8-1991',
      ' 5-26-1977',
      ' 8-10-1988',
      ' 8- 1-1988',
      '10- 6-1988',
      NULL,
      ' 5-29-1989',
      ' 0- 7-1974',
      NULL,
      NULL,
      ' 7-18-1986',
      '10- 6-1989',
      ' 7-19-1998',
      NULL,
      ' 6- 3-1987',
      ' 7-15-1988',
      ' 3- 1-1986',
      NULL,
      ' 2- 1-1995',
      ' 7-14-1983',
      ' 3-24-1995',
      ' 0- 6-1993',
      ' 4-20-1989',
      ' 4-12-1995',
      NULL,
      NULL,
      ' 5- 7-1995',
      '10- 0-1996',
      ' 5-20-1977',
      ' 3- 4-1974',
      '11-17-1981',
      ' 8-20-1975',
      NULL,
      ' 0-19-2001',
      NULL,
      '10-21-1994',
      ' 4-23-1981',
      ' 4-24-1985',
      ' 9-19-1994',
      ' 7- 7-1991',
      NULL,
      ' 1-14-1987',
      ' 0- 2-1975',
      NULL,
      NULL,
      ' 1-13-1999',
      NULL,
      ' 5-10-2000',
      NULL,
      ' 1-28-1984',
      ' 3-28-1984',
      '11-17-1999',
      '10- 8-1989',
      NULL,
      ' 2- 3-1980',
      ' 7-14-1981',
      ' 3- 7-1980',
      '11- 4-1982',
      '10-12-1974',
      NULL,
      '10-21-1975',
      NULL,
      NULL,
      ' 3-11-1997',
      ' 8-11-2002',
      '10-18-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1999',
      NULL,
      ' 2- 3-1999',
      ' 7-19-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319177);
commit;
end;
/


