set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655289';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '111',
      '12210242',
      43.657438,
      55.815825,
      '2202034',
      1,
      3,
      0,
      '33414',
      0,
      NULL,
      223.815292,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.836287,
      0,
      0.203777,
      3,
      2,
      2.909506,
      0.653943,
      0,
      NULL,
      NULL,
      0.892422,
      NULL,
      0,
      24.149418,
      13,
      4,
      NULL,
      NULL,
      2.438992,
      1,
      0,
      3,
      NULL,
      NULL,
      6,
      4,
      2,
      3,
      1,
      0,
      9,
      NULL,
      4,
      NULL,
      0,
      1,
      7,
      2,
      0,
      3.922486,
      3,
      1.126165,
      1.748051,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.458096,
      0.505129,
      4,
      NULL,
      NULL,
      1.727490,
      3,
      3,
      3,
      0,
      5.948963,
      ' 3- 9-2003',
      9.651694,
      NULL,
      3.721385,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      223.617190,
      4.942974,
      3.416674,
      NULL,
      167,
      9.377210,
      2,
      3,
      54,
      NULL,
      1.151145,
      4.977842,
      91.856510,
      19,
      3.513883,
      2.741155,
      426,
      NULL,
      NULL,
      5.156323,
      NULL,
      NULL,
      3.057015,
      0.916935,
      371,
      2.610974,
      2,
      0,
      74,
      162,
      NULL,
      5,
      322.569831,
      0,
      1.767595,
      0,
      721,
      0.159450,
      3.412040,
      2.460468,
      NULL,
      NULL,
      0,
      0.455470,
      NULL,
      7.075187,
      2.039843,
      NULL,
      86.186225,
      7.421604,
      NULL,
      3,
      120,
      6.052144,
      2,
      0.291097,
      214.765575,
      37,
      3,
      2,
      79,
      30.590505,
      0.408986,
      0,
      212.047632,
      2,
      NULL,
      0,
      210,
      50,
      1,
      0.804839,
      709,
      7.619587,
      0,
      4.434579,
      644.348960,
      NULL,
      1.497727,
      1,
      NULL,
      68,
      NULL,
      NULL,
      203.026921,
      28.599580,
      1.464177,
      1,
      NULL,
      69.584255,
      3.296755,
      NULL,
      199,
      NULL,
      2.751493,
      0.405280,
      8.470129,
      7,
      NULL,
      0.430531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.985789,
      '21224',
      '30201',
      '13211',
      '',
      '',
      NULL,
      1.535646,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      2,
      NULL,
      NULL,
      0.205787,
      585,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.764833,
      NULL,
      1.235445,
      NULL,
      NULL,
      327.799262,
      0,
      NULL,
      3.577660,
      6,
      NULL,
      9,
      2.777338,
      5,
      7.599091,
      8.690776,
      5,
      NULL,
      4,
      NULL,
      6,
      0.025565,
      6.635191,
      14,
      5,
      17.422551,
      5.378409,
      6,
      2,
      NULL,
      2.064212,
      2.856973,
      NULL,
      22.751684,
      4,
      NULL,
      6.806083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.842856,
      NULL,
      3.015561,
      3,
      13,
      NULL,
      14.823713,
      9.592950,
      30,
      2.410763,
      0,
      3.591058,
      NULL,
      2,
      5.065707,
      1,
      2,
      9.047532,
      NULL,
      20,
      1.925796,
      NULL,
      48.741232,
      22.987991,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69,
      100,
      143,
      162.510032,
      95.438580,
      51,
      110,
      18,
      151,
      57.959791,
      39,
      181,
      152,
      NULL,
      133,
      136.373797,
      1,
      NULL,
      0.277121,
      0,
      NULL,
      1,
      4,
      4,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.176860,
      3,
      4.399614,
      NULL,
      1.438775,
      NULL,
      0.754006,
      5,
      NULL,
      5.945992,
      NULL,
      6,
      9,
      6,
      0,
      2,
      NULL,
      6.720892,
      6,
      NULL,
      2.285161,
      5.960487,
      3.802926,
      4,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.737859,
      NULL,
      4,
      5,
      3,
      1.087345,
      NULL,
      6.090777,
      1.975922,
      4.663990,
      3.032332,
      1.481337,
      1.772146,
      2,
      3.929716,
      9.589335,
      2.113902,
      8.186743,
      NULL,
      8.681737,
      7.545453,
      7.151597,
      5.224274,
      7,
      6.908571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.461182,
      NULL,
      0.972954,
      1,
      0,
      1,
      1,
      10.544826,
      NULL,
      NULL,
      3,
      5,
      2.006339,
      9.313847,
      3.237090,
      3,
      3,
      3,
      3,
      2.623137,
      NULL,
      5.657909,
      1,
      5.663074,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.392666,
      4.342008,
      0,
      NULL,
      4,
      NULL,
      0,
      0.342188,
      4.680172,
      2.625769,
      5.818502,
      2.861651,
      9.850111,
      NULL,
      1.175037,
      3,
      NULL,
      5.452258,
      2,
      1.415753,
      1.992829,
      0.062658,
      0.141897,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.117945,
      1,
      1.660042,
      5,
      5.174601,
      4.034088,
      0.613569,
      NULL,
      2.525583,
      5.470025,
      NULL,
      3,
      3,
      NULL,
      0.760393,
      4.707998,
      NULL,
      3,
      3,
      4.086124,
      3,
      1.217488,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      8,
      9.942505,
      4.361658,
      9,
      5.636421,
      8.568790,
      6.860573,
      7.562118,
      6.230617,
      1,
      4.656836,
      5,
      3,
      9,
      NULL,
      3.722586,
      4.556374,
      NULL,
      2,
      7.259611,
      1,
      9,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.404660,
      7,
      3,
      6,
      4,
      7,
      NULL,
      0,
      0,
      2,
      8.030486,
      5.541766,
      3,
      7.295394,
      3.996984,
      5,
      4,
      5.077681,
      1.695801,
      8.525623,
      NULL,
      7.707749,
      5,
      0.735800,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      7,
      NULL,
      0.666671,
      NULL,
      1.620706,
      NULL,
      1,
      NULL,
      0.769153,
      NULL,
      0.256094,
      NULL,
      1.579436,
      NULL,
      NULL,
      0,
      1,
      2.566558,
      0.751141,
      1.041311,
      1.536751,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.936641,
      NULL,
      1.089739,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.544055,
      2,
      5,
      5,
      2,
      1.249674,
      4,
      1,
      1,
      4.901446,
      1,
      1.365073,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.684476,
      0,
      0,
      1,
      4,
      1,
      2,
      NULL,
      0,
      1.403105,
      4.952885,
      NULL,
      4.305031,
      1,
      NULL,
      1.596241,
      3.900629,
      0,
      1,
      1,
      1.631094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.041491,
      1,
      0.563663,
      0.082185,
      1.321133,
      1,
      1.433955,
      NULL,
      1.789641,
      0.330967,
      0.383256,
      1.100237,
      0,
      0,
      0.258330,
      0,
      NULL,
      NULL,
      0.719652,
      0.736607,
      0,
      1.118685,
      1.007932,
      0.800600,
      0.673286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408445,
      0.191223,
      1.844334,
      1,
      1.245368,
      1,
      0,
      1.251605,
      1.764855,
      1.599825,
      NULL,
      0.130284,
      NULL,
      NULL,
      0.200586,
      0.581090,
      0.428882,
      1,
      1,
      0.951057,
      0,
      NULL,
      2,
      1.955613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357902,
      2,
      3.997556,
      2,
      1.472368,
      1,
      5,
      0,
      5.872191,
      3,
      4.389750,
      NULL,
      4,
      2.366859,
      1.486944,
      1,
      NULL,
      0.310657,
      1.147713,
      0,
      0.423264,
      0.494689,
      4,
      0.710523,
      4,
      0.433329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.816831,
      4.170231,
      5.941026,
      5.212734,
      5,
      3,
      1,
      3.817224,
      0,
      4.021226,
      0,
      1.710820,
      6,
      4.092449,
      NULL,
      NULL,
      4.507668,
      6,
      2,
      8.257710,
      3.955471,
      0.291646,
      5.954222,
      7.721456,
      0.778601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      5,
      3.108313,
      6.707079,
      8.149703,
      NULL,
      1.662175,
      0,
      NULL,
      6,
      NULL,
      NULL,
      0.790325,
      NULL,
      3,
      1.297982,
      7,
      NULL,
      6.523197,
      6.883745,
      7.422184,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.772412,
      1,
      NULL,
      NULL,
      0.870974,
      1.719589,
      0.561338,
      NULL,
      1.016935,
      1.226343,
      0.084949,
      0,
      NULL,
      0,
      NULL,
      1.509095,
      1.712728,
      0,
      0,
      1.836250,
      0,
      1.129026,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      1.134594,
      1.916451,
      NULL,
      0.266869,
      1,
      0.426920,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0.420878,
      1,
      1,
      0.019000,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1,
      NULL,
      3,
      1,
      0,
      0,
      4,
      1,
      3,
      1,
      4,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      4,
      1,
      5,
      1,
      3,
      NULL,
      5,
      0,
      2,
      0,
      7,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      5,
      2,
      3,
      0,
      NULL,
      NULL,
      1,
      2,
      5,
      2,
      NULL,
      3,
      3,
      2,
      1,
      3,
      NULL,
      0,
      4,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      1,
      3,
      0,
      3,
      1,
      3,
      2,
      1,
      0,
      0,
      0,
      2,
      1,
      NULL,
      3,
      1,
      1,
      0,
      1,
      3,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-17-1993',
      ' 7-12-1988',
      ' 0- 8-1982',
      ' 9-12-1989',
      NULL,
      NULL,
      ' 6-16-1980',
      ' 0-15-1979',
      ' 4-20-1993',
      ' 1- 2-1976',
      ' 6-12-1977',
      '10- 3-1989',
      ' 9-12-2002',
      NULL,
      ' 1- 0-2002',
      ' 8- 9-1981',
      ' 4-28-2001',
      ' 6-24-1976',
      ' 0-15-1998',
      NULL,
      ' 5- 7-1975',
      ' 9- 2-1985',
      NULL,
      ' 5-19-2001',
      ' 9- 1-1985',
      ' 4-26-1998',
      ' 3-24-1979',
      ' 4-23-1994',
      ' 8- 6-1999',
      ' 5-16-1996',
      ' 0-28-2001',
      NULL,
      ' 5-15-1974',
      '10-26-1994',
      ' 9-23-2001',
      ' 0- 7-1977',
      '11-23-1995',
      ' 0- 7-1999',
      ' 0-25-1991',
      ' 2-20-1990',
      NULL,
      ' 6-11-1981',
      ' 1- 6-1980',
      ' 7-14-1998',
      ' 1-26-1992',
      '10-12-1998',
      '10-27-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-17-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.945404);
commit;
end;
/


