set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505264';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      '0313323',
      3,
      3.854000,
      2,
      '01311',
      0,
      NULL,
      18,
      NULL,
      0,
      1,
      0.332110,
      0,
      1,
      0,
      1,
      2,
      0,
      2.306409,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.184954,
      0.076905,
      2,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      4,
      3,
      0,
      3,
      5.895645,
      NULL,
      1,
      3,
      1,
      0,
      0,
      1,
      2,
      NULL,
      NULL,
      0,
      1,
      2,
      2,
      2,
      3.625098,
      4,
      9,
      1.772616,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      NULL,
      1,
      5,
      NULL,
      NULL,
      89.253906,
      19.106933,
      NULL,
      2.709530,
      32,
      0,
      0.127580,
      1.425597,
      NULL,
      327,
      1.231037,
      1.343788,
      NULL,
      2.488206,
      2.918601,
      3,
      116.186380,
      5.227678,
      2,
      4.837665,
      NULL,
      38,
      2,
      NULL,
      148,
      4,
      0.688094,
      1.698412,
      98,
      NULL,
      0.418093,
      3.489953,
      NULL,
      0,
      NULL,
      7,
      391,
      229.877350,
      0.239001,
      2,
      93,
      35,
      3,
      0,
      74,
      10,
      5,
      1,
      19,
      24.531833,
      0,
      NULL,
      544.347698,
      45,
      3.964074,
      1,
      NULL,
      371.241321,
      NULL,
      5.425885,
      98.019597,
      NULL,
      3.907775,
      7,
      147,
      21.919662,
      NULL,
      8.638114,
      NULL,
      2.891811,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      316.845509,
      2200.179154,
      3,
      NULL,
      326,
      90,
      2.951788,
      NULL,
      109,
      NULL,
      0,
      9,
      14.032005,
      2.894132,
      0.323396,
      3.238561,
      141.322996,
      12.039977,
      6.947263,
      2,
      95.352866,
      28.030497,
      2,
      7.815970,
      173,
      47,
      NULL,
      NULL,
      108,
      80.382791,
      2,
      NULL,
      928.947185,
      181,
      3.352064,
      0.831657,
      NULL,
      NULL,
      3,
      NULL,
      835.866048,
      13,
      2,
      4,
      NULL,
      0.377873,
      1.923459,
      1,
      NULL,
      4,
      1,
      NULL,
      98,
      0.549876,
      2.678712,
      5,
      NULL,
      2.334877,
      0.035603,
      9.621414,
      799,
      0,
      0,
      1.275920,
      288.842749,
      9,
      0.006331,
      2,
      167.594093,
      5.866980,
      3.457854,
      7.668014,
      121,
      51,
      0.835536,
      5,
      167.202754,
      NULL,
      2.789327,
      NULL,
      140,
      270.937541,
      3,
      5.459863,
      166.278516,
      131.984129,
      3.762465,
      4.390454,
      90,
      204.500046,
      NULL,
      3.720024,
      64,
      537,
      0,
      5.618636,
      686.835385,
      6.168813,
      2.129255,
      9.789661,
      90,
      497,
      2.779769,
      0.884519,
      14,
      NULL,
      3.861741,
      0.989885,
      404,
      2.022205,
      2,
      3.977382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.952995,
      '40221',
      '23221',
      '10444',
      '',
      '',
      '',
      2.926060,
      '23404',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      1.261509,
      NULL,
      1,
      619.559804,
      0.621221,
      NULL,
      1.626889,
      NULL,
      1.476971,
      NULL,
      NULL,
      2.164725,
      1.680317,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      405,
      NULL,
      4,
      20,
      0,
      0.225514,
      1.379474,
      3,
      0.332185,
      11.407699,
      NULL,
      9,
      0,
      4,
      6.891846,
      1,
      0.856241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      25.184226,
      1,
      NULL,
      NULL,
      13.840125,
      15,
      1.990155,
      12.606772,
      NULL,
      9.766015,
      0,
      2.446199,
      0,
      39,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      124,
      131.299665,
      85,
      56.867433,
      82,
      47,
      153.012539,
      31.154843,
      132,
      NULL,
      139,
      NULL,
      126,
      123.209748,
      0.071513,
      98.499233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.868633,
      NULL,
      7.160970,
      7,
      7,
      7,
      4,
      4,
      3,
      3.754155,
      4.476140,
      6.530556,
      2,
      1,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597319,
      0.182185,
      0.823249,
      4,
      7.576475,
      6,
      1.925328,
      8,
      5.685796,
      6.862171,
      8.629997,
      7,
      4,
      7,
      10.028398,
      7.087741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5.989295,
      3.063209,
      11,
      6,
      0.924496,
      0.252756,
      1,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0.450408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477010,
      NULL,
      NULL,
      NULL,
      NULL,
      2.868384,
      0.786213,
      4.232987,
      5.137397,
      1,
      0,
      0.657371,
      NULL,
      NULL,
      1,
      6.606332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      0,
      6,
      7.780535,
      0,
      4.284295,
      NULL,
      0,
      5.390038,
      0.356204,
      0.937006,
      NULL,
      1.591079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.223754,
      5.435115,
      NULL,
      6,
      7.615668,
      1.911878,
      NULL,
      2,
      5,
      2.810136,
      4.691173,
      3,
      2.347984,
      4,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833753,
      3,
      5,
      7,
      3.742546,
      NULL,
      3,
      0,
      0,
      4,
      3.382472,
      6.534453,
      7.304199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.817228,
      5,
      0,
      1.684075,
      8.556617,
      4.657951,
      5,
      0,
      2,
      NULL,
      NULL,
      1,
      0,
      1.435277,
      3.048144,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.562048,
      4,
      0,
      8.176855,
      2,
      5.093062,
      1,
      3,
      4,
      2,
      3.412913,
      3.704556,
      4.880268,
      1,
      10.370179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.098651,
      1,
      4.331969,
      1,
      7.281822,
      2,
      4.471024,
      3,
      2,
      4.418101,
      2,
      0,
      5.399006,
      2.670075,
      0.961556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760341,
      1.485568,
      0,
      NULL,
      NULL,
      1,
      0.310981,
      0,
      0,
      NULL,
      1.070857,
      1.066449,
      NULL,
      0,
      1.164569,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186762,
      1,
      0.260954,
      0.192140,
      0,
      NULL,
      1,
      0.823961,
      0.404734,
      1,
      NULL,
      1.329559,
      0.985423,
      0.948901,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.660785,
      1,
      0.580815,
      0.149228,
      1,
      NULL,
      0.081562,
      NULL,
      0,
      NULL,
      0,
      1.977085,
      0.145120,
      5,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.315604,
      7,
      7.041935,
      11.387036,
      2.586465,
      5,
      6,
      9.608594,
      0.150372,
      NULL,
      9.630758,
      1.845540,
      7.158985,
      4.433032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.972296,
      4.055381,
      4.837409,
      6.826359,
      1,
      1,
      6,
      NULL,
      6,
      NULL,
      2,
      7.505637,
      7.312482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177543,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.200151,
      0.812051,
      1,
      1.538938,
      1.008127,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174667,
      1,
      0.739006,
      0,
      0.332318,
      0,
      0.668518,
      0,
      0,
      NULL,
      NULL,
      1.328461,
      1,
      2,
      5.574933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      4,
      0,
      1,
      NULL,
      0,
      2,
      4,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      4,
      NULL,
      7,
      6,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      2,
      NULL,
      2,
      2,
      2,
      0,
      3,
      NULL,
      0,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 4-1990',
      ' 0-21-1989',
      ' 6- 8-1992',
      ' 2-14-1991',
      ' 0-22-1976',
      ' 8-16-1979',
      NULL,
      ' 4-16-1979',
      ' 7- 0-1976',
      NULL,
      ' 5-21-1997',
      NULL,
      ' 2-24-1988',
      ' 6-23-1975',
      '10-19-1989',
      NULL,
      ' 6-19-1988',
      ' 1-24-1985',
      NULL,
      NULL,
      NULL,
      ' 5-10-1977',
      NULL,
      '10-24-1977',
      ' 3- 5-1987',
      '11-11-2000',
      ' 6-28-1988',
      ' 3- 5-2001',
      ' 3-16-2002',
      '11-23-2001',
      NULL,
      ' 9-25-2002',
      '11-28-1993',
      ' 6-10-1977',
      '10-19-1993',
      NULL,
      NULL,
      ' 4-15-1989',
      ' 3- 0-1974',
      ' 8-22-1996',
      '10-27-1992',
      ' 3-24-1995',
      ' 6-21-1998',
      ' 2- 7-1993',
      '11- 0-1974',
      NULL,
      ' 8- 9-1988',
      '10-12-2001',
      NULL,
      NULL,
      ' 4-19-1996',
      ' 4-13-1984',
      '10-20-1977',
      NULL,
      NULL,
      NULL,
      ' 9-20-1991',
      ' 0-27-1991',
      ' 1-12-1987',
      ' 5-20-1978',
      NULL,
      NULL,
      ' 6- 5-1978',
      ' 7- 6-1981',
      '10-10-1975',
      '10-16-1984',
      ' 1- 3-1979',
      ' 7-21-1995',
      NULL,
      '11- 5-1975',
      NULL,
      '10-15-1985',
      ' 6-19-1974',
      ' 8-12-1975',
      NULL,
      ' 7- 8-1986',
      ' 1- 2-1988',
      ' 1-28-1998',
      ' 2-15-1994',
      ' 2- 8-1990',
      NULL,
      ' 6-10-1982',
      ' 0-23-1992',
      '11- 1-2000',
      ' 1- 1-1996',
      ' 4- 3-2003',
      ' 0- 3-1996',
      '11- 6-1978',
      ' 1-18-1980',
      NULL,
      ' 7- 2-1975',
      ' 8- 8-2001',
      ' 7-17-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-17-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-24-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-17-1999',
      ' 2- 3-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


