set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6900066';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '0034441',
      1,
      1.273213,
      NULL,
      '23214',
      1.784415,
      ' 6-23-1986',
      69,
      NULL,
      NULL,
      3,
      0.731323,
      1.163343,
      1.537215,
      0,
      0.213214,
      2.464806,
      0,
      NULL,
      1.229265,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.900436,
      NULL,
      NULL,
      0.148347,
      1,
      NULL,
      NULL,
      2,
      2,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      7,
      7,
      5,
      2.558423,
      NULL,
      1.983776,
      0,
      1,
      1,
      0,
      3,
      2.898814,
      0,
      1,
      2,
      3,
      3,
      0.493525,
      NULL,
      5,
      0,
      2,
      7.419530,
      NULL,
      17.127888,
      3.227846,
      NULL,
      0,
      1,
      3,
      3.472537,
      4,
      62.490330,
      603,
      NULL,
      0.975111,
      0.970536,
      54.280892,
      9,
      NULL,
      0.029405,
      148.056110,
      220,
      1.663784,
      3.234367,
      75,
      NULL,
      0,
      NULL,
      326,
      284.467120,
      1,
      2,
      NULL,
      2,
      2,
      NULL,
      115.984690,
      14,
      NULL,
      2.192429,
      75,
      9.266303,
      1.323646,
      2.629376,
      22.191676,
      5,
      0,
      0,
      NULL,
      1127,
      1.646879,
      1.013704,
      57.379017,
      699.938977,
      1.081937,
      3,
      188.882254,
      95.605135,
      NULL,
      0.515269,
      106.445502,
      215.344428,
      1,
      0.186877,
      149,
      5,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      3,
      155,
      279.016081,
      1,
      4.801089,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.488155,
      2.776886,
      478.630015,
      3,
      3.474283,
      0,
      421,
      1164.161764,
      3.143154,
      NULL,
      213,
      319.266215,
      2.819171,
      1,
      213,
      167.282791,
      1,
      2,
      514.085168,
      2,
      2,
      5,
      244,
      194,
      NULL,
      NULL,
      198,
      571,
      0.862082,
      0,
      272.016692,
      NULL,
      2,
      NULL,
      NULL,
      2,
      3.241692,
      3,
      NULL,
      1074.084826,
      3.832620,
      1.166073,
      847,
      15.944351,
      0,
      0,
      581,
      74.711840,
      1.325470,
      0.608428,
      NULL,
      NULL,
      0.263481,
      3,
      1047,
      2.386471,
      3.882789,
      1,
      1665.242685,
      11,
      0.176636,
      NULL,
      NULL,
      12,
      3,
      NULL,
      593.848281,
      97,
      NULL,
      NULL,
      NULL,
      102.792410,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '41020',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      NULL,
      '',
      '',
      NULL,
      3,
      4,
      NULL,
      1198,
      0,
      NULL,
      0,
      NULL,
      12.244333,
      73,
      1.769436,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.560451,
      NULL,
      1.485130,
      NULL,
      ' 2-17-1993',
      5,
      9,
      3.924306,
      8,
      6.509074,
      3,
      23.261145,
      NULL,
      NULL,
      5.901748,
      3,
      0.524397,
      11.106853,
      1,
      7,
      NULL,
      5.377265,
      4.336588,
      1,
      0,
      1,
      4.393033,
      NULL,
      5,
      9.104524,
      12,
      5.688851,
      1,
      1,
      1,
      NULL,
      6.356279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      NULL,
      NULL,
      33,
      2.616024,
      1,
      1.695497,
      4.985459,
      24,
      9.719512,
      29,
      NULL,
      24.296144,
      10.905940,
      NULL,
      5.246324,
      NULL,
      23,
      21,
      31.956122,
      8,
      21.569371,
      4.636656,
      20.592832,
      25.400470,
      38.622487,
      26,
      22.465569,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      64.714629,
      49.750384,
      142,
      70,
      3.458775,
      33.391928,
      39,
      102.734487,
      NULL,
      47.305598,
      157,
      NULL,
      91,
      98.496580,
      NULL,
      51.195299,
      101.644020,
      NULL,
      NULL,
      152,
      NULL,
      NULL,
      5.994122,
      NULL,
      28,
      NULL,
      166,
      0,
      106.342582,
      71,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      3.657894,
      2.161248,
      NULL,
      9.008768,
      4.861838,
      0,
      7,
      8,
      7.391107,
      9,
      NULL,
      0.008996,
      5,
      7.016066,
      3.266588,
      2.850571,
      4,
      NULL,
      5.518100,
      7.703652,
      3.613215,
      1,
      2,
      7,
      9,
      4,
      NULL,
      NULL,
      NULL,
      9,
      9.446777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.758733,
      NULL,
      0.519071,
      1.655603,
      1,
      0,
      1,
      3.132666,
      1.180756,
      NULL,
      0.175866,
      6,
      2,
      NULL,
      4,
      7.668711,
      4,
      5,
      3.440127,
      3.856773,
      2.345768,
      1,
      9,
      5.632804,
      6.287519,
      8,
      8,
      1.483967,
      8.263413,
      4,
      5.048102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.814741,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0.422712,
      2.492313,
      1.335071,
      0.854975,
      0,
      1.256712,
      1,
      NULL,
      1.622818,
      0.128653,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1.795145,
      0,
      0.122253,
      0.000805,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.097872,
      1,
      1,
      1,
      1,
      1.973485,
      NULL,
      1.538170,
      NULL,
      0,
      NULL,
      1,
      1.987035,
      3.103423,
      1.086823,
      0,
      0,
      1.070775,
      0,
      1.556541,
      1.282182,
      1.533121,
      NULL,
      0.035951,
      1,
      NULL,
      0.406696,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751360,
      0.419778,
      5,
      4.656093,
      3,
      1,
      0,
      1,
      0.487505,
      1,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      1,
      0.455796,
      0,
      1.769189,
      1.008109,
      1.227473,
      NULL,
      1,
      1,
      1.031173,
      0.827245,
      0.698460,
      1.536707,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      0.983910,
      1.220304,
      2,
      4,
      4.860664,
      0.840981,
      8,
      6,
      7.550009,
      5,
      1,
      0,
      2.749156,
      6.212358,
      NULL,
      NULL,
      1.082117,
      6.217626,
      5.591043,
      7,
      NULL,
      0.400142,
      2.580045,
      1,
      0.739105,
      0.808711,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.407688,
      0,
      0,
      0.202536,
      5,
      NULL,
      1.636772,
      2.357005,
      0.361842,
      5.716908,
      7.581577,
      NULL,
      4.426181,
      4,
      NULL,
      3,
      6.855770,
      5,
      5.326438,
      NULL,
      1.950623,
      7.941039,
      3.975833,
      0.381376,
      7,
      7,
      NULL,
      2.261091,
      3.501623,
      6,
      NULL,
      7.780067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.625261,
      0.419743,
      9,
      4.509283,
      NULL,
      7.718352,
      6.797642,
      4.355133,
      0,
      2.335074,
      3,
      7,
      3.587372,
      1.380401,
      NULL,
      5.862258,
      4,
      6,
      4.924992,
      NULL,
      6.799287,
      NULL,
      6.853048,
      NULL,
      7,
      7.076130,
      NULL,
      NULL,
      NULL,
      7,
      5.693176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1.777046,
      1,
      1.805187,
      0.823571,
      0,
      NULL,
      0,
      NULL,
      1.629024,
      0.034344,
      0,
      0.314164,
      0.475133,
      6,
      0.642351,
      NULL,
      1.651845,
      NULL,
      1,
      NULL,
      NULL,
      1.290832,
      1,
      1.563988,
      3,
      1,
      0.377309,
      0,
      1.883788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263354,
      0,
      0.013997,
      0,
      0,
      1.278421,
      0.182003,
      1.168584,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0.722847,
      1.973381,
      1.097973,
      1,
      0,
      0,
      1,
      0.957357,
      0.848080,
      0,
      0,
      0,
      0,
      1.268931,
      NULL,
      1,
      1,
      0.908212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.202415,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0.332412,
      3.537154,
      0.657686,
      1,
      1.210117,
      0.097753,
      NULL,
      NULL,
      1.705503,
      0.526099,
      1,
      3.059598,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.584247,
      0,
      0.412187,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      3,
      NULL,
      9,
      7.377900,
      4,
      3,
      7,
      2.896042,
      5,
      0,
      2.853552,
      NULL,
      0,
      0.927013,
      1.970523,
      1,
      NULL,
      6.817508,
      4,
      6,
      1.284173,
      0,
      0.309221,
      1.457676,
      2,
      3,
      1,
      0,
      0.320176,
      2.458807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.701260,
      NULL,
      0.486286,
      0,
      NULL,
      5.587849,
      1.281472,
      NULL,
      0.291825,
      0,
      1,
      3,
      0.427062,
      NULL,
      0,
      1.100483,
      5.899899,
      3.314397,
      0.397197,
      1,
      2,
      2,
      NULL,
      0,
      NULL,
      2,
      7,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      3,
      5.967569,
      9.160137,
      7,
      4,
      NULL,
      1,
      NULL,
      9.670939,
      7,
      8,
      NULL,
      3.062417,
      8,
      6,
      9.057629,
      NULL,
      NULL,
      2.905380,
      4,
      NULL,
      3.815334,
      4.423837,
      7.291115,
      NULL,
      NULL,
      6.183030,
      NULL,
      6,
      6.813800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.478925,
      2.215990,
      6.447207,
      2.047230,
      NULL,
      4.528845,
      0,
      4,
      NULL,
      7.570897,
      NULL,
      4.079570,
      9,
      6,
      7.184253,
      1.676646,
      2,
      5,
      5.919424,
      5.734326,
      1.350726,
      8,
      NULL,
      5,
      3.343765,
      NULL,
      0,
      NULL,
      5.189999,
      6.380686,
      2,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.830458,
      0.652439,
      1,
      NULL,
      0,
      0,
      2,
      0.049927,
      3,
      1.384382,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1.926258,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.751963,
      1.123477,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      5,
      NULL,
      3,
      5.737261,
      4.974521,
      2,
      7.479543,
      NULL,
      NULL,
      NULL,
      4.358136,
      1,
      NULL,
      0.954538,
      0,
      0,
      NULL,
      6,
      2.909274,
      6,
      1,
      1,
      1.209105,
      2,
      1.659423,
      1,
      1.833045,
      1.385462,
      1,
      0.900632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      4,
      1,
      2,
      NULL,
      3,
      1,
      2,
      0,
      3,
      0,
      1,
      1,
      1,
      NULL,
      3,
      2,
      2,
      2,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      3,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-14-1980',
      NULL,
      ' 0-23-1981',
      ' 7-20-1991',
      ' 5-22-1989',
      ' 2-11-1988',
      '11-23-1980',
      '11-21-1998',
      ' 0- 2-1994',
      NULL,
      ' 3- 6-1977',
      ' 4-20-1999',
      ' 2-19-1980',
      ' 9-25-1991',
      ' 5-20-1989',
      ' 5- 8-1979',
      ' 1- 7-1994',
      NULL,
      NULL,
      ' 2-24-1994',
      NULL,
      ' 2-16-1998',
      ' 8-25-2002',
      ' 2-15-1996',
      ' 8- 8-2000',
      NULL,
      '10-25-1978',
      ' 0-25-1993',
      ' 4-24-1981',
      ' 3-18-1994',
      ' 6-10-1982',
      NULL,
      ' 7- 3-1992',
      ' 7-27-1984',
      NULL,
      NULL,
      ' 5-18-1978',
      '10-24-1978',
      ' 1-20-1981',
      '11- 2-1989',
      ' 5-18-1998',
      ' 9- 6-1975',
      ' 8- 4-1974',
      ' 4-13-1982',
      ' 3-26-1997',
      ' 4- 7-1977',
      '10-12-1986',
      ' 3- 0-1997',
      '11-10-1980',
      ' 7-10-1995',
      ' 0-25-1996',
      ' 8-22-1993',
      ' 5- 5-1987',
      NULL,
      ' 0-10-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-26-1981',
      NULL,
      ' 9- 1-2001',
      NULL,
      NULL,
      NULL,
      '11-10-1992',
      NULL,
      ' 6-19-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-14-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318182);
commit;
end;
/


