set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6916891';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-4-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '0342304',
      0,
      1.088550,
      3,
      '24034',
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      0,
      1,
      3.551119,
      NULL,
      0,
      1,
      8,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      3,
      1,
      8,
      5,
      2.443560,
      NULL,
      9,
      5,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      NULL,
      0,
      6,
      5,
      0.479080,
      7,
      1,
      4,
      2,
      1,
      NULL,
      NULL,
      '11-21-2001',
      13.509397,
      0.650172,
      4.721382,
      1,
      0,
      3,
      5,
      0,
      49.213683,
      NULL,
      1732,
      NULL,
      1,
      214.914171,
      21.104037,
      1.713083,
      3.474856,
      NULL,
      2568,
      0.919326,
      1.549518,
      65.965791,
      NULL,
      2,
      3,
      NULL,
      NULL,
      2.765392,
      1,
      NULL,
      4,
      0.976671,
      2.047543,
      145.032366,
      67.483734,
      NULL,
      0.645642,
      NULL,
      6,
      3,
      2.049044,
      210,
      22.382284,
      3,
      3,
      216,
      150.253838,
      NULL,
      2.213534,
      206.215311,
      89.557689,
      6.105380,
      NULL,
      NULL,
      1931,
      3.979680,
      2,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      3,
      NULL,
      679,
      41.895806,
      1.585879,
      NULL,
      1079.839584,
      NULL,
      2,
      1.384418,
      88,
      301.824659,
      5,
      0,
      1345.698171,
      NULL,
      1,
      0,
      143,
      5,
      3,
      1.676078,
      202.317522,
      20,
      NULL,
      2,
      NULL,
      67.922397,
      0.450314,
      5,
      55.590961,
      NULL,
      1,
      3,
      503.763123,
      509,
      2,
      3,
      525.047855,
      722.803816,
      3.795501,
      0.658593,
      106,
      NULL,
      3,
      1,
      39.225078,
      7.416222,
      0.561997,
      0,
      36,
      NULL,
      1.824716,
      2.306405,
      407,
      14.195205,
      0,
      0,
      NULL,
      17.130689,
      1.197065,
      NULL,
      238,
      NULL,
      1,
      NULL,
      208,
      201,
      NULL,
      0,
      NULL,
      NULL,
      3,
      5.516770,
      128.314090,
      16.092384,
      3.638143,
      3.661452,
      136.946576,
      65,
      NULL,
      1.618413,
      28.966051,
      3.786104,
      0,
      5.044489,
      251,
      12.954291,
      0,
      3.045103,
      NULL,
      9,
      1,
      3.670611,
      508.504589,
      22,
      2,
      1,
      144,
      NULL,
      1.261813,
      1.542843,
      783.061257,
      618.811893,
      0.493571,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.895106,
      3.043610,
      514,
      345.334280,
      1,
      3,
      459.727657,
      559,
      2.398601,
      1.955082,
      110.096460,
      28.577926,
      3.383363,
      5,
      178.200401,
      NULL,
      NULL,
      3.919672,
      NULL,
      NULL,
      1,
      4.469516,
      1004.124399,
      69,
      1.652142,
      3,
      26.096081,
      NULL,
      NULL,
      3,
      52,
      195.379382,
      NULL,
      NULL,
      NULL,
      159,
      2.446051,
      1,
      52.958866,
      34,
      3,
      2.467946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.049313,
      NULL,
      '',
      '',
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.854438,
      '',
      '',
      NULL,
      4,
      11.230016,
      1048.770174,
      0.699419,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.008300,
      NULL,
      1.100428,
      NULL,
      0.258155,
      NULL,
      0.047736,
      NULL,
      NULL,
      4.094203,
      8.119615,
      11.076531,
      0.665769,
      13.828581,
      11,
      NULL,
      NULL,
      6,
      0,
      2.414169,
      23.928159,
      6,
      5.281552,
      NULL,
      6,
      0.675562,
      4.606881,
      7.971428,
      0,
      7,
      NULL,
      3,
      15.846556,
      3.691812,
      1.603660,
      5.502489,
      0.763590,
      NULL,
      7,
      0,
      NULL,
      11,
      3.319093,
      14,
      12.223147,
      16,
      NULL,
      9,
      19.270975,
      25.724698,
      14,
      12.020429,
      10.503252,
      12,
      5.711326,
      4.763680,
      3,
      6,
      NULL,
      7.902166,
      NULL,
      29,
      NULL,
      14.883206,
      29,
      2.133223,
      1,
      15,
      NULL,
      NULL,
      28,
      NULL,
      2.873967,
      0,
      10,
      20,
      11.484281,
      NULL,
      1.285880,
      7.911387,
      16,
      15,
      11,
      8,
      32.766502,
      NULL,
      21,
      3,
      13,
      5.388112,
      26,
      18.663369,
      16,
      16.465344,
      27.925306,
      NULL,
      12,
      34.924181,
      14.180349,
      6,
      NULL,
      20,
      26.674668,
      27,
      NULL,
      23.922050,
      25.217820,
      36.513491,
      NULL,
      NULL,
      57,
      22,
      NULL,
      44.613859,
      20.791056,
      6.248023,
      67,
      66.632899,
      131,
      66.254178,
      53,
      109,
      58,
      69,
      128,
      NULL,
      0,
      55.734672,
      92.389579,
      58.149879,
      NULL,
      80.504312,
      14.148475,
      39.655630,
      NULL,
      142.112913,
      28.504088,
      183.860704,
      102.363153,
      40,
      NULL,
      NULL,
      29.930788,
      58,
      170,
      125.929796,
      141,
      143.649186,
      147.621201,
      27,
      142.187540,
      44.093794,
      184,
      109.115723,
      41,
      NULL,
      57.222022,
      130.290249,
      21,
      4.997362,
      52,
      157.398126,
      153.259951,
      7,
      NULL,
      1.586573,
      5.331768,
      6,
      3.808648,
      NULL,
      2.360992,
      NULL,
      3,
      5,
      7,
      3,
      9.749287,
      2.171549,
      5.693370,
      1,
      1,
      0.619082,
      1,
      NULL,
      1,
      3.343863,
      6,
      5.470346,
      3.875709,
      NULL,
      NULL,
      NULL,
      NULL,
      3.461376,
      7.288222,
      1,
      2,
      0,
      NULL,
      1,
      2.046018,
      0.233386,
      2,
      3.373764,
      0.280683,
      NULL,
      4.503825,
      1.019414,
      5.933867,
      3.574163,
      8.216736,
      5.584051,
      8,
      1,
      2.408326,
      0,
      NULL,
      2.770614,
      2.796463,
      5.345957,
      5.303426,
      NULL,
      4.372940,
      2,
      6,
      1,
      6,
      3,
      1,
      NULL,
      3.234897,
      3.731970,
      8.128933,
      1.488690,
      5,
      1,
      3.975562,
      3.857238,
      2,
      5.412120,
      7,
      NULL,
      2,
      NULL,
      2.801230,
      0.799484,
      1,
      0,
      2.452244,
      3.063055,
      3,
      0.276440,
      1,
      1.578905,
      NULL,
      3,
      5,
      3.320702,
      5.934307,
      NULL,
      NULL,
      3.818740,
      5.535628,
      1.667830,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.598194,
      NULL,
      NULL,
      0.652208,
      0.129092,
      1,
      0,
      NULL,
      NULL,
      1,
      1.731000,
      1.507315,
      1,
      NULL,
      0.715897,
      1,
      0,
      1.368996,
      1.887762,
      1.599250,
      NULL,
      NULL,
      0,
      0.037288,
      1,
      0,
      0.055572,
      0,
      0,
      0.370817,
      1,
      1.690540,
      1.608695,
      0.495443,
      1.176503,
      0,
      1.226931,
      0.528333,
      1.469725,
      0.365948,
      0,
      0.996372,
      0,
      0.546936,
      0.870546,
      1.909154,
      NULL,
      0.429133,
      1,
      0,
      0,
      NULL,
      NULL,
      0.704873,
      0,
      0,
      0,
      0.721434,
      0.897888,
      0.912991,
      NULL,
      1,
      NULL,
      0.625713,
      NULL,
      0,
      1.113289,
      NULL,
      1,
      0.083512,
      0,
      0.533870,
      0.671168,
      NULL,
      0.467161,
      NULL,
      1,
      1.114280,
      0.171044,
      0.889125,
      NULL,
      1,
      0.430524,
      0.646923,
      1,
      NULL,
      NULL,
      1.158072,
      0.228005,
      1,
      1.890047,
      NULL,
      1,
      NULL,
      0.069673,
      1.520758,
      0.296554,
      1.462913,
      0.444494,
      0,
      1,
      1.978927,
      NULL,
      NULL,
      0.225995,
      NULL,
      5,
      NULL,
      3,
      NULL,
      4.090414,
      1.997604,
      5.280228,
      1,
      0,
      5.590615,
      5,
      3.683484,
      NULL,
      1,
      1,
      3.770804,
      3.466598,
      1,
      0,
      NULL,
      1.695126,
      1.097956,
      1.003077,
      0,
      NULL,
      1,
      NULL,
      0.614530,
      NULL,
      2.477508,
      3.724747,
      2.339403,
      2,
      0.056836,
      3,
      1.198285,
      NULL,
      3,
      0,
      3,
      1.812609,
      0,
      3.289332,
      1,
      3,
      2,
      1,
      0,
      1.408134,
      NULL,
      1.436114,
      0.808013,
      0.690668,
      NULL,
      7,
      1,
      3,
      1,
      4,
      NULL,
      6.494114,
      1,
      1,
      2.674418,
      0,
      8.283983,
      8.218099,
      NULL,
      4,
      4.645034,
      0.211197,
      9,
      9,
      9,
      5.080747,
      7,
      8,
      NULL,
      NULL,
      1,
      1.012094,
      4.461176,
      NULL,
      4.051514,
      3.748671,
      1.763568,
      8.118781,
      2.268865,
      NULL,
      3.866502,
      NULL,
      NULL,
      1.168422,
      3,
      5.128191,
      4.233680,
      2,
      3,
      1.250456,
      4.174984,
      1,
      NULL,
      1,
      2,
      2.099803,
      3.784002,
      1.590008,
      7.266622,
      3.402296,
      NULL,
      3.810092,
      NULL,
      NULL,
      NULL,
      1.101983,
      7,
      NULL,
      2.904488,
      4,
      0.644694,
      7.445752,
      8.006633,
      1,
      NULL,
      8.381707,
      NULL,
      NULL,
      3.078793,
      4.896159,
      1,
      NULL,
      0,
      0,
      9.849301,
      2.644255,
      3,
      NULL,
      6.719096,
      3.373849,
      9,
      NULL,
      3.204889,
      9.040082,
      4,
      8,
      4,
      4,
      5.784402,
      8,
      7,
      NULL,
      1.649630,
      NULL,
      NULL,
      0.300837,
      1.178476,
      NULL,
      0.571267,
      NULL,
      3,
      0.288817,
      1,
      0.597231,
      NULL,
      6,
      7,
      6,
      NULL,
      4.898288,
      6,
      4.594934,
      2.486584,
      7.051142,
      4.568654,
      3.078236,
      7,
      NULL,
      6,
      5,
      2,
      4.756913,
      NULL,
      6,
      3.402372,
      5.182996,
      5.546554,
      2.763957,
      3,
      5,
      NULL,
      2.366774,
      NULL,
      0.301627,
      NULL,
      5.965023,
      3.367596,
      4,
      1.072367,
      3.815701,
      0,
      NULL,
      NULL,
      1,
      4,
      1.377959,
      NULL,
      1,
      1,
      1.360133,
      3,
      2.326252,
      0,
      0,
      2,
      NULL,
      5,
      0,
      5,
      2,
      7.006876,
      NULL,
      NULL,
      1.223767,
      2.259930,
      5.768219,
      5.688307,
      6.674633,
      7.567898,
      6,
      6,
      4.315578,
      0,
      3,
      5.801352,
      3.739812,
      4,
      NULL,
      0,
      5,
      3,
      6.656163,
      6.392499,
      1.692235,
      3.121250,
      6.293146,
      6,
      0.238614,
      NULL,
      NULL,
      0,
      6,
      5.172048,
      4,
      7.624769,
      2,
      NULL,
      5.925419,
      NULL,
      0.524249,
      1,
      1.291564,
      1,
      NULL,
      1.511145,
      1,
      0.490843,
      0,
      0,
      0,
      0.724886,
      NULL,
      1,
      0.009804,
      1.246330,
      0.795222,
      1.525973,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0.239435,
      NULL,
      0,
      1.904925,
      1.580742,
      1,
      NULL,
      NULL,
      1.725096,
      1,
      0,
      1.517695,
      0.464813,
      1.614422,
      0,
      1.028429,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0.204337,
      0,
      0,
      0.825659,
      NULL,
      1.927512,
      0.931323,
      0,
      0,
      NULL,
      0.258898,
      0.845484,
      9.968721,
      1.151474,
      NULL,
      1.971370,
      0.365502,
      1,
      0,
      1.854877,
      1,
      0.880090,
      1.715991,
      0.334992,
      NULL,
      NULL,
      NULL,
      0,
      0.113420,
      1.819119,
      1.272048,
      NULL,
      1.918150,
      1,
      0.833243,
      0,
      NULL,
      1.023521,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1.897240,
      1.759568,
      NULL,
      1.562293,
      1,
      NULL,
      1.826182,
      1,
      0.893833,
      1.505890,
      NULL,
      1,
      NULL,
      0,
      1.489303,
      0,
      5,
      3,
      9.531799,
      NULL,
      6,
      1.180155,
      8.860530,
      6.099965,
      2,
      3.392968,
      7,
      1,
      1,
      3.250679,
      6,
      3.790887,
      2,
      0.565739,
      4,
      2.631618,
      NULL,
      NULL,
      7.077420,
      1.295243,
      8,
      5.673821,
      3,
      4,
      1,
      5,
      3,
      NULL,
      NULL,
      1,
      5.207187,
      5,
      NULL,
      6.590524,
      4.576496,
      2.762615,
      6,
      6,
      3.597387,
      4,
      3.166347,
      2,
      4,
      0,
      NULL,
      1,
      0.748386,
      0,
      0.931397,
      1,
      0,
      1.482510,
      0,
      0.505383,
      0.898128,
      0,
      1.704431,
      0,
      0,
      1.010403,
      NULL,
      0.608934,
      0.178001,
      1.193670,
      0.240637,
      0.755315,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      0.723648,
      1,
      0,
      0,
      NULL,
      0.971065,
      0.960911,
      0.217750,
      0.199038,
      1,
      1.495874,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1.035579,
      1.537964,
      NULL,
      0.767648,
      0.204758,
      1,
      NULL,
      1,
      5.189061,
      3,
      3,
      1,
      5.955123,
      NULL,
      4.028738,
      3.028959,
      0.142028,
      4,
      7,
      1.343685,
      5.335045,
      2,
      6.083319,
      NULL,
      2,
      3.760517,
      3,
      2,
      NULL,
      NULL,
      4.631432,
      5.781675,
      6,
      NULL,
      3,
      1,
      NULL,
      3,
      3,
      2.456596,
      NULL,
      2.937963,
      5.065903,
      NULL,
      4,
      2,
      5,
      3,
      3.861305,
      1,
      5.457079,
      1,
      5.031141,
      3,
      NULL,
      3.398475,
      5,
      2.358892,
      NULL,
      1.444117,
      0.923743,
      2.243020,
      NULL,
      6.133497,
      5.742829,
      NULL,
      2.843061,
      NULL,
      6.722929,
      7,
      NULL,
      NULL,
      NULL,
      0.922866,
      1,
      3.241469,
      6.857802,
      0.263552,
      9.285424,
      1,
      NULL,
      1.233432,
      6.057215,
      0,
      8.163704,
      6.328015,
      NULL,
      8,
      NULL,
      NULL,
      9.716373,
      1,
      7,
      7.349745,
      8,
      6.899322,
      NULL,
      6.154533,
      1.882025,
      1.049365,
      4,
      2,
      0,
      7.674963,
      4,
      2,
      1.004232,
      2,
      NULL,
      7,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1.275581,
      1,
      NULL,
      1,
      0,
      1.061723,
      0.233320,
      0.823574,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1.944724,
      0,
      NULL,
      1,
      1,
      NULL,
      0.406294,
      0.562689,
      0.465677,
      0.777152,
      1,
      0,
      1,
      NULL,
      0.535990,
      1,
      0.703146,
      NULL,
      NULL,
      0.151692,
      1.009798,
      1.370950,
      1.691594,
      0,
      1,
      1,
      0.293196,
      0.396560,
      0.011848,
      1.246025,
      0.387152,
      1,
      NULL,
      0.451396,
      1.535703,
      0,
      NULL,
      NULL,
      2,
      2.499426,
      1,
      5,
      7,
      4.981052,
      5,
      NULL,
      1,
      0,
      7,
      4,
      7,
      2,
      7.684789,
      3,
      1,
      NULL,
      7.492299,
      3,
      NULL,
      NULL,
      2,
      1,
      NULL,
      6,
      NULL,
      NULL,
      2,
      3,
      3.669351,
      7,
      NULL,
      NULL,
      NULL,
      0.637181,
      0,
      NULL,
      NULL,
      6.704739,
      NULL,
      7.487515,
      7.624071,
      1.087730,
      2.599451,
      2,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      4,
      3,
      NULL,
      2,
      NULL,
      3,
      5,
      1,
      5,
      2,
      0,
      0,
      4,
      1,
      2,
      1,
      1,
      1,
      2,
      1,
      2,
      3,
      NULL,
      NULL,
      1,
      2,
      4,
      3,
      5,
      0,
      1,
      NULL,
      1,
      3,
      0,
      0,
      NULL,
      2,
      NULL,
      2,
      2,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 4-1976',
      ' 5- 1-1983',
      ' 6-15-1995',
      ' 7-19-1986',
      ' 4-26-1988',
      ' 9- 6-2002',
      ' 4-28-1977',
      ' 1-11-2003',
      NULL,
      NULL,
      NULL,
      ' 8-16-1993',
      '11-29-1999',
      ' 1-16-1997',
      ' 8-16-1986',
      ' 1- 8-1999',
      '10-18-1987',
      ' 8-26-2003',
      ' 1- 4-1981',
      ' 0-21-1995',
      ' 6- 0-1993',
      ' 0-13-1976',
      NULL,
      ' 4-22-1994',
      ' 8- 8-1986',
      NULL,
      NULL,
      ' 9-20-1978',
      ' 7-13-2002',
      ' 9-26-1988',
      ' 8-13-1993',
      NULL,
      '11- 4-1986',
      ' 1- 5-1989',
      '11-25-2001',
      '10-27-2003',
      ' 3- 0-1985',
      ' 9- 1-1997',
      ' 2-21-1986',
      '11-17-1998',
      NULL,
      ' 9-27-1986',
      ' 4-19-1981',
      ' 7-13-1993',
      ' 1-12-1996',
      ' 3-19-1998',
      ' 1- 9-1983',
      ' 2-19-1976',
      ' 6-15-2002',
      ' 4- 0-1999',
      ' 7- 7-1990',
      ' 0-17-1981',
      ' 5- 9-1996',
      '10- 8-1981',
      '10-23-1987',
      ' 8-27-1988',
      ' 7- 6-1991',
      ' 3- 4-2003',
      ' 8- 5-1994',
      ' 1-27-1979',
      ' 6- 1-1988',
      ' 1-29-2000',
      ' 9- 0-1987',
      ' 0-14-1996',
      ' 5- 7-1978',
      ' 2-24-1976',
      ' 9-28-1978',
      NULL,
      NULL,
      NULL,
      '11-15-1991',
      ' 1-12-1992',
      NULL,
      ' 6-11-1982',
      ' 9- 7-1989',
      ' 1-13-1995',
      ' 3- 1-1991',
      ' 2-14-1997',
      ' 9-10-1974',
      ' 5-15-1977',
      ' 5-20-1989',
      ' 6-23-2003',
      '10-18-1979',
      ' 3-10-1984',
      ' 9- 3-1988',
      ' 7- 2-1992',
      ' 4-22-1988',
      NULL,
      ' 2-19-1993',
      ' 8- 4-1997',
      ' 2-23-1991',
      NULL,
      NULL,
      ' 1- 6-1976',
      ' 2-27-1983',
      ' 2-24-1998',
      ' 7- 5-1979',
      '10-21-1980',
      '11-23-1981',
      '11-12-1996',
      ' 8-26-1994',
      ' 6-18-1992',
      ' 9-23-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-23-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


