set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8716657';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      '3020043',
      0,
      NULL,
      NULL,
      '03210',
      NULL,
      NULL,
      39.981489,
      NULL,
      1.358626,
      5,
      NULL,
      1.322501,
      1.119736,
      1.581235,
      1,
      1.280705,
      0.877869,
      3.993920,
      NULL,
      3,
      NULL,
      NULL,
      3.768522,
      NULL,
      NULL,
      NULL,
      1,
      0.620633,
      2,
      NULL,
      NULL,
      3.326973,
      0,
      NULL,
      0,
      2,
      7,
      NULL,
      1,
      7,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      4,
      2.685344,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.544888,
      0.963662,
      1.292698,
      5,
      NULL,
      3,
      1.783873,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446972,
      3.244853,
      0,
      NULL,
      3,
      3,
      2,
      9.924165,
      490.164980,
      3,
      2,
      NULL,
      469.437318,
      43.633291,
      NULL,
      4,
      331,
      97,
      0,
      NULL,
      NULL,
      117,
      NULL,
      NULL,
      515,
      23,
      2.483640,
      2,
      NULL,
      51.230169,
      1,
      2.798060,
      96,
      NULL,
      2,
      1.283213,
      1038.783332,
      1.533837,
      NULL,
      1.634293,
      393.565416,
      59,
      2,
      1,
      NULL,
      4,
      2.064837,
      1,
      35.777724,
      2,
      1,
      1.053237,
      152,
      7.505378,
      3.477897,
      7.609623,
      172.080406,
      NULL,
      2.849360,
      8.620345,
      640,
      12.880750,
      1.779061,
      2.996316,
      232.737043,
      3,
      0.027730,
      2.560992,
      112,
      1,
      3,
      4,
      292.781025,
      NULL,
      NULL,
      NULL,
      106.752099,
      20.510391,
      0.660733,
      NULL,
      148,
      2.357882,
      NULL,
      9,
      602.319537,
      14.215672,
      0.100278,
      0.168458,
      2.571093,
      1.383568,
      2,
      2.977029,
      233.826858,
      NULL,
      NULL,
      4,
      144.908456,
      31.234818,
      0.814018,
      1.582699,
      224.211264,
      146,
      2,
      2.775313,
      217.648161,
      0.149534,
      NULL,
      3,
      142,
      2,
      1,
      NULL,
      78.660841,
      3.738060,
      3.989645,
      4,
      225.213786,
      4.846283,
      1,
      5.349390,
      591,
      84,
      3.905866,
      NULL,
      4.638908,
      104.857597,
      1,
      1.857161,
      340.742265,
      NULL,
      3,
      3.747094,
      102,
      1,
      NULL,
      0.158371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '32212',
      '',
      '',
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.163644,
      NULL,
      NULL,
      '',
      NULL,
      1.670810,
      1,
      1,
      NULL,
      1.179411,
      NULL,
      1.767102,
      NULL,
      0,
      8.293133,
      1.493235,
      NULL,
      NULL,
      NULL,
      1.050044,
      NULL,
      NULL,
      NULL,
      0.181383,
      NULL,
      ' 1-13-1985',
      3.993814,
      11.484355,
      9,
      7,
      13.880338,
      NULL,
      1.641719,
      1,
      9,
      8,
      10,
      NULL,
      NULL,
      12.046130,
      7,
      16,
      7,
      4,
      0.620051,
      NULL,
      4.839526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28.752272,
      7.786962,
      NULL,
      1.286936,
      1.970639,
      NULL,
      16,
      4.408805,
      12,
      33.522838,
      32,
      0,
      25,
      59.589126,
      1,
      16.780849,
      1,
      3,
      7,
      7.134387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.858967,
      NULL,
      184,
      135.383253,
      124,
      101,
      160,
      40.702710,
      149.065100,
      83.618376,
      18,
      NULL,
      138,
      53,
      66.873611,
      128,
      127.925905,
      35,
      11,
      152,
      107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357770,
      3.513630,
      8.458985,
      1.095502,
      NULL,
      3,
      3.246390,
      8,
      1,
      NULL,
      6.847292,
      3.268842,
      3,
      NULL,
      2.172674,
      1,
      0.414410,
      1,
      NULL,
      NULL,
      1.141382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.817925,
      3,
      3,
      1,
      2,
      1.698075,
      1,
      2,
      2.905918,
      2,
      7,
      0,
      5.861873,
      2.721334,
      NULL,
      1.201410,
      0,
      1.618934,
      1.301020,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923035,
      6.280151,
      5,
      1,
      NULL,
      6,
      1,
      4.373185,
      2,
      NULL,
      3.938100,
      0,
      5.100755,
      1.373754,
      0,
      NULL,
      0.500673,
      0,
      0,
      1.874949,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.348230,
      0,
      2,
      NULL,
      1,
      NULL,
      1,
      3,
      2.150955,
      2.285191,
      2.797723,
      NULL,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.410523,
      1.755201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.131997,
      1,
      2.588867,
      1.022794,
      1,
      0,
      1.253457,
      1.204343,
      NULL,
      0,
      2.613057,
      3.341466,
      2,
      2.309882,
      1,
      1,
      0,
      1.163749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.219021,
      6.991735,
      NULL,
      8.311088,
      5,
      3.655932,
      3,
      2.224277,
      2,
      0.041673,
      7,
      3.210781,
      3,
      0.373396,
      5.871606,
      6.684118,
      2.960034,
      3.187220,
      NULL,
      7,
      1.340137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.466851,
      1.293267,
      5.881348,
      3.620595,
      5,
      NULL,
      8,
      3.410798,
      5,
      4.327664,
      9,
      NULL,
      1,
      0,
      0,
      NULL,
      5.954626,
      6.903398,
      4.170756,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      4.166113,
      2.423687,
      3,
      5.590268,
      NULL,
      0.008092,
      0.040697,
      4.210421,
      1,
      0,
      3.997025,
      2,
      0.010584,
      NULL,
      0.453140,
      4.491177,
      NULL,
      3.933472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528972,
      1.144675,
      3.361100,
      1.231449,
      3.366790,
      NULL,
      2.522921,
      NULL,
      NULL,
      2,
      5,
      0.685527,
      1.575835,
      NULL,
      NULL,
      NULL,
      3.487847,
      0,
      2.694690,
      2.601505,
      1.759802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      2,
      0,
      0.447386,
      3.282493,
      1,
      NULL,
      1.728025,
      1.608558,
      0.761270,
      0.801081,
      1.195404,
      NULL,
      1.600004,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.282790,
      1.540373,
      1,
      0.354283,
      1.296847,
      1,
      0.082447,
      0,
      1.031721,
      NULL,
      0.293972,
      NULL,
      1.152462,
      0.602744,
      0.485899,
      1.628813,
      1,
      0.448593,
      1.914285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.455218,
      4.867205,
      3,
      1,
      1,
      5,
      5,
      NULL,
      2,
      4.310004,
      0,
      5,
      3,
      1,
      0.544681,
      3,
      0.562551,
      1.203605,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      4.912318,
      4.989193,
      6.481741,
      1.705577,
      3.392826,
      3.722220,
      NULL,
      1,
      2.724185,
      4,
      1,
      4.809169,
      4.122843,
      2.240787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.617322,
      3.695033,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      3.757367,
      2.284493,
      3,
      3,
      2,
      0.456069,
      0.739097,
      1,
      1,
      1,
      1.035503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.014859,
      1,
      NULL,
      NULL,
      0,
      NULL,
      4,
      7.145957,
      NULL,
      4,
      NULL,
      2,
      3.797460,
      6,
      NULL,
      1.769932,
      7.819745,
      NULL,
      3,
      NULL,
      3.806953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.509936,
      0,
      NULL,
      0.409058,
      0.973035,
      0.202432,
      1,
      NULL,
      0.124138,
      1,
      0.207407,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.215615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.454836,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.508006,
      3,
      5,
      0.223758,
      9,
      3.602187,
      2,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5,
      0,
      1,
      4,
      1,
      3,
      2,
      0,
      4,
      0,
      2,
      3,
      4,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-24-1980',
      ' 6-12-1979',
      ' 9- 3-1981',
      NULL,
      NULL,
      ' 2-15-1980',
      ' 6- 4-1985',
      NULL,
      NULL,
      '10- 7-1978',
      ' 9-20-1996',
      ' 1-23-1974',
      ' 1-18-1992',
      ' 2- 5-1977',
      '11- 9-1992',
      '10-16-1985',
      ' 6-19-1977',
      ' 7- 2-1975',
      ' 9- 0-1980',
      ' 1-19-2000',
      ' 2-23-1991',
      NULL,
      NULL,
      NULL,
      ' 1- 0-1981',
      ' 2-15-1985',
      ' 0- 6-1991',
      ' 2- 3-1999',
      ' 2-29-1993',
      NULL,
      ' 9-10-1994',
      ' 0-27-1985',
      ' 3-14-2003',
      NULL,
      ' 8-24-1990',
      ' 9- 5-1992',
      NULL,
      ' 5-26-1978',
      ' 6-22-1990',
      NULL,
      ' 0- 7-1985',
      ' 4- 6-1988',
      NULL,
      ' 0- 9-1981',
      ' 5-22-1988',
      '11- 3-1991',
      ' 8- 1-1985',
      NULL,
      ' 1-26-2001',
      '10-11-1999',
      ' 0- 8-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-10-1980',
      NULL,
      ' 3- 2-1985',
      ' 2-13-1978',
      NULL,
      ' 8-29-2000',
      ' 3- 0-1992',
      ' 0- 1-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-29-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.230051);
commit;
end;
/


