set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9693915';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '220',
      '00011310',
      6,
      20,
      '1002344',
      NULL,
      4,
      1,
      '03002',
      2,
      ' 4-29-1991',
      92,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588739,
      0.865712,
      NULL,
      0.897548,
      2.586850,
      2,
      NULL,
      7,
      NULL,
      NULL,
      3.620088,
      NULL,
      0.947178,
      80.871853,
      7.054249,
      1.246030,
      NULL,
      NULL,
      1.359356,
      NULL,
      1,
      NULL,
      0,
      0,
      7,
      4,
      NULL,
      2,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      2,
      5,
      1,
      1,
      0.064118,
      NULL,
      1,
      0,
      2,
      5,
      7,
      NULL,
      6.078741,
      0,
      2.372095,
      3,
      NULL,
      4,
      2,
      1.769974,
      4.206395,
      0.145875,
      ' 5- 3-1974',
      NULL,
      3,
      2,
      3,
      2,
      NULL,
      NULL,
      3,
      7.569469,
      582,
      37,
      3.898264,
      2,
      254.406523,
      NULL,
      1,
      2.535802,
      39,
      7.739148,
      0.515511,
      NULL,
      334.736888,
      17,
      1.814065,
      3,
      160,
      NULL,
      2,
      NULL,
      609,
      2.996322,
      NULL,
      2.047296,
      504,
      166,
      1,
      NULL,
      94.851971,
      11,
      NULL,
      3.720252,
      810,
      3.478487,
      NULL,
      0.111040,
      159.404100,
      4.891850,
      1.420415,
      0,
      13,
      15,
      2.040660,
      4.098301,
      165.812944,
      28.813793,
      3.217484,
      NULL,
      1139,
      188,
      1.778019,
      3.016533,
      77.676521,
      11,
      3.474140,
      0.286514,
      112.249105,
      3,
      1,
      3.779651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '10031',
      '',
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      3,
      1.349895,
      1,
      2.205942,
      6,
      1.348208,
      NULL,
      0,
      NULL,
      3.188991,
      8,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      ' 2-11-1998',
      13.619738,
      14,
      NULL,
      2.621269,
      23,
      7.688464,
      3.424328,
      3,
      NULL,
      24.021784,
      NULL,
      3.744377,
      1.134244,
      0.265302,
      1.783714,
      5.167098,
      2.921829,
      NULL,
      2.103335,
      NULL,
      14,
      NULL,
      9,
      6.927784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44.392892,
      35.871333,
      6,
      17,
      17.473036,
      37,
      6.245793,
      0,
      4,
      20.230334,
      26,
      5,
      2,
      NULL,
      22,
      16.505378,
      NULL,
      NULL,
      27.325315,
      7.543007,
      NULL,
      8.147578,
      15.814643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      73,
      164.793322,
      149,
      NULL,
      62,
      NULL,
      115,
      152.706862,
      NULL,
      133.137379,
      126.215101,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      134.053612,
      NULL,
      NULL,
      1.345523,
      0,
      0.508102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      5.546904,
      1,
      4,
      0.186096,
      0,
      5.372926,
      NULL,
      NULL,
      0.589093,
      0.846278,
      0,
      NULL,
      3.453136,
      1.147218,
      NULL,
      4.750710,
      6,
      4,
      5.896111,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.679127,
      2.882812,
      NULL,
      1,
      1,
      3,
      2,
      3,
      NULL,
      0.080283,
      2,
      0,
      3.413314,
      1.484096,
      0,
      3,
      1,
      5.820078,
      5.847905,
      0.798292,
      8.485619,
      6.300475,
      0,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.675915,
      3.265640,
      0.120898,
      NULL,
      2.385383,
      NULL,
      1.164915,
      3.080578,
      4.465149,
      NULL,
      0.915559,
      3.979102,
      4,
      2.413439,
      3,
      0.116195,
      0.853811,
      NULL,
      0.452598,
      2,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018683,
      NULL,
      NULL,
      0.140207,
      1.828650,
      0.784794,
      3,
      NULL,
      3,
      1,
      1.405030,
      3,
      NULL,
      0.923435,
      0,
      0.430644,
      0.448356,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.265428,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024075,
      NULL,
      2.331066,
      3,
      1.008020,
      0,
      1.878196,
      NULL,
      1,
      0.760375,
      0.570652,
      1,
      NULL,
      0.988189,
      3.941188,
      1,
      1.817301,
      1,
      NULL,
      NULL,
      1,
      1.498332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.290186,
      NULL,
      NULL,
      7,
      7.378400,
      2,
      3,
      3,
      1.000990,
      1,
      NULL,
      1.750587,
      5,
      5.401780,
      0.557055,
      NULL,
      NULL,
      5,
      5.171577,
      7,
      1,
      5.021515,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.085613,
      3.230203,
      1,
      NULL,
      2,
      0,
      1.892211,
      NULL,
      1.933135,
      0,
      4.585465,
      2,
      3,
      NULL,
      NULL,
      3.601683,
      3,
      5,
      0.700776,
      2.666516,
      6,
      7.460282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175493,
      4.792353,
      5,
      4,
      1,
      1,
      5,
      NULL,
      1.661214,
      3.815643,
      3,
      NULL,
      NULL,
      2,
      3.317121,
      1,
      NULL,
      1,
      1.431372,
      3,
      0.400569,
      1.574381,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.441286,
      4.172470,
      4.849182,
      5.261210,
      6,
      4.740153,
      4,
      NULL,
      5.161929,
      NULL,
      2,
      3,
      5,
      3,
      3,
      0,
      NULL,
      3,
      0.071059,
      3,
      4,
      1,
      4,
      4.062578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.115344,
      0,
      1.075089,
      NULL,
      1,
      1.677678,
      2,
      0,
      1,
      0,
      1,
      5,
      NULL,
      1.703783,
      1.059915,
      1,
      NULL,
      1,
      0,
      1.447682,
      0.406283,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.739096,
      1,
      1,
      NULL,
      1.117633,
      5.595760,
      3.458893,
      4.727232,
      1.140264,
      0,
      1.199460,
      1.107651,
      0,
      1,
      0,
      1,
      1,
      1,
      0.053441,
      1.085065,
      0.491006,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.361042,
      6.606547,
      5,
      9,
      3,
      6,
      3.822816,
      1.981449,
      0,
      0.957266,
      3.176228,
      3.768044,
      3,
      5,
      1.254956,
      1.439703,
      1,
      2.889100,
      4.001128,
      NULL,
      2.229864,
      3.011858,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.524509,
      1,
      4,
      1.504970,
      2,
      4,
      0.952325,
      1,
      4.961194,
      4,
      2,
      7,
      5,
      NULL,
      6.811652,
      NULL,
      3,
      1,
      6,
      3,
      7.354227,
      3.114194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.081763,
      2,
      2.348796,
      3,
      3,
      4,
      4,
      0.574956,
      1.327359,
      4.355135,
      2,
      1.603422,
      4.353354,
      1.342922,
      2.948843,
      3,
      NULL,
      1.751275,
      2.743554,
      2,
      6.076282,
      2,
      7.152364,
      1.730775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      0,
      5,
      NULL,
      NULL,
      2,
      1,
      5.955125,
      1,
      2.092614,
      3.713497,
      2.158471,
      3.303489,
      5,
      3.251710,
      4.614046,
      2,
      NULL,
      1.951630,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      2.316632,
      0,
      1.825341,
      1.097496,
      1,
      1.355541,
      1.757889,
      NULL,
      1.185948,
      1,
      NULL,
      1,
      NULL,
      1,
      1.377096,
      1.690744,
      1.698259,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.932404,
      0.576501,
      9.429118,
      8.210373,
      7.550650,
      1,
      1.588194,
      3,
      1.042029,
      0,
      5.528532,
      NULL,
      5,
      1.284645,
      2.118305,
      5.336447,
      4.081724,
      5,
      5.175017,
      3.322593,
      4,
      1,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      2,
      NULL,
      3,
      NULL,
      0,
      3,
      5,
      1,
      3,
      NULL,
      2,
      1,
      1,
      2,
      2,
      3,
      0,
      5,
      2,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-22-2002',
      ' 8-17-1994',
      ' 5-25-2003',
      '10-16-1990',
      NULL,
      ' 3- 9-1974',
      ' 9- 8-1996',
      ' 6- 3-1985',
      NULL,
      ' 8-10-1976',
      ' 0-11-2002',
      ' 3- 1-1975',
      ' 4- 4-1975',
      '11-28-1984',
      NULL,
      ' 5- 5-1999',
      ' 5- 4-1997',
      ' 1-29-1994',
      ' 9- 1-1996',
      ' 0- 5-2002',
      ' 8-12-2000',
      NULL,
      ' 8-13-1976',
      ' 9- 6-1998',
      ' 6-10-1978',
      ' 3- 3-2001',
      NULL,
      ' 0-15-1991',
      ' 2- 4-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-11-1999',
      '10- 6-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


