set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7944128';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '1134133',
      1,
      2,
      1,
      NULL,
      1.000153,
      NULL,
      50.285419,
      NULL,
      NULL,
      2,
      3,
      1.146362,
      0.345737,
      0.869303,
      NULL,
      2,
      NULL,
      NULL,
      1.288714,
      6,
      NULL,
      NULL,
      0.833890,
      1.871988,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.091413,
      1.479404,
      NULL,
      NULL,
      NULL,
      2,
      3,
      8,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      0,
      7,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      2,
      0,
      2,
      0.601057,
      0,
      4,
      NULL,
      6,
      4,
      6,
      7,
      NULL,
      NULL,
      15,
      NULL,
      48.267340,
      2.472987,
      3,
      0,
      6,
      4,
      0.544311,
      6,
      60.375350,
      664.604834,
      16642,
      2.615052,
      3.431975,
      130.995221,
      2140,
      0.094361,
      1,
      184.854768,
      NULL,
      NULL,
      2,
      190.702932,
      2562,
      0,
      NULL,
      241,
      NULL,
      3.553869,
      1,
      29,
      NULL,
      NULL,
      0.716980,
      30,
      12753,
      1.524506,
      2.439746,
      135,
      4586.478926,
      1.623719,
      2.978975,
      261,
      NULL,
      1,
      2.373554,
      216,
      968.311743,
      2.023443,
      3.257549,
      445,
      4.581911,
      NULL,
      1.201823,
      163.846743,
      17261,
      1,
      3.458510,
      329,
      2465,
      NULL,
      2.407129,
      182.111114,
      31.708569,
      3.224482,
      NULL,
      155,
      38.765551,
      0.398949,
      3.826084,
      NULL,
      0,
      2,
      2.554185,
      1256.431896,
      49,
      0,
      2.600193,
      277.566629,
      18821,
      1.145282,
      2,
      NULL,
      16149.225550,
      NULL,
      1.982732,
      NULL,
      NULL,
      3,
      0,
      NULL,
      99.179942,
      3.161994,
      3.551161,
      194,
      9455.455543,
      2.203234,
      2,
      395.849591,
      13176,
      NULL,
      3.210342,
      13.314832,
      NULL,
      3,
      5.317774,
      420,
      1491.310146,
      0,
      0,
      1276.598259,
      15.780239,
      3,
      8,
      533,
      3,
      NULL,
      0.308469,
      NULL,
      130,
      3.942844,
      1,
      NULL,
      NULL,
      2,
      5,
      NULL,
      NULL,
      3.149611,
      3,
      231.508110,
      NULL,
      3,
      0.792287,
      155,
      NULL,
      1,
      0,
      164,
      15.565835,
      1,
      8.813468,
      87.144389,
      1.361476,
      NULL,
      3.570726,
      798,
      3,
      2.365979,
      4.915310,
      NULL,
      NULL,
      0.232493,
      NULL,
      449.686549,
      9,
      2,
      3,
      56,
      36.775987,
      1.325478,
      0,
      128.086532,
      68,
      2.175880,
      0,
      111,
      136,
      2,
      NULL,
      NULL,
      NULL,
      1.355065,
      NULL,
      NULL,
      338.680174,
      0.302764,
      5.009627,
      NULL,
      172.733541,
      NULL,
      5,
      180,
      266.735797,
      0,
      4.061766,
      NULL,
      182,
      NULL,
      1,
      89,
      497.944827,
      3,
      7.021109,
      NULL,
      527.184348,
      0,
      4.612037,
      123.734086,
      29.383108,
      1,
      1,
      847.687179,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '34303',
      '02432',
      '',
      '',
      NULL,
      '',
      0.923949,
      '',
      '',
      '',
      2,
      NULL,
      '4141',
      '',
      5,
      NULL,
      67,
      0,
      262,
      NULL,
      NULL,
      0.998961,
      NULL,
      NULL,
      NULL,
      0.001784,
      NULL,
      1.948810,
      NULL,
      0,
      NULL,
      1.218900,
      NULL,
      0,
      NULL,
      ' 6- 2-1995',
      10.341848,
      2.343094,
      19,
      NULL,
      1,
      8.330514,
      NULL,
      1,
      3.968102,
      3.013963,
      7,
      18,
      19,
      0,
      NULL,
      13,
      NULL,
      8,
      6.495004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      10.091401,
      5,
      22,
      2.817819,
      19,
      NULL,
      NULL,
      NULL,
      5,
      4,
      NULL,
      0,
      22.670140,
      NULL,
      20.458130,
      7,
      23.320193,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      55,
      84,
      NULL,
      NULL,
      54.089524,
      NULL,
      33,
      NULL,
      4,
      23.828669,
      159,
      70.459139,
      63,
      113,
      166.836834,
      NULL,
      25.328833,
      110.507388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.714722,
      8,
      0.511616,
      8.160332,
      4.806638,
      NULL,
      3.272081,
      NULL,
      3,
      9,
      5,
      2,
      1,
      NULL,
      NULL,
      5,
      8,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.882376,
      1,
      1.591104,
      0.635315,
      3,
      NULL,
      1,
      1.655402,
      1,
      1,
      3.405997,
      1.580452,
      1.364537,
      NULL,
      NULL,
      0.363286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.649722,
      NULL,
      4,
      NULL,
      1,
      2.207336,
      NULL,
      0,
      0,
      3,
      6.016383,
      4,
      NULL,
      3.825729,
      2.682207,
      NULL,
      0,
      2.994403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133486,
      0.792328,
      7.728640,
      3,
      6,
      1,
      NULL,
      3,
      3,
      NULL,
      0,
      1,
      5.300695,
      3,
      2,
      NULL,
      4,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.944986,
      1,
      1,
      NULL,
      1,
      6.419638,
      1,
      0,
      1.201002,
      3.150200,
      0,
      3,
      0.176710,
      1.188386,
      1.196371,
      0,
      3.307519,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.928943,
      3.162055,
      1.670133,
      0.889564,
      1,
      7,
      NULL,
      2,
      NULL,
      2.548733,
      0,
      NULL,
      4,
      4.826642,
      6.521528,
      5.282051,
      5.883895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.004789,
      3.539636,
      4.780829,
      2,
      3.562634,
      0,
      5,
      6.909845,
      5.820244,
      NULL,
      0.935719,
      3,
      6.928154,
      3,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.749114,
      0.212904,
      NULL,
      0,
      2,
      0,
      3.450352,
      NULL,
      3.178621,
      NULL,
      2,
      1,
      0.341139,
      6.479968,
      3,
      2.343355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.328530,
      2,
      3.196720,
      NULL,
      NULL,
      NULL,
      0.147193,
      NULL,
      0,
      3,
      1.205835,
      0.506982,
      1,
      0,
      7.396166,
      1.697179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.822186,
      NULL,
      3,
      3,
      NULL,
      0.250903,
      2.611653,
      1,
      3,
      NULL,
      0.061903,
      2,
      3,
      1.683777,
      3,
      10.740467,
      2,
      1.410577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      8,
      NULL,
      NULL,
      1,
      2,
      1.812338,
      NULL,
      1,
      3.566717,
      0,
      1,
      NULL,
      1.729828,
      2.742152,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.620559,
      1.207810,
      1,
      2.800268,
      0,
      0,
      NULL,
      1.200516,
      0.366775,
      0,
      1,
      1,
      1.531566,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.739698,
      0.370887,
      1.981234,
      NULL,
      0,
      1.388646,
      0.224564,
      1.993557,
      1,
      1,
      0,
      1.561230,
      1.547599,
      NULL,
      1.039671,
      NULL,
      0.527285,
      0.586354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0.589534,
      6,
      0,
      4.286039,
      5,
      NULL,
      4.071493,
      NULL,
      0.784140,
      4.769896,
      2.499200,
      0,
      4.073908,
      1,
      4.916991,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012517,
      NULL,
      0.650953,
      1.357097,
      NULL,
      NULL,
      0,
      5,
      4,
      0.443215,
      4,
      1,
      2,
      7.702665,
      4.411637,
      2,
      8.873724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      1,
      1.093575,
      0,
      0,
      NULL,
      0.891554,
      NULL,
      0.632576,
      0.103776,
      1.530393,
      0,
      NULL,
      5,
      2.980091,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.511195,
      0.735239,
      1,
      NULL,
      NULL,
      1.028195,
      0.185251,
      1,
      NULL,
      0,
      0.179498,
      0.955974,
      NULL,
      1.775662,
      1,
      0.784646,
      1.795160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      0,
      0,
      0,
      0,
      2,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      3,
      1,
      0,
      0,
      2,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      3,
      4,
      NULL,
      5,
      1,
      4,
      2,
      3,
      3,
      2,
      1,
      1,
      0,
      2,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-24-1999',
      ' 7- 1-1992',
      NULL,
      ' 9-27-1982',
      ' 8-10-1985',
      NULL,
      NULL,
      NULL,
      ' 8- 9-1980',
      ' 0-14-1975',
      NULL,
      NULL,
      ' 9- 1-1981',
      ' 5- 4-1982',
      NULL,
      ' 5-15-1993',
      ' 0-18-1999',
      NULL,
      ' 3- 1-1983',
      NULL,
      ' 5-28-1984',
      NULL,
      NULL,
      NULL,
      ' 3- 3-1980',
      ' 9-21-1998',
      ' 2-11-2002',
      '11-19-2001',
      ' 9-13-2001',
      '10-22-1993',
      '10-13-1986',
      NULL,
      ' 7- 0-1976',
      NULL,
      NULL,
      NULL,
      ' 9-20-1998',
      '11-21-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-12-1978',
      NULL,
      ' 5-16-1978',
      NULL,
      NULL,
      NULL,
      ' 9- 7-1998',
      NULL,
      ' 8-15-1979',
      ' 5- 5-1975',
      NULL,
      '11-19-1995',
      ' 1-29-1979',
      ' 0-23-1986',
      ' 3-19-1989',
      ' 4-13-1989',
      '10-18-1995',
      ' 0- 0-1997',
      NULL,
      ' 9- 7-1975',
      NULL,
      ' 1-29-1997',
      ' 3-22-1982',
      ' 5-25-1977',
      ' 1-27-1982',
      ' 5-27-1978',
      ' 2- 3-1990',
      ' 2-27-1980',
      ' 8-14-1980',
      NULL,
      NULL,
      ' 5-20-1987',
      ' 8-23-1999',
      '11-23-1998',
      '11-11-1991',
      ' 2- 2-1985',
      ' 4-12-2000',
      ' 5- 0-1978',
      ' 0-18-1988',
      ' 3-20-1987',
      NULL,
      '11-28-1995',
      ' 8-15-1985',
      ' 7- 8-1984',
      ' 3- 5-1996',
      ' 2-28-1991',
      ' 4-12-1979',
      ' 9-22-1974',
      NULL,
      ' 2-24-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-23-1991',
      NULL,
      NULL,
      '10-12-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


